/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.propagation.DistributedListenerRep;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.ExtrinsicDescription;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.IntrinsicDescription;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.cluster.KeyConverter;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.iiop.topography.propagation.StateTransfer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;

public final class DistributedListenerRepImpl
implements DistributedListenerRep {
    private static final TraceComponent tc = Tr.register(DistributedListenerRepImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Map contracts;
    private StateTransfer listener;
    private Subject subject;
    private BulletinBoard bb;
    private final SubjectPost subjectPost;

    public DistributedListenerRepImpl(StateTransfer stateTransfer) {
        block3: {
            this.contracts = new HashMap();
            this.listener = null;
            this.subject = null;
            this.bb = null;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "<init>", stateTransfer);
            }
            this.subjectPost = null;
            this.listener = stateTransfer;
            try {
                this.subject = ContextManagerFactory.getInstance().getCallerSubject();
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException(wSSecurityException, DistributedListenerRepImpl.class.getName() + ".<init>", "99", this, new Object[]{this.bb});
                if (!tc.isEventEnabled()) break block3;
                Tr.event(tc, "unexpected", wSSecurityException);
            }
        }
    }

    public DistributedListenerRepImpl(BulletinBoard bulletinBoard, String string) {
        SubjectPost subjectPost;
        block3: {
            this.contracts = new HashMap();
            this.listener = null;
            this.subject = null;
            this.bb = null;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "<init>", new Object[]{bulletinBoard, string});
            }
            this.bb = bulletinBoard;
            ProcessProperties processProperties = ProcessProperties.getInstance();
            BulletinBoardScope bulletinBoardScope = (BulletinBoardScope)processProperties.get("key.public.bbscope");
            subjectPost = null;
            try {
                subjectPost = bulletinBoard.createPost(bulletinBoard.createSubject(bulletinBoardScope, string));
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, DistributedListenerRepImpl.class.getName() + ".<init>", "117", this, new Object[]{bulletinBoard, string, bulletinBoardScope});
                if (!tc.isEventEnabled()) break block3;
                Tr.event(tc, "unexpected", exception);
            }
        }
        this.subjectPost = subjectPost;
    }

    public void update(DescriptionKey descriptionKey, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update", descriptionKey);
        }
        this.push(descriptionKey, byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    public void push(DescriptionKey descriptionKey, byte[] byArray) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "push", descriptionKey);
            }
            if (this.listener != null) {
                this.listener.push(KeyConverter.translateKey(descriptionKey, null, ClusterDescription.class.getName(), false), byArray);
            } else if (this.bb != null) {
                try {
                    this.subjectPost.updatePost(byArray);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, DistributedListenerRepImpl.class.getName() + ".push", "148", this, new Object[]{this.subjectPost, byArray});
                    if (!tc.isEventEnabled()) break block7;
                    Tr.event(tc, "unexpected", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "push");
        }
    }

    public void reregister(DescriptionKey descriptionKey, URL uRL) {
    }

    public void register(Description description, Contract contract, Format format, URL uRL) {
    }

    public boolean setContract(DescriptionKey descriptionKey, Contract contract, URL uRL) {
        this.contracts.put(descriptionKey, contract);
        return true;
    }

    public void aggregate(ExtrinsicDescription extrinsicDescription) {
    }

    public void aggregate(IntrinsicDescription intrinsicDescription) {
    }

    public Contract getContract(DescriptionKey descriptionKey) {
        return (Contract)this.contracts.get(descriptionKey);
    }

    public String toString() {
        return super.toString() + "[c:" + this.contracts + " l:" + System.identityHashCode(this.listener) + "@" + this.listener + "]";
    }

    public void deregister() {
        block2: {
            try {
                this.subjectPost.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, DistributedListenerRepImpl.class.getName() + ".deregister", "195", this, new Object[]{this.subjectPost});
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "unexpected", exception);
            }
        }
    }

    private byte[] toByteArray(Serializable serializable) {
        byte[] byArray;
        block2: {
            byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, DistributedListenerRepImpl.class.getName() + ".toByteArray", "215", this, new Object[]{serializable});
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "unexpected", exception);
            }
        }
        return byArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.11 ");
        }
    }
}

