/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.propagation.DistributedListener;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.ExtrinsicDescription;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.IntrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.websphere.cluster.topography.SelectionDescription;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.KeyConverter;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.iiop.topography.propagation.Registrar;
import com.ibm.ws.cluster.iiop.topography.propagation._StateTransferImplBase;
import com.ibm.ws.cluster.management.IIOPRegistrar;
import com.ibm.ws.cluster.topography.ClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescription;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.ws.wlm.TypeConversion;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScopes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class IIOPDistributedListener
extends _StateTransferImplBase
implements DistributedListener {
    private static final TraceComponent tc = Tr.register(IIOPDistributedListener.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final long serialVersionUID = -5166275833384013900L;
    private static Map contracts;
    private final boolean inDMGR;
    public static final int routeTableStreamVersion = 0;
    private transient KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private transient DescriptionManager descriptionManager;
    private transient ClusterManagement clusterMgr;
    private transient Map registrars;
    private ORB orb;
    private boolean ivHAManagerAvailable;
    private boolean publishAsProxy;
    BulletinBoardFactory bbf;
    BulletinBoardScope scope;
    private final String colon = ":";
    private final String concern;
    private final Format format;
    private Contract ivContract;
    private byte[] ivRouteTableStreamVersion;
    private final String tmpKeyDistinction = "timestamp";
    public static final String remote = "ClusterListenerService";

    public IIOPDistributedListener(DescriptionKey descriptionKey) {
        DescriptionManagerFactory.getInstance();
        this.descriptionManager = DescriptionManagerFactory.getDescriptionManager();
        this.clusterMgr = ClusterManagementFactory.getClusterManagement();
        this.registrars = new HashMap();
        this.ivHAManagerAvailable = true;
        this.publishAsProxy = false;
        this.bbf = (BulletinBoardFactory)ProcessProperties.getInstance().get("key.bulletinboard.factory");
        this.scope = null;
        this.colon = ":";
        this.concern = new Integer(Integer.MAX_VALUE).toString();
        this.format = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 3);
        this.ivContract = null;
        this.ivRouteTableStreamVersion = new byte[4];
        this.tmpKeyDistinction = "timestamp";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.orb = GlobalORBFactory.globalORB();
        AdminService adminService = null;
        try {
            adminService = (AdminService)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return AdminServiceFactory.getAdminService();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException, IIOPDistributedListener.class.getName() + "<init>", "181");
        }
        this.inDMGR = adminService.getProcessType().equals("DeploymentManager");
        String string = adminService.getNodeName();
        String string2 = adminService.getProcessName();
        String string3 = adminService.getCellName();
        IIOPRegistrar.getInstance().servantmanager.addServant(this, "ClusterListenerService[" + string + ":" + string2 + "]" + string3);
        if (this.bbf == null) {
            this.ivHAManagerAvailable = false;
        }
        this.scope = (BulletinBoardScope)ProcessProperties.getInstance().get("key.public.bbscope");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
        this.ivContract = new ContractImpl();
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        this.ivContract.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        TypeConversion.intToBytes(0, this.ivRouteTableStreamVersion, 0);
    }

    public void push(String[] stringArray, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "push", stringArray);
        }
        DescriptionKey descriptionKey = KeyConverter.convertKey(stringArray);
        this.update(descriptionKey, byArray);
        IIOPRegistrar iIOPRegistrar = IIOPRegistrar.getInstance();
        if (iIOPRegistrar != null) {
            iIOPRegistrar.forward(stringArray, byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "push", byArray);
        }
    }

    public void reregister(DescriptionKey descriptionKey, URL uRL) {
    }

    public void register(Description description, Contract contract, Format format, URL uRL) {
    }

    public void update(DescriptionKey descriptionKey, byte[] byArray) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "update", descriptionKey);
            }
            DescriptionKey descriptionKey2 = null;
            try {
                byte[] byArray2 = Compressor.decompress(byArray, 4);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
                if (this.publishAsProxy) {
                    descriptionKey2 = this.update(wsObjectInputStream);
                    this.publishAsProxy(descriptionKey, descriptionKey2);
                } else {
                    this.descriptionManager.update(wsObjectInputStream);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, IIOPDistributedListener.class.getName() + ".update", "256", this);
                if (!tc.isEventEnabled()) break block6;
                Tr.event(tc, "unexpected", iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update", byArray);
        }
    }

    public boolean setContract(DescriptionKey descriptionKey, Contract contract, URL uRL) {
        return true;
    }

    public void aggregate(ExtrinsicDescription extrinsicDescription) {
    }

    public void aggregate(IntrinsicDescription intrinsicDescription) {
    }

    public Contract getContract(DescriptionKey descriptionKey) {
        return this.ivContract;
    }

    public void invokeRegistration(String[] stringArray, Registrar registrar2) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invokeRegistration", stringArray);
            }
            try {
                registrar2.registerCurrentVersionBackupClusterListener(stringArray, this, this.toByteArray(this.ivContract));
            }
            catch (Exception exception) {
                try {
                    registrar2.registerClusterListener(stringArray, this, this.toByteArray(this.ivContract));
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, IIOPDistributedListener.class.getName() + ".invokeRegistration", "301", this);
                    if (!tc.isEventEnabled()) break block6;
                    Tr.event(tc, "unexpected", exception2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeRegistration");
        }
    }

    public void checkForPeerAccessPoint(String string) {
        boolean bl = false;
        BulletinBoardScopes bulletinBoardScopes = (BulletinBoardScopes)ProcessProperties.getInstance().get("key.bbscopes");
        Map map = bulletinBoardScopes.getPeerAccessPointsMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!string.equals((String)entry.getValue())) continue;
            bl = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "found peer access point - CGBS enabled");
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "did not find peer access point - no CGBS, pusblish as proxy enabled");
            }
            this.publishAsProxy = true;
        }
    }

    private byte[] toByteArray(Serializable serializable) {
        byte[] byArray;
        block2: {
            byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, IIOPDistributedListener.class.getName() + ".toByteArray", "349", this, new Object[]{serializable});
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "unexpected", exception);
            }
        }
        return byArray;
    }

    private byte[] serializeKey(DescriptionKey descriptionKey) {
        byte[] byArray;
        block2: {
            byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                this.keyRepository.exportToStream(objectOutputStream, descriptionKey);
                objectOutputStream.flush();
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, IIOPDistributedListener.class.getName() + ".serializeKey", "372", this, new Object[]{descriptionKey});
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "unexpected", exception);
            }
        }
        return byArray;
    }

    private void publishAsProxy(DescriptionKey descriptionKey, DescriptionKey descriptionKey2) {
        Object object;
        Object object2;
        ClusterDescription clusterDescription;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        ClusterDescription clusterDescription2;
        block33: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "publishAsProxy " + descriptionKey2);
            }
            clusterDescription2 = null;
            try {
                clusterDescription2 = (ClusterDescription)this.descriptionManager.getDescription(descriptionKey, ClusterDescription.class.getName());
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException(instantiationException, IIOPDistributedListener.class.getName() + ".publishAsProxy", "390", this, new Object[]{descriptionKey});
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected, unable to update backup cluster", instantiationException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "publishAsProxy " + descriptionKey2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException(illegalAccessException, IIOPDistributedListener.class.getName() + ".publishAsProxy", "397", this, new Object[]{descriptionKey});
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected, unable to update backup cluster", illegalAccessException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "publishAsProxy " + descriptionKey2);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException(invocationTargetException, IIOPDistributedListener.class.getName() + ".publishAsProxy", "404", this, new Object[]{descriptionKey});
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected, unable to update backup cluster", invocationTargetException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "publishAsProxy " + descriptionKey2);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException(noSuchMethodException, IIOPDistributedListener.class.getName() + ".publishAsProxy", "411", this, new Object[]{descriptionKey});
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected, unable to update backup cluster", noSuchMethodException);
                }
                if (!tc.isEntryEnabled()) break block33;
                Tr.exit(tc, "publishAsProxy " + descriptionKey2);
            }
        }
        ClusterDescription clusterDescription3 = (ClusterDescription)this.descriptionManager.getDescription(descriptionKey2);
        ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription3.getMemento();
        ClusterDescription.Memento memento2 = (ClusterDescription.Memento)clusterDescription2.getMemento();
        Set set = memento.getClusterScopedData();
        if (set != null && !set.isEmpty()) {
            object6 = set.iterator();
            while (object6.hasNext()) {
                object5 = (Map.Entry)object6.next();
                object4 = (DescriptionKey)object5.getKey();
                object3 = (byte[])object5.getValue();
                if (object4 == null || object3 == null || ((byte[])object3).length == 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found cluster scoped data " + object4 + " publishing data as proxy");
                }
                clusterDescription2.setClusterScopedData((DescriptionKey)object4, (byte[])object3);
            }
        }
        if ((object6 = memento.getWeightTable()) != null && !object6.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found weight table " + object6 + " publishing weight table as proxy");
            }
            object5 = object6.entrySet().iterator();
            while (object5.hasNext()) {
                object4 = (Map.Entry)object5.next();
                object3 = (DescriptionKey)object4.getKey();
                int n = (Integer)object4.getValue();
                this.clusterMgr.setDesiredWeight(clusterDescription2.getKey(), (Identity)object3, n);
            }
        }
        byte by = memento.getState();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got state " + by + " publishing state as proxy");
        }
        clusterDescription2.setState(by);
        long l = memento.getStructuralEpoch();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got structural epoch " + l + " publishing structural epoch as proxy");
        }
        clusterDescription2.setStructuralEpoch(l);
        long l2 = memento.getInfluentialEpoch();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got influential epoch " + l2 + " publishing influential epoch as proxy");
        }
        clusterDescription2.setInfluentialEpoch(l2);
        SelectionDescription selectionDescription = memento.getSelectionDescription();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got selection description selec " + selectionDescription + " publishing selection description as proxy");
        }
        clusterDescription2.setSelectionDescription(selectionDescription);
        SelectionDescription.Memento memento3 = (SelectionDescription.Memento)selectionDescription.getMemento();
        String[] stringArray = memento3.getRules();
        if (stringArray != null && stringArray.length != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found rules publishing rules as proxy");
            }
            selectionDescription.modifyRules(stringArray);
        }
        if ((clusterDescription = memento.getBackupCluster()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found backup cluster " + clusterDescription.getKey() + " publishing backup cluster as proxy");
            }
            clusterDescription2.setBackupCluster(clusterDescription);
        }
        Set set2 = memento2.getMemberEntrySet();
        Map map = memento.getMembers();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            object = (DescriptionKey)object2.getKey();
            if (map.containsKey(object)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found current member " + object + " that is absent on the wire - " + "removing member");
            }
            clusterDescription2.removeMember((ClusterMemberDescription)object2.getValue());
        }
        object2 = memento.getClusterMembers();
        if (object2 != null) {
            while (object2.hasNext()) {
                object = (ClusterMemberDescription)object2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found member " + object.getKey() + " publishing member as proxy");
                }
                clusterDescription2.addMember((ClusterMemberDescription)object);
                this.publishClusterMemberDescription((ClusterMemberDescription)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishAsProxy " + descriptionKey);
        }
    }

    private void publishClusterMemberDescription(ClusterMemberDescription clusterMemberDescription) {
        Object object;
        Object object2;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishClusterMemberDescription " + clusterMemberDescription.getKey());
        }
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
        if (clusterMemberDescription instanceof ProcessDescription) {
            String string2 = ((ProcessDescription.Memento)memento).getNodeName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got member nodeName " + string2 + " publishing member nodeName as proxy");
            }
            ((ProcessDescription)clusterMemberDescription).setNodeName(string2);
            string = ((ProcessDescription.Memento)memento).getProcessName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got member processName " + string + " publishing member processName as proxy");
            }
            ((ProcessDescription)clusterMemberDescription).setProcessName(string);
        }
        byte by = memento.getState();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got member state " + by + " publishing member state as proxy");
        }
        clusterMemberDescription.setState(by);
        string = memento.getVersion();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got member version " + string + " publishing member version as proxy");
        }
        ((ClusterMemberDescriptionImpl)clusterMemberDescription).setVersion(string);
        Set set = memento.getClusterAssociations();
        if (set != null && !set.isEmpty()) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (DescriptionKey)object2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found association " + object + " publishing association as proxy");
                }
                clusterMemberDescription.setClusterAssociation((DescriptionKey)object);
            }
        }
        if ((object2 = memento.getExtrinsicData()) != null && !object2.isEmpty()) {
            object = object2.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                ExtrinsicDescription extrinsicDescription = (ExtrinsicDescription)entry.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found extrinsic description " + extrinsicDescription.getKey() + " publishing extrinsic description as proxy");
                }
                clusterMemberDescription.setExtrinsicData(extrinsicDescription);
                this.publishExtrinsicDescription(extrinsicDescription);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishClusterMemberDescription " + clusterMemberDescription.getKey());
        }
    }

    private void publishExtrinsicDescription(ExtrinsicDescription extrinsicDescription) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishExtrinsicDescription " + extrinsicDescription.getKey());
        }
        if (extrinsicDescription instanceof IIOPClusterMemberDescription) {
            IOR iOR;
            IIOPClusterMemberDescription iIOPClusterMemberDescription = (IIOPClusterMemberDescription)extrinsicDescription;
            IIOPClusterMemberDescription.Memento memento = (IIOPClusterMemberDescription.Memento)iIOPClusterMemberDescription.getMemento();
            DescriptionKey descriptionKey = memento.getClusterMemberAssociation();
            if (descriptionKey != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found cluster member association " + descriptionKey + " publishing cluster member association as proxy");
                }
                iIOPClusterMemberDescription.setClusterMemberAssociation(descriptionKey);
            }
            if ((iOR = memento.getIOR()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found IOR " + iOR + " publishing ior as proxy");
                }
                ((IIOPClusterMemberDescriptionImpl)iIOPClusterMemberDescription).setIOR(iOR);
            }
        } else if (extrinsicDescription instanceof EndPoint) {
            EndPoint endPoint = (EndPoint)((Object)extrinsicDescription);
            byte[] byArray = endPoint.getData();
            if (byArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found endpoint data " + byArray.length + " endpoint data as proxy");
                }
                endPoint.setData(byArray);
            }
        } else if (extrinsicDescription instanceof SelectionClusterMemberDescription) {
            Set set;
            String string;
            SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)extrinsicDescription;
            SelectionClusterMemberDescription.Memento memento = (SelectionClusterMemberDescription.Memento)selectionClusterMemberDescription.getMemento();
            DescriptionKey descriptionKey = memento.getClusterMemberAssociation();
            if (descriptionKey != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found cluster member association " + descriptionKey + " publishing cluster member association as proxy");
                }
                selectionClusterMemberDescription.setClusterMemberAssociation(descriptionKey);
            }
            if ((string = memento.getHost()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found host " + string + " publishing host as proxy");
                }
                ((SelectionClusterMemberDescriptionImpl)selectionClusterMemberDescription).setHost(string);
            }
            if ((set = memento.getAttributes()) != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found attribute " + string2 + " publishing attribute as proxy");
                    }
                    selectionClusterMemberDescription.addAttribute(string2);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unknown extrinsic type " + extrinsicDescription.getClass().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishExtrinsicDescription " + extrinsicDescription.getKey());
        }
    }

    private DescriptionKey update(ObjectInput objectInput) throws IOException {
        Format format = null;
        DescriptionKey descriptionKey = null;
        try {
            int n = objectInput.readInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read count " + n);
            }
            while (n > 0) {
                format = (Format)objectInput.readObject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read format ", format);
                }
                int n2 = objectInput.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read size " + n2);
                }
                while (n2 > 0) {
                    descriptionKey = this.keyRepository.importFromStream(objectInput);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read key", descriptionKey);
                    }
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    treeMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
                    descriptionKey = this.keyRepository.getDescriptionKey(descriptionKey, treeMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "reset to tmp key", descriptionKey);
                    }
                    String string = (String)objectInput.readObject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read definition key", string);
                    }
                    Description description = this.descriptionManager.getDescription(descriptionKey, string);
                    Description.Memento memento = description.importFromStream(objectInput, format, null);
                    --n2;
                    description.setMemento(memento);
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "Description updated", memento);
                }
                --n;
            }
            return descriptionKey;
        }
        catch (InstantiationException instantiationException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", instantiationException);
            }
            IOException iOException = new IOException(instantiationException.getMessage());
            iOException.initCause(instantiationException);
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", illegalAccessException);
            }
            IOException iOException = new IOException(illegalAccessException.getMessage());
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", invocationTargetException);
            }
            IOException iOException = new IOException(invocationTargetException.getMessage());
            iOException.initCause(invocationTargetException);
            throw iOException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", noSuchMethodException);
            }
            IOException iOException = new IOException(noSuchMethodException.getMessage());
            iOException.initCause(noSuchMethodException);
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", classNotFoundException);
            }
            IOException iOException = new IOException(classNotFoundException.getMessage());
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.13 ");
        }
        contracts = new HashMap();
    }
}

