/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.websphere.management.wlm.ClusterWeightTableEntry;
import com.ibm.ws.cluster.propagation.MultiversionInteropDataCollector;
import com.ibm.ws.cluster.propagation.StreamContextHandler;
import com.ibm.ws.cluster.propagation.WLMTemplateImpl;
import com.ibm.ws.cluster.service.ClusterManagementImpl;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescription;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.Identity;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.management.JMException;

public class MultiversionClusterInteropHelper
implements DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(MultiversionClusterInteropHelper.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private final String colon = ":";
    private final int STREAMVERSION1 = 1;
    private final byte POLICY_WEIGHTED = 0;
    private final byte POLICY_WEIGHTED_LOCAL = 1;
    private static KeyRepository svKeyRepository;
    private String ivCellName;
    private ORB ivOrb;
    private ClusterDescription ivClusterDescription;
    private DescriptionKey ivClusterKey;
    private String ivClusterName;
    private DescriptionManager ivDescMgr;
    private ClusterManagement ivClusterManagement;
    private Map ivProxyClusterMembers;
    private Map ivWeightTable;
    private Map iiopMemberDistinction;
    private WLMTemplateImpl proxy;
    private StreamContextHandler ivStreamHandler;

    public MultiversionClusterInteropHelper(String string, String string2, ORB oRB, WLMTemplateImpl wLMTemplateImpl) {
        block5: {
            this.colon = ":";
            this.STREAMVERSION1 = 1;
            this.POLICY_WEIGHTED = 0;
            this.POLICY_WEIGHTED_LOCAL = 1;
            this.ivCellName = null;
            this.ivOrb = null;
            this.ivClusterDescription = null;
            this.ivClusterKey = null;
            this.ivClusterName = null;
            this.ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
            this.ivClusterManagement = ClusterManagementFactory.getClusterManagement();
            this.ivProxyClusterMembers = new HashMap();
            this.ivWeightTable = new HashMap();
            this.iiopMemberDistinction = new TreeMap();
            this.proxy = null;
            this.ivStreamHandler = StreamContextHandler.getInstance();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", new Object[]{string, string2});
            }
            this.ivCellName = string;
            this.ivClusterName = string2;
            this.ivOrb = oRB;
            if (wLMTemplateImpl != null) {
                this.proxy = wLMTemplateImpl;
                ContractImpl contractImpl = new ContractImpl();
                contractImpl.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
                contractImpl.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
                contractImpl.setInterest(new ConcernImpl(Integer.MAX_VALUE));
                try {
                    this.ivClusterKey = MultiversionClusterInteropHelper.getClusterKey(string, string2);
                    this.ivClusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(this.ivClusterKey, ClusterDescription.class.getName());
                    this.ivClusterDescription.registerNotificationListener(this, "member.added", null);
                    this.ivClusterDescription.registerNotificationListener(this, "member.removed", null);
                    this.ivClusterDescription.registerNotificationListener(this, "type.cluster.weight.update", null);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, MultiversionClusterInteropHelper.class.getName() + ".init", "150");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "unexpected exception ", exception);
                }
            }
        }
        this.iiopMemberDistinction.put(IIOPClusterMemberDescription.distinction[0], IIOPClusterMemberDescription.distinction[1]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void createProxyClusterMember(String string, String string2, String string3) {
        ProcessDescription processDescription;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createProxyClusterMember", new Object[]{string, string2});
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(string2);
            String string4 = stringBuffer.toString();
            IOR iOR = ORB.createIOR((ORB)this.ivOrb, (String)string3);
            String string5 = iOR.getProfile(0).getHost();
            DescriptionKey descriptionKey = (DescriptionKey)((ClusterManagementImpl)this.ivClusterManagement).createClusterMember(this.ivCellName, string, string5, string2);
            DescriptionKey descriptionKey2 = svKeyRepository.getDescriptionKey(descriptionKey, this.iiopMemberDistinction);
            processDescription = null;
            try {
                block15: {
                    processDescription = (ProcessDescription)this.ivDescMgr.getDescription(descriptionKey, ProcessDescription.class.getName());
                    this.ivProxyClusterMembers.put(string4, descriptionKey);
                    if (this.ivWeightTable.containsKey(string4)) {
                        int n = (Integer)this.ivWeightTable.get(string4);
                        this.ivClusterManagement.setDesiredWeight(this.ivClusterKey, descriptionKey, n);
                    } else {
                        try {
                            MultiversionInteropDataCollector.reconnectMembers();
                        }
                        catch (JMException jMException) {
                            if (!tc.isEventEnabled()) break block15;
                            Tr.event(tc, "Unexpected. Member " + string4 + " will have a default weight", jMException);
                        }
                    }
                }
                IIOPClusterMemberDescriptionImpl iIOPClusterMemberDescriptionImpl = (IIOPClusterMemberDescriptionImpl)this.ivDescMgr.getDescription(descriptionKey2, IIOPClusterMemberDescription.class.getName());
                if (iIOPClusterMemberDescriptionImpl != null) {
                    iIOPClusterMemberDescriptionImpl.setORB(this.ivOrb);
                    iIOPClusterMemberDescriptionImpl.setIOR(iOR);
                    iIOPClusterMemberDescriptionImpl.setClusterMemberAssociation(descriptionKey);
                    processDescription.setExtrinsicData(iIOPClusterMemberDescriptionImpl);
                }
                processDescription.setAvailability((byte)0);
                this.ivClusterManagement.joinCluster(this.ivClusterKey, new Identity[]{descriptionKey});
            }
            catch (InstantiationException instantiationException) {
                if (tc.isEventEnabled()) {
                    Tr.entry(tc, "Unexpected, unable to create proxy member, returning ", instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (tc.isEventEnabled()) {
                    Tr.entry(tc, "Unexpected, unable to create proxy member, returning ", illegalAccessException);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (tc.isEventEnabled()) {
                    Tr.entry(tc, "Unexpected, unable to create proxy member, returning ", invocationTargetException);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!tc.isEventEnabled()) break block16;
                Tr.entry(tc, "Unexpected, unable to create proxy member, returning ", noSuchMethodException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createProxyClusterMember", new Object[]{string, string2, this.ivClusterDescription, processDescription});
        }
    }

    public void removeProxyClusterMember(String string) {
        ClusterMemberDescription clusterMemberDescription;
        DescriptionKey descriptionKey = (DescriptionKey)this.ivProxyClusterMembers.remove(string);
        if (descriptionKey != null && (clusterMemberDescription = (ClusterMemberDescription)this.ivDescMgr.getDescription(descriptionKey)) != null && this.ivClusterKey != null) {
            this.ivClusterManagement.disjoinCluster(this.ivClusterKey, new Identity[]{descriptionKey});
        }
    }

    public ClusterDescription getDescription() {
        return this.ivClusterDescription;
    }

    public String getClusterName() {
        return this.ivClusterName;
    }

    public void setWeightTable(ClusterWeightTableEntry[] clusterWeightTableEntryArray) {
        for (int i = 0; i < clusterWeightTableEntryArray.length; ++i) {
            ClusterMemberDescription clusterMemberDescription;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(clusterWeightTableEntryArray[i].nodeName);
            stringBuffer.append(":");
            stringBuffer.append(clusterWeightTableEntryArray[i].memberName);
            String string = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting weight in weight table " + string + ":" + clusterWeightTableEntryArray[i].weight);
            }
            this.ivWeightTable.put(string, clusterWeightTableEntryArray[i].weight);
            DescriptionKey descriptionKey = (DescriptionKey)this.ivProxyClusterMembers.get(string);
            if (descriptionKey == null || (clusterMemberDescription = (ClusterMemberDescription)this.ivDescMgr.getDescription(descriptionKey)) == null) continue;
            int n = clusterWeightTableEntryArray[i].weight;
            this.ivClusterManagement.setDesiredWeight(this.ivClusterKey, descriptionKey, n);
        }
        if (this.proxy != null) {
            this.proxy.notifyListeners(this.ivClusterKey, this.ivClusterName, this.export50cd());
        }
    }

    public static DescriptionKey getClusterKey(String string, String string2) {
        DescriptionKey descriptionKey;
        block2: {
            descriptionKey = null;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("CELLNAME", string);
            treeMap.put("CLUSTERNAME", string2);
            try {
                descriptionKey = svKeyRepository.getDescriptionKey(treeMap);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, MultiversionClusterInteropHelper.class.getName() + ".getClusterKey", "223");
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        return descriptionKey;
    }

    public byte[] export50cd() {
        byte[] byArray = null;
        byArray = this.ivStreamHandler.exportVersion1(this.ivClusterDescription, this.ivClusterName);
        return byArray;
    }

    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        Object object3;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2});
            }
            if (string.equals("member.added")) {
                object3 = this.ivDescMgr.getDescription(descriptionKey);
                if (object3 instanceof ClusterMemberDescription) {
                    object3.registerNotificationListener(this, "type.add.extrinsic", null);
                    object3.registerNotificationListener(this, "type.remove.extrinsic", null);
                    DescriptionKey descriptionKey2 = svKeyRepository.getDescriptionKey(object3.getKey(), this.iiopMemberDistinction);
                    ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)object3.getMemento();
                    IIOPClusterMemberDescription iIOPClusterMemberDescription = (IIOPClusterMemberDescription)memento.getExtrinsicData(descriptionKey2);
                    if (iIOPClusterMemberDescription != null) {
                        iIOPClusterMemberDescription.registerNotificationListener(this, "type.memento.updated", null);
                    }
                }
            } else if (string.equals("type.add.extrinsic")) {
                object3 = this.ivDescMgr.getDescription(descriptionKey);
                if (object3 instanceof IIOPClusterMemberDescription) {
                    object3.registerNotificationListener(this, "type.memento.updated", null);
                }
            } else {
                if (string.equals("type.remove.extrinsic")) {
                    object3 = this.ivDescMgr.getDescription(descriptionKey);
                    try {
                        object3.deregisterNotificationListener(this, "type.memento.updated");
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, MultiversionClusterInteropHelper.class.getName() + ".handleNotification", "322");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unexpected exception deregisteringNotficationListener ", exception);
                        }
                        break block23;
                    }
                }
                if (string.equals("member.removed")) {
                    object3 = this.ivDescMgr.getDescription(descriptionKey);
                    try {
                        object3.deregisterNotificationListener(this, "type.remove.extrinsic");
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, MultiversionClusterInteropHelper.class.getName() + ".handleNotification", "322");
                        if (!tc.isDebugEnabled()) break block23;
                        Tr.debug(tc, "unexpected exception deregisteringNotficationListener ", exception);
                    }
                }
            }
        }
        object3 = (ClusterDescription.Memento)this.ivClusterDescription.getMemento();
        if (object3.getState() != 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification -- cluster not running (probably uninitialized), don't propagate", new Object[]{this.ivClusterDescription});
            }
            return;
        }
        if (this.triggerPropagation((ClusterDescription.Memento)object3)) {
            if (this.proxy != null) {
                this.proxy.notifyListeners(this.ivClusterKey, this.ivClusterName, this.export50cd());
            } else if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification: null proxy, not pushing data");
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification: triggerPropagation returned null");
        }
    }

    private boolean triggerPropagation(ClusterDescription.Memento memento) {
        boolean bl = true;
        Iterator iterator = memento.getClusterMembers();
        while (iterator.hasNext()) {
            ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)iterator.next();
            DescriptionKey descriptionKey = svKeyRepository.getDescriptionKey(clusterMemberDescription.getKey(), this.iiopMemberDistinction);
            ClusterMemberDescription.Memento memento2 = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
            IIOPClusterMemberDescription iIOPClusterMemberDescription = (IIOPClusterMemberDescription)memento2.getExtrinsicData(descriptionKey);
            if (iIOPClusterMemberDescription == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "triggerPropagation = false, member has no IIOPDescription", clusterMemberDescription);
                }
                return false;
            }
            IIOPClusterMemberDescription.Memento memento3 = (IIOPClusterMemberDescription.Memento)iIOPClusterMemberDescription.getMemento();
            if (memento3 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "triggerPropagation = false, member's IIOPMemento=null", clusterMemberDescription);
                }
                return false;
            }
            IOR iOR = memento3.getIOR();
            if (iOR == null) {
                iIOPClusterMemberDescription.registerNotificationListener(this, "type.memento.updated", null);
                if (memento3.getIOR() != null) {
                    iIOPClusterMemberDescription.deregisterNotificationListener(this, "type.memento.updated");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "triggerPropagation = false, member's IOR is null", clusterMemberDescription);
                }
                return false;
            }
            iIOPClusterMemberDescription.deregisterNotificationListener(this, "type.memento.updated");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "triggerPropagation = " + bl);
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.18.1.1 ");
        }
        svKeyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    }
}

