/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.wlm.ClusterData;
import com.ibm.websphere.management.wlm.ClusterMemberData;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.propagation.WLMTemplateImpl;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.management.wlm.ClusterMgr;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.wlm.WLMTemplate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;
import org.omg.CORBA.Object;

public class MultiversionInteropDataCollector {
    private static final TraceComponent tc = Tr.register(MultiversionInteropDataCollector.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static ORB svOrb;
    private static WLMTemplateImpl svProxy;
    private static String svCellName;
    private static boolean doReconnect;

    public static void initialize(WLMTemplateImpl wLMTemplateImpl, ORB oRB, String string) {
        svProxy = wLMTemplateImpl;
        svOrb = oRB;
        svCellName = string;
    }

    private static void reconnectMembers(ClusterData[] clusterDataArray) throws JMException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnectMembers", new Integer(clusterDataArray.length));
        }
        int n = 0;
        ProcessProperties processProperties = ProcessProperties.getInstance();
        EndPointMgr endPointMgr = (EndPointMgr)processProperties.get("key.endpointmgr");
        ManagedObjectMetadataHelper managedObjectMetadataHelper = null;
        try {
            managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(new Properties()));
        }
        catch (AdminException adminException) {
            Tr.debug(tc, "error getting the ManagedObjectMetadataHelper", adminException);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < clusterDataArray.length; ++i) {
            ClusterMemberData[] clusterMemberDataArray = clusterDataArray[i].clusterMembers;
            String string = clusterDataArray[i].clusterName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "reconnecting cluster: " + string);
            }
            svProxy.setWeightTable(string, clusterDataArray[i].weightTable);
            for (int j = 0; j < clusterMemberDataArray.length; ++j) {
                String string2 = (String)hashMap.get(clusterMemberDataArray[j].nodeName);
                try {
                    if (string2 == null && managedObjectMetadataHelper != null) {
                        string2 = managedObjectMetadataHelper.getNodeMajorVersion(clusterMemberDataArray[j].nodeName);
                        hashMap.put(clusterMemberDataArray[j].nodeName, string2);
                    }
                }
                catch (AdminException adminException) {
                    Tr.debug(tc, "error calling ManagedObjectMetadataHelper.getNodeMajorVersion", adminException);
                }
                if (string2 != null && !string2.equals("5")) continue;
                String string3 = clusterMemberDataArray[j].nodeName + ":" + clusterMemberDataArray[j].memberName;
                try {
                    EndPointMgr.NodeEndPoints nodeEndPoints = endPointMgr.getNodeEndPoints(clusterMemberDataArray[j].nodeName);
                    EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(clusterMemberDataArray[j].memberName);
                    EndPoint endPoint = serverEndPoints.getEndPoint("BOOTSTRAP_ADDRESS");
                    String string4 = "corbaloc:iiop:" + endPoint.getHost() + ":" + endPoint.getPort() + "/" + "WLMService";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "bootstrap end point", string4);
                    }
                    WLMTemplate wLMTemplate = (WLMTemplate)svOrb.string_to_object(string4);
                    svProxy.pushSelf(svCellName, string, string3, svOrb.objectToIOR((Object)wLMTemplate).stringify());
                    ++n;
                    continue;
                }
                catch (Exception exception) {
                    Tr.debug(tc, "Server not available for reconnect.", new java.lang.Object[]{clusterMemberDataArray[j].clusterName, clusterMemberDataArray[j].nodeName, clusterMemberDataArray[j].memberName, exception});
                }
            }
        }
        doReconnect = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnectMembers", new Integer(n));
        }
    }

    static synchronized void reconnectMembers() throws JMException {
        if (!doReconnect) {
            return;
        }
        ProcessProperties processProperties = ProcessProperties.getInstance();
        ClusterMgr clusterMgr = (ClusterMgr)processProperties.get("key.clustermgr");
        ClusterData[] clusterDataArray = clusterMgr.retrieveClusters();
        if (clusterDataArray != null) {
            MultiversionInteropDataCollector.reconnectMembers(clusterDataArray);
        }
    }

    public static java.lang.Object[] constructLSDEP(String string, String string2) {
        java.lang.Object[] objectArray;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "constructLSDEP", new java.lang.Object[]{string, string2});
            }
            objectArray = null;
            ProcessProperties processProperties = ProcessProperties.getInstance();
            EndPointMgr endPointMgr = (EndPointMgr)processProperties.get("key.endpointmgr");
            try {
                Map map = endPointMgr.getNodeEndPoints();
                boolean bl = false;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    EndPointMgr.NodeEndPoints nodeEndPoints = (EndPointMgr.NodeEndPoints)entry.getValue();
                    EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(Utils.getNodeAgentName());
                    Map map2 = nodeEndPoints.getServerEndPoints();
                    Iterator iterator2 = map2.values().iterator();
                    while (iterator2.hasNext()) {
                        EndPointMgr.EndPoints endPoints = (EndPointMgr.EndPoints)iterator2.next();
                        if (serverEndPoints != endPoints || !string.equals(nodeEndPoints.getName()) || !string2.equals(endPoints.getName())) continue;
                        EndPoint endPoint = endPoints.getEndPoint("ORB_LISTENER_ADDRESS");
                        EndPoint endPoint2 = endPoints.getEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
                        EndPoint endPoint3 = endPoints.getEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
                        if (endPoint != null) {
                            objectArray = new java.lang.Object[]{endPoint.getHost(), new Short((short)endPoint.getPort()), endPoint2 != null ? new Short((short)endPoint2.getPort()) : new Short(0), endPoint3 != null ? new Short((short)endPoint3.getPort()) : new Short(0)};
                        }
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    break;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructLSDEP", objectArray);
        }
        return objectArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.5 ");
        }
        svOrb = null;
        svProxy = null;
        svCellName = null;
        doReconnect = true;
    }
}

