/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.LSDClusterMemberDescription;
import com.ibm.ws.cluster.topography.LSDClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.configuration.LSDAddress;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MultiversionLSDInteropHelper {
    private static final TraceComponent tc = Tr.register(MultiversionLSDInteropHelper.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static ClusterDescription svLsdCluster = null;
    public static DescriptionKey svLsdClusterKey = null;
    public static Map svLsdData = new HashMap();
    private static KeyRepository svKeyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static DescriptionManager svDescMgr;
    private static Map proxyMembers;
    private static String cellName;

    public static void lookupLSDCluster() {
        ContractImpl contractImpl = new ContractImpl();
        contractImpl.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        contractImpl.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        contractImpl.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        if (svLsdClusterKey == null) {
            MultiversionLSDInteropHelper.constructLSDKey();
        }
        if (svLsdClusterKey != null) {
            try {
                svLsdCluster = (ClusterDescription)svDescMgr.getDescription(svLsdClusterKey, ClusterDescription.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, MultiversionLSDInteropHelper.class.getName() + ".lookupLSDCluster", "97");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception ", exception);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "svLsdClusterKey null, cannot lookup LSD Cluster ");
        }
    }

    public static void createProxyLSDMember(String string, String string2, Object[] objectArray) {
        block3: {
            if (cellName == null) {
                MultiversionLSDInteropHelper.constructLSDKey();
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("CELLNAME", cellName);
            treeMap.put("NODENAME", string);
            treeMap.put("MEMBERNAME", string2);
            ProcessDescription processDescription = null;
            try {
                DescriptionKey descriptionKey = svKeyRepository.getDescriptionKey(treeMap);
                processDescription = (ProcessDescription)svDescMgr.getDescription(descriptionKey, ProcessDescription.class.getName());
                processDescription.setNodeName(string);
                processDescription.setProcessName(string2);
                processDescription.setState((byte)0);
                TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
                treeMap2.put(LSDClusterMemberDescription.distinction[0], LSDClusterMemberDescription.distinction[1]);
                DescriptionKey descriptionKey2 = svKeyRepository.getDescriptionKey(descriptionKey, treeMap2);
                LSDClusterMemberDescriptionImpl lSDClusterMemberDescriptionImpl = (LSDClusterMemberDescriptionImpl)svDescMgr.getDescription(descriptionKey2, LSDClusterMemberDescription.class.getName());
                lSDClusterMemberDescriptionImpl.setHost((String)objectArray[0]);
                lSDClusterMemberDescriptionImpl.setPort(((Short)objectArray[1]).shortValue());
                lSDClusterMemberDescriptionImpl.setSSLPort(((Short)objectArray[2]).shortValue());
                lSDClusterMemberDescriptionImpl.setSSLClientCertificatePort(((Short)objectArray[3]).shortValue());
                lSDClusterMemberDescriptionImpl.setClusterMemberAssociation(descriptionKey);
                processDescription.setExtrinsicData(lSDClusterMemberDescriptionImpl);
                svLsdCluster.addMember(processDescription);
                proxyMembers.put(string, processDescription);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, MultiversionLSDInteropHelper.class.getName() + ".handleAggregation", "139");
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
    }

    public static Map getLsdClusterData() {
        HashMap<Object, Object[]> hashMap = new HashMap<Object, Object[]>();
        if (svLsdCluster == null) {
            return hashMap;
        }
        Iterator iterator = ((ClusterDescription.Memento)svLsdCluster.getMemento()).getClusterMembers();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(LSDClusterMemberDescription.distinction[0], LSDClusterMemberDescription.distinction[1]);
        while (iterator.hasNext()) {
            ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)iterator.next();
            ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
            DescriptionKey descriptionKey = svKeyRepository.getDescriptionKey(clusterMemberDescription.getKey(), treeMap);
            LSDClusterMemberDescription lSDClusterMemberDescription = null;
            if (memento != null) {
                lSDClusterMemberDescription = (LSDClusterMemberDescription)memento.getExtrinsicData(descriptionKey);
            }
            if (lSDClusterMemberDescription == null) continue;
            Object[] objectArray = new Object[4];
            LSDClusterMemberDescription.Memento memento2 = (LSDClusterMemberDescription.Memento)lSDClusterMemberDescription.getMemento();
            objectArray[0] = memento2.getHost();
            objectArray[1] = new Short((short)memento2.getPort());
            objectArray[2] = new Short((short)memento2.getSSLPort());
            objectArray[3] = new Short((short)memento2.getSSLClientCertificatePort());
            hashMap.put(objectArray[0], objectArray);
        }
        return hashMap;
    }

    public static void writeLSDList(DataOutputStream dataOutputStream) throws IOException {
        LSDAddress[] lSDAddressArray = WLMProperties.getLSDAddresses();
        if (lSDAddressArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LSDAddress[] is null");
            }
            Map map = MultiversionLSDInteropHelper.getLsdClusterData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Write lsd data size " + map.size());
            }
            dataOutputStream.writeInt(map.size());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object[] objectArray = (Object[])entry.getValue();
                dataOutputStream.writeUTF((String)objectArray[0]);
                dataOutputStream.writeShort(((Short)objectArray[1]).shortValue());
                dataOutputStream.writeShort(((Short)objectArray[2]).shortValue());
                dataOutputStream.writeShort(((Short)objectArray[3]).shortValue());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Write host [" + objectArray[0] + "] port [" + objectArray[1] + "] SSL port [" + objectArray[2] + "] SSL CC port [" + objectArray[3] + "]");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Write lsd data size " + lSDAddressArray.length);
            }
            dataOutputStream.writeInt(lSDAddressArray.length);
            for (int i = 0; i < lSDAddressArray.length; ++i) {
                dataOutputStream.writeUTF(lSDAddressArray[i].getHost());
                dataOutputStream.writeShort((short)lSDAddressArray[i].getPort());
                dataOutputStream.writeShort((short)lSDAddressArray[i].getSSLPort());
                dataOutputStream.writeShort((short)lSDAddressArray[i].getSSLCCPort());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Write host [" + lSDAddressArray[i].getHost() + "] port [" + lSDAddressArray[i].getPort() + "] SSL port [" + lSDAddressArray[i].getSSLPort() + "] SSL CC port [" + lSDAddressArray[i].getSSLCCPort() + "]");
            }
        }
    }

    public static void removeProxyLSDMember(String string, String string2) {
        if (svLsdClusterKey == null) {
            MultiversionLSDInteropHelper.constructLSDKey();
        }
        if (!proxyMembers.containsKey(string)) {
            return;
        }
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)proxyMembers.get(string);
        clusterMemberDescription.removeClusterAssociation(svLsdClusterKey);
        svLsdCluster.removeMember(clusterMemberDescription);
    }

    private static void constructLSDKey() {
        block5: {
            if (svLsdClusterKey == null) {
                try {
                    Object object;
                    if (cellName == null) {
                        object = AdminServiceFactory.getAdminService();
                        cellName = object == null ? (String)ProcessProperties.getInstance().get("key.containing.cellname") : object.getCellName();
                    }
                    if (cellName != null) {
                        object = new TreeMap();
                        object.put("CELLNAME", cellName);
                        object.put("CLUSTERNAME", "LSDCluster");
                        svLsdClusterKey = svKeyRepository.getDescriptionKey((Map)object);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isEventEnabled()) break block5;
                    Tr.event(tc, "Unable to construct LSD Cluster Key", exception);
                }
            }
        }
    }

    static {
        DescriptionManagerFactory.getInstance();
        svDescMgr = DescriptionManagerFactory.getDescriptionManager();
        proxyMembers = new HashMap();
        cellName = "";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.12 ");
        }
        if (svLsdClusterKey == null) {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                cellName = adminService == null ? (String)ProcessProperties.getInstance().get("key.containing.cellname") : adminService.getCellName();
                if (cellName != null) {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    treeMap.put("CELLNAME", cellName);
                    treeMap.put("CLUSTERNAME", "LSDCluster");
                    svLsdClusterKey = svKeyRepository.getDescriptionKey(treeMap);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

