/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.propagation.MultiversionInteropDataCollector;
import com.ibm.ws.cluster.propagation.MultiversionLSDInteropHelper;
import com.ibm.ws.cluster.propagation.WLMTemplateImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MultiversionNotificationListener
implements NotificationListener {
    private static final TraceComponent tc = Tr.register(MultiversionNotificationListener.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    AdminService adminService = null;
    ClusterDescription cd = null;
    private Integer HANDBACKNA = new Integer(0);
    private Integer HANDBACKSERVER = new Integer(1);
    private KeyRepository ivKeyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private DescriptionManager ivDescMgr;
    private static final String v6 = "6.";
    private WLMTemplateImpl proxy;

    public MultiversionNotificationListener(WLMTemplateImpl wLMTemplateImpl) {
        DescriptionManagerFactory.getInstance();
        this.ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
        this.proxy = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>");
        }
        this.adminService = AdminServiceFactory.getAdminService();
        this.proxy = wLMTemplateImpl;
        this.registerNotificationListener();
    }

    private void registerNotificationListener() {
        block2: {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("*:*,type=Discovery,name=Discovery,node=" + this.adminService.getNodeName() + ",process=" + this.adminService.getProcessName());
                Set set = this.adminService.queryNames(objectName, null);
                Iterator iterator = set.iterator();
                objectName = (ObjectName)iterator.next();
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.discovery.process.found");
                notificationFilterSupport.enableType("websphere.discovery.process.lost");
                this.adminService.addNotificationListener(objectName, this, (NotificationFilter)notificationFilterSupport, (Object)this.HANDBACKNA);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, MultiversionNotificationListener.class.getName() + ".<init>", "109", this, new Object[]{objectName});
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "unexpected", exception);
            }
        }
    }

    private void registerForMemberStartStopNotificationListener(String string, String string2) {
        block3: {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("*:*,type=Discovery,name=Discovery,node=" + string + ",process=" + string2);
                Set set = this.adminService.queryNames(objectName, null);
                Iterator iterator = set.iterator();
                objectName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "queryName " + objectName);
                }
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.discovery.process.found");
                notificationFilterSupport.enableType("websphere.discovery.process.lost");
                this.adminService.addNotificationListener(objectName, this, (NotificationFilter)notificationFilterSupport, (Object)this.HANDBACKSERVER);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, MultiversionNotificationListener.class.getName() + ".<init>", "131", this, new Object[]{objectName});
                if (!tc.isEventEnabled()) break block3;
                Tr.event(tc, "unexpected", exception);
            }
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleNotification", new Object[]{"handBack = " + object, "type = " + notification.getType(), "source = " + notification.getSource(), "userData = " + notification.getUserData()});
        }
        String string = notification.getType();
        Map map = (Map)notification.getUserData();
        String string2 = null;
        String string3 = (String)map.get("processName");
        String string4 = (String)map.get("nodeName");
        if (string.equals("websphere.discovery.process.found")) {
            string2 = (String)map.get("version");
            if (((Integer)object).equals(this.HANDBACKNA) && string2.compareTo(v6) < 0) {
                this.registerForMemberStartStopNotificationListener(string4, string3);
                try {
                    MultiversionInteropDataCollector.reconnectMembers();
                    Object[] objectArray = MultiversionInteropDataCollector.constructLSDEP(string4, string3);
                    MultiversionLSDInteropHelper.lookupLSDCluster();
                    MultiversionLSDInteropHelper.createProxyLSDMember(string4, string3, objectArray);
                    MultiversionLSDInteropHelper.svLsdData.put(string4, objectArray);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, MultiversionNotificationListener.class.getName() + ".handleNotification", "175", this, new Object[]{MultiversionLSDInteropHelper.svLsdClusterKey});
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "unexpected", exception);
                    }
                }
            }
        } else {
            string3 = (String)map.get("processName");
            if (((Integer)object).equals(this.HANDBACKNA)) {
                MultiversionLSDInteropHelper.svLsdData.remove(string4);
                MultiversionLSDInteropHelper.removeProxyLSDMember(string4, string3);
            } else {
                this.proxy.removeMember(null, string4, string3);
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.5 ");
        }
    }
}

