/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.KeyConverter;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.propagation.StreamContextHandler;
import com.ibm.ws.cluster.router.selection.WLMLSDRouter;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.ws.wlm.TypeConversion;
import com.ibm.ws.wlm.server.WLMServiceServerContextListener;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.cluster.distribution.ServerClusterContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.Object;
import org.omg.PortableInterceptor.ForwardRequest;

public class ServerClusterContextListenerImpl
implements WLMServiceServerContextListener,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(ServerClusterContextListenerImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final long serialVersionUID = 4497162537725491355L;
    private ORB orb;
    private ServerClusterContext ucfServerClusterContext;
    private static ThreadLocal threadIdentity;
    private DescriptionManager ivDescMgr;
    private StreamContextHandler ivStreamContextHandler;
    private ProcessProperties ivProcessProperties;
    private KeyRepository repos;
    private ClusterService ivClusterService;
    private DescriptionKey initClusterKey;
    private static final Map rtCache;
    private static final Map wtCache;

    public static Identity getContextIdentity() {
        return (Identity)threadIdentity.get();
    }

    public ServerClusterContextListenerImpl(ORB oRB, ServerClusterContext serverClusterContext) {
        DescriptionManagerFactory.getInstance();
        this.ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
        this.ivStreamContextHandler = StreamContextHandler.getInstance();
        this.ivProcessProperties = ProcessProperties.getInstance();
        this.repos = KeyRepositoryFactory.getInstance().getKeyRepository();
        this.ivClusterService = ClusterServiceFactory.getClusterService();
        this.initClusterKey = null;
        this.orb = oRB;
        this.ucfServerClusterContext = serverClusterContext;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CELLNAME", "INIT");
        hashMap.put("CLUSTERNAME", "INIT");
        this.initClusterKey = this.repos.getDescriptionKey(hashMap);
    }

    public byte[] receiveServerContext(byte[] byArray) throws ForwardRequest {
        byte[] byArray2;
        block35: {
            if (byArray == null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "receiveServerContext", byArray);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "receiveServerContext - null context received");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "receiveServerContext", new ByteArray(byArray).toString());
            }
            if (byArray.length == 4) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "receiveServerContext: received context from downlevel server of version", String.valueOf(TypeConversion.bytesToInt(byArray, 0)));
                }
                return null;
            }
            byArray2 = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n = dataInputStream.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clientVersion " + n);
                }
                if (n == 1) {
                    ClusterDescription clusterDescription;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stream is 5.0");
                    }
                    long l = TypeConversion.bytesTolong(byArray, 4);
                    DescriptionKey descriptionKey = (DescriptionKey)this.ivProcessProperties.get("key.containing.cluster");
                    if (descriptionKey != null && (clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey)) != null) {
                        ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
                        long l2 = memento.getStructuralEpoch();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "client and server epochs", new java.lang.Object[]{String.valueOf(l), String.valueOf(l2)});
                        }
                        if (l < l2) {
                            byArray2 = this.ivStreamContextHandler.exportVersion1(clusterDescription, null);
                        }
                        if (byArray2 == null) {
                            byArray2 = new byte[4];
                            TypeConversion.intToBytes(-1, byArray2, 0);
                        }
                    }
                } else if (n == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stream is 5.0 PME/WBI");
                    }
                    TypeConversion.bytesTolong(byArray, 4);
                    TypeConversion.bytesTolong(byArray, 4);
                    byte by = this.receiveServerContextPrefix(dataInputStream);
                    WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(dataInputStream);
                    HashMap hashMap = new HashMap();
                    this.receiveServerContextCluster(wsObjectInputStream, hashMap, 0, n, 1);
                    if (!hashMap.isEmpty()) {
                        ClusterDescription[] clusterDescriptionArray;
                        Set set = hashMap.keySet();
                        Iterator iterator = set.iterator();
                        HashSet<ClusterDescription> hashSet = new HashSet<ClusterDescription>();
                        while (iterator.hasNext()) {
                            clusterDescriptionArray = (ClusterDescription[])iterator.next();
                            Set set2 = (Set)hashMap.get(clusterDescriptionArray);
                            Iterator iterator2 = set2.iterator();
                            while (iterator2.hasNext()) {
                                DescriptionKey descriptionKey = (DescriptionKey)iterator2.next();
                                Description description = this.ivDescMgr.getDescription(descriptionKey);
                                if (description == null || !(description instanceof ClusterDescription)) continue;
                                hashSet.add((ClusterDescription)description);
                            }
                        }
                        clusterDescriptionArray = hashSet.toArray(new ClusterDescription[hashSet.size()]);
                        if (clusterDescriptionArray.length != 0) {
                            byArray2 = this.ivStreamContextHandler.exportVersion2(true, clusterDescriptionArray, false, false);
                        }
                    }
                    if (byArray2 == null) {
                        byArray2 = new byte[4];
                        TypeConversion.intToBytes(-1, byArray2, 0);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stream is 6.0.X or greater");
                    }
                    TypeConversion.bytesTolong(byArray, 4);
                    byte by = this.receiveServerContextPrefix(dataInputStream);
                    WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(dataInputStream);
                    HashMap hashMap = new HashMap();
                    this.receiveServerContextCluster(wsObjectInputStream, hashMap, 0, n, 3);
                    if (!hashMap.isEmpty()) {
                        dataOutputStream.writeInt(4);
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
                        this.ivDescMgr.stream(hashMap, objectOutputStream);
                        objectOutputStream.flush();
                        byte[] byArray3 = byteArrayOutputStream.toByteArray();
                        if (tc.isDebugEnabled() && byArray3 != null) {
                            Tr.debug(tc, "uncompressed response: ", new ByteArray(byArray3).toString());
                        }
                        byArray2 = Compressor.compress(byArray3, 4);
                        objectOutputStream.close();
                    }
                    wsObjectInputStream.close();
                }
                dataOutputStream.close();
                dataInputStream.close();
                byteArrayOutputStream.close();
                byteArrayInputStream.close();
            }
            catch (StreamCorruptedException streamCorruptedException) {
                FFDCFilter.processException((Throwable)streamCorruptedException, ServerClusterContextListenerImpl.class.getName() + ".receiveServerContext", "323", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to stream descriptions", streamCorruptedException);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "for byte array", new ByteArray(byArray).toString());
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, ServerClusterContextListenerImpl.class.getName() + ".receiveServerContext", "326", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to stream descriptions", iOException);
                }
                if (!tc.isDebugEnabled()) break block35;
                Tr.debug(tc, "for byte array", new ByteArray(byArray).toString());
            }
        }
        if (byArray2 != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receiveServerContext", new ByteArray(byArray2).toString());
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveServerContext", byArray2);
        }
        return byArray2;
    }

    protected byte receiveServerContextPrefix(DataInput dataInput) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveServerContextPrefix");
        }
        long l = dataInput.readLong();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read structural epoch " + l);
        }
        int n = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read client PMI ID " + n);
        }
        byte by = dataInput.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read affinity type " + by);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveServerContextPrefix", new java.lang.Object[]{new Long(l), new Integer(n), new Byte(by)});
        }
        return by;
    }

    private void receiveServerContextCluster(ObjectInput objectInput, Map map, int n, int n2, int n3) throws IOException, ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveServerContextCluster", new java.lang.Object[]{map, String.valueOf(n)});
        }
        if (objectInput.readBoolean()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Read cluster available to process true");
            }
            DescriptionKey descriptionKey = null;
            try {
                String[] stringArray = (String[])objectInput.readObject();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        Tr.debug(tc, "key[" + i + "] = " + stringArray[i]);
                    }
                }
                descriptionKey = n2 == 2 ? (!stringArray[1].equals("LSDCluster") ? (DescriptionKey)this.ivClusterService.stringToIdentity(stringArray[1]) : KeyConverter.convertKey(stringArray)) : KeyConverter.convertKey(stringArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, ServerClusterContextListenerImpl.class.getName() + ".receiveServerContext", "417", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected", classNotFoundException);
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read cluster Key " + descriptionKey);
            }
            if (n == 0) {
                threadIdentity.set(descriptionKey);
            }
            long l = objectInput.readLong();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read structural epoch " + l);
            }
            long l2 = objectInput.readLong();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read influential epoch " + l2);
            }
            ClusterDescription clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster available to process ", new java.lang.Object[]{String.valueOf(l), new Long(l2), descriptionKey});
            }
            if (clusterDescription != null) {
                if (l == -2L) {
                    FormatImpl formatImpl = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), n3);
                    this.addAllClusterKeys(map, clusterDescription, formatImpl);
                } else {
                    ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
                    if (l < memento.getStructuralEpoch()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "structural epoch has changed");
                        }
                    } else if (l2 < memento.getInfluentialEpoch()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "influential epoch has changed");
                        }
                        if (n2 != 4) {
                            n3 = 2;
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "client is up to date");
                        }
                        n3 = 0;
                    }
                    if (n3 != 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "client needs updated cluster information");
                        }
                        FormatImpl formatImpl = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), n3);
                        this.addClusterKey(map, clusterDescription, formatImpl);
                    }
                }
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to find cluster " + (descriptionKey == null ? "" : descriptionKey.toString()));
            }
            if (n2 == 2) {
                this.receiveServerContextCluster(objectInput, map, ++n, n2, 1);
            } else {
                this.receiveServerContextCluster(objectInput, map, ++n, n2, 3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveServerContextCluster", new java.lang.Object[]{map, String.valueOf(n2)});
        }
    }

    protected void addAllClusterKeys(Map map, ClusterDescription clusterDescription, Format format) {
        this.addClusterKey(map, clusterDescription, format);
        this.addBackupCluster(map, clusterDescription, format);
    }

    private void addBackupCluster(Map map, ClusterDescription clusterDescription, Format format) {
        ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
        ClusterDescription clusterDescription2 = memento.getBackupCluster();
        HashSet<ClusterDescription> hashSet = new HashSet<ClusterDescription>();
        hashSet.add(clusterDescription);
        for (int i = 0; clusterDescription2 != null && !hashSet.contains(clusterDescription2) && i < 1; ++i) {
            this.addClusterKey(map, clusterDescription2, format);
            hashSet.add(clusterDescription2);
            memento = (ClusterDescription.Memento)clusterDescription2.getMemento();
            clusterDescription2 = memento.getBackupCluster();
        }
    }

    protected void addClusterKey(Map map, ClusterDescription clusterDescription, Format format) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addClusterKey");
        }
        Set<DescriptionKey> set = null;
        if (map.containsKey(format)) {
            set = (Set)map.get(format);
            if (!set.contains(clusterDescription.getKey())) {
                set.add(clusterDescription.getKey());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "added key ", clusterDescription.getKey());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set already contains cluster key");
            }
        } else {
            set = new HashSet();
            set.add(clusterDescription.getKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "added key ", clusterDescription.getKey());
            }
            map.put(format, set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClusterKey");
        }
    }

    public int getListenerTag() {
        return 0;
    }

    private Object forwardRequest(Identity identity, ObjectKey objectKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forwardRequest", identity);
        }
        Object object = null;
        IOR iOR = WLMLSDRouter.getLSDRouter(this.orb).select(identity, objectKey);
        object = this.orb.IORToObject(iOR);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forwardRequest", object);
        }
        return object;
    }

    public void validateRequest(ObjectKey objectKey) throws ForwardRequest {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateRequest", objectKey);
        }
        Identity identity = (Identity)threadIdentity.get();
        threadIdentity.set(null);
        if (identity != null && objectKey != null) {
            if (identity.equals(this.initClusterKey)) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "do not validate requests for INIT (4.0 admin server group) clusters");
                    Tr.exit(tc, "validateRequest", identity);
                }
                return;
            }
            if (!this.ucfServerClusterContext.validateClusterResidency(identity) && !this.backupClusterRequest(identity)) {
                ClusterDescription clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription((DescriptionKey)identity);
                ClusterDescription clusterDescription2 = null;
                if (clusterDescription != null) {
                    clusterDescription2 = ((ClusterDescription.Memento)clusterDescription.getMemento()).getBackupCluster();
                }
                if (clusterDescription2 == null || !this.ucfServerClusterContext.validateClusterResidency(clusterDescription2.getKey())) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Route validation forwarding agent, request being forwarded.", identity);
                    }
                    Object object = this.forwardRequest(identity, objectKey);
                    if (objectKey != null) {
                        throw new ForwardRequest(object);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateRequest", identity);
        }
    }

    private boolean backupClusterRequest(Identity identity) {
        boolean bl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "backupClusterRequest", identity);
            }
            bl = false;
            try {
                String string = IdentityMapping.getCellNameFromIdentity(identity);
                String string2 = (String)this.ivProcessProperties.get("key.containing.cellname");
                if (!string.equals(string2)) {
                    String string3 = IdentityMapping.getClusterNameFromClusterIdentity(identity);
                    Identity identity2 = IdentityMapping.getClusterIdentityFromClusterName(string2, string3);
                    bl = this.ucfServerClusterContext.validateClusterResidency(identity2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, ServerClusterContextListenerImpl.class.getName() + ".backupClusterRequest", "696", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "backupClusterRequest - Problem getting cell name from Identity: ", identity);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "backupClusterRequest", String.valueOf(bl));
        }
        return bl;
    }

    public void handleNotification(DescriptionKey descriptionKey, String string, java.lang.Object object, java.lang.Object object2) {
        java.lang.Object object3;
        java.lang.Object object4;
        java.lang.Object object5;
        HashMap<FormatImpl, DescriptionKey> hashMap;
        FormatImpl formatImpl;
        Description description;
        block6: {
            description = this.ivDescMgr.getDescription(descriptionKey);
            if (description instanceof ClusterDescription) {
                formatImpl = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 2);
                hashMap = new HashMap<FormatImpl, DescriptionKey>();
                hashMap.put(formatImpl, descriptionKey);
                try {
                    object5 = new ByteArrayOutputStream();
                    object4 = new ObjectOutputStream((OutputStream)object5);
                    this.ivDescMgr.stream(hashMap, (ObjectOutput)object4);
                    ((ObjectOutputStream)object4).flush();
                    object3 = ((ByteArrayOutputStream)object5).toByteArray();
                    wtCache.put(descriptionKey, object3);
                    ((ObjectOutputStream)object4).close();
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "unable to stream description", description);
                }
            }
        }
        formatImpl = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 3);
        hashMap = new HashMap();
        object5 = rtCache.entrySet().iterator();
        while (object5.hasNext()) {
            block7: {
                object4 = object5.next();
                hashMap.put(formatImpl, (DescriptionKey)object4.getKey());
                try {
                    object3 = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object3);
                    this.ivDescMgr.stream(hashMap, objectOutputStream);
                    objectOutputStream.flush();
                    byte[] byArray = ((ByteArrayOutputStream)object3).toByteArray();
                    rtCache.put(descriptionKey, byArray);
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "unable to stream description", description);
                }
            }
            hashMap.clear();
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.24 ");
        }
        threadIdentity = new ThreadLocal();
        rtCache = new HashMap();
        wtCache = new HashMap();
    }
}

