/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.ExtrinsicDescription;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.websphere.cluster.topography.SelectionDescription;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.KeyConverter;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.propagation.MultiversionLSDInteropHelper;
import com.ibm.ws.cluster.propagation.bulletinboard.BBDescriptionManager;
import com.ibm.ws.cluster.service.ClusterManagementImpl;
import com.ibm.ws.cluster.topography.ClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescription;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.LSDClusterMemberDescription;
import com.ibm.ws.cluster.topography.LSDClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBExistsException;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

public class StreamContextHandler {
    private static final TraceComponent tc = Tr.register(StreamContextHandler.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final int MAX_SERVER_WEIGHT = 20;
    private final String version1 = "version1";
    private final String version2 = "version2";
    private final String version4 = "version4";
    private boolean debug = false;
    private boolean entry = false;
    private Map clusterDescriptions = new HashMap();
    private Map memberToIds = new HashMap();
    private ORB orb = GlobalORBFactory.globalORB();
    private static StreamContextHandler instance;
    private KeyRepository ivKeyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private ClusterService ivClusterService = ClusterServiceFactory.getClusterService();
    private ClusterManagement ivClusterManagement = ClusterManagementFactory.getClusterManagement();
    private String ivCellName = null;
    private DescriptionManager ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
    private boolean ivDescMgrIsBBDescMgr = this.ivDescMgr instanceof BBDescriptionManager;
    private BBDescriptionManager ivBBDescMgr = null;
    private Format ivFormat = null;
    private Contract ivContract = null;
    private Map iiopMemberDistinction = new TreeMap();
    static /* synthetic */ Class class$com$ibm$ws$cluster$topography$LSDClusterMemberDescription;
    static /* synthetic */ Class class$com$ibm$ws$cluster$topography$SelectionClusterMemberDescription;

    public static StreamContextHandler getInstance() {
        if (instance == null) {
            instance = new StreamContextHandler();
        }
        return instance;
    }

    private StreamContextHandler() {
        this.debug = tc.isDebugEnabled();
        this.entry = tc.isEntryEnabled();
        this.setCellName();
        MultiversionLSDInteropHelper.lookupLSDCluster();
        ConcernImpl concernImpl = new ConcernImpl(Integer.MAX_VALUE);
        this.ivFormat = new FormatImpl(concernImpl, 1);
        this.ivContract = new ContractImpl();
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.ivContract.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        this.iiopMemberDistinction.put(IIOPClusterMemberDescription.distinction[0], IIOPClusterMemberDescription.distinction[1]);
        if (this.orb == null) {
            this.setOrb();
        }
        if (this.ivDescMgrIsBBDescMgr) {
            this.ivBBDescMgr = (BBDescriptionManager)this.ivDescMgr;
        }
    }

    public void parseVersion1(DataInput dataInput) throws IOException {
        int n;
        int n2;
        int n3;
        if (this.entry) {
            Tr.entry(tc, "parseVersion1");
        }
        HashMap hashMap = null;
        String string = dataInput.readUTF();
        if (this.debug) {
            Tr.debug(tc, "read cellName " + string);
        }
        String string2 = dataInput.readUTF();
        if (this.debug) {
            Tr.debug(tc, "read clusterName " + string2);
        }
        DescriptionKey descriptionKey = KeyConverter.convertKey(string, string2);
        if (this.debug) {
            Tr.debug(tc, "read clusterKey " + descriptionKey);
        }
        long l = dataInput.readLong();
        if (this.debug) {
            Tr.debug(tc, "read wire epoch " + l);
        }
        byte by = dataInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "read policy " + by);
        }
        DescriptionKey descriptionKey2 = SelectionDescription.KEY_WEIGHTED;
        if (by == 1) {
            descriptionKey2 = SelectionDescription.KEY_WEIGHTED_PREFER_LOCAL;
        }
        if (!this.setClusterData(descriptionKey2, l, descriptionKey, 1)) {
            if (this.entry) {
                Tr.exit(tc, "parseVersion1 -- cluster description current");
            }
            return;
        }
        hashMap = (HashMap)this.getClusterMembers(descriptionKey);
        ClusterMemberDescription clusterMemberDescription = null;
        int n4 = dataInput.readInt();
        if (this.debug) {
            Tr.debug(tc, "read size " + n4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            String string3 = dataInput.readUTF();
            if (this.debug) {
                Tr.debug(tc, "read id " + string3);
            }
            int n5 = dataInput.readInt();
            if (this.debug) {
                Tr.debug(tc, "read member's state " + n5);
            }
            n2 = dataInput.readInt();
            if (this.debug) {
                Tr.debug(tc, "read member's weight " + n2);
            }
            String string4 = dataInput.readUTF();
            if (this.debug) {
                Tr.debug(tc, "read member's IOR " + string4);
            }
            if (n5 != 0) continue;
            clusterMemberDescription = (ClusterMemberDescription)hashMap.get(string3);
            if (clusterMemberDescription == null) {
                DescriptionKey descriptionKey3 = null;
                try {
                    descriptionKey3 = this.ivDescMgr.stringToKey(string3);
                    clusterMemberDescription = (ClusterMemberDescription)this.ivDescMgr.getDescription(descriptionKey3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got existing member: ", clusterMemberDescription);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (clusterMemberDescription == null) {
                    clusterMemberDescription = this.createMember(string, string3, descriptionKey, n2, ORB.createIOR((ORB)this.orb, (String)string4), descriptionKey, "version1");
                } else {
                    this.updateMember(clusterMemberDescription, n2, ORB.createIOR((ORB)this.orb, (String)string4), descriptionKey);
                }
            } else {
                this.updateMember(clusterMemberDescription, n2, ORB.createIOR((ORB)this.orb, (String)string4), descriptionKey);
            }
            hashMap.remove(string3);
        }
        if (!hashMap.isEmpty()) {
            this.removeMembers(hashMap, descriptionKey);
        }
        n3 = dataInput.readInt();
        if (this.debug) {
            Tr.debug(tc, "LSD list size " + String.valueOf(n3));
        }
        for (n = 0; n < n3; ++n) {
            String string5 = dataInput.readUTF();
            n2 = dataInput.readShort();
            short s = dataInput.readShort();
            short s2 = dataInput.readShort();
            if (!this.debug) continue;
            Tr.debug(tc, "lsd list host:" + string5 + " port:" + n2 + " sslPort:" + s + " sslccPort:" + s2);
        }
        n = dataInput.readInt();
        if (this.debug) {
            Tr.debug(tc, "read lsdMirroredListSize " + n);
        }
        if (this.entry) {
            Tr.exit(tc, "parseVersion1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseVersion2(ObjectInput objectInput, boolean bl, DescriptionKey descriptionKey, boolean bl2) throws IOException {
        if (!bl2) {
            try {
                if (this.ivDescMgrIsBBDescMgr) {
                    this.ivBBDescMgr.setThreadForLocalPosting();
                }
                this.parseVersion2(objectInput, bl, descriptionKey);
            }
            finally {
                if (this.ivDescMgrIsBBDescMgr) {
                    this.ivBBDescMgr.unsetThreadForLocalPosting();
                }
            }
        } else {
            this.parseVersion2(objectInput, bl, descriptionKey);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void parseVersion2(ObjectInput var1_1, boolean var2_2, DescriptionKey var3_3) throws IOException {
        if (this.entry) {
            Tr.entry(StreamContextHandler.tc, "parseVersion2");
        }
        var6_4 = null;
        var7_5 = null;
        var8_6 = null;
        var9_7 = KeyRepositoryFactory.getInstance().getKeyRepository();
        if (!var2_2) {
            try {
                var4_8 = var1_1.readInt();
                if (this.debug) {
                    Tr.debug(StreamContextHandler.tc, "count " + var4_8);
                }
                while (var4_8 > 0) {
                    var6_4 = (Format)var1_1.readObject();
                    if (this.debug) {
                        Tr.debug(StreamContextHandler.tc, "format " + var6_4);
                    }
                    var5_9 = var1_1.readInt();
                    if (this.debug) {
                        Tr.debug(StreamContextHandler.tc, "size " + var5_9);
                    }
                    while (var5_9 > 0) {
                        var8_6 = (String[])var1_1.readObject();
                        if (this.debug) {
                            Tr.debug(StreamContextHandler.tc, "read String[] ", new Object[]{var8_6[0], var8_6[1]});
                        }
                        var7_5 = KeyConverter.convertKey(var8_6);
                        var10_10 = (String)var1_1.readObject();
                        if (this.debug) {
                            Tr.debug(StreamContextHandler.tc, "implString " + var10_10);
                        }
                        var11_14 = (ClusterDescription)this.ivDescMgr.getDescription(var7_5, var10_10);
                        this.parseVersion2ClusterDescription(var1_1, var11_14, var6_4);
                        if (StreamContextHandler.tc.isEventEnabled()) {
                            Tr.event(StreamContextHandler.tc, "Description updated.", var11_14);
                        }
                        --var5_9;
                    }
                    --var4_8;
                }
            }
            catch (Exception var10_11) {
                FFDCFilter.processException(var10_11, StreamContextHandler.class.getName() + ".parseVersion2", "525", this, new Object[]{var7_5, var6_4});
                if (!StreamContextHandler.tc.isEventEnabled()) ** GOTO lbl47
                Tr.event(StreamContextHandler.tc, "unexpected", var10_11);
            }
        } else {
            try {
                var10_12 = (ClusterDescription)this.ivDescMgr.getDescription(var3_3, ClusterDescription.class.getName());
                this.parseVersion2ClusterDescription(var1_1, var10_12, this.ivFormat);
            }
            catch (Exception var10_13) {
                // empty catch block
            }
        }
lbl47:
        // 5 sources

        if (this.entry) {
            Tr.exit(StreamContextHandler.tc, "parseVersion2");
        }
    }

    private void parseVersion2ClusterDescription(ObjectInput objectInput, ClusterDescription clusterDescription, Format format) throws IOException, ClassNotFoundException {
        SelectionDescription selectionDescription;
        block26: {
            byte by = objectInput.readByte();
            if (this.debug) {
                Tr.debug(tc, "versionIntrinsicA " + by);
            }
            int n = objectInput.readInt();
            if (this.debug) {
                Tr.debug(tc, "size " + n);
            }
            byte by2 = objectInput.readByte();
            if (this.debug) {
                Tr.debug(tc, "versionCMD " + by2);
            }
            boolean bl = objectInput.readBoolean();
            if (this.debug) {
                Tr.debug(tc, "leaf " + bl);
            }
            byte by3 = objectInput.readByte();
            if (this.debug) {
                Tr.debug(tc, "state " + by3);
            }
            clusterDescription.setState(by3);
            int n2 = objectInput.readInt();
            if (this.debug) {
                Tr.debug(tc, "weight " + n2);
            }
            String string = objectInput.readUTF();
            if (this.debug) {
                Tr.debug(tc, "mixed-version flag " + string);
            }
            ((ClusterMemberDescriptionImpl)((Object)clusterDescription)).setVersion("version2");
            byte by4 = objectInput.readByte();
            if (this.debug) {
                Tr.debug(tc, "clusterDescriptionVersion " + by4);
            }
            int n3 = objectInput.readInt();
            if (this.debug) {
                Tr.debug(tc, "size of member map " + n3);
            }
            for (int i = 0; i < n3; ++i) {
                String[] stringArray = (String[])objectInput.readObject();
                if (this.debug) {
                    Tr.debug(tc, "read memberKey String[]", new Object[]{stringArray[0], stringArray[1], stringArray[2]});
                }
                ProcessDescription processDescription = null;
                try {
                    processDescription = (ProcessDescription)this.ivDescMgr.getDescription(KeyConverter.convertKey(stringArray), (class$com$ibm$websphere$cluster$topography$ProcessDescription == null ? StreamContextHandler.class$("com.ibm.websphere.cluster.topography.ProcessDescription") : class$com$ibm$websphere$cluster$topography$ProcessDescription).getName());
                    clusterDescription.addMember(processDescription);
                    this.parseVersion2ClusterMember(objectInput, clusterDescription, processDescription, format);
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (class$com$ibm$ws$cluster$propagation$StreamContextHandler == null ? StreamContextHandler.class$("com.ibm.ws.cluster.propagation.StreamContextHandler") : class$com$ibm$ws$cluster$propagation$StreamContextHandler).getName() + ".parseVersion2ClusterDescription", "613", this);
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unexpected", exception);
                }
            }
            long l = objectInput.readLong();
            if (this.debug) {
                Tr.debug(tc, "structEpoch " + l);
            }
            clusterDescription.setStructuralEpoch(l);
            long l2 = objectInput.readLong();
            if (this.debug) {
                Tr.debug(tc, "influentialEpoch " + l2);
            }
            clusterDescription.setInfluentialEpoch(l2);
            String[] stringArray = (String[])objectInput.readObject();
            if (this.debug) {
                Tr.debug(tc, "read selectionDescriptionKey String[]");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.debug) continue;
                    Tr.debug(tc, "selecDesKey[" + i + "] = " + stringArray[i]);
                }
            }
            DescriptionKey descriptionKey = KeyConverter.convertKey(stringArray);
            selectionDescription = null;
            try {
                selectionDescription = (SelectionDescription)this.ivDescMgr.getDescription(descriptionKey, SelectionDescription.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, StreamContextHandler.class.getName() + ".parseVersion2ClusterDescription", "648", this, new Object[]{descriptionKey});
                if (!tc.isEventEnabled()) break block26;
                Tr.event(tc, "unexpected", exception);
            }
        }
        clusterDescription.setSelectionDescription(selectionDescription);
        byte by = objectInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "selecDesc version " + by);
        }
        short s = objectInput.readShort();
        if (this.debug) {
            Tr.debug(tc, "extendedCDVersion " + s);
        }
        boolean bl = objectInput.readBoolean();
        if (this.debug) {
            Tr.debug(tc, "isThereABackupCluster " + bl);
        }
        if (bl) {
            ClusterDescription clusterDescription2;
            block27: {
                String[] stringArray = (String[])objectInput.readObject();
                if (this.debug) {
                    Tr.debug(tc, "Read backup cluster key", new Object[]{stringArray[0], stringArray[1]});
                }
                DescriptionKey descriptionKey = KeyConverter.convertKey(stringArray);
                clusterDescription2 = null;
                try {
                    clusterDescription2 = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey, ClusterDescription.class.getName());
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, StreamContextHandler.class.getName() + ".parseVersion2ClusterDescription", "681", this, new Object[]{descriptionKey});
                    if (!tc.isEventEnabled()) break block27;
                    Tr.event(tc, "unexpected", exception);
                }
            }
            clusterDescription.setBackupCluster(clusterDescription2);
        }
    }

    private void parseVersion2ClusterMember(ObjectInput objectInput, ClusterDescription clusterDescription, ProcessDescription processDescription, Format format) throws IOException, ClassNotFoundException {
        String string;
        Object object;
        int n;
        byte by = objectInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "IntrinsicA version " + by);
        }
        int n2 = objectInput.readInt();
        if (this.debug) {
            Tr.debug(tc, "extrinsic map size " + n2);
        }
        for (n = 0; n < n2; ++n) {
            block30: {
                String[] stringArray = (String[])objectInput.readObject();
                if (this.debug) {
                    Tr.debug(tc, "read extrinsic key");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Tr.debug(tc, "extrinsicIdentity[" + i + "] = " + stringArray[i]);
                    }
                }
                DescriptionKey descriptionKey = KeyConverter.convertKey(stringArray);
                String string2 = objectInput.readUTF();
                if (this.debug) {
                    Tr.debug(tc, "read implKey " + string2);
                }
                object = null;
                try {
                    object = (ExtrinsicDescription)this.ivDescMgr.getDescription(descriptionKey, string2);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, (class$com$ibm$ws$cluster$propagation$StreamContextHandler == null ? StreamContextHandler.class$("com.ibm.ws.cluster.propagation.StreamContextHandler") : class$com$ibm$ws$cluster$propagation$StreamContextHandler).getName() + ".parseVersion2ClusterMember", "724", this, new Object[]{descriptionKey});
                    if (!tc.isEventEnabled()) break block30;
                    Tr.event(tc, "unexpected", exception);
                }
            }
            if (object instanceof IIOPClusterMemberDescription) {
                byte by2 = objectInput.readByte();
                if (this.debug) {
                    Tr.debug(tc, "read IIOPCMD version " + by2);
                }
                string = objectInput.readUTF();
                if (this.debug) {
                    Tr.debug(tc, "read ior " + string);
                }
                ((IIOPClusterMemberDescriptionImpl)object).setORB(this.orb);
                ((IIOPClusterMemberDescriptionImpl)object).setIOR(ORB.createIOR((ORB)this.orb, (String)string));
            } else if (object instanceof LSDClusterMemberDescription) {
                byte by3 = objectInput.readByte();
                if (this.debug) {
                    Tr.debug(tc, "read LSDCMD version " + by3);
                }
                string = objectInput.readUTF();
                if (this.debug) {
                    Tr.debug(tc, "host " + string);
                }
                ((LSDClusterMemberDescriptionImpl)object).setHost(string);
                int n3 = objectInput.readInt();
                if (this.debug) {
                    Tr.debug(tc, "port " + n3);
                }
                ((LSDClusterMemberDescriptionImpl)object).setPort(n3);
                int n4 = objectInput.readInt();
                if (this.debug) {
                    Tr.debug(tc, "sslPort " + n4);
                }
                ((LSDClusterMemberDescriptionImpl)object).setSSLPort(n4);
                int n5 = objectInput.readInt();
                if (this.debug) {
                    Tr.debug(tc, "sslccPort " + n5);
                }
                ((LSDClusterMemberDescriptionImpl)object).setSSLClientCertificatePort(n5);
            } else if (object instanceof SelectionClusterMemberDescription) {
                byte by4 = objectInput.readByte();
                if (this.debug) {
                    Tr.debug(tc, "version4 " + by4);
                }
                string = objectInput.readUTF();
                if (this.debug) {
                    Tr.debug(tc, "host " + string);
                }
                ((SelectionClusterMemberDescriptionImpl)object).setHost(string);
            }
            processDescription.setExtrinsicData((ExtrinsicDescription)object);
        }
        n = objectInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "ClusterMemberDescription version " + n);
        }
        boolean bl = objectInput.readBoolean();
        if (this.debug) {
            Tr.debug(tc, "isLeaf " + bl);
        }
        byte by5 = objectInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "state " + by5);
        }
        processDescription.setState(by5);
        int n6 = objectInput.readInt();
        if (this.debug) {
            Tr.debug(tc, "weight " + n6);
        }
        this.ivClusterManagement.setDesiredWeight(clusterDescription.getKey(), processDescription.getKey(), n6);
        object = objectInput.readUTF();
        if (this.debug) {
            Tr.debug(tc, "multiversionVersion " + (String)object);
        }
        ((ClusterMemberDescriptionImpl)((Object)processDescription)).setVersion("version2");
        byte by6 = objectInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "processDescription version " + by6);
        }
        string = objectInput.readUTF();
        if (this.debug) {
            Tr.debug(tc, "nodeName " + string);
        }
        processDescription.setNodeName(string);
        String string3 = objectInput.readUTF();
        if (this.debug) {
            Tr.debug(tc, "processName " + string3);
        }
        processDescription.setProcessName(string3);
    }

    public byte[] exportVersion1(ClusterDescription clusterDescription, String string) {
        byte[] byArray;
        block26: {
            if (this.entry) {
                Tr.entry(tc, "exportVersion1", clusterDescription);
            }
            byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                dataOutputStream.writeInt(1);
                if (this.debug) {
                    Tr.debug(tc, "Write Version 1");
                }
                if (this.ivCellName == null) {
                    this.setCellName();
                }
                if (this.ivCellName == null) {
                    dataOutputStream.writeUTF("CELLNAME");
                    if (this.debug) {
                        Tr.debug(tc, "Write CellName CELLNAME");
                    }
                } else {
                    dataOutputStream.writeUTF(this.ivCellName);
                    if (this.debug) {
                        Tr.debug(tc, "Write CellName " + this.ivCellName);
                    }
                }
                if (string == null) {
                    object4 = clusterDescription.getKey();
                    Map map = object4.getProperties();
                    String string2 = (String)map.get("CLUSTERNAME");
                    dataOutputStream.writeUTF(string2);
                    if (this.debug) {
                        Tr.debug(tc, "Write newClusterName", string2);
                    }
                } else {
                    dataOutputStream.writeUTF(string);
                    if (this.debug) {
                        Tr.debug(tc, "Write clusterName " + string);
                    }
                }
                object4 = (ClusterDescription.Memento)clusterDescription.getMemento();
                long l = object4.getStructuralEpoch();
                if ((l == -2L || l == -1L) && (object3 = object4.getClusterMembers()).hasNext()) {
                    l = System.currentTimeMillis();
                }
                dataOutputStream.writeLong(l);
                if (this.debug) {
                    Tr.debug(tc, "Write StructuralEpoch " + l);
                }
                if ((object3 = object4.getSelectionDescription().getKey()).equals(SelectionDescription.KEY_WEIGHTED)) {
                    dataOutputStream.writeByte(0);
                    if (this.debug) {
                        Tr.debug(tc, "Write Weight Policy 0");
                    }
                } else {
                    dataOutputStream.writeByte(1);
                    if (this.debug) {
                        Tr.debug(tc, "Write Weight Policy 1");
                    }
                }
                Stack<Object> stack = new Stack<Object>();
                int n = 0;
                Iterator iterator = object4.getClusterMembers();
                while (iterator.hasNext()) {
                    IOR iOR;
                    IIOPClusterMemberDescription.Memento memento;
                    object2 = (ClusterMemberDescription)iterator.next();
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    treeMap.put(IIOPClusterMemberDescription.distinction[0], IIOPClusterMemberDescription.distinction[1]);
                    DescriptionKey descriptionKey = this.ivKeyRepository.getDescriptionKey(object2.getKey(), treeMap);
                    object = (ClusterMemberDescription.Memento)object2.getMemento();
                    IIOPClusterMemberDescription iIOPClusterMemberDescription = (IIOPClusterMemberDescription)object.getExtrinsicData(descriptionKey);
                    if (iIOPClusterMemberDescription == null || (memento = (IIOPClusterMemberDescription.Memento)iIOPClusterMemberDescription.getMemento()) == null || (iOR = memento.getIOR()) == null) continue;
                    int n2 = this.ivClusterManagement.getDesiredWeight(clusterDescription.getKey(), object2.getKey());
                    stack.push(iOR.stringify());
                    stack.push(new Integer(n2));
                    stack.push(new Byte(object.getState()));
                    stack.push(this.ivClusterService.identityToString(object2.getKey()));
                    ++n;
                }
                if (this.debug) {
                    Tr.debug(tc, "Write cluster Members size " + n);
                }
                dataOutputStream.writeInt(n);
                if (!stack.empty()) {
                    while (!stack.empty()) {
                        object2 = (String)stack.pop();
                        byte by = (Byte)stack.pop();
                        int n3 = (Integer)stack.pop();
                        object = (String)stack.pop();
                        dataOutputStream.writeUTF((String)object2);
                        dataOutputStream.writeInt(by);
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.writeUTF((String)object);
                        if (!this.debug) continue;
                        Tr.debug(tc, "Write key [" + (String)object2 + "] state [" + by + " ] weight [" + n3 + "] ior [" + (String)object + "]");
                    }
                }
                MultiversionLSDInteropHelper.writeLSDList(dataOutputStream);
                dataOutputStream.writeInt(0);
                if (this.debug) {
                    Tr.debug(tc, "Write mirrored cluster size 0");
                }
                byArray = byteArrayOutputStream.toByteArray();
                if (tc.isDebugEnabled() && byArray != null) {
                    Tr.debug(tc, "uncompressed response: ", new ByteArray(byArray).toString());
                }
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) break block26;
                Tr.event(tc, "unexpected", exception);
            }
        }
        if (this.entry) {
            Tr.exit(tc, "exportVersion1", byArray);
        }
        return byArray;
    }

    public byte[] exportVersion2(boolean bl, ClusterDescription[] clusterDescriptionArray, boolean bl2, boolean bl3) {
        byte[] byArray;
        block24: {
            int n;
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            block23: {
                if (this.entry) {
                    Tr.entry(tc, "exportVersion2");
                }
                byArray = null;
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = null;
                n = 0;
                if (bl) {
                    dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    try {
                        dataOutputStream.writeInt(2);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, StreamContextHandler.class.getName() + ".exportVersion2", "1211", this);
                        if (!this.debug) break block23;
                        Tr.debug(tc, "Unexpected exception", iOException);
                    }
                }
            }
            try {
                Object[] objectArray;
                ObjectOutputStream objectOutputStream = dataOutputStream != null ? new ObjectOutputStream(dataOutputStream) : new ObjectOutputStream(byteArrayOutputStream);
                int n2 = clusterDescriptionArray.length;
                DescriptionKey descriptionKey = null;
                if (!bl2) {
                    objectOutputStream.writeInt(1);
                    if (this.debug) {
                        Tr.debug(tc, "wrote count 1");
                    }
                    objectOutputStream.writeObject(this.ivFormat);
                    if (this.debug) {
                        Tr.debug(tc, "wrote format " + this.ivFormat);
                    }
                    objectOutputStream.writeInt(n2);
                    if (this.debug) {
                        Tr.debug(tc, "wrote size " + n2);
                    }
                    for (n = 0; n < n2; ++n) {
                        descriptionKey = clusterDescriptionArray[n].getKey();
                        Map map = descriptionKey.getProperties();
                        if (map.containsValue("LSDCluster") || bl3) {
                            objectArray = KeyConverter.translateKey(descriptionKey, null, (class$com$ibm$websphere$cluster$topography$ClusterDescription == null ? StreamContextHandler.class$("com.ibm.websphere.cluster.topography.ClusterDescription") : class$com$ibm$websphere$cluster$topography$ClusterDescription).getName(), false);
                        } else {
                            if (this.ivCellName == null) {
                                this.setCellName();
                            }
                            objectArray = this.ivCellName == null ? (Object[])new String[]{"CELLNAME", this.ivClusterService.identityToString(descriptionKey)} : (Object[])new String[]{this.ivCellName, this.ivClusterService.identityToString(descriptionKey)};
                        }
                        objectOutputStream.writeObject(objectArray);
                        if (this.debug) {
                            Tr.debug(tc, "wrote identities");
                            for (int i = 0; i < objectArray.length; ++i) {
                                Tr.debug(tc, "identities[" + i + "] = " + (String)objectArray[i]);
                            }
                        }
                        objectOutputStream.writeObject(clusterDescriptionArray[n].getDefinitionKey());
                        if (this.debug) {
                            Tr.debug(tc, "wrote definitionKey " + clusterDescriptionArray[n].getDefinitionKey());
                        }
                        this.exportVersion2ClusterDescription(objectOutputStream, clusterDescriptionArray[n]);
                    }
                } else {
                    this.exportVersion2ClusterDescription(objectOutputStream, clusterDescriptionArray[n]);
                }
                objectOutputStream.flush();
                if (!bl2) {
                    objectArray = byteArrayOutputStream.toByteArray();
                    if (tc.isDebugEnabled() && objectArray != null) {
                        Tr.debug(tc, "uncompressed response: ", new ByteArray((byte[])objectArray).toString());
                    }
                    byArray = Compressor.compress((byte[])objectArray, 4);
                } else {
                    byArray = byteArrayOutputStream.toByteArray();
                }
                if (dataOutputStream != null) {
                    byteArrayOutputStream.flush();
                }
                objectOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, StreamContextHandler.class.getName() + ".exportVersion2", "1287", this);
                if (!this.debug) break block24;
                Tr.debug(tc, "Unexpected exception", iOException);
            }
        }
        if (this.entry) {
            Tr.exit(tc, "exportVersion2", byArray);
        }
        return byArray;
    }

    private void exportVersion2ClusterDescription(ObjectOutputStream objectOutputStream, ClusterDescription clusterDescription) throws IOException {
        ClusterDescription clusterDescription2;
        Description description;
        objectOutputStream.writeByte(0);
        if (this.debug) {
            Tr.debug(tc, "wrote IntrinsicA version 0");
        }
        objectOutputStream.writeInt(0);
        if (this.debug) {
            Tr.debug(tc, "wrote size of extrinsic map 0");
        }
        objectOutputStream.writeByte(0);
        if (this.debug) {
            Tr.debug(tc, "wrote CMD version 0");
        }
        ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
        objectOutputStream.writeBoolean(memento.isLeaf());
        if (this.debug) {
            Tr.debug(tc, "wrote isLeaf " + memento.isLeaf());
        }
        objectOutputStream.writeByte(memento.getState());
        if (this.debug) {
            Tr.debug(tc, "wrote state " + memento.getState());
        }
        objectOutputStream.writeInt(2);
        if (this.debug) {
            Tr.debug(tc, "wrote weight 2");
        }
        objectOutputStream.writeUTF("version4");
        if (this.debug) {
            Tr.debug(tc, "wrote mixed-Version flag version4");
        }
        objectOutputStream.writeByte(0);
        if (this.debug) {
            Tr.debug(tc, "wrote clusterDescription version 0");
        }
        Iterator iterator = memento.getClusterMembers();
        HashSet<ProcessDescription> hashSet = new HashSet<ProcessDescription>();
        int n = 0;
        while (iterator.hasNext()) {
            description = (Description)iterator.next();
            if (description instanceof ClusterDescription) continue;
            hashSet.add((ProcessDescription)description);
            ++n;
        }
        objectOutputStream.writeInt(n);
        if (this.debug) {
            Tr.debug(tc, "wrote size of member map " + n);
        }
        this.exportVersion2Members(objectOutputStream, clusterDescription.getKey(), hashSet);
        objectOutputStream.writeLong(memento.getStructuralEpoch());
        if (this.debug) {
            Tr.debug(tc, "wrote structural epoch " + memento.getStructuralEpoch());
        }
        objectOutputStream.writeLong(memento.getInfluentialEpoch());
        if (this.debug) {
            Tr.debug(tc, "wrote influential epoch " + memento.getInfluentialEpoch());
        }
        description = memento.getSelectionDescription();
        String[] stringArray = KeyConverter.translateKey(description.getKey(), new DescriptionKey[]{clusterDescription.getKey()}, description.getDefinitionKey(), description.getKey().equals(SelectionDescription.KEY_WEIGHTED_PREFER_LOCAL));
        objectOutputStream.writeObject(stringArray);
        if (this.debug) {
            Tr.debug(tc, "wrote identities");
            for (int i = 0; i < stringArray.length; ++i) {
                Tr.debug(tc, "identities[" + i + "] = " + stringArray[i]);
            }
        }
        objectOutputStream.writeByte(0);
        if (this.debug) {
            Tr.debug(tc, "wrote selection description version 0");
        }
        objectOutputStream.writeShort(0);
        if (this.debug) {
            Tr.debug(tc, "wrote extended cluster description version 0");
        }
        boolean bl = (clusterDescription2 = memento.getBackupCluster()) != null;
        objectOutputStream.writeBoolean(bl);
        if (this.debug) {
            Tr.debug(tc, "isBackupAvailable " + bl);
        }
        if (bl) {
            String[] stringArray2 = KeyConverter.translateKey(clusterDescription2.getKey(), null, clusterDescription2.getDefinitionKey(), false);
            objectOutputStream.writeObject(stringArray2);
            if (this.debug) {
                Tr.debug(tc, "wrote identities");
                for (int i = 0; i < stringArray2.length; ++i) {
                    Tr.debug(tc, "identities[" + i + "] = " + stringArray2[i]);
                }
            }
        }
    }

    private void exportVersion2Members(ObjectOutput objectOutput, DescriptionKey descriptionKey, Set set) throws IOException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            String[] stringArray;
            HashSet hashSet = new HashSet();
            int n = 0;
            ProcessDescription processDescription = (ProcessDescription)iterator.next();
            if (this.debug) {
                Tr.debug(tc, "got cluster member to export", processDescription);
            }
            String[] stringArray2 = KeyConverter.translateKey(processDescription.getKey(), new DescriptionKey[]{descriptionKey}, processDescription.getDefinitionKey(), false);
            objectOutput.writeObject(stringArray2);
            if (this.debug) {
                Tr.debug(tc, "wrote identities");
                for (int i = 0; i < stringArray2.length; ++i) {
                    Tr.debug(tc, "identities[" + i + "] = " + stringArray2[i]);
                }
            }
            ProcessDescription.Memento memento = (ProcessDescription.Memento)processDescription.getMemento();
            Set set2 = memento.getExtrinsicData().entrySet();
            DescriptionKey descriptionKey2 = null;
            DescriptionKey descriptionKey3 = null;
            DescriptionKey descriptionKey4 = null;
            IIOPClusterMemberDescription iIOPClusterMemberDescription = null;
            LSDClusterMemberDescription lSDClusterMemberDescription = null;
            SelectionClusterMemberDescription selectionClusterMemberDescription = null;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                stringArray = iterator2.next();
                object = (Description)stringArray.getValue();
                if (object instanceof IIOPClusterMemberDescription) {
                    descriptionKey2 = (DescriptionKey)stringArray.getKey();
                    iIOPClusterMemberDescription = (IIOPClusterMemberDescription)object;
                    ++n;
                    continue;
                }
                if (object instanceof LSDClusterMemberDescription) {
                    descriptionKey3 = (DescriptionKey)stringArray.getKey();
                    lSDClusterMemberDescription = (LSDClusterMemberDescription)object;
                    ++n;
                    continue;
                }
                if (!(object instanceof SelectionClusterMemberDescription)) continue;
                descriptionKey4 = (DescriptionKey)stringArray.getKey();
                selectionClusterMemberDescription = (SelectionClusterMemberDescription)object;
                ++n;
            }
            objectOutput.writeByte(0);
            if (this.debug) {
                Tr.debug(tc, "wrote IntrinsicA version 0");
            }
            objectOutput.writeInt(n);
            if (this.debug) {
                Tr.debug(tc, "wrote extrinsic map size " + n);
            }
            if (iIOPClusterMemberDescription != null) {
                stringArray = KeyConverter.translateKey(descriptionKey2, new DescriptionKey[]{descriptionKey, processDescription.getKey()}, (class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription == null ? StreamContextHandler.class$("com.ibm.ws.cluster.topography.IIOPClusterMemberDescription") : class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription).getName(), false);
                objectOutput.writeObject(stringArray);
                if (this.debug) {
                    Tr.debug(tc, "wrote identities");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Tr.debug(tc, "identities[" + i + "] = " + stringArray[i]);
                    }
                }
                objectOutput.writeUTF((class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription == null ? StreamContextHandler.class$("com.ibm.ws.cluster.topography.IIOPClusterMemberDescription") : class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription).getName());
                if (this.debug) {
                    Tr.debug(tc, "wrote impl string " + (class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription == null ? StreamContextHandler.class$("com.ibm.ws.cluster.topography.IIOPClusterMemberDescription") : class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription).getName());
                }
                objectOutput.writeByte(0);
                if (this.debug) {
                    Tr.debug(tc, "wrote iiop CMD version 0");
                }
                if ((object = ((IIOPClusterMemberDescription.Memento)iIOPClusterMemberDescription.getMemento()).getIOR()) != null) {
                    objectOutput.writeUTF(object.stringify());
                    if (this.debug) {
                        Tr.debug(tc, "wrote ior " + object.stringify());
                    }
                } else {
                    objectOutput.writeUTF("");
                    if (this.debug) {
                        Tr.debug(tc, "wrote or as empty string");
                    }
                }
            }
            if (lSDClusterMemberDescription != null) {
                stringArray = KeyConverter.translateKey(descriptionKey3, new DescriptionKey[]{descriptionKey, processDescription.getKey()}, (class$com$ibm$ws$cluster$topography$LSDClusterMemberDescription == null ? StreamContextHandler.class$("com.ibm.ws.cluster.topography.LSDClusterMemberDescription") : class$com$ibm$ws$cluster$topography$LSDClusterMemberDescription).getName(), false);
                objectOutput.writeObject(stringArray);
                if (this.debug) {
                    Tr.debug(tc, "wrote identities");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Tr.debug(tc, "identities[" + i + "] = " + stringArray[i]);
                    }
                }
                objectOutput.writeUTF((class$com$ibm$ws$cluster$topography$LSDClusterMemberDescription == null ? StreamContextHandler.class$("com.ibm.ws.cluster.topography.LSDClusterMemberDescription") : class$com$ibm$ws$cluster$topography$LSDClusterMemberDescription).getName());
                if (this.debug) {
                    Tr.debug(tc, "wrote impl string " + (class$com$ibm$ws$cluster$topography$LSDClusterMemberDescription == null ? StreamContextHandler.class$("com.ibm.ws.cluster.topography.LSDClusterMemberDescription") : class$com$ibm$ws$cluster$topography$LSDClusterMemberDescription).getName());
                }
                objectOutput.writeByte(0);
                if (this.debug) {
                    Tr.debug(tc, "wrote lsd CMD version 0");
                }
                object = (LSDClusterMemberDescription.Memento)lSDClusterMemberDescription.getMemento();
                objectOutput.writeUTF(object.getHost());
                if (this.debug) {
                    Tr.debug(tc, "wrote host " + object.getHost());
                }
                objectOutput.writeInt(object.getPort());
                if (this.debug) {
                    Tr.debug(tc, "wrote port " + object.getPort());
                }
                objectOutput.writeInt(object.getSSLPort());
                if (this.debug) {
                    Tr.debug(tc, "wrote sslPort " + object.getSSLPort());
                }
                objectOutput.writeInt(object.getSSLClientCertificatePort());
                if (this.debug) {
                    Tr.debug(tc, "wrote sslccPort " + object.getSSLClientCertificatePort());
                }
            }
            if (selectionClusterMemberDescription != null) {
                stringArray = KeyConverter.translateKey(descriptionKey4, new DescriptionKey[]{descriptionKey, processDescription.getKey()}, (class$com$ibm$ws$cluster$topography$SelectionClusterMemberDescription == null ? StreamContextHandler.class$("com.ibm.ws.cluster.topography.SelectionClusterMemberDescription") : class$com$ibm$ws$cluster$topography$SelectionClusterMemberDescription).getName(), false);
                objectOutput.writeObject(stringArray);
                if (this.debug) {
                    Tr.debug(tc, "wrote identities");
                    for (int i = 0; i < stringArray.length; ++i) {
                        Tr.debug(tc, "identities[" + i + "] = " + stringArray[i]);
                    }
                }
                objectOutput.writeUTF((class$com$ibm$ws$cluster$topography$SelectionClusterMemberDescription == null ? StreamContextHandler.class$("com.ibm.ws.cluster.topography.SelectionClusterMemberDescription") : class$com$ibm$ws$cluster$topography$SelectionClusterMemberDescription).getName());
                if (this.debug) {
                    Tr.debug(tc, "wrote impl string " + (class$com$ibm$ws$cluster$topography$SelectionClusterMemberDescription == null ? StreamContextHandler.class$("com.ibm.ws.cluster.topography.SelectionClusterMemberDescription") : class$com$ibm$ws$cluster$topography$SelectionClusterMemberDescription).getName());
                }
                objectOutput.writeByte(0);
                if (this.debug) {
                    Tr.debug(tc, "wrote selection description version 0");
                }
                objectOutput.writeUTF(((SelectionClusterMemberDescription.Memento)selectionClusterMemberDescription.getMemento()).getHost());
                if (this.debug) {
                    Tr.debug(tc, "wrote host " + ((SelectionClusterMemberDescription.Memento)selectionClusterMemberDescription.getMemento()).getHost());
                }
            }
            objectOutput.writeByte(0);
            if (this.debug) {
                Tr.debug(tc, "wrote process description version 0");
            }
            objectOutput.writeBoolean(memento.isLeaf());
            if (this.debug) {
                Tr.debug(tc, "wrote isLeaf " + memento.isLeaf());
            }
            objectOutput.writeByte(memento.getState());
            if (this.debug) {
                Tr.debug(tc, "wrote state " + memento.getState());
            }
            int n2 = this.ivClusterManagement.getDesiredWeight(descriptionKey, processDescription.getKey());
            objectOutput.writeInt(n2);
            if (this.debug) {
                Tr.debug(tc, "wrote weight " + n2);
            }
            objectOutput.writeUTF("version4");
            if (this.debug) {
                Tr.debug(tc, "wrote mixed-version flag version4");
            }
            objectOutput.writeByte(0);
            if (this.debug) {
                Tr.debug(tc, "wrote process description version 0");
            }
            objectOutput.writeUTF(memento.getNodeName());
            if (this.debug) {
                Tr.debug(tc, "wrote nodeName " + memento.getNodeName());
            }
            objectOutput.writeUTF(memento.getProcessName());
            if (!this.debug) continue;
            Tr.debug(tc, "wrote processName " + memento.getProcessName());
        }
    }

    public void parseVersion2IIOPClusterMemberDescription(IIOPClusterMemberDescription iIOPClusterMemberDescription, ObjectInput objectInput) throws IOException {
        IOR iOR;
        if (this.entry) {
            Tr.entry(tc, "parseVersion2IIOPClusterMemberDescription");
        }
        byte by = objectInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "read version " + by);
        }
        String string = objectInput.readUTF();
        if (this.debug) {
            Tr.debug(tc, "importFromStream", string);
        }
        IOR iOR2 = iOR = string.equals("") ? null : ORB.createIOR((ORB)this.orb, (String)string);
        if (this.orb != null) {
            ((IIOPClusterMemberDescriptionImpl)iIOPClusterMemberDescription).setORB(this.orb);
        }
        ((IIOPClusterMemberDescriptionImpl)iIOPClusterMemberDescription).setIOR(iOR);
        if (this.entry) {
            Tr.exit(tc, "parseVersion2IIOPClusterMemberDescription", iIOPClusterMemberDescription);
        }
    }

    public void parseVersion2LSDClusterMemberDescription(LSDClusterMemberDescription lSDClusterMemberDescription, ObjectInput objectInput) throws IOException {
        if (this.entry) {
            Tr.entry(tc, "parseVersion2LSDClusterMemberDescription");
        }
        byte by = objectInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "read version " + by);
        }
        String string = objectInput.readUTF();
        if (this.debug) {
            Tr.debug(tc, "read host " + string);
        }
        if (string != null) {
            ((LSDClusterMemberDescriptionImpl)lSDClusterMemberDescription).setHost(string);
        }
        int n = objectInput.readInt();
        ((LSDClusterMemberDescriptionImpl)lSDClusterMemberDescription).setPort(n);
        if (this.debug) {
            Tr.debug(tc, "read port " + n);
        }
        int n2 = objectInput.readInt();
        ((LSDClusterMemberDescriptionImpl)lSDClusterMemberDescription).setSSLPort(n2);
        if (this.debug) {
            Tr.debug(tc, "read sslPort " + n2);
        }
        int n3 = objectInput.readInt();
        ((LSDClusterMemberDescriptionImpl)lSDClusterMemberDescription).setSSLClientCertificatePort(n3);
        if (this.debug) {
            Tr.debug(tc, "read sslccPort " + n3);
        }
        if (this.entry) {
            Tr.exit(tc, "parseVersion2LSDClusterMemberDescription", lSDClusterMemberDescription);
        }
    }

    public void parseVersion2SelectionClusterMemberDescription(SelectionClusterMemberDescription selectionClusterMemberDescription, ObjectInput objectInput) throws IOException {
        if (this.entry) {
            Tr.entry(tc, "parseVersion2SelectionClusterMemberDescription");
        }
        byte by = objectInput.readByte();
        if (this.debug) {
            Tr.debug(tc, "read version " + by);
        }
        String string = objectInput.readUTF();
        if (this.debug) {
            Tr.debug(tc, "read host " + string);
        }
        if (string != null) {
            ((SelectionClusterMemberDescriptionImpl)selectionClusterMemberDescription).setHost(string);
        }
        if (this.entry) {
            Tr.exit(tc, "parseVersion2SelectionClusterMemberDescription", selectionClusterMemberDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean setClusterData(DescriptionKey descriptionKey, long l, DescriptionKey descriptionKey2, int n) {
        boolean bl;
        block11: {
            if (this.entry) {
                Tr.entry(tc, "setClusterData ", new Object[]{descriptionKey, new Long(l)});
            }
            bl = false;
            ClusterDescription clusterDescription = null;
            try {
                if (this.clusterDescriptions.containsKey(descriptionKey2)) {
                    clusterDescription = (ClusterDescription)this.clusterDescriptions.get(descriptionKey2);
                } else {
                    clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey2, ClusterDescription.class.getName());
                    this.clusterDescriptions.put(descriptionKey2, clusterDescription);
                }
                if (((ClusterDescription.Memento)clusterDescription.getMemento()).getStructuralEpoch() >= l) break block11;
                try {
                    if (this.ivDescMgrIsBBDescMgr) {
                        this.ivBBDescMgr.setThreadForLocalPosting();
                    }
                    clusterDescription.setStructuralEpoch(l);
                    clusterDescription.setInfluentialEpoch(l);
                    clusterDescription.setState((byte)0);
                    clusterDescription.setSelectionDescription((SelectionDescription)this.ivDescMgr.getDescription(descriptionKey));
                }
                finally {
                    if (this.ivDescMgrIsBBDescMgr) {
                        this.ivBBDescMgr.unsetThreadForLocalPosting();
                    }
                }
                bl = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, StreamContextHandler.class.getName() + ".setClusterData", "1715", this);
            }
        }
        if (this.debug) {
            Tr.exit(tc, "setClusterData " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ClusterMemberDescription createMember(String string, String string2, DescriptionKey descriptionKey, int n, IOR iOR, DescriptionKey descriptionKey2, String string3) {
        Object object;
        ProcessDescription processDescription;
        block32: {
            block31: {
                if (this.entry) {
                    Tr.entry(tc, "createMember", string2);
                }
                processDescription = null;
                DescriptionKey descriptionKey3 = null;
                String string4 = "nodeName";
                String string5 = string2;
                DescriptionKey descriptionKey4 = null;
                try {
                    descriptionKey4 = this.ivDescMgr.stringToKey(string2);
                    object = descriptionKey4.getProperties();
                    string5 = (String)object.get("MEMBERNAME");
                }
                catch (IllegalStateException illegalStateException) {
                    string5 = string2;
                }
                if (descriptionKey4 != null) {
                    string4 = IdentityMapping.getNodeNameFromClusterMemberIdentity(descriptionKey4);
                }
                if (string4 == null || string4.equals("nodeName")) {
                    try {
                        string4 = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                try {
                    if (this.ivDescMgrIsBBDescMgr) {
                        this.ivBBDescMgr.setThreadForLocalPosting();
                    }
                    descriptionKey3 = (DescriptionKey)((ClusterManagementImpl)this.ivClusterManagement).createClusterMember(string, string4, null, string5);
                }
                finally {
                    if (this.ivDescMgrIsBBDescMgr) {
                        this.ivBBDescMgr.unsetThreadForLocalPosting();
                    }
                }
                try {
                    this.memberToIds.put(descriptionKey3, string2);
                    processDescription = (ProcessDescription)this.ivDescMgr.getDescription(descriptionKey3, ProcessDescription.class.getName());
                    object = null;
                    DescriptionKey descriptionKey5 = null;
                    descriptionKey5 = this.ivKeyRepository.getDescriptionKey(processDescription.getKey(), this.iiopMemberDistinction);
                    object = (IIOPClusterMemberDescriptionImpl)this.ivDescMgr.getDescription(descriptionKey5, IIOPClusterMemberDescription.class.getName());
                    try {
                        if (this.ivDescMgrIsBBDescMgr) {
                            this.ivBBDescMgr.setThreadForLocalPosting();
                        }
                        processDescription.setExtrinsicData((ExtrinsicDescription)object);
                    }
                    finally {
                        if (this.ivDescMgrIsBBDescMgr) {
                            this.ivBBDescMgr.unsetThreadForLocalPosting();
                        }
                    }
                    this.updateMember(processDescription, n, iOR, descriptionKey2);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, StreamContextHandler.class.getName() + ".initalize", "1753");
                    if (!this.debug) break block31;
                    Tr.debug(tc, "unexpected exception ", exception);
                }
            }
            object = null;
            if (this.clusterDescriptions.containsKey(descriptionKey)) {
                object = (ClusterDescription)this.clusterDescriptions.get(descriptionKey);
            } else {
                try {
                    object = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey, ClusterDescription.class.getName());
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, StreamContextHandler.class.getName() + ".initalize", "1767");
                    if (!this.debug) break block32;
                    Tr.debug(tc, "unexpected exception ", exception);
                }
            }
        }
        this.clusterDescriptions.put(descriptionKey, object);
        try {
            if (this.ivDescMgrIsBBDescMgr) {
                this.ivBBDescMgr.setThreadForLocalPosting();
            }
            object.addMember(processDescription);
        }
        finally {
            if (this.ivDescMgrIsBBDescMgr) {
                this.ivBBDescMgr.unsetThreadForLocalPosting();
            }
        }
        if (this.entry) {
            Tr.exit(tc, "createMember");
        }
        return processDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateMember(ClusterMemberDescription clusterMemberDescription, int n, IOR iOR, DescriptionKey descriptionKey) {
        if (this.entry) {
            Tr.entry(tc, "updateMember", new Object[]{clusterMemberDescription, new Integer(n), iOR.stringify()});
        }
        try {
            ClusterDescription clusterDescription;
            DescriptionKey descriptionKey2 = this.ivKeyRepository.getDescriptionKey(clusterMemberDescription.getKey(), this.iiopMemberDistinction);
            IIOPClusterMemberDescriptionImpl iIOPClusterMemberDescriptionImpl = (IIOPClusterMemberDescriptionImpl)this.ivDescMgr.getDescription(descriptionKey2);
            if (iIOPClusterMemberDescriptionImpl != null) {
                try {
                    if (this.ivDescMgrIsBBDescMgr) {
                        this.ivBBDescMgr.setThreadForLocalPosting();
                    }
                    iIOPClusterMemberDescriptionImpl.setIOR(iOR);
                }
                finally {
                    if (this.ivDescMgrIsBBDescMgr) {
                        this.ivBBDescMgr.unsetThreadForLocalPosting();
                    }
                }
            }
            if ((clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey)) != null) {
                try {
                    if (this.ivDescMgrIsBBDescMgr) {
                        this.ivBBDescMgr.setThreadForLocalPosting();
                    }
                    this.ivClusterManagement.setDesiredWeight(descriptionKey, clusterMemberDescription.getKey(), n);
                }
                finally {
                    if (this.ivDescMgrIsBBDescMgr) {
                        this.ivBBDescMgr.unsetThreadForLocalPosting();
                    }
                }
            }
            try {
                if (this.ivDescMgrIsBBDescMgr) {
                    this.ivBBDescMgr.setThreadForLocalPosting();
                }
                clusterMemberDescription.setState((byte)0);
            }
            finally {
                if (this.ivDescMgrIsBBDescMgr) {
                    this.ivBBDescMgr.unsetThreadForLocalPosting();
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, StreamContextHandler.class.getName() + ".updateMember", "1796", this);
        }
        if (this.entry) {
            Tr.exit(tc, "updateMember");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeMembers(Map map, DescriptionKey descriptionKey) {
        if (this.entry) {
            Tr.entry(tc, "removeMembers", map);
        }
        Iterator iterator = map.keySet().iterator();
        String string = null;
        ClusterDescription clusterDescription = (ClusterDescription)this.clusterDescriptions.get(descriptionKey);
        ClusterMemberDescription clusterMemberDescription = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            clusterMemberDescription = (ClusterMemberDescription)map.get(string);
            if (clusterDescription == null) continue;
            try {
                if (this.ivDescMgrIsBBDescMgr) {
                    this.ivBBDescMgr.setThreadForLocalPosting();
                }
                clusterDescription.removeMember(clusterMemberDescription);
                if (clusterMemberDescription == null) continue;
                clusterMemberDescription.setClusterAssociation(descriptionKey);
            }
            finally {
                if (!this.ivDescMgrIsBBDescMgr) continue;
                this.ivBBDescMgr.unsetThreadForLocalPosting();
            }
        }
        if (this.entry) {
            Tr.exit(tc, "removeMembers");
        }
    }

    private Map getClusterMembers(DescriptionKey descriptionKey) {
        if (this.entry) {
            Tr.entry(tc, "getClusterMembers", new Object[]{descriptionKey});
        }
        HashMap<String, ClusterMemberDescription> hashMap = new HashMap<String, ClusterMemberDescription>();
        ClusterDescription clusterDescription = (ClusterDescription)this.clusterDescriptions.get(descriptionKey);
        if (clusterDescription != null) {
            try {
                ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
                Iterator iterator = memento.getClusterMembers();
                while (iterator.hasNext()) {
                    String string;
                    ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)iterator.next();
                    if (((ClusterMemberDescription.Memento)clusterMemberDescription.getMemento()).getState() != 0 || (string = (String)this.memberToIds.get(clusterMemberDescription.getKey())) == null) continue;
                    hashMap.put(string, clusterMemberDescription);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, StreamContextHandler.class.getName() + ".getClusterMembers", "1845", this);
            }
        }
        if (this.entry) {
            Tr.exit(tc, "getClusterMembers " + hashMap.size());
        }
        return hashMap;
    }

    private void setOrb() {
        Properties properties = new Properties();
        properties.put("org.omg.CORBA.ORBClass", "com.ibm.CORBA.iiop.ORB");
        try {
            GlobalORBFactory.init((String[])null, properties);
            this.orb = GlobalORBFactory.globalORB();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GlobalOrbFactory initialized, orb set", this.orb);
            }
        }
        catch (GlobalORBExistsException globalORBExistsException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "already a global orb in existence");
            }
            this.orb = GlobalORBFactory.globalORB();
        }
    }

    private void setCellName() {
        AdminService adminService = (AdminService)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return AdminServiceFactory.getAdminService();
            }
        });
        this.ivCellName = adminService == null ? (String)ProcessProperties.getInstance().get("key.containing.cellname") : adminService.getCellName();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.22 ");
        }
    }
}

