/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.propagation.bulletinboard;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.propagation.Connection;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionCallback;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.DescriptionManagerA;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wlm.TypeConversion;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScopes;
import com.ibm.wsspi.hamanager.bboard.DuplicatePostException;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import com.ibm.wsspi.hamanager.bboard.SubjectPostClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class BBDescriptionManager
extends DescriptionManagerA
implements SubjectSubscriptionEvents {
    private static final TraceComponent tc = Tr.register(BBDescriptionManager.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static BulletinBoard bulletinBoard;
    private static BulletinBoardScopes bulletinBoardScopes;
    private static final ProcessProperties procProps;
    private Map initialDescriptions = new HashMap(113);
    protected ReferenceQueue refQueue = new ReferenceQueue();
    private static final Set DescSubPhantomReferences;
    private static final Map postCache;
    private static final String version = "v0:";
    private static final String colon = ":";
    public static boolean processPosts;
    private Map valueVersions = Collections.synchronizedMap(new HashMap());
    private static final Object bbLockObject;
    private static WSThreadLocal postingLocal;
    public static DescriptionModificationListener listener;
    private Connection connection = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBulletinBoardScopes(BulletinBoardScopes bulletinBoardScopes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBulletinBoardScopes", bulletinBoardScopes);
        }
        BBDescriptionManager.bulletinBoardScopes = bulletinBoardScopes;
        Map map = this.initialDescriptions;
        synchronized (map) {
            Iterator iterator = this.initialDescriptions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                DescriptionKey descriptionKey = (DescriptionKey)entry.getKey();
                String string = (String)entry.getValue();
                this.subscribe(descriptionKey, string);
                this.publish(this.getDescription(descriptionKey));
            }
            this.initialDescriptions = Collections.EMPTY_MAP;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBulletinBoardScopes");
        }
    }

    public Description getDescription(DescriptionKey descriptionKey, String string) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Description description;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescription", new Object[]{descriptionKey, string});
        }
        if ((description = this.getDescription(descriptionKey)) == null) {
            this.purge();
            description = super.getDescription(descriptionKey, string);
            this.subscribe(descriptionKey, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescription");
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean publish(String string, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", new Object[]{string, byArray == null ? null : String.valueOf(byArray.length)});
        }
        if (((Boolean)procProps.get("key.ignore.bb.updates")).booleanValue()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "publish", "shutting down, skipping publishing");
            }
            return false;
        }
        boolean bl = true;
        try {
            Object object;
            Object object2;
            Object object3 = bbLockObject;
            synchronized (object3) {
                if (bulletinBoard == null && (object2 = (BulletinBoardFactory)((HashMap)(object = ProcessProperties.getInstance())).get("key.bulletinboard.factory")) != null && (bulletinBoard = object2.findBulletinBoard("WLM")) != null) {
                    this.setBulletinBoardScopes((BulletinBoardScopes)((HashMap)object).get("key.bbscopes"));
                }
            }
            if (bulletinBoard == null) {
                bl = !processPosts;
            } else if (((Boolean)postingLocal.get()).booleanValue()) {
                bl = false;
            } else {
                object3 = new StringBuffer();
                ((StringBuffer)object3).append(version);
                ((StringBuffer)object3).append(string);
                object = ((StringBuffer)object3).toString();
                object2 = (SubjectPost)postCache.get(object);
                if (object2 == null) {
                    BulletinBoardScope bulletinBoardScope = bulletinBoardScopes.getPublicScope();
                    SubjectInfo subjectInfo = bulletinBoard.createSubject(bulletinBoardScope, (String)object);
                    object2 = bulletinBoard.createPost(subjectInfo);
                    postCache.put(object, object2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new post for subject " + subjectInfo);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found cached post " + object2);
                }
                object2.updatePost(byArray);
            }
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not publish to BB for description " + this.stringToKey(string), hAParameterRejectedException);
            }
            bl = false;
        }
        catch (DuplicatePostException duplicatePostException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not publish to BB for description " + this.stringToKey(string), duplicatePostException);
            }
            bl = false;
        }
        catch (SubjectPostClosedException subjectPostClosedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not publish to BB for description " + this.stringToKey(string), subjectPostClosedException);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publish", String.valueOf(bl));
        }
        return bl;
    }

    public void updated(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray) {
        DescriptionKey descriptionKey;
        block9: {
            descriptionKey = null;
            try {
                String string;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "updated", subjectSubscription.getSubject().getSubjectName());
                }
                if (((Boolean)procProps.get("key.ignore.bb.updates")).booleanValue()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updated", "shutting down, skipping processing updates");
                    }
                    return;
                }
                SubjectInfo subjectInfo = subjectSubscription.getSubject();
                String string2 = string = subjectInfo.getSubjectName();
                if (!string.startsWith(version)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "multiversion cell subjectName - ignoring update", string);
                    }
                    return;
                }
                string2 = string.substring(string.indexOf(colon) + 1, string.length());
                descriptionKey = this.stringToKey(string2);
                Description description = this.getDescription(descriptionKey);
                byte[][] byArray = this.getOrderedBytes(string2, subjectValueArray);
                this.update(string2, byArray);
                if (description != null && listener != null) {
                    listener.handleNotification(descriptionKey, description.getDefinitionKey(), byArray == null ? null : TypeConversion.doubleToSingleBytes(byArray), null);
                }
            }
            catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                FFDCFilter.processException(subjectSubscriptionClosedException, BBDescriptionManager.class.getName() + ".updated", "320", this, new Object[]{subjectSubscription, subjectValueArray});
                if (!tc.isEventEnabled()) break block9;
                Tr.event(tc, "Unexpected: Unable to perform update", subjectSubscriptionClosedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updated", descriptionKey);
        }
    }

    public void lookupClusterCallback(String string, Contract contract, URL uRL, DescriptionCallback descriptionCallback, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupClusterCallback", new Object[]{string, uRL, descriptionCallback, object});
        }
        if (uRL != null) {
            if (this.connection != null) {
                this.connection.monitorConnection(string, uRL, contract, descriptionCallback, object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected", "Connection not initialized.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupClusterCallback");
        }
    }

    public void registerService(Connection connection) {
        this.connection = connection;
    }

    public long computeEpoch(byte[] byArray) {
        long l = byArray.hashCode();
        l <<= 16;
        return l &= (long)byArray.length;
    }

    protected void purge() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "purge");
        }
        DescriptionSubscription descriptionSubscription = null;
        while ((descriptionSubscription = (DescriptionSubscription)this.refQueue.poll()) != null) {
            SubjectSubscription[] subjectSubscriptionArray = descriptionSubscription.subscriptions;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "refQueue not null", subjectSubscriptionArray);
            }
            DescSubPhantomReferences.remove(descriptionSubscription);
            if (subjectSubscriptionArray == null) continue;
            for (int i = 0; i < subjectSubscriptionArray.length; ++i) {
                try {
                    String string = subjectSubscriptionArray[i].getSubject().getSubjectName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Closing subscription " + string);
                    }
                    subjectSubscriptionArray[i].close();
                    SubjectPost subjectPost = (SubjectPost)postCache.remove(string);
                    if (subjectPost != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Closing post " + string);
                        }
                        subjectPost.close();
                    }
                    this.updated(subjectSubscriptionArray[i], null);
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (class$com$ibm$ws$cluster$propagation$bulletinboard$BBDescriptionManager == null ? BBDescriptionManager.class$("com.ibm.ws.cluster.propagation.bulletinboard.BBDescriptionManager") : class$com$ibm$ws$cluster$propagation$bulletinboard$BBDescriptionManager).getName() + ".purge", "389", this);
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unexpected", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "purge");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[][] getOrderedBytes(String string, SubjectValue[] subjectValueArray) {
        if (tc.isEntryEnabled()) {
            if (subjectValueArray == null) {
                Tr.entry(tc, "getOrderedBytes null");
            } else {
                Tr.entry(tc, "getOrderedBytes ", subjectValueArray);
            }
        }
        LinkedList<Object> linkedList = null;
        if (subjectValueArray == null || subjectValueArray.length == 0) {
            Map map = this.valueVersions;
            synchronized (map) {
                linkedList = (LinkedList<Object>)this.valueVersions.get(string);
                if (linkedList != null) {
                    LinkedList<Object> linkedList2 = linkedList;
                    synchronized (linkedList2) {
                        this.valueVersions.remove(string);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getOrderedBytes: cleared values:" + string);
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOrderedBytes", null);
                }
                return null;
            }
        }
        byte[][] byArrayArray = new byte[subjectValueArray.length][];
        String[] stringArray = null;
        if (tc.isEntryEnabled()) {
            stringArray = new String[subjectValueArray.length];
        }
        LinkedList<Object> linkedList3 = this.valueVersions;
        synchronized (linkedList3) {
            linkedList = (LinkedList)this.valueVersions.get(string);
        }
        if (linkedList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOrderedBytes: new subject: use the posts in the order received from the BB");
            }
            linkedList = new LinkedList<Object>();
            linkedList3 = this.valueVersions;
            synchronized (linkedList3) {
                this.valueVersions.put(string, linkedList);
            }
            linkedList3 = linkedList;
            synchronized (linkedList3) {
                for (int i = 0; i < subjectValueArray.length; ++i) {
                    if (subjectValueArray[i] == null) continue;
                    byte[] byArray = subjectValueArray[i].getValues();
                    linkedList.add(i, subjectValueArray[i]);
                    byArrayArray[i] = byArray;
                    if (stringArray == null) continue;
                    String string2 = subjectValueArray[i].getServerName();
                    long l = subjectValueArray[i].getVersion();
                    stringArray[i] = String.valueOf(l) + " " + string2 + " " + (byArray == null ? "null" : String.valueOf(byArray.length));
                }
            }
        }
        linkedList3 = linkedList;
        synchronized (linkedList3) {
            int n;
            Object object;
            boolean bl;
            boolean bl2 = false;
            LinkedList<Object> linkedList4 = new LinkedList<Object>(linkedList);
            Iterator iterator = linkedList4.iterator();
            while (iterator.hasNext()) {
                bl = false;
                object = (SubjectValue)iterator.next();
                if (object == null) continue;
                for (int i = 0; i < subjectValueArray.length; ++i) {
                    String string3;
                    SubjectValue subjectValue = subjectValueArray[i];
                    String string4 = subjectValue.getServerName();
                    if (!string4.equals(string3 = object.getServerName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    String string5 = object.getServerName();
                    long l = object.getVersion();
                    Tr.debug(tc, "getOrderedBytes: post is removed: server: " + string5 + " version: " + String.valueOf(l));
                }
                bl2 = true;
                linkedList.remove(object);
            }
            if (bl2) {
                linkedList4.clear();
                linkedList4.addAll(linkedList);
            }
            for (n = 0; n < subjectValueArray.length; ++n) {
                bl = false;
                object = subjectValueArray[n];
                SubjectValue subjectValue = null;
                if (object == null) continue;
                Object object2 = linkedList4.iterator();
                while (object2.hasNext()) {
                    String string6;
                    subjectValue = (SubjectValue)object2.next();
                    String string7 = object.getServerName();
                    if (!string7.equals(string6 = subjectValue.getServerName())) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    linkedList4.remove(subjectValue);
                    long l = object.getVersion();
                    long l2 = subjectValue.getVersion();
                    if (l == l2) continue;
                    if (tc.isDebugEnabled()) {
                        String string8 = object.getServerName();
                        Tr.debug(tc, "getOrderedBytes: post is updated: server: " + string8 + " from version: " + String.valueOf(l2) + " to version: " + String.valueOf(l));
                    }
                    linkedList.remove(subjectValue);
                    linkedList.addLast(object);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    object2 = object.getServerName();
                    long l = object.getVersion();
                    Tr.debug(tc, "getOrderedBytes: post is added: server: " + (String)object2 + " version: " + String.valueOf(l));
                }
                linkedList.addLast(object);
            }
            if (tc.isDebugEnabled() && linkedList.size() != subjectValueArray.length) {
                Tr.debug(tc, "getOrderedBytes: unexpected: post mismatch: LinkList:");
                for (n = 0; n < linkedList.size(); ++n) {
                    SubjectValue subjectValue = (SubjectValue)linkedList.get(n);
                    object = subjectValue.getServerName();
                    long l = subjectValue.getVersion();
                    Tr.debug(tc, "server: " + (String)object + " version: " + String.valueOf(l));
                }
            }
            for (n = 0; n < linkedList.size(); ++n) {
                SubjectValue subjectValue = (SubjectValue)linkedList.get(n);
                if (subjectValue == null) continue;
                object = subjectValue.getValues();
                byArrayArray[n] = (byte[])object;
                if (stringArray == null) continue;
                String string9 = subjectValue.getServerName();
                long l = subjectValue.getVersion();
                stringArray[n] = String.valueOf(l) + " " + string9 + " " + (object == null ? "null" : String.valueOf(((Object)object).length));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOrderedBytes ", stringArray);
        }
        return byArrayArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void subscribe(DescriptionKey descriptionKey, String string) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "subscribe");
            }
            boolean bl = false;
            try {
                Object object;
                BulletinBoardScope[] bulletinBoardScopeArray = bbLockObject;
                // MONITORENTER : bbLockObject
                if (bulletinBoard == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "did not subscribe because the BB is not yet available", descriptionKey);
                    }
                    object = this.initialDescriptions;
                    // MONITORENTER : this.initialDescriptions
                    this.initialDescriptions.put(descriptionKey, string);
                    // MONITOREXIT : object
                    bl = true;
                    object = ProcessProperties.getInstance();
                    BulletinBoardFactory bulletinBoardFactory = (BulletinBoardFactory)((HashMap)object).get("key.bulletinboard.factory");
                    if (bulletinBoardFactory != null && (bulletinBoard = bulletinBoardFactory.findBulletinBoard("WLM")) != null) {
                        this.setBulletinBoardScopes((BulletinBoardScopes)((HashMap)object).get("key.bbscopes"));
                    }
                }
                // MONITOREXIT : bulletinBoardScopeArray
                if (bulletinBoard != null && !bl) {
                    bulletinBoardScopeArray = this.getScopes(descriptionKey);
                    object = new SubjectSubscription[bulletinBoardScopeArray.length];
                    for (int i = 0; i < bulletinBoardScopeArray.length; ++i) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(version);
                        stringBuffer.append(this.keyToString(descriptionKey));
                        String string2 = stringBuffer.toString();
                        SubjectInfo subjectInfo = bulletinBoard.createSubject(bulletinBoardScopeArray[i], string2);
                        object[i] = bulletinBoard.subscribe(subjectInfo, this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "subscribed to subject for " + descriptionKey, subjectInfo);
                    }
                    DescSubPhantomReferences.add(new DescriptionSubscription(descriptionKey, this.refQueue, (SubjectSubscription[])object));
                }
            }
            catch (HAParameterRejectedException hAParameterRejectedException) {
                FFDCFilter.processException((Throwable)hAParameterRejectedException, BBDescriptionManager.class.getName() + ".subscribe", "613", this);
                Tr.warning(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{BBDescriptionManager.class.getName() + ".subscribe", hAParameterRejectedException});
                if (!tc.isEventEnabled()) break block12;
                Tr.event(tc, "Could not subscribe to BB for description " + descriptionKey, hAParameterRejectedException);
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "subscribe");
    }

    private BulletinBoardScope[] getScopes(DescriptionKey descriptionKey) throws HAParameterRejectedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopes", descriptionKey);
        }
        BulletinBoardScope[] bulletinBoardScopeArray = null;
        try {
            bulletinBoardScopeArray = new BulletinBoardScope[]{bulletinBoardScopes.getRemoteScope(descriptionKey.getProperties())};
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Key properties rejected, getting all remote scopes with peer map");
            }
            Map map = bulletinBoardScopes.getPeerAccessPointsMap();
            Iterator iterator = map.entrySet().iterator();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n = map.size() + 1;
            bulletinBoardScopeArray = new BulletinBoardScope[n];
            bulletinBoardScopeArray[0] = bulletinBoardScopes.getPublicScope();
            for (int i = 1; i < n; ++i) {
                Map.Entry entry = iterator.next();
                hashMap.put("peerName", entry.getKey());
                hashMap.put("cellName", entry.getValue());
                bulletinBoardScopeArray[i] = bulletinBoardScopes.getRemoteScope(hashMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopes", bulletinBoardScopeArray);
        }
        return bulletinBoardScopeArray;
    }

    public void setThreadForLocalPosting() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setThreadForLocalPosting");
        }
        postingLocal.set(new Boolean(true));
    }

    public void unsetThreadForLocalPosting() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unsetThreadForLocalPosting");
        }
        postingLocal.set(new Boolean(false));
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.22 ");
        }
        bulletinBoard = null;
        bulletinBoardScopes = null;
        procProps = ProcessProperties.getInstance();
        DescSubPhantomReferences = Collections.synchronizedSet(new HashSet(256));
        postCache = Collections.synchronizedMap(new HashMap(217));
        processPosts = true;
        bbLockObject = new Object();
        postingLocal = new WSThreadLocal(){

            protected Object initialValue() {
                return new Boolean(false);
            }
        };
    }

    private final class DescriptionSubscription
    extends PhantomReference {
        private final SubjectSubscription[] subscriptions;

        private DescriptionSubscription(DescriptionKey descriptionKey, ReferenceQueue referenceQueue, SubjectSubscription[] subjectSubscriptionArray) {
            super(descriptionKey, referenceQueue);
            this.subscriptions = subjectSubscriptionArray;
        }
    }
}

