/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.affinity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.ws.cluster.router.NoAffinityFailoverException;
import java.util.Hashtable;
import java.util.Iterator;

public final class Affinity {
    private static final TraceComponent tc = Tr.register(Affinity.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final TraceComponent etc;
    private Hashtable entries = new Hashtable();

    public void addTarget(ClusterMemberDescription clusterMemberDescription, DescriptionKey descriptionKey, Iterator iterator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTarget", new Object[]{clusterMemberDescription, descriptionKey, iterator});
        }
        Entry entry = new Entry(clusterMemberDescription, iterator);
        entry.incrNumInvokes();
        this.entries.put(descriptionKey, entry);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTarget");
        }
    }

    public ClusterMemberDescription findMemberWithAffinity(ClusterDescription clusterDescription) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findMemberWithAffinity", clusterDescription);
        }
        ClusterMemberDescription clusterMemberDescription = null;
        ClusterMemberDescription clusterMemberDescription2 = null;
        Iterator iterator = this.entries.values().iterator();
        while (iterator.hasNext() && clusterMemberDescription == null) {
            Entry entry = (Entry)iterator.next();
            clusterMemberDescription2 = entry.getTarget();
            if (!entry.established || ((ClusterMemberDescription.Memento)clusterMemberDescription2.getMemento()).getState() != 0) continue;
            DescriptionKey descriptionKey = clusterMemberDescription2.getKey();
            Iterator iterator2 = ((ClusterDescription.Memento)clusterDescription.getMemento()).getClusterMembers();
            ClusterMemberDescription clusterMemberDescription3 = null;
            while (iterator2.hasNext() && clusterMemberDescription == null) {
                clusterMemberDescription3 = (ClusterMemberDescription)iterator2.next();
                DescriptionKey descriptionKey2 = clusterMemberDescription3.getKey();
                if (descriptionKey2 != descriptionKey) continue;
                clusterMemberDescription = clusterMemberDescription2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findMemberWithAffinity");
        }
        return clusterMemberDescription;
    }

    public ClusterMemberDescription getTarget(DescriptionKey descriptionKey) throws NoAffinityFailoverException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTarget", descriptionKey);
        }
        ClusterMemberDescription clusterMemberDescription = null;
        Entry entry = (Entry)this.entries.get(descriptionKey);
        if (entry == null) {
            return null;
        }
        clusterMemberDescription = entry.getTarget();
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
        if (entry.established && (0 == memento.getAvailability() || 0 == memento.getReachability())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTarget", clusterMemberDescription);
            }
            entry.incrNumInvokes();
            return clusterMemberDescription;
        }
        if (!entry.established) {
            entry.decrNumInvokes();
            this.entries.remove(descriptionKey);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTarget entry not estabished");
            }
            return null;
        }
        Iterator iterator = entry.getFailoverList();
        if (iterator == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTarget", "throwing NoAffinityFailoverException exception(1)");
            }
            throw new NoAffinityFailoverException();
        }
        clusterMemberDescription = null;
        while (iterator.hasNext() && clusterMemberDescription == null) {
            clusterMemberDescription = (ClusterMemberDescription)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cluster Member", clusterMemberDescription);
            }
            if (memento.getState() == 0) continue;
            clusterMemberDescription = null;
        }
        if (clusterMemberDescription == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTarget", "throwing NoAffinityFailoverException exception(2)");
            }
            throw new NoAffinityFailoverException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTarget", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    public void postInvoke(DescriptionKey descriptionKey) {
        Entry entry;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke", descriptionKey);
        }
        if ((entry = (Entry)this.entries.get(descriptionKey)) != null) {
            entry.setEstablished();
            entry.decrNumInvokes();
        } else {
            Tr.debug(tc, "no entry found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.entries;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.6 : none");
        }
        etc = Tr.register(Entry.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    }

    private class Entry {
        private ClusterMemberDescription member;
        private int numInvokes = 0;
        private boolean established = false;
        Iterator failoverList;

        private Entry(ClusterMemberDescription clusterMemberDescription, Iterator iterator) {
            if (etc.isEntryEnabled()) {
                Tr.entry(etc, "<init>", new Object[]{clusterMemberDescription, iterator});
            }
            this.member = clusterMemberDescription;
            this.failoverList = iterator;
            if (etc.isEntryEnabled()) {
                Tr.exit(etc, "<init>", this);
            }
        }

        private ClusterMemberDescription getTarget() {
            if (etc.isEventEnabled()) {
                Tr.event(etc, "getTarget", this.member);
            }
            return this.member;
        }

        private void incrNumInvokes() {
            ++this.numInvokes;
            if (etc.isEventEnabled()) {
                Tr.event(etc, "incrNumInvokes", new Integer(this.numInvokes));
            }
        }

        private void decrNumInvokes() {
            --this.numInvokes;
            if (etc.isEventEnabled()) {
                Tr.event(etc, "decrNumInvokes", new Integer(this.numInvokes));
            }
        }

        private int getNumInvokes() {
            if (etc.isEventEnabled()) {
                Tr.event(etc, "getNumInvokes", new Integer(this.numInvokes));
            }
            return this.numInvokes;
        }

        private boolean isEstablished() {
            if (etc.isEventEnabled()) {
                Tr.event(etc, "isEstablished", new Boolean(this.established));
            }
            return this.established;
        }

        private void setEstablished() {
            if (etc.isEventEnabled()) {
                Tr.event(etc, "setEstablished");
            }
            this.established = true;
        }

        private Iterator getFailoverList() {
            return this.failoverList;
        }

        public String toString() {
            return this.getClass().getName() + "@" + this.member + ":" + this.numInvokes + ":" + this.established;
        }
    }
}

