/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.affinity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.ws.cluster.router.affinity.Affinity;
import com.ibm.ws.cluster.router.affinity.AffinityModule;
import com.ibm.ws.cluster.router.affinity.AffinitySynchronization;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.PMIManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;

public final class AffinityManager
implements AffinitySynchronization {
    private static final TraceComponent tc = Tr.register(AffinityManager.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final byte STRONG_AFFINITY = 2;
    public static final byte WEAK_AFFINITY = 1;
    public static final byte NO_AFFINITY = 0;
    private AffinityModule[] modules;
    private Hashtable affinities = new Hashtable();

    AffinityManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        String[] stringArray = new String[]{"com.ibm.ws.cluster.router.affinity.ActivitySessionAffinityModule", "com.ibm.ws.cluster.router.affinity.TransactionAffinityModule"};
        ArrayList arrayList = new ArrayList();
        Class[] classArray = new Class[]{AffinitySynchronization.class};
        Object[] objectArray = new Object[]{this};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Constructor<?> constructor = Class.forName(stringArray[i]).getConstructor(classArray);
                arrayList.add(constructor.newInstance(objectArray));
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ws.wlm.client.affinity.AffinityManager.AffinityManager", "116", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Class not loaded", noSuchMethodException);
                continue;
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.wlm.client.affinity.AffinityManager.AffinityManager", "125", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Class not loaded", instantiationException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.wlm.client.affinity.AffinityManager.AffinityManager", "134", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Class not loaded", illegalAccessException);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.wlm.client.affinity.AffinityManager.AffinityManager", "143", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Class not loaded", invocationTargetException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Class not available", stringArray[i]);
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Class not available", stringArray[i]);
            }
        }
        this.modules = new AffinityModule[arrayList.size()];
        try {
            arrayList.toArray(this.modules);
        }
        catch (ArrayStoreException arrayStoreException) {
            FFDCFilter.processException((Throwable)arrayStoreException, "com.ibm.ws.wlm.client.affinity.AffinityManager.AffinityManager", "169", this);
            Tr.warning(tc, "WLMKEY_UNABLE_TO_INITIALIZE_AFFINITY", arrayStoreException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptionKey getAffinityKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAffinityKey");
        }
        int n = this.modules.length;
        for (int i = 0; i < n; ++i) {
            DescriptionKey descriptionKey = this.modules[i].testAndSetAffinity();
            if (descriptionKey == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAffinityKey", descriptionKey);
            }
            Hashtable hashtable = this.affinities;
            synchronized (hashtable) {
                Affinity affinity = this.getAffinity(descriptionKey);
                if (affinity == null) {
                    affinity = new Affinity();
                    this.affinities.put(descriptionKey, affinity);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, descriptionKey.toString());
                        Tr.debug(tc, affinity.toString());
                    }
                }
            }
            PMIManager.putAffinityType(this.modules[i].affinityType);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAffinityKey");
            }
            return descriptionKey;
        }
        PMIManager.putAffinityType((byte)0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAffinityKey");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(DescriptionKey descriptionKey) {
        DescriptionKey descriptionKey2;
        Affinity affinity;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke", descriptionKey);
        }
        Affinity affinity2 = affinity = (descriptionKey2 = this.getAffinityKey()) == null ? null : (Affinity)this.affinities.get(descriptionKey2);
        if (affinity == null) {
            if (descriptionKey2 != null) {
                Tr.warning(tc, "WLMKEY_AFFINITY_NOT_FOUND", new Object[]{descriptionKey2, "postInvoke"});
            }
        } else {
            Affinity affinity3 = affinity;
            synchronized (affinity3) {
                affinity.postInvoke(descriptionKey);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    public void terminateAffinity(DescriptionKey descriptionKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminateAffinity", descriptionKey);
        }
        this.affinities.remove(descriptionKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateAffinity");
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        for (int i = 0; i < this.modules.length; ++i) {
            string = string + ":" + this.modules[i].getClass().getName();
        }
        return string;
    }

    public Affinity getAffinity(DescriptionKey descriptionKey) {
        Affinity affinity = (Affinity)this.affinities.get(descriptionKey);
        return affinity;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.2 : none");
        }
    }
}

