/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.affinity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.cluster.router.affinity.AffinityId;
import com.ibm.ws.cluster.router.affinity.AffinityModule;
import com.ibm.ws.cluster.router.affinity.AffinitySynchronization;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

final class TransactionAffinityModule
extends AffinityModule {
    private static final TraceComponent tc = Tr.register(TransactionAffinityModule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private TransactionManager txManager;
    private Hashtable affinities = new Hashtable();
    private AffinitySynchronization affSync;

    public TransactionAffinityModule(AffinitySynchronization affinitySynchronization) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.txManager = TransactionManagerFactory.getTransactionManager();
        this.affSync = affinitySynchronization;
        this.affinityType = (byte)2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DescriptionKey testAndSetAffinity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testAndSetAffinity");
        }
        Transaction transaction = null;
        try {
            transaction = this.txManager.getTransaction();
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.wlm.client.affinity.TransactionAffinityModule.testAndSetAffinity", "209", this);
            return null;
        }
        if (transaction == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "no transaction");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "testAndSetAffinity");
            }
            return null;
        }
        TransactionAffinityKey transactionAffinityKey = new TransactionAffinityKey(transaction);
        Hashtable hashtable = this.affinities;
        synchronized (hashtable) {
            DescriptionKey descriptionKey;
            block19: {
                Object object;
                AffinityId affinityId = (AffinityId)this.affinities.get(transactionAffinityKey);
                if (affinityId == null) {
                    affinityId = new AffinityId();
                    this.affinities.put(transactionAffinityKey, affinityId);
                    object = new TranSynchronization(transactionAffinityKey);
                    try {
                        transaction.registerSynchronization((Synchronization)object);
                    }
                    catch (IllegalStateException illegalStateException) {
                        FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.wlm.client.affinity.TransactionAffinityModule.testAndSetAffinity", "269", this);
                        Tr.warning(tc, "WLMKEY_UNEXPECTED_EXCEPTION", new Object[]{"testAndSetAffinity", illegalStateException});
                        affinityId = null;
                        this.affinities.remove(transactionAffinityKey);
                    }
                    catch (SystemException systemException) {
                        FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.wlm.client.affinity.TransactionAffinityModule.testAndSetAffinity", "274", this);
                        Tr.warning(tc, "WLMKEY_UNEXPECTED_EXCEPTION", new Object[]{"testAndSetAffinity", systemException});
                    }
                    catch (RollbackException rollbackException) {
                        FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.wlm.client.affinity.TransactionAffinityModule.testAndSetAffinity", "277", this);
                        Tr.warning(tc, "WLMKEY_UNEXPECTED_EXCEPTION", new Object[]{"testAndSetAffinity", rollbackException});
                    }
                }
                if (affinityId == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "testAndSetAffinity", affinityId);
                    }
                    return null;
                }
                object = new TreeMap<String, String>();
                object.put("affinity ID", affinityId.toString());
                descriptionKey = null;
                try {
                    descriptionKey = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey((Map)object);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wlm.client.affinity.TransactionAffinityModule.testAndSetAffinity", "295", this);
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "Unexpected exception", exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "testAndSetAffinity", descriptionKey);
            }
            return descriptionKey;
        }
    }

    public String toString() {
        return super.toString() + ":" + this.affinities;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.2 : none");
        }
    }

    class TranSynchronization
    implements Synchronization {
        TransactionAffinityKey key;

        TranSynchronization(TransactionAffinityKey transactionAffinityKey) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", transactionAffinityKey);
            }
            this.key = transactionAffinityKey;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>");
            }
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "afterCompletion", this.key);
            }
            Hashtable hashtable = TransactionAffinityModule.this.affinities;
            synchronized (hashtable) {
                DescriptionKey descriptionKey;
                block7: {
                    AffinityId affinityId = (AffinityId)TransactionAffinityModule.this.affinities.get(this.key);
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    treeMap.put("affinity ID", affinityId.toString());
                    descriptionKey = null;
                    try {
                        descriptionKey = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey(treeMap);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wlm.client.affinity.TransactionAffinityModule.afterCompletion", "164", this);
                        if (!tc.isDebugEnabled()) break block7;
                        Tr.debug(tc, "Unexpected exception", exception);
                    }
                }
                TransactionAffinityModule.this.affSync.terminateAffinity(descriptionKey);
                TransactionAffinityModule.this.affinities.remove(this.key);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterCompletion");
            }
        }
    }

    private class TransactionAffinityKey {
        private Transaction transaction;

        private TransactionAffinityKey(Transaction transaction) {
            this.transaction = transaction;
        }

        public boolean equals(Object object) {
            try {
                TransactionAffinityKey transactionAffinityKey = (TransactionAffinityKey)object;
                return this.transaction.equals(transactionAffinityKey.transaction);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.wlm.client.affinity.TransactionAffinityModule.equals", "115", this);
                return false;
            }
        }

        public int hashCode() {
            return this.transaction.hashCode();
        }

        public String toString() {
            return this.transaction.toString();
        }
    }
}

