/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.router.NoAffinityFailoverException;
import com.ibm.ws.cluster.router.affinity.Affinity;
import com.ibm.ws.cluster.router.affinity.AffinityManager;
import com.ibm.ws.cluster.router.affinity.AffinityManagerFactory;
import com.ibm.ws.cluster.router.selection.CommonRouter;
import com.ibm.ws.cluster.router.selection.IIOPSelectionAdapter;
import com.ibm.ws.cluster.router.selection.NoClusterMembersAvailableException;
import com.ibm.ws.cluster.router.selection.RequestData;
import com.ibm.ws.cluster.router.selection.UnavailableManager;
import com.ibm.ws.cluster.router.selection.UnavailableManagerFactory;
import com.ibm.ws.cluster.selection.AdvisorMediatorFactory;
import com.ibm.ws.cluster.selection.RouterMediator;
import com.ibm.ws.cluster.selection.SelectionModifier;
import com.ibm.wsspi.cluster.Identity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CommonRouterImpl
implements CommonRouter {
    private static final TraceComponent tc = Tr.register(CommonRouter.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private AffinityManager affinityManager;
    private UnavailableManager unavailableManager;
    private IIOPSelectionAdapter adapter;
    private SelectionModifier lsdModifier;
    private SelectionModifier defaultModifier;
    private RouterMediator routerMediator;

    public ClusterMemberDescription getNextMemberFromLSD(RequestData requestData) throws NoAffinityFailoverException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextMemberFrom LSD", requestData);
        }
        ClusterMemberDescription clusterMemberDescription = null;
        List list = requestData.getClusterList();
        DescriptionKey descriptionKey = requestData.getAffinityKey();
        Affinity affinity = descriptionKey == null ? null : this.affinityManager.getAffinity(descriptionKey);
        Iterator iterator = list.iterator();
        ClusterDescription clusterDescription = null;
        DescriptionKey descriptionKey2 = null;
        while (iterator.hasNext() && clusterMemberDescription == null) {
            clusterDescription = (ClusterDescription)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster to be used for selection ", clusterDescription);
            }
            descriptionKey2 = clusterDescription.getKey();
            if (affinity != null) {
                clusterMemberDescription = this.getMemberFromAffinity(affinity, clusterDescription, descriptionKey2);
            }
            if (clusterMemberDescription != null) continue;
            DescriptionKey descriptionKey3 = clusterDescription.getKey();
            clusterMemberDescription = descriptionKey3.getProperties().containsValue("LSDCluster") ? this.selectNextMember(descriptionKey3, this.lsdModifier) : this.selectNextMember(descriptionKey3, this.defaultModifier);
            if (affinity == null || clusterMemberDescription == null) continue;
            Iterator iterator2 = null;
            affinity.addTarget(clusterMemberDescription, descriptionKey2, iterator2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextMemberfromLSD", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    public CommonRouterImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.adapter = new IIOPSelectionAdapter();
        this.routerMediator = (RouterMediator)AdvisorMediatorFactory.getRouterMediator();
        this.lsdModifier = new SelectionModifier();
        this.lsdModifier.setClientFirst(true);
        this.lsdModifier.setPreferLocal(-4);
        this.lsdModifier.setPreferProcess(-1);
        this.defaultModifier = new SelectionModifier();
        this.affinityManager = AffinityManagerFactory.getInstance().getAffinityManager();
        int n = (Integer)ProcessProperties.getInstance().get(ProcessProperties.KEY_UNUSABLE_INTERVAL);
        int n2 = n / 2;
        this.unavailableManager = UnavailableManagerFactory.getInstance().getUnavailableManager();
        this.unavailableManager.setSleepInterval(n2);
        this.unavailableManager.setUnusableInterval(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init", this.unavailableManager);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public ClusterMemberDescription getNextMember(RequestData requestData) throws NoAffinityFailoverException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextMember", requestData);
        }
        ClusterMemberDescription clusterMemberDescription = null;
        List list = requestData.getClusterList();
        DescriptionKey descriptionKey = requestData.getAffinityKey();
        Affinity affinity = descriptionKey == null ? null : this.affinityManager.getAffinity(descriptionKey);
        Iterator iterator = list.iterator();
        ClusterDescription clusterDescription = null;
        DescriptionKey descriptionKey2 = null;
        while (iterator.hasNext() && clusterMemberDescription == null) {
            DescriptionKey descriptionKey3;
            clusterDescription = (ClusterDescription)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster to be used for selection ", clusterDescription);
            }
            descriptionKey2 = clusterDescription.getKey();
            if (affinity != null && (clusterMemberDescription = this.getMemberFromAffinity(affinity, clusterDescription, descriptionKey2)) == null) {
                clusterMemberDescription = affinity.findMemberWithAffinity(clusterDescription);
            }
            if (clusterMemberDescription == null) {
                descriptionKey3 = clusterDescription.getKey();
                clusterMemberDescription = descriptionKey3.getProperties().containsValue("LSDCluster") ? this.selectNextMember(descriptionKey3, this.lsdModifier) : this.selectNextMember(descriptionKey3, this.defaultModifier);
            }
            if (affinity == null || clusterMemberDescription == null) continue;
            descriptionKey3 = null;
            affinity.addTarget(clusterMemberDescription, descriptionKey2, (Iterator)((Object)descriptionKey3));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextMember", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    public RouterMediator getMediator() {
        return this.routerMediator;
    }

    private ClusterMemberDescription selectNextMember(Identity identity, SelectionModifier selectionModifier) {
        ClusterMemberDescription clusterMemberDescription;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "selectNextMember", new Object[]{identity, selectionModifier});
            }
            clusterMemberDescription = null;
            try {
                clusterMemberDescription = this.adapter.selectMember(identity, selectionModifier);
            }
            catch (NoClusterMembersAvailableException noClusterMembersAvailableException) {
                clusterMemberDescription = null;
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "cannot find a member");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selectNextMember", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    public void updateClusterList(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateClusterList", list);
        }
        ArrayList arrayList = new ArrayList(list);
        int n = list.size();
        Iterator iterator = arrayList.iterator();
        for (int i = 0; i < n; ++i) {
            ClusterDescription clusterDescription = (ClusterDescription)iterator.next();
            ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
            ClusterDescription clusterDescription2 = memento.getBackupCluster();
            HashSet<ClusterDescription> hashSet = new HashSet<ClusterDescription>();
            hashSet.add(clusterDescription);
            for (int j = 0; clusterDescription2 != null && !hashSet.contains(clusterDescription2) && j < 1; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found backup cluster for primary cluster", new Object[]{clusterDescription, clusterDescription2});
                }
                if (!list.contains(clusterDescription2)) {
                    list.add(clusterDescription2);
                }
                hashSet.add(clusterDescription2);
                memento = (ClusterDescription.Memento)clusterDescription2.getMemento();
                clusterDescription2 = memento.getBackupCluster();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateClusterList", list);
        }
    }

    public UnavailableManager getUnavailableManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnavailableManager", this.unavailableManager);
        }
        if (null == this.unavailableManager) {
            int n = (Integer)ProcessProperties.getInstance().get(ProcessProperties.KEY_UNUSABLE_INTERVAL);
            int n2 = n / 2;
            this.unavailableManager = UnavailableManagerFactory.getInstance().getUnavailableManager();
            this.unavailableManager.setSleepInterval(n2);
            this.unavailableManager.setUnusableInterval(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getUnavailableManager", this.unavailableManager);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnavailableManager", this.unavailableManager);
        }
        return this.unavailableManager;
    }

    protected ClusterMemberDescription getMemberFromAffinity(Affinity affinity, ClusterDescription clusterDescription, DescriptionKey descriptionKey) throws NoAffinityFailoverException {
        ClusterDescription.Memento memento;
        ClusterDescription clusterDescription2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberFromAffinity", new Object[]{affinity, clusterDescription, descriptionKey});
        }
        ClusterMemberDescription clusterMemberDescription = null;
        clusterMemberDescription = affinity.getTarget(descriptionKey);
        if (clusterMemberDescription == null && (clusterDescription2 = (memento = (ClusterDescription.Memento)clusterDescription.getMemento()).getBackupCluster()) != null) {
            DescriptionKey descriptionKey2 = clusterDescription2.getKey();
            clusterMemberDescription = affinity.getTarget(descriptionKey2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberFromAffinity", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    public String toString() {
        return ":af " + this.affinityManager.toString() + ":UM " + this.unavailableManager.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.11 ");
        }
    }
}

