/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.router.selection.IIOPSelectionCriteria;
import com.ibm.ws.cluster.router.selection.LSDSelectionCriteria;
import com.ibm.ws.cluster.router.selection.NoClusterMembersAvailableException;
import com.ibm.ws.cluster.selection.SelectionModifier;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class IIOPSelectionAdapter {
    private static final TraceComponent tc = Tr.register(IIOPSelectionAdapter.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private static final SelectionService selectionService = SelectionServiceFactory.getSelectionService();
    private Map criteriaCache = new WeakHashMap();

    public ClusterMemberDescription selectMember(Identity identity, SelectionModifier selectionModifier) throws NoClusterMembersAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selectMember", new Object[]{identity, selectionModifier});
        }
        Target target = this.select(identity, selectionModifier);
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)target.getMemberIdentity());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selectMember", new Object[]{clusterMemberDescription});
        }
        return clusterMemberDescription;
    }

    public Target select(Identity identity, SelectionModifier selectionModifier) throws NoClusterMembersAvailableException {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "select", new Object[]{identity, selectionModifier});
            }
            try {
                Target target = selectionService.select(this.getCriteria(identity));
                if (!target.isTargetInProcess() || WorkloadController.inStartingMode() || WorkloadController.inStartedMode() || WorkloadController.inQuiesceMode()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "select", target);
                    }
                    return target;
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "select - failed quiesce mode.");
                }
            }
            catch (NoAvailableTargetException noAvailableTargetException) {
                if (!tc.isEventEnabled()) break block6;
                Tr.event(tc, "select - failed to select member.", noAvailableTargetException);
            }
        }
        throw new NoClusterMembersAvailableException();
    }

    private SelectionCriteria getCriteria(Identity identity) {
        SelectionCriteria selectionCriteria = (SelectionCriteria)this.criteriaCache.get(identity);
        if (selectionCriteria == null) {
            HashMap<String, SelectionRule[]> hashMap = new HashMap<String, SelectionRule[]>();
            if (identity.getProperties().containsValue("LSDCluster")) {
                hashMap.put("rules.restriction", new SelectionRule[]{new LSDSelectionCriteria()});
            } else {
                hashMap.put("rules.restriction", new SelectionRule[]{new IIOPSelectionCriteria()});
            }
            selectionCriteria = selectionService.getCriteria(identity, hashMap);
            this.criteriaCache.put(identity, selectionCriteria);
        }
        return selectionCriteria;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.10 : none");
        }
    }
}

