/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescription;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IIOPSelectionCriteria
implements SelectionRule {
    private static final TraceComponent tc = Tr.register(IIOPSelectionCriteria.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr;
    private static final KeyRepository keyRepository;
    private RuleArbitrator arbiter = null;
    private Map distinction = new HashMap();

    public IIOPSelectionCriteria() {
        this.distinction.put(IIOPClusterMemberDescription.distinction[0], IIOPClusterMemberDescription.distinction[1]);
    }

    public void subset(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DescriptionKey descriptionKey = (DescriptionKey)iterator.next();
            if (this.arbiter != null) {
                this.arbiter.registerNotificationType(this, descriptionKey, "type.add.extrinsic");
                this.arbiter.registerNotificationType(this, descriptionKey, "type.remove.extrinsic");
            }
            ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription(descriptionKey);
            DescriptionKey descriptionKey2 = keyRepository.getDescriptionKey(descriptionKey, this.distinction);
            if (this.arbiter != null) {
                this.arbiter.registerNotificationType(this, descriptionKey2, "type.memento.updated");
            }
            Description description = null;
            if (clusterMemberDescription != null) {
                description = (IIOPClusterMemberDescription)((ClusterMemberDescription.Memento)clusterMemberDescription.getMemento()).getExtrinsicData(descriptionKey2);
            }
            if (clusterMemberDescription != null && description != null && ((IIOPClusterMemberDescription.Memento)description.getMemento()).getIOR() != null) continue;
            iterator.remove();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "removed entry for lack of IIOP end point", new Object[]{descriptionKey, descriptionKey2});
        }
    }

    public void registerRuleArbitrator(RuleArbitrator ruleArbitrator) {
        this.arbiter = ruleArbitrator;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.4 ");
        }
        descMgr = DescriptionManagerFactory.getDescriptionManager();
        keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    }
}

