/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescription;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescriptionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBExistsException;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.wlm.ClientClusterContextListenerFactory;
import com.ibm.ws.wlm.WLMServiceClientContextListener;
import com.ibm.ws.wlm.client.WLMClientRequestInterceptor;
import com.ibm.ws.wlm.client.selection.NoUsableTargetException;
import com.ibm.ws.wlm.server.config.WLMTemplate;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.rmi.PortableRemoteObject;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;

public class Interop40ServerGroupRefresh {
    private static final TraceComponent tc = Tr.register(Interop40ServerGroupRefresh.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static Interop40ServerGroupRefresh instance;
    private String clusterDefinitionKey = null;
    private List clusterMList = null;
    private WLMServiceClientContextListener listener = null;
    public static final String bootstrapHostKey = "com.ibm.websphere.wlm.bootstrap.host";
    public static final String bootstrapPortKey = "com.ibm.websphere.wlm.bootstrap.port";
    private ORB orb = null;
    private ProcessProperties processProperties = ProcessProperties.getInstance();
    private String definitionKey = ClientClusterContextListenerFactory.getInstance().getDefinitionKey();
    private ClientClusterContextListenerFactory clientContextFactory = ClientClusterContextListenerFactory.getInstance();
    private static TransactionManager txManager;
    private Map iiopMemberDistinction = new TreeMap();

    private Interop40ServerGroupRefresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
        this.iiopMemberDistinction.put(IIOPClusterMemberDescription.distinction[0], IIOPClusterMemberDescription.distinction[1]);
        this.setOrb();
    }

    private void setOrb() {
        if (this.orb != null) {
            return;
        }
        this.orb = (ORB)this.processProperties.get("key.orb");
        if (this.orb == null) {
            block4: {
                Properties properties = new Properties();
                properties.put("org.omg.CORBA.ORBClass", "com.ibm.CORBA.iiop.ORB");
                try {
                    GlobalORBFactory.init((String[])null, properties);
                }
                catch (GlobalORBExistsException globalORBExistsException) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "already a global orb in existence. Retriving it and returning.");
                }
            }
            this.orb = GlobalORBFactory.globalORB();
        }
    }

    public static Interop40ServerGroupRefresh getInterOp40Server() {
        if (instance == null) {
            instance = new Interop40ServerGroupRefresh();
        }
        return instance;
    }

    public void refreshServerGroup(DescriptionKey descriptionKey, List list) throws NoUsableTargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshServerGroup", new java.lang.Object[]{descriptionKey, list});
        }
        byte[] byArray = null;
        Map map = descriptionKey.getProperties();
        this.clusterMList = list;
        KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string = (String)map.get("CELLNAME");
        treeMap.put("CELLNAME", string);
        treeMap.put("CLUSTERNAME", string);
        DescriptionKey descriptionKey2 = keyRepository.getDescriptionKey(treeMap);
        DescriptionManagerFactory.getInstance();
        DescriptionManager descriptionManager = DescriptionManagerFactory.getDescriptionManager();
        ClusterDescription clusterDescription = (ClusterDescription)descriptionManager.getDescription(descriptionKey2);
        this.clusterDefinitionKey = clusterDescription.getDefinitionKey();
        if (clusterDescription != null) {
            if (this.orb == null) {
                this.setOrb();
            }
            if (this.orb != null) {
                this.registerContextForClientInterceptor(this.orb);
                try {
                    byArray = this.pullServerGroupFromAdminProcess(clusterDescription, descriptionKey, string);
                    this.listener.receiveClientContext(byArray);
                    this.deregisterContextForClientInterceptor(this.orb);
                }
                catch (NoUsableTargetException noUsableTargetException) {
                    this.deregisterContextForClientInterceptor(this.orb);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "refreshServerGroup");
                    }
                    throw noUsableTargetException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshServerGroup");
        }
    }

    private byte[] pullServerGroupFromAdminProcess(ClusterDescription clusterDescription, DescriptionKey descriptionKey, String string) throws NoUsableTargetException {
        Transaction transaction;
        ClusterMemberDescription clusterMemberDescription;
        Iterator iterator;
        byte[] byArray;
        WLMTemplate wLMTemplate;
        Object object;
        IOR iOR;
        IIOPClusterMemberDescriptionImpl iIOPClusterMemberDescriptionImpl;
        DescriptionManager descriptionManager;
        DescriptionKey descriptionKey2;
        KeyRepository keyRepository;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "pullServerGroupFromAdminProcess", new java.lang.Object[]{clusterDescription, descriptionKey});
            }
            keyRepository = null;
            descriptionKey2 = null;
            descriptionManager = null;
            iIOPClusterMemberDescriptionImpl = null;
            iOR = null;
            object = null;
            wLMTemplate = null;
            byArray = null;
            iterator = null;
            clusterMemberDescription = null;
            if (txManager == null) {
                txManager = TransactionManagerFactory.getTransactionManager();
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "getServerGroupFromRepository, after TransactionManagerFactory.getTransactionManager=", txManager);
                }
            }
            transaction = null;
            try {
                transaction = txManager.suspend();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.wlm.client.selection.InterOp40Server.pullServerGroupFromAdminProcess", "262", this);
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug(tc, "Unexpected exception", (java.lang.Object)systemException);
            }
        }
        iterator = ((ClusterDescription.Memento)clusterDescription.getMemento()).getClusterMembers();
        while (byArray == null && iterator.hasNext()) {
            try {
                clusterMemberDescription = (ClusterMemberDescription)iterator.next();
                keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
                DescriptionManagerFactory.getInstance();
                descriptionManager = DescriptionManagerFactory.getDescriptionManager();
                descriptionKey2 = keyRepository.getDescriptionKey(clusterMemberDescription.getKey(), this.iiopMemberDistinction);
                iIOPClusterMemberDescriptionImpl = (IIOPClusterMemberDescriptionImpl)descriptionManager.getDescription(descriptionKey2);
                iOR = ((IIOPClusterMemberDescription.Memento)iIOPClusterMemberDescriptionImpl.getMemento()).getIOR();
                if (this.orb == null) {
                    this.setOrb();
                }
                if (this.orb != null) {
                    object = this.orb.IORToObject(iOR);
                    wLMTemplate = (WLMTemplate)PortableRemoteObject.narrow((java.lang.Object)object, (Class)(class$com$ibm$ws$wlm$server$config$WLMTemplate == null ? Interop40ServerGroupRefresh.class$("com.ibm.ws.wlm.server.config.WLMTemplate") : class$com$ibm$ws$wlm$server$config$WLMTemplate));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "templateIOR: " + iOR);
                        Tr.debug(tc, "pulling: " + string + ":" + string);
                    }
                }
                byArray = wLMTemplate.pull(string, string);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "exception thrown for adminserver: " + clusterMemberDescription, exception);
            }
        }
        if (byArray == null) {
            byArray = this.pullServerGroupFromBootstrapServer(string, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pullServerGroupFromAdminProcess");
        }
        try {
            txManager.resume(transaction);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.wlm.client.selection.InterOp40Server.pullServerGroupFromAdminProcess", "314", this);
            throw new INTERNAL("", 1229066305, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            FFDCFilter.processException((Throwable)invalidTransactionException, "com.ibm.ws.wlm.client.selection.InterOp40Server.pullServerGroupFromAdminProcess", "320", this);
            throw new INTERNAL("", 1229066305, CompletionStatus.COMPLETED_MAYBE);
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "pullServerGroupFromAdminProcess", byArray);
            }
            throw new NoUsableTargetException("Method pullServerGroupFromAdminProcess found no useable proxies in the list.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pullServerGroupFromAdminProcess", byArray);
        }
        return byArray;
    }

    private byte[] pullServerGroupFromBootstrapServer(String string, String string2) {
        byte[] byArray;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "pullServerGroupFromBootstrapServer", new java.lang.Object[]{string, string2});
            }
            byArray = null;
            try {
                String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public java.lang.Object run() {
                        String string = System.getProperty(Interop40ServerGroupRefresh.bootstrapHostKey);
                        if (string == null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "com.ibm.websphere.wlm.bootstrap.host not set, returning null.");
                        }
                        return string;
                    }
                });
                String string4 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public java.lang.Object run() {
                        String string = System.getProperty(Interop40ServerGroupRefresh.bootstrapPortKey);
                        if (string == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "com.ibm.websphere.wlm.bootstrap.port not set, using default: 900");
                            }
                            string = "900";
                        }
                        return string;
                    }
                });
                String string5 = "corbaloc:iiop:" + string3 + ":" + string4 + "/WLMService";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bootstrap server WLMService call: URL=" + string5);
                }
                if (this.orb == null) {
                    this.setOrb();
                }
                if (this.orb != null) {
                    Object object = this.orb.string_to_object(string5);
                    WLMTemplate wLMTemplate = (WLMTemplate)PortableRemoteObject.narrow((java.lang.Object)object, (Class)WLMTemplate.class);
                    byArray = wLMTemplate.pull(string, string2);
                }
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "Bootstrap server call for WLMService failed", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pullServerGroupFromBootstrapServer", byArray);
        }
        return byArray;
    }

    private void registerContextForClientInterceptor(ORB oRB) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerContextForClientInterceptor", oRB);
            }
            try {
                this.listener = this.clientContextFactory.getClientClusterContextListener(this.clusterMList, this.definitionKey);
                WLMClientRequestInterceptor wLMClientRequestInterceptor = (WLMClientRequestInterceptor)oRB.resolve_initial_references("WLMClientRequestInterceptor");
                wLMClientRequestInterceptor.registerServiceContextListener(oRB, this.listener);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.cluster.propagation.Interop40Server.registerContextForClientInterceptor", "425", this, new java.lang.Object[]{oRB});
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerContextForClientInterceptor");
        }
    }

    private void deregisterContextForClientInterceptor(ORB oRB) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deregisterContextForClientInterceptor");
            }
            try {
                WLMClientRequestInterceptor wLMClientRequestInterceptor = (WLMClientRequestInterceptor)oRB.resolve_initial_references("WLMClientRequestInterceptor");
                this.listener = ClientClusterContextListenerFactory.getInstance().getClientClusterContextListener(this.clusterMList, this.clusterDefinitionKey);
                wLMClientRequestInterceptor.deregisterServiceContextListener(oRB, this.listener);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cluster.propagation.Interop40Server..deregisterContextForClientInterceptor", "455", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterContextForClientInterceptor");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version :", "1.2");
        }
        instance = null;
        txManager = null;
    }
}

