/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.router.NoAffinityFailoverException;
import com.ibm.ws.cluster.router.affinity.Affinity;
import com.ibm.ws.cluster.router.affinity.AffinityManager;
import com.ibm.ws.cluster.router.affinity.AffinityManagerFactory;
import com.ibm.ws.cluster.router.selection.ClusterAndClusterMemberInUse;
import com.ibm.ws.cluster.router.selection.CommonRouter;
import com.ibm.ws.cluster.router.selection.Interop40ServerGroupRefresh;
import com.ibm.ws.cluster.router.selection.LSDSelector;
import com.ibm.ws.cluster.router.selection.MasterProxy;
import com.ibm.ws.cluster.router.selection.NoClusterMembersAvailableException;
import com.ibm.ws.cluster.router.selection.RequestData;
import com.ibm.ws.cluster.router.selection.RequestDataImpl;
import com.ibm.ws.cluster.router.selection.SelectionManager;
import com.ibm.ws.cluster.router.selection.WLMIORBuilder;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescription;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.ClientClusterContextListenerFactory;
import com.ibm.ws.wlm.WLMServiceClientContextListener;
import com.ibm.ws.wlm.client.WLMClientRequestInterceptor;
import com.ibm.ws.wlm.client.selection.NoUsableTargetException;
import com.ibm.ws.wlm.configuration.WLMIOR;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.ClusterIdentityResolverCoordinator;
import com.ibm.wsspi.cluster.selection.ClusterIdentityResolverCoordinatorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MasterProxyImpl
implements MasterProxy {
    private static final int MIN_RETRIES = 10;
    private static final int MAX_RETRIES = 50;
    private static final TraceComponent tc = Tr.register(MasterProxy.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final TraceComponent tc1 = Tr.register(ClusterList.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterIdentityResolverCoordinator resolverCoordinator;
    private static final AffinityManager affinityManager;
    private int maxRetries;
    private DescriptionKey clusterKey;
    private IOR ior;
    private boolean tryOriginalIOR;
    private LSDSelector lsdSelector;
    private Map cacheMap;
    private CommonRouter router;
    private DescriptionKey routeSetKey;
    private Contract contract;
    private ClusterList clusterMList;
    private String definitionKey;
    private DescriptionKey Admin40ServerGroup;
    private ClusterMemberDescription originalIORMember;

    public MasterProxyImpl(WLMIOR wLMIOR, CommonRouter commonRouter) {
        ClusterDescription clusterDescription;
        ClusterDescription clusterDescription2;
        block5: {
            this.maxRetries = 10;
            this.cacheMap = Collections.synchronizedMap(new HashMap());
            this.router = null;
            this.clusterMList = null;
            this.definitionKey = null;
            this.Admin40ServerGroup = null;
            this.originalIORMember = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", wLMIOR);
            }
            clusterDescription2 = null;
            clusterDescription = null;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("Admin40ServerGroup", "true");
            this.Admin40ServerGroup = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey(treeMap);
            this.ior = wLMIOR.getIOR();
            this.clusterKey = wLMIOR.getClusterKey();
            this.router = commonRouter;
            this.tryOriginalIOR = true;
            this.definitionKey = ClientClusterContextListenerFactory.getInstance().getDefinitionKey();
            this.routeSetKey = null;
            this.contract = new ContractImpl();
            this.contract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
            this.contract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
            this.contract.setInterest(new ConcernImpl(2));
            try {
                clusterDescription2 = (ClusterDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(this.clusterKey, ClusterDescription.class.getName());
                Iterator iterator = ((ClusterDescription.Memento)clusterDescription2.getMemento()).getClusterMembers();
                this.maxRetries = 0;
                while (iterator.hasNext()) {
                    this.maxRetries += 2;
                    iterator.next();
                }
                this.maxRetries = this.maxRetries < 10 ? 10 : this.maxRetries;
                this.maxRetries = this.maxRetries > 50 ? 50 : this.maxRetries;
                clusterDescription = (ClusterDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(wLMIOR.getLSDClusterKey(), ClusterDescription.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, MasterProxyImpl.class.getName() + ".<init>", "250", this, new Object[]{wLMIOR});
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "unexpected", exception);
            }
        }
        this.clusterMList = new ClusterList(clusterDescription2, clusterDescription);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public DescriptionKey getClusterKey() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClusterKey", this.clusterKey.toString());
        }
        return this.clusterKey;
    }

    public ClusterMemberDescription getNextClone(List list) throws NoAffinityFailoverException, NoClusterMembersAvailableException {
        List list2;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextClone" + list);
        }
        ClusterMemberDescription clusterMemberDescription = null;
        DescriptionKey descriptionKey = affinityManager.getAffinityKey();
        this.clusterMList.checkAndUpdateList();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                object2 = (ClusterAndClusterMemberInUse)list.get(i);
                object = ((ClusterAndClusterMemberInUse)object2).getClusterKey();
                if (!this.clusterKey.equals(object)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNextClone", new Object[]{"inUseList used to select member", ((ClusterAndClusterMemberInUse)object2).getClusterMember()});
                }
                return ((ClusterAndClusterMemberInUse)object2).getClusterMember();
            }
        }
        if ((clusterMemberDescription = this.router.getNextMember((RequestData)(object2 = new RequestDataImpl(list2 = this.clusterMList.getClusterList(), descriptionKey, this.routeSetKey, null)))) == null) {
            boolean bl;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getNextClone - null returned from router");
            }
            boolean bl2 = bl = ((ClusterDescription.Memento)(object = (ClusterDescription)this.clusterMList.getClusterList().get(0)).getMemento()).getClusterScopedData(this.Admin40ServerGroup) != null;
            if (bl) {
                clusterMemberDescription = this.refreshClusterfromAdminServer((RequestData)object2);
            }
            if (clusterMemberDescription == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNextClone", clusterMemberDescription);
                }
                throw new NoClusterMembersAvailableException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextClone", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    public void postInvoke() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "postInvoke marking usable = true");
        }
        affinityManager.postInvoke(this.clusterKey);
        this.tryOriginalIOR = false;
    }

    public String toString() {
        String string = this.getClass().getName() + "@" + this.ior.getTypeId() + ":" + this.clusterKey;
        return string;
    }

    public IOR assembleTargetIOR(ORB oRB, ClusterMemberDescription clusterMemberDescription) {
        IOR iOR;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "assembleTargetIOR", clusterMemberDescription);
        }
        if ((iOR = (IOR)this.cacheMap.get(clusterMemberDescription)) == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "cache miss assemble the ior");
            }
            iOR = WLMIORBuilder.assembleTargetIOR(oRB, clusterMemberDescription, this.ior);
            this.cacheMap.put(clusterMemberDescription, iOR);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "assembleTargetIOR", this.cacheMap);
        }
        return iOR;
    }

    public void registerContextForClientInterceptor(ORB oRB) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerContextForClientInterceptor", oRB);
            }
            try {
                WLMClientRequestInterceptor wLMClientRequestInterceptor = (WLMClientRequestInterceptor)oRB.resolve_initial_references("WLMClientRequestInterceptor");
                WLMServiceClientContextListener wLMServiceClientContextListener = ClientClusterContextListenerFactory.getInstance().getClientClusterContextListener(this.clusterMList.getClusterList(), this.definitionKey);
                wLMClientRequestInterceptor.registerServiceContextListener(oRB, wLMServiceClientContextListener);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, MasterProxyImpl.class.getName() + ".registerContextForClientInterceptor", "440", this, new Object[]{oRB});
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerContextForClientInterceptor");
        }
    }

    public void deregisterContextForClientInterceptor(ORB oRB) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deregisterContextForClientInterceptor");
            }
            try {
                WLMClientRequestInterceptor wLMClientRequestInterceptor = (WLMClientRequestInterceptor)oRB.resolve_initial_references("WLMClientRequestInterceptor");
                WLMServiceClientContextListener wLMServiceClientContextListener = ClientClusterContextListenerFactory.getInstance().getClientClusterContextListener(this.clusterMList.getClusterList(), this.definitionKey);
                wLMClientRequestInterceptor.deregisterServiceContextListener(oRB, wLMServiceClientContextListener);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, MasterProxyImpl.class.getName() + ".deregisterContextForClientInterceptor", "474", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterContextForClientInterceptor");
        }
    }

    private ClusterMemberDescription refreshClusterfromAdminServer(RequestData requestData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshClusterfromAdminServer", requestData);
        }
        ClusterMemberDescription clusterMemberDescription = null;
        Interop40ServerGroupRefresh interop40ServerGroupRefresh = Interop40ServerGroupRefresh.getInterOp40Server();
        try {
            interop40ServerGroupRefresh.refreshServerGroup(this.clusterKey, this.clusterMList.getClusterList());
        }
        catch (NoUsableTargetException noUsableTargetException) {
            FFDCFilter.processException((Throwable)noUsableTargetException, MasterProxyImpl.class.getName() + ".refreshClusterfromAdminServer", "508", this);
            return null;
        }
        this.clearIORCache();
        try {
            clusterMemberDescription = this.router.getNextMember(requestData);
        }
        catch (NoAffinityFailoverException noAffinityFailoverException) {
            FFDCFilter.processException((Throwable)noAffinityFailoverException, MasterProxyImpl.class.getName() + ".refreshClusterfromAdminServer", "518", this);
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshClusterfromAdminServer", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    public ClusterMemberDescription getMemberFromOriginalIOR() {
        DescriptionKey descriptionKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberFromOriginalIOR");
        }
        if (this.originalIORMember == null) {
            this.originalIORMember = this.createOriginalIORMember();
        }
        if ((descriptionKey = affinityManager.getAffinityKey()) != null) {
            Affinity affinity = affinityManager.getAffinity(descriptionKey);
            affinity.addTarget(this.originalIORMember, this.clusterKey, null);
        }
        return this.originalIORMember;
    }

    public IOR getIOR() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIOR");
        }
        if (this.originalIORMember == null) {
            this.originalIORMember = this.createOriginalIORMember();
        }
        IOR iOR = null;
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)this.originalIORMember.getMemento();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TryOriginalIOR", new Object[]{this.ior.stringify(), new Boolean(this.tryOriginalIOR), new Byte(memento.getState())});
        }
        if (this.tryOriginalIOR && memento.getState() == 0) {
            iOR = this.ior;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIOR", iOR == null ? null : iOR.stringify());
        }
        return iOR;
    }

    public IOR assembleTargetIOR(ClusterMemberDescription clusterMemberDescription, ORB oRB) {
        IOR iOR = WLMIORBuilder.assembleTargetIOR(oRB, this.ior, clusterMemberDescription);
        return iOR;
    }

    public boolean setLSClusterFromLSDListInIOR(ORB oRB) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLSClusterFromLSDListInIOR", this.ior.stringify());
        }
        boolean bl = false;
        ClusterDescription clusterDescription = (ClusterDescription)this.clusterMList.getClusterList().get(this.clusterMList.size() - 1);
        if (this.lsdSelector == null) {
            this.lsdSelector = new LSDSelector(oRB);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cluster state is ", new Byte(((ClusterDescription.Memento)clusterDescription.getMemento()).getState()));
        }
        bl = this.lsdSelector.update(this.ior, clusterDescription);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLSClusterFromLSDListInIOR", String.valueOf(bl));
        }
        return bl;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    private ClusterMemberDescription createOriginalIORMember() {
        ClusterMemberDescription clusterMemberDescription;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createOriginalIORMember", new Object[]{this.clusterKey, this.ior.stringify()});
            }
            clusterMemberDescription = null;
            IIOPClusterMemberDescriptionImpl iIOPClusterMemberDescriptionImpl = null;
            try {
                DescriptionManager descriptionManager = DescriptionManagerFactory.getLocalDescriptionManager();
                clusterMemberDescription = (ClusterMemberDescription)descriptionManager.getDescription(ClusterMemberDescription.KEY_ORIGINAL_IOR, ClusterMemberDescription.class.getName());
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put(IIOPClusterMemberDescription.distinction[0], IIOPClusterMemberDescription.distinction[1]);
                DescriptionKey descriptionKey = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey(ClusterMemberDescription.KEY_ORIGINAL_IOR, treeMap);
                iIOPClusterMemberDescriptionImpl = (IIOPClusterMemberDescriptionImpl)descriptionManager.getDescription(descriptionKey, IIOPClusterMemberDescription.class.getName());
                clusterMemberDescription.setExtrinsicData(iIOPClusterMemberDescriptionImpl);
                iIOPClusterMemberDescriptionImpl.setIOR(this.ior);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, SelectionManager.class.getName() + ".createOriginalIORMember", "675", this, new Object[]{this.clusterKey, this.ior.stringify()});
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createOriginalIORMember", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    public void clearIORCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearIORCache", this.cacheMap);
        }
        this.cacheMap.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearIORCache", this.cacheMap);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.16 : none");
        }
        resolverCoordinator = ClusterIdentityResolverCoordinatorFactory.getClusterIdentityResolverCoordinator();
        affinityManager = AffinityManagerFactory.getInstance().getAffinityManager();
    }

    private class ClusterList {
        private List clusterList = null;
        private List clusterMementoList = null;
        private ThreadLocal local = new ThreadLocal();

        protected ClusterList(ClusterDescription clusterDescription, ClusterDescription clusterDescription2) {
            if (tc1.isEntryEnabled()) {
                Tr.entry(tc1, "<init>", new Object[]{clusterDescription, clusterDescription2});
            }
            this.clusterList = new ArrayList(2);
            this.clusterMementoList = new ArrayList(2);
            this.clusterList.add(clusterDescription);
            MasterProxyImpl.this.router.updateClusterList(this.clusterList);
            this.clusterList.add(clusterDescription2);
            Iterator iterator = this.clusterList.iterator();
            while (iterator.hasNext()) {
                this.clusterMementoList.add(((ClusterDescription)iterator.next()).getMemento());
            }
            if (tc1.isEntryEnabled()) {
                Tr.exit(tc1, "<init>", new Object[]{this.clusterList, this.clusterMementoList});
            }
        }

        protected List getClusterList() {
            block3: {
                Identity identity = (Identity)this.local.get();
                if (identity != null) {
                    try {
                        ArrayList<Description> arrayList = new ArrayList<Description>(this.clusterList);
                        arrayList.add(0, DescriptionManagerFactory.getDescriptionManager().getDescription((DescriptionKey)identity, (class$com$ibm$websphere$cluster$topography$ClusterDescription == null ? (class$com$ibm$websphere$cluster$topography$ClusterDescription = MasterProxyImpl.class$("com.ibm.websphere.cluster.topography.ClusterDescription")) : class$com$ibm$websphere$cluster$topography$ClusterDescription).getName()));
                        return arrayList;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, (class$com$ibm$ws$cluster$router$selection$MasterProxyImpl$ClusterList == null ? (class$com$ibm$ws$cluster$router$selection$MasterProxyImpl$ClusterList = MasterProxyImpl.class$("com.ibm.ws.cluster.router.selection.MasterProxyImpl$ClusterList")) : class$com$ibm$ws$cluster$router$selection$MasterProxyImpl$ClusterList).getName() + ".getClusterList", "744", this, new Object[]{identity});
                        if (!tc.isEventEnabled()) break block3;
                        Tr.event(tc, "unexpected exception", exception);
                    }
                }
            }
            return this.clusterList;
        }

        protected int size() {
            return this.clusterList.size();
        }

        protected void checkAndUpdateList() {
            Object object;
            if (tc1.isEntryEnabled()) {
                Tr.entry(tc1, "checkAndUpdateList");
            }
            Iterator iterator = this.clusterMementoList.iterator();
            while (iterator.hasNext()) {
                object = (ClusterDescription.Memento)iterator.next();
                if (object.delta() == null) continue;
                MasterProxyImpl.this.clusterMList = new ClusterList((ClusterDescription)this.clusterList.get(0), (ClusterDescription)this.clusterList.get(this.clusterList.size() - 1));
                MasterProxyImpl.this.cacheMap.clear();
                break;
            }
            object = resolverCoordinator.getOrderedSequence();
            this.local.set(null);
            for (int i = 0; i < ((Object)object).length; ++i) {
                Identity identity = object[i].resolveIdentity(MasterProxyImpl.this.ior);
                if (identity == null) continue;
                this.local.set(identity);
                break;
            }
            if (tc1.isEntryEnabled()) {
                Tr.exit(tc1, "checkAndUpdateList", new Object[]{this.clusterList, this.clusterMementoList});
            }
        }
    }
}

