/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.ws.cluster.router.selection.OutStandingRequestMonitor;
import java.util.WeakHashMap;

public class OutStandingRequestMonitorImpl
implements OutStandingRequestMonitor {
    private static final TraceComponent tc = Tr.register(OutStandingRequestMonitorImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static WeakHashMap memberMap;
    public static final int POINTS_TO_TRACK = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutstandingRequest(ClusterMemberDescription clusterMemberDescription) {
        OutstandingRequestTracker outstandingRequestTracker = (OutstandingRequestTracker)memberMap.get(clusterMemberDescription);
        if (outstandingRequestTracker == null) {
            WeakHashMap weakHashMap = memberMap;
            synchronized (weakHashMap) {
                outstandingRequestTracker = new OutstandingRequestTracker();
                memberMap.put(clusterMemberDescription, outstandingRequestTracker);
            }
        }
        outstandingRequestTracker.addOutstandingRequest();
    }

    public void removeOutstandingRequest(ClusterMemberDescription clusterMemberDescription) {
        OutstandingRequestTracker outstandingRequestTracker = (OutstandingRequestTracker)memberMap.get(clusterMemberDescription);
        if (outstandingRequestTracker != null) {
            outstandingRequestTracker.removeOutstandingRequest();
        }
    }

    public int getOutstandingRequests(ClusterMemberDescription clusterMemberDescription) {
        OutstandingRequestTracker outstandingRequestTracker = (OutstandingRequestTracker)memberMap.get(clusterMemberDescription);
        if (outstandingRequestTracker == null) {
            return 0;
        }
        return outstandingRequestTracker.getOutstandingRequests();
    }

    public int getTotalOutstandingRequests(ClusterMemberDescription clusterMemberDescription) {
        OutstandingRequestTracker outstandingRequestTracker = (OutstandingRequestTracker)memberMap.get(clusterMemberDescription);
        if (outstandingRequestTracker == null) {
            return 0;
        }
        return outstandingRequestTracker.getTotalOutstandingRequests();
    }

    public int getNumDataPoints(ClusterMemberDescription clusterMemberDescription) {
        OutstandingRequestTracker outstandingRequestTracker = (OutstandingRequestTracker)memberMap.get(clusterMemberDescription);
        if (outstandingRequestTracker == null) {
            return 1;
        }
        return outstandingRequestTracker.getNumDataPoints();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.3 ");
        }
        memberMap = new WeakHashMap();
    }

    protected class Counter {
        int value;

        protected Counter(int n) {
            this.value = n;
        }

        protected int getValue() {
            return this.value;
        }

        protected synchronized void increment() {
            ++this.value;
        }

        protected synchronized void decrement() {
            --this.value;
        }

        public String toString() {
            return "Counter: " + this.value;
        }
    }

    protected class OutstandingRequestTracker {
        Counter outstanding;
        int[] arrayOutstanding;
        int arrayIndex;
        int numDataPoints;
        int countOutstanding;

        protected OutstandingRequestTracker() {
            this.outstanding = new Counter(0);
            this.arrayOutstanding = new int[5];
            this.arrayIndex = 0;
            this.numDataPoints = 0;
            this.countOutstanding = 0;
        }

        public void addOutstandingRequest() {
            this.outstanding.increment();
            int n = this.outstanding.getValue();
            ++this.countOutstanding;
            int n2 = this.arrayIndex;
            ++this.arrayIndex;
            this.arrayIndex %= 5;
            this.arrayOutstanding[n2 %= 5] = n;
        }

        public void removeOutstandingRequest() {
            this.outstanding.decrement();
        }

        public int getTotalOutstandingRequests() {
            int n = 0;
            int n2 = this.getNumDataPoints();
            for (int i = 0; i < n2; ++i) {
                n += this.arrayOutstanding[i];
            }
            return n;
        }

        public int getOutstandingRequests() {
            return this.outstanding.getValue();
        }

        public int getNumDataPoints() {
            return this.countOutstanding < 5 ? this.countOutstanding : 5;
        }
    }
}

