/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class RetryCounter {
    private static final TraceComponent tc = Tr.register(RetryCounter.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private int maxDepth;
    private int currentDepth;
    private long requestTimeout;
    private long currentTime;

    public RetryCounter(int n, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> ", new Object[]{String.valueOf(l), String.valueOf(n)});
        }
        this.requestTimeout = l <= 0L ? Long.MAX_VALUE : l;
        this.currentTime = 0L;
        this.currentDepth = 0;
        this.maxDepth = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void reset() {
        this.currentDepth = 0;
        this.currentTime = 0L;
    }

    public void setDepth(int n) {
        this.maxDepth = n;
    }

    public boolean increment() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "increment", new Object[]{String.valueOf(this.currentDepth), String.valueOf(this.currentTime)});
        }
        boolean bl = true;
        long l = System.currentTimeMillis();
        if (this.currentTime == 0L) {
            this.currentTime = l;
        } else if (this.currentDepth > 0 && this.requestTimeout < l - this.currentTime) {
            bl = false;
        } else if (++this.currentDepth > this.maxDepth) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "increment " + bl);
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.6 ");
        }
    }
}

