/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.router.NoAffinityFailoverException;
import com.ibm.ws.cluster.router.affinity.Affinity;
import com.ibm.ws.cluster.router.affinity.AffinityManager;
import com.ibm.ws.cluster.router.affinity.AffinityManagerFactory;
import com.ibm.ws.cluster.router.selection.ClusterAndClusterMemberInUse;
import com.ibm.ws.cluster.router.selection.CommonRouter;
import com.ibm.ws.cluster.router.selection.CommonRouterFactory;
import com.ibm.ws.cluster.router.selection.MasterProxy;
import com.ibm.ws.cluster.router.selection.MasterProxyImpl;
import com.ibm.ws.cluster.router.selection.NoClusterMembersAvailableException;
import com.ibm.ws.cluster.router.selection.RetryCounter;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescription;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescriptionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.TargetForwardedListener;
import com.ibm.ws.wlm.client.WLMClientRequestInterceptor;
import com.ibm.ws.wlm.client.selection.CloneNotFoundException;
import com.ibm.ws.wlm.configuration.WLMIOR;
import com.ibm.ws.wlm.util.ConnectionExceptionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;

public class SelectionManager
implements TargetForwardedListener {
    private static final TraceComponent tc = Tr.register(SelectionManager.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static CommonRouter router;
    private Map proxies = new WeakHashMap(23, 0.75f);
    private static ThreadLocal serversInUse;
    private static ThreadLocal requestCount;
    private ORB orb;

    public SelectionManager(ORB oRB) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>");
        }
        this.orb = oRB;
        router = CommonRouterFactory.getInstance().getCommonRouter();
        WLMClientRequestInterceptor.registerTargetForwardedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOR getTarget(Delegate delegate) throws NoAffinityFailoverException, NO_IMPLEMENT {
        IOR iOR;
        RetryCounter retryCounter;
        int n;
        Integer n2;
        MasterProxy masterProxy;
        IOR iOR2;
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTarget", delegate);
            }
            iOR2 = null;
            masterProxy = this.findMasterProxy(delegate);
            ProcessProperties processProperties = ProcessProperties.getInstance();
            n2 = new Integer(180000);
            try {
                n2 = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_CALLBACK_TIMEOUT"));
            }
            catch (NumberFormatException numberFormatException) {
                if (!tc.isEventEnabled()) break block26;
                Tr.event(tc, "Custom Property IBM_CLUSTER_CALLBACK_TIMEOUT is not set properly, received NumberFormatException.  Defaulting to 3 minutes");
            }
        }
        if (n2 != null) {
            n = n2;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Custom Property IBM_CLUSTER_CALLBACK_TIMEOUT is not set properly, Defaulting to 3 minutes");
            }
            n = 180000;
        }
        int n3 = 0;
        if (n > 0) {
            n3 = n;
        }
        if ((retryCounter = (RetryCounter)requestCount.get()) == null) {
            retryCounter = new RetryCounter(masterProxy.getMaxRetries(), n3);
            requestCount.set(retryCounter);
        } else {
            retryCounter.setDepth(masterProxy.getMaxRetries());
        }
        if (!retryCounter.increment()) {
            retryCounter.reset();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getNextTarget", "Retry limit reached");
            }
            masterProxy.clearIORCache();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getNextTarget", "clearing serversInUse cache");
            }
            ThreadLocal threadLocal = serversInUse;
            synchronized (threadLocal) {
                List list = (List)serversInUse.get();
                if (list != null) {
                    list.clear();
                }
            }
            throw new NO_IMPLEMENT("Retry limit reached", 1229066304, CompletionStatus.COMPLETED_NO);
        }
        ClusterMemberDescription clusterMemberDescription = null;
        try {
            iOR2 = masterProxy.getIOR();
            clusterMemberDescription = masterProxy.getNextClone((List)serversInUse.get());
            iOR = masterProxy.assembleTargetIOR(this.orb, clusterMemberDescription);
            if (iOR == null) {
                iOR = iOR2;
                clusterMemberDescription = masterProxy.getMemberFromOriginalIOR();
            }
        }
        catch (NoClusterMembersAvailableException noClusterMembersAvailableException) {
            iOR = iOR2;
            if (iOR == null) {
                boolean bl = masterProxy.setLSClusterFromLSDListInIOR(this.orb);
                if (bl) {
                    try {
                        clusterMemberDescription = masterProxy.getNextClone((List)serversInUse.get());
                    }
                    catch (NoClusterMembersAvailableException noClusterMembersAvailableException2) {
                        FFDCFilter.processException(noClusterMembersAvailableException2, SelectionManager.class.getName() + ".getTarget", "254", this, new java.lang.Object[]{delegate, masterProxy, serversInUse, retryCounter});
                    }
                }
                if (clusterMemberDescription == null) {
                    throw new NO_IMPLEMENT("No available target", 1229066304, CompletionStatus.COMPLETED_NO);
                }
                iOR = masterProxy.assembleTargetIOR(this.orb, clusterMemberDescription);
                if (iOR == null) {
                    throw new NO_IMPLEMENT("No applicable target", 1229066304, CompletionStatus.COMPLETED_NO);
                }
            }
            clusterMemberDescription = masterProxy.getMemberFromOriginalIOR();
        }
        masterProxy.registerContextForClientInterceptor(this.orb);
        SelectionManager.pushServerForInvocation(new ClusterAndClusterMemberInUse(masterProxy.getClusterKey(), clusterMemberDescription));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTarget");
        }
        return iOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetForwarded(Object object) {
        block13: {
            List list;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "targetForwarded", object);
            }
            java.lang.Object object2 = serversInUse;
            synchronized (object2) {
                list = (List)serversInUse.get();
            }
            object2 = null;
            if (list == null || list.isEmpty()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "targetForwarded", new java.lang.Object[]{"serversInUse doesn't have any information", list});
                }
                return;
            }
            IOR iOR = this.orb.objectToIOR(object);
            try {
                java.lang.Object object3;
                RetryCounter retryCounter = (RetryCounter)requestCount.get();
                if (retryCounter != null && !retryCounter.increment()) {
                    retryCounter.reset();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "targetForwarded", "Retry limit reached");
                    }
                    if (list != null) {
                        list.clear();
                    }
                    throw new NO_IMPLEMENT("Forward limit reached", 1229066304, CompletionStatus.COMPLETED_NO);
                }
                object2 = SelectionManager.popServerForInvocation();
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put("inUseMemberDistinction", Thread.currentThread().getName());
                DescriptionKey descriptionKey = null;
                descriptionKey = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey(((ClusterAndClusterMemberInUse)object2).getClusterMember().getKey(), treeMap);
                ClusterMemberDescription clusterMemberDescription = this.createClusterMember(descriptionKey, iOR);
                AffinityManager affinityManager = AffinityManagerFactory.getInstance().getAffinityManager();
                DescriptionKey descriptionKey2 = affinityManager.getAffinityKey();
                if (descriptionKey2 != null) {
                    object3 = affinityManager.getAffinity(descriptionKey2);
                    ((Affinity)object3).addTarget(clusterMemberDescription, ((ClusterAndClusterMemberInUse)object2).getClusterKey(), null);
                }
                object3 = new ClusterAndClusterMemberInUse(((ClusterAndClusterMemberInUse)object2).getClusterKey(), clusterMemberDescription);
                SelectionManager.pushServerForInvocation((ClusterAndClusterMemberInUse)object3);
            }
            catch (CloneNotFoundException cloneNotFoundException) {
                FFDCFilter.processException(cloneNotFoundException, SelectionManager.class.getName() + ".targetForwarded", "395", this, new java.lang.Object[]{object2, list});
                if (!tc.isEventEnabled()) break block13;
                Tr.event(tc, "targetForwarded - popServerForInvocation threw CloneNotFoundException ", cloneNotFoundException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "targetForwarded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushServerForInvocation(ClusterAndClusterMemberInUse clusterAndClusterMemberInUse) {
        ArrayList<ClusterAndClusterMemberInUse> arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushServerForInvocation", clusterAndClusterMemberInUse);
        }
        ThreadLocal threadLocal = serversInUse;
        synchronized (threadLocal) {
            arrayList = (ArrayList<ClusterAndClusterMemberInUse>)serversInUse.get();
            if (arrayList == null) {
                arrayList = new ArrayList<ClusterAndClusterMemberInUse>(2);
                serversInUse.set(arrayList);
            }
        }
        arrayList.add(clusterAndClusterMemberInUse);
        if (arrayList.size() == 1) {
            router.getMediator().setObservedWeight(clusterAndClusterMemberInUse.getClusterKey(), clusterAndClusterMemberInUse.getClusterMember().getKey(), 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushServerForInvocation", Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClusterAndClusterMemberInUse popServerForInvocation() throws CloneNotFoundException {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popServerForInvocation", Thread.currentThread().getName());
        }
        java.lang.Object object = serversInUse;
        synchronized (object) {
            list = (List)serversInUse.get();
        }
        if (list == null) {
            Tr.info(tc, "popServerForInvocation - target has not been pushed in - targets is null");
            throw new CloneNotFoundException();
        }
        object = list.isEmpty() ? null : list.remove(list.size() - 1);
        if (list.size() == 0 && object != null) {
            router.getMediator().setObservedWeight(((ClusterAndClusterMemberInUse)object).getClusterKey(), ((ClusterAndClusterMemberInUse)object).getClusterMember().getKey(), -1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popServerForInvocation", object);
        }
        if (object == null) {
            throw new CloneNotFoundException();
        }
        return object;
    }

    public ClusterMemberDescription getCorrespondingServer(java.lang.Object object, IOR iOR) throws CloneNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCorrespondingServer", new java.lang.Object[]{object, iOR});
        }
        MasterProxy masterProxy = this.findMasterProxy(object);
        masterProxy.deregisterContextForClientInterceptor(this.orb);
        ClusterAndClusterMemberInUse clusterAndClusterMemberInUse = SelectionManager.popServerForInvocation();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCorrespondingServer", clusterAndClusterMemberInUse);
        }
        return clusterAndClusterMemberInUse.getClusterMember();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterProxy findMasterProxy(java.lang.Object object) {
        MasterProxy masterProxy;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findMasterProxy", object);
        }
        Map map = this.proxies;
        synchronized (map) {
            masterProxy = (MasterProxy)this.proxies.get(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findMasterProxy", masterProxy);
        }
        return masterProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheIOR(Delegate delegate, WLMIOR wLMIOR) {
        MasterProxyImpl masterProxyImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheIOR", new java.lang.Object[]{delegate, wLMIOR});
        }
        Map map = this.proxies;
        synchronized (map) {
            masterProxyImpl = new MasterProxyImpl(wLMIOR, router);
            this.proxies.put(delegate, masterProxyImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheIOR", masterProxyImpl);
        }
    }

    public ClusterMemberDescription postInvoke(java.lang.Object object, IOR iOR) throws CloneNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke", iOR.stringify());
        }
        ((RetryCounter)requestCount.get()).reset();
        MasterProxy masterProxy = this.findMasterProxy(object);
        masterProxy.postInvoke();
        masterProxy.deregisterContextForClientInterceptor(this.orb);
        ClusterAndClusterMemberInUse clusterAndClusterMemberInUse = SelectionManager.popServerForInvocation();
        ClusterMemberDescription clusterMemberDescription = clusterAndClusterMemberInUse.getClusterMember();
        clusterMemberDescription.setReachability((byte)0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    public void handleRemoteException(ClusterMemberDescription clusterMemberDescription, ConnectionExceptionHelper connectionExceptionHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRemoteException {0} {1}", new java.lang.Object[]{clusterMemberDescription, connectionExceptionHelper});
        }
        if (connectionExceptionHelper.commFailure()) {
            router.getUnavailableManager().markUnavailable(clusterMemberDescription);
            Tr.service(tc, "WLMKEY_SERVER_MARKED_UNUSABLE", new java.lang.Object[]{clusterMemberDescription.getKey(), "", connectionExceptionHelper.getException()});
        } else {
            ((RetryCounter)requestCount.get()).reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRemoteException", clusterMemberDescription);
        }
    }

    private ClusterMemberDescription createClusterMember(DescriptionKey descriptionKey, IOR iOR) {
        ClusterMemberDescription clusterMemberDescription;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createClusterMember", new java.lang.Object[]{descriptionKey, iOR});
            }
            clusterMemberDescription = null;
            IIOPClusterMemberDescriptionImpl iIOPClusterMemberDescriptionImpl = null;
            try {
                DescriptionManager descriptionManager = DescriptionManagerFactory.getLocalDescriptionManager();
                clusterMemberDescription = (ClusterMemberDescription)descriptionManager.getDescription(descriptionKey, ClusterMemberDescription.class.getName());
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put(IIOPClusterMemberDescription.distinction[0], IIOPClusterMemberDescription.distinction[1]);
                DescriptionKey descriptionKey2 = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey(descriptionKey, treeMap);
                iIOPClusterMemberDescriptionImpl = (IIOPClusterMemberDescriptionImpl)descriptionManager.getDescription(descriptionKey2, IIOPClusterMemberDescription.class.getName());
                clusterMemberDescription.setExtrinsicData(iIOPClusterMemberDescriptionImpl);
                iIOPClusterMemberDescriptionImpl.setIOR(iOR);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "member", clusterMemberDescription);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, SelectionManager.class.getName() + ".createClusterMember", "678", this, new java.lang.Object[]{descriptionKey, clusterMemberDescription});
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "unexpected", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClusterMember", clusterMemberDescription);
        }
        return clusterMemberDescription;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ifix", "1.27 : none");
        }
        router = null;
        serversInUse = new ThreadLocal();
        requestCount = new ThreadLocal();
    }
}

