/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.router.selection.UnavailableManager;
import com.ibm.ws.cluster.selection.AdvisorMediatorFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPoolFactory;
import com.ibm.wsspi.cluster.monitor.AdvisorMediator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UnavailableManagerImpl
implements UnavailableManager {
    private static final TraceComponent tc = Tr.register(UnavailableManagerImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private long unusableInterval;
    private long sleepInterval;
    private ContextManager contextMgr = null;
    private static DescriptionManager descriptionManager;
    private static Map memberKeys;
    private static Timer timer;
    private static boolean releaseTimer;

    public UnavailableManagerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Contructs UnavailableManagerImpl(); at this time, the previous timer object is", timer);
        }
        DescriptionManagerFactory.getInstance();
        descriptionManager = DescriptionManagerFactory.getDescriptionManager();
        if (timer != null) {
            try {
                Thread.sleep(this.sleepInterval + this.unusableInterval);
            }
            catch (InterruptedException interruptedException) {
                Tr.error(tc, "UnavailableManagerImpl()", interruptedException);
            }
            timer.destroy();
            releaseTimer = true;
            timer = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Contructed UnavailableManagerImpl(); at this time, previous timer object should be null", timer);
        }
    }

    public void setUnusableInterval(long l) {
        this.unusableInterval = l;
    }

    public void setSleepInterval(long l) {
        this.sleepInterval = l;
    }

    public void createTimer() {
        if (timer == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "create Timer in UnavailableManager");
            }
            if (this.sleepInterval < this.unusableInterval) {
                final long l = this.sleepInterval;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        UnavailableManagerImpl.timer = new Timer(l);
                        return null;
                    }
                });
            } else {
                final long l = this.unusableInterval;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        UnavailableManagerImpl.timer = new Timer(l);
                        return null;
                    }
                });
            }
            SleeperThreadPoolFactory.getInstance().RunInTimeOrder(timer, timer.getSleepTimeInterval());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTimer - new Timer created with sleepInterval=" + this.sleepInterval + " and unavailableInterval=" + this.unusableInterval, timer);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createTimer - Timer object already exists in this JVM", timer);
        }
    }

    protected void forceCreateTimer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "force to create Timer in UnavailableManager on failures");
        }
        if (this.sleepInterval < this.unusableInterval) {
            final long l = this.sleepInterval;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    UnavailableManagerImpl.timer = new Timer(l);
                    return null;
                }
            });
        } else {
            final long l = this.unusableInterval;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    UnavailableManagerImpl.timer = new Timer(l);
                    return null;
                }
            });
        }
        SleeperThreadPoolFactory.getInstance().RunInTimeOrder(timer, timer.getSleepTimeInterval());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forced to create new Timer", timer);
        }
    }

    public void markUnavailable(ClusterMemberDescription clusterMemberDescription) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markUnavailable", clusterMemberDescription);
        }
        clusterMemberDescription.setState((byte)4);
        this.createTimer();
        Long l = new Long(System.currentTimeMillis() + this.unusableInterval);
        memberKeys.put(clusterMemberDescription.getKey(), l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markUnavailable");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.8 : none");
        }
        memberKeys = new HashMap();
        releaseTimer = false;
    }

    private class Timer
    implements Runnable {
        private long sleepTimeInterval;
        private boolean next = true;

        public Timer(long l) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Timer");
            }
            UnavailableManagerImpl.this.contextMgr = ContextManagerFactory.getInstance();
            this.sleepTimeInterval = l;
        }

        public void doTask() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "doTask");
            }
            HashMap hashMap = new HashMap(memberKeys);
            ArrayList<DescriptionKey> arrayList = new ArrayList<DescriptionKey>();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                DescriptionKey descriptionKey = (DescriptionKey)iterator.next();
                if ((Long)hashMap.get(descriptionKey) > System.currentTimeMillis()) continue;
                ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descriptionManager.getDescription(descriptionKey);
                if (clusterMemberDescription != null) {
                    if (((ClusterMemberDescription.Memento)clusterMemberDescription.getMemento()).getState() == 4) {
                        AdvisorMediator advisorMediator = AdvisorMediatorFactory.getMediator();
                        clusterMemberDescription.setState((byte)0);
                        advisorMediator.setAvailable(clusterMemberDescription.getKey());
                    }
                    iterator.remove();
                    arrayList.add(descriptionKey);
                    continue;
                }
                Tr.error(tc, "markUnavailable - Cluster member not found with Description Key:", descriptionKey);
            }
            hashMap = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In this cycle at time of " + System.currentTimeMillis() + ", " + arrayList.size() + " members are reset to active", arrayList);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                memberKeys.remove(arrayList.get(i));
            }
            arrayList = null;
        }

        public void destroy() {
            Tr.error(tc, "Availability Monitor thread error, destroy this thread.");
            this.next = false;
        }

        public void run() {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        if (!memberKeys.isEmpty()) {
                            Timer.this.doTask();
                        }
                        SleeperThreadPoolFactory.getInstance().RunInTimeOrder(timer, timer.getSleepTimeInterval());
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cluster.router.selection.UnavailableManagerImpl.Timer-run", "438", this);
                        Tr.info(tc, "Timer Thread - Problem with thread - Throwable", throwable);
                        UnavailableManagerImpl.this.forceCreateTimer();
                        Timer.this.destroy();
                    }
                    return null;
                }
            };
            try {
                UnavailableManagerImpl.this.contextMgr.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.cluster.router.selection.UnavailableManagerImpl.Timer.run", "454", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Timer.run", new Object[]{privilegedActionException});
                }
                Tr.info(tc, "Timer Thread - Problem with thread - Throwable", privilegedActionException);
                UnavailableManagerImpl.this.forceCreateTimer();
                this.destroy();
            }
        }

        int getSleepTimeInterval() {
            return (int)this.sleepTimeInterval;
        }
    }
}

