/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.router.selection;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.ejs.oa.UserKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.router.selection.IIOPSelectionCriteria;
import com.ibm.ws.cluster.router.selection.WLMIORBuilder;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.selection.ClusterIdentityResolver;
import com.ibm.wsspi.cluster.selection.ClusterIdentityResolverCoordinator;
import com.ibm.wsspi.cluster.selection.ClusterIdentityResolverCoordinatorFactory;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionCallback;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;

public class WLMLSDRouter {
    static final TraceComponent tc = Tr.register(WLMLSDRouter.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private static final SelectionService selectionService = SelectionServiceFactory.getSelectionService();
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private static final ClusterIdentityResolverCoordinator resolverCoordinator = ClusterIdentityResolverCoordinatorFactory.getClusterIdentityResolverCoordinator();
    private ORB orb = null;
    private static WLMLSDRouter instance;
    private String cellName = null;
    private Contract contract = null;
    private int callbackCount = 0;
    private static final Map criteriaCache;

    private WLMLSDRouter(ORB oRB) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " WLMLSDRouter CTOR");
        }
        this.orb = oRB;
        this.contract = new ContractImpl();
        this.contract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.contract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        this.contract.setInterest(new ConcernImpl(2));
        this.cellName = (String)ProcessProperties.getInstance().get("key.containing.cellname");
        if (tc.isEventEnabled()) {
            Tr.event(tc, "WLMLSDRouter cell is " + this.cellName);
        }
    }

    public static WLMLSDRouter getLSDRouter(ORB oRB) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLSDRouter", oRB);
        }
        if (instance == null) {
            instance = new WLMLSDRouter(oRB);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLSDRouter", instance);
        }
        return instance;
    }

    public IOR getNextTarget(ObjectKey objectKey, UserKey userKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextTarget(oKey,userKey)", new Object[]{objectKey, userKey});
        }
        IOR iOR = null;
        if (userKey.getWLMObjectRefType() == 1) {
            String string = userKey.getName();
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("CELLNAME", this.cellName);
            treeMap.put("CLUSTERNAME", string);
            Identity identity = clusterService.getIdentity(treeMap);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "getNextTarget server cluster is " + identity);
            }
            iOR = this.select(identity, objectKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextTarget", iOR == null ? "null" : iOR.stringify());
        }
        return iOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOR select(Identity identity, ObjectKey objectKey) {
        IOR iOR;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{identity, objectKey});
        }
        try {
            ClusterIdentityResolver[] clusterIdentityResolverArray = resolverCoordinator.getOrderedSequence();
            for (int i = 0; i < clusterIdentityResolverArray.length; ++i) {
                Identity identity2 = clusterIdentityResolverArray[i].resolveIdentity(objectKey);
                if (identity2 == null) continue;
                identity = identity2;
                break;
            }
            Target target = selectionService.select(this.getCriteria(identity));
            ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)target.getMemberIdentity());
            iOR = WLMIORBuilder.assembleTargetIOR(this.orb, objectKey, clusterMemberDescription);
        }
        catch (NoAvailableTargetException noAvailableTargetException) {
            Target target = this.selectBackup(identity);
            if (target == null) {
                int n;
                Integer n2;
                block22: {
                    ProcessProperties processProperties = ProcessProperties.getInstance();
                    n2 = new Integer(180000);
                    try {
                        n2 = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_CALLBACK_TIMEOUT"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!tc.isEventEnabled()) break block22;
                        Tr.event(tc, "Custom Property IBM_CLUSTER_CALLBACK_TIMEOUT is not set properly, received NumberFormatException.  Defaulting to 3 minutes");
                    }
                }
                if (n2 != null) {
                    n = n2;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Custom Property IBM_CLUSTER_CALLBACK_TIMEOUT is not set properly, Defaulting to 3 minutes");
                    }
                    n = 180000;
                }
                if (n != 0) {
                    int n3 = 0;
                    if (n > 0) {
                        n3 = n;
                    }
                    LSDSelectorCallback lSDSelectorCallback = new LSDSelectorCallback();
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "NoAvailableTargetException registering callback", new Object[]{lSDSelectorCallback, String.valueOf(n3), String.valueOf(this.callbackCount)});
                    }
                    LSDSelectorCallback lSDSelectorCallback2 = lSDSelectorCallback;
                    synchronized (lSDSelectorCallback2) {
                        noAvailableTargetException.callbackWhenAvailable(lSDSelectorCallback, null);
                        try {
                            lSDSelectorCallback.wait(n3);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    target = lSDSelectorCallback.target;
                }
                if (target == null && target == null) {
                    Tr.service(tc, "WLMKEY_CLUSTER_MARKED_UNUSABLE", new Object[]{identity, null});
                    throw new NO_IMPLEMENT("No Cluster Data Available", 1229066306, CompletionStatus.COMPLETED_NO);
                }
            }
            ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)target.getMemberIdentity());
            iOR = WLMIORBuilder.assembleTargetIOR(this.orb, objectKey, clusterMemberDescription);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, WLMLSDRouter.class.getName() + ".select", "298", this, new Object[]{identity, objectKey});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", exception);
            }
            NO_IMPLEMENT nO_IMPLEMENT = new NO_IMPLEMENT("ERROR:  See chained exception", 1229066306, CompletionStatus.COMPLETED_NO);
            nO_IMPLEMENT.initCause((Throwable)exception);
            throw nO_IMPLEMENT;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", iOR.stringify());
        }
        return iOR;
    }

    private Target selectBackup(Identity identity) {
        Target target;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "selectBackup", identity);
            }
            target = null;
            try {
                ClusterDescription clusterDescription = (ClusterDescription)descMgr.getDescription((DescriptionKey)identity, ClusterDescription.class.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got description, attempting to get backup", clusterDescription);
                }
                clusterDescription = ((ClusterDescription.Memento)clusterDescription.getMemento()).getBackupCluster();
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "selectBackup", clusterDescription);
                }
                if (clusterDescription != null) {
                    target = selectionService.select(clusterDescription.getKey());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, WLMLSDRouter.class.getName() + ".selectBackup", "337", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selectBackup", target);
        }
        return target;
    }

    private synchronized SelectionCriteria getCriteria(Identity identity) {
        SelectionCriteria selectionCriteria = (SelectionCriteria)criteriaCache.get(identity);
        if (selectionCriteria == null) {
            HashMap<String, SelectionRule[]> hashMap = new HashMap<String, SelectionRule[]>();
            hashMap.put("rules.restriction", new SelectionRule[]{new IIOPSelectionCriteria()});
            hashMap.put("rules.precedence", new SelectionRule[]{new DefaultRule()});
            selectionCriteria = selectionService.getCriteria(identity, hashMap);
            criteriaCache.put(identity, selectionCriteria);
        }
        return selectionCriteria;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.14.1.4 : none");
        }
        instance = null;
        criteriaCache = new HashMap();
    }

    private class LSDSelectorCallback
    implements SelectionCallback {
        Target target = null;

        private LSDSelectorCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(Target target, Object object) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "LSDSelectorCallback::callback", target);
            }
            LSDSelectorCallback lSDSelectorCallback = this;
            synchronized (lSDSelectorCallback) {
                this.target = target;
                this.notifyAll();
            }
        }
    }
}

