/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBContainerException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.WLMCustomPropertyUtility;
import com.ibm.ws.cluster.runtime.WLMNonDefaultCookieUtility;
import com.ibm.ws.csi.EJBClusterNameService;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;

public class ApplicationServerRuntimeImpl
extends WsComponentImpl
implements EJBClusterNameService,
DeployedObjectListener {
    private static final TraceComponent tc = Tr.register(ApplicationServerRuntimeImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String cellName = AdminServiceFactory.getAdminService().getCellName();
    private static ClusterMemberService clusterMemberService = null;
    private static WLMNonDefaultCookieUtility cookieUtility = null;
    private static Object cookieMutex = new Object();
    private static final boolean USE_NON_DEFAULT_COOKIE_NAMES = WLMCustomPropertyUtility.getNonDefaultCookieNameValue();
    private Repository repository = null;
    private AdminService adminService = AdminServiceFactory.getAdminService();
    private String processType;
    private Identity containingClusterIdentity = null;
    private Server server = null;

    public static void setClusterMemberService(ClusterMemberService clusterMemberService) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setClusterMemberService", clusterMemberService);
        }
        ApplicationServerRuntimeImpl.clusterMemberService = clusterMemberService;
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        Object object2;
        block17: {
            block16: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "initialize", object);
                }
                super.initialize(object);
                try {
                    this.server = (Server)WsServiceRegistry.getService((Object)this, (Class)Server.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "116");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "initialize getService Failed");
                    }
                    throw new ComponentDisabledException();
                }
                try {
                    this.repository = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "146");
                    if (!tc.isEventEnabled()) break block16;
                    Tr.event(tc, "loadClusterData getService Failed");
                }
            }
            AdminService adminService = AdminServiceFactory.getAdminService();
            this.processType = adminService.getProcessType();
            String string = this.server.getClusterName();
            if (string != null) {
                this.containingClusterIdentity = IdentityMapping.getApplicationServerCluster(cellName, string);
                object2 = null;
                try {
                    object2 = (EJBContainer)WsServiceRegistry.getService((Object)this, (Class)EJBContainer.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "128");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "initialize getService Failed");
                    }
                    throw new ComponentDisabledException();
                }
                try {
                    object2.setClusterNameService(this);
                }
                catch (EJBContainerException eJBContainerException) {
                    FFDCFilter.processException((Throwable)eJBContainerException, ApplicationServerRuntimeImpl.class.getName() + ".start", "107", this);
                    if (!tc.isEventEnabled()) break block17;
                    Tr.event(tc, "unexpected", eJBContainerException);
                }
            }
        }
        object2 = null;
        try {
            object2 = (ApplicationMgr)WsServiceRegistry.getService((Object)this, (Class)ApplicationMgr.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "147");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Failed");
            }
            throw new ComponentDisabledException();
        }
        object2.addDeployedObjectListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", new Object[]{clusterMemberService, this.containingClusterIdentity});
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        super.start();
        this.joinStandaloneCluster(cellName, this.server.getNodeName(), this.server.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public Identity getClusterIdentity(J2EEName j2EEName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentity", new Object[]{j2EEName, j2EEName.getModule()});
        }
        Identity identity = this.containingClusterIdentity;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterIdentity", identity);
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        block25: {
            DeployedObject deployedObject;
            String string;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stateChanged", deployedObjectEvent);
            }
            try {
                string = deployedObjectEvent.getDeployedObject().getName();
                deployedObject = deployedObjectEvent.getDeployedObject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, ApplicationServerRuntimeImpl.class.getName(), "188", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "unexpected exception", exception);
                }
                return;
            }
            String string2 = null;
            if (!(deployedObject instanceof DeployedModule)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stateChanged", string + " is not a deployed module.");
                }
                return;
            }
            string2 = ((DeployedModule)deployedObject).getDeployedApplication().getName();
            if (deployedObjectEvent.getPropertyName() != null && deployedObjectEvent.getPropertyName().equals("state")) {
                if (deployedObjectEvent.getNewValue() != null && deployedObjectEvent.getNewValue().equals("STARTED")) {
                    block23: {
                        Identity identity = IdentityMapping.getApplicationCluster(cellName, string2, string);
                        try {
                            clusterMemberService.joinCluster(identity);
                            clusterMemberService.defineAttribute(string);
                        }
                        catch (NoClusterDefinedException noClusterDefinedException) {
                            FFDCFilter.processException((Throwable)noClusterDefinedException, ApplicationServerRuntimeImpl.class.getName(), "165", this);
                            if (!tc.isEventEnabled()) break block23;
                            Tr.event(tc, "unexpected exception", noClusterDefinedException);
                        }
                    }
                    if (USE_NON_DEFAULT_COOKIE_NAMES && this.processType.equals("ManagedProcess")) {
                        Object object = cookieMutex;
                        synchronized (object) {
                            block24: {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "stateChanged - loading non-default cookie information");
                                }
                                try {
                                    if (cookieUtility == null) {
                                        cookieUtility = new WLMNonDefaultCookieUtility();
                                    }
                                    String string3 = this.adminService.getProcessName();
                                    String string4 = this.adminService.getNodeName();
                                    Identity identity = IdentityMapping.getMemberIdentityFromMemberName(cellName, string4, string3);
                                    cookieUtility.parseAndSetCookie(identity, string2);
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, ApplicationServerRuntimeImpl.class.getName() + ".stateChanged()", "311", this);
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block24;
                                    Tr.event(tc, "Unexpected exception trying to initialize non-default cookie path, non-default cookies may not be loaded", exception);
                                }
                            }
                        }
                    }
                } else if (deployedObjectEvent.getOldValue() != null && deployedObjectEvent.getOldValue().equals("STARTED")) {
                    Identity identity = IdentityMapping.getApplicationCluster(cellName, string2, string);
                    try {
                        clusterMemberService.disjoinCluster(identity);
                        clusterMemberService.undefineAttribute(string);
                    }
                    catch (NoClusterDefinedException noClusterDefinedException) {
                        FFDCFilter.processException((Throwable)noClusterDefinedException, ApplicationServerRuntimeImpl.class.getName(), "176", this);
                        if (!tc.isEventEnabled()) break block25;
                        Tr.event(tc, "unexpected exception", noClusterDefinedException);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged", new Object[]{deployedObjectEvent.getPropertyName(), deployedObjectEvent.getOldValue(), deployedObjectEvent.getNewValue(), deployedObjectEvent.getRuntimeState()});
        }
    }

    private void joinStandaloneCluster(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "joinStandaloneCluster", new Object[]{string, string2, string3});
        }
        try {
            Identity identity = IdentityMapping.getServerInstanceCluster(string, string2, string3);
            clusterMemberService.joinCluster(identity);
        }
        catch (NoClusterDefinedException noClusterDefinedException) {
            FFDCFilter.processException(noClusterDefinedException, ApplicationServerRuntimeImpl.class.getName() + ".joinSingletonCluster", "197", this, new Object[]{string, string2, string3});
            if (tc.isEventEnabled()) {
                Tr.event(tc, "joinSingletonCluster", noClusterDefinedException);
            }
            Tr.error(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{"joinSingletonCluster", noClusterDefinedException});
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.14.1.1 ");
        }
    }
}

