/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.runtime.ClusterRuntime;
import com.ibm.ws.cluster.runtime.CrossCellConnector;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.wlm.ClusterMgr;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wlm.Factory;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.HashMap;

public class ClusterRuntimeImpl
extends WsComponentImpl
implements ClusterRuntime {
    private static final TraceComponent tc = Tr.register(ClusterRuntimeImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");

    public ClusterRuntimeImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        if (!AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", "Component Disabled.");
            }
            throw new ComponentDisabledException();
        }
        try {
            WsServiceRegistry.addService((Object)this, (Class)ClusterRuntime.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterRuntimeImpl.class.getName() + ".initialize", "117");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
            new CrossCellConnector();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this);
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        SecurityService securityService;
        HashMap<String, Object> hashMap;
        block12: {
            EndPointMgr endPointMgr;
            block11: {
                Repository repository2;
                block10: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "start");
                    }
                    try {
                        Factory.loadImpl("com.ibm.ws.cluster.control.mbean.MBeanRouter");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    hashMap = new HashMap<String, Object>();
                    repository2 = null;
                    try {
                        repository2 = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, ClusterRuntimeImpl.class.getName() + ".start", "155");
                        if (!tc.isEventEnabled()) break block10;
                        Tr.event(tc, "start getService Failed");
                    }
                }
                hashMap.put("Repository", repository2);
                AdminService adminService = AdminServiceFactory.getAdminService();
                hashMap.put("AdminService", adminService);
                endPointMgr = null;
                try {
                    endPointMgr = (EndPointMgr)WsServiceRegistry.getService((Object)this, (Class)EndPointMgr.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ClusterRuntimeImpl.class.getName() + ".start", "169");
                    if (!tc.isEventEnabled()) break block11;
                    Tr.event(tc, "start getService Failed");
                }
            }
            hashMap.put("EndPointMgr", endPointMgr);
            securityService = null;
            try {
                securityService = (SecurityService)WsServiceRegistry.getService((Object)this, (Class)SecurityService.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterRuntimeImpl.class.getName() + ".start", "180");
                if (!tc.isEventEnabled()) break block12;
                Tr.event(tc, "start getService Failed");
            }
        }
        hashMap.put("SecurityService", securityService);
        this.initializeClusterMgr(hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    private void initializeClusterMgr(HashMap hashMap) {
        Admin admin2;
        ClusterMgr clusterMgr;
        block2: {
            clusterMgr = new ClusterMgr();
            clusterMgr.initialize(hashMap);
            admin2 = null;
            try {
                admin2 = (Admin)WsServiceRegistry.getService((Object)this, (Class)Admin.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterRuntimeImpl.class.getName() + ".initializeClusterMgr", "201");
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "initializeClusterMgr getService Failed");
            }
        }
        admin2.addConfigChangeListener(clusterMgr);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.11 ");
        }
    }
}

