/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.propagation.Connection;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.DescriptionCallback;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.KeyConverter;
import com.ibm.ws.cluster.iiop.topography.propagation.Registrar;
import com.ibm.ws.cluster.iiop.topography.propagation.RegistrarHelper;
import com.ibm.ws.cluster.iiop.topography.propagation.StateTransfer;
import com.ibm.ws.cluster.iiop.topography.propagation.StateTransferHelper;
import com.ibm.ws.cluster.management.IIOPRegistrar;
import com.ibm.ws.cluster.propagation.IIOPDistributedListener;
import com.ibm.ws.cluster.propagation.StreamContextHandler;
import com.ibm.ws.cluster.propagation.bulletinboard.BBDescriptionManager;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CrossCellConnector
implements Connection {
    private static final TraceComponent tc = Tr.register(CrossCellConnector.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final Map threads = new HashMap();
    static /* synthetic */ Class class$com$ibm$websphere$cluster$topography$ClusterDescription;

    public CrossCellConnector() {
        DescriptionManagerFactory.getInstance();
        ((BBDescriptionManager)DescriptionManagerFactory.getDescriptionManager()).registerService(this);
    }

    public synchronized void monitorConnection(String string, URL uRL, Contract contract, DescriptionCallback descriptionCallback, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "monitorConnection", new Object[]{string, uRL, contract, descriptionCallback, object});
        }
        if (threads.containsKey(string)) {
            ((ConnectionThread)threads.get(string)).reconnect = false;
            threads.remove(string);
        }
        ConnectionThread connectionThread = new ConnectionThread(string, uRL, contract, descriptionCallback, object);
        threads.put(string, connectionThread);
        connectionThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "monitorConnection");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.13 ");
        }
    }

    private final class ConnectionThread
    extends Thread {
        private final String openBracket = "[";
        private final String closeBracket = "]";
        private final String colon = ":";
        private final Format format = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 1);
        private boolean reconnect;
        private String name;
        private URL connection;
        private Contract contract;
        private DescriptionCallback callback;
        private Object handback;
        private Registrar iiopRegistrar = null;
        private StateTransfer iiopDistributedListener = null;
        private StreamContextHandler ivStreamHandler = StreamContextHandler.getInstance();
        private Format ivStructuralFormat = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 3);
        private DescriptionManager ivDescriptionManager;

        private ConnectionThread(String string, URL uRL, Contract contract, DescriptionCallback descriptionCallback, Object object) {
            DescriptionManagerFactory.getInstance();
            this.ivDescriptionManager = DescriptionManagerFactory.getDescriptionManager();
            this.name = string;
            this.connection = uRL;
            this.contract = contract;
            this.callback = descriptionCallback;
            this.handback = object;
        }

        private byte[] toByteArray(Serializable serializable) {
            byte[] byArray;
            block2: {
                byArray = null;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = null;
                try {
                    objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(serializable);
                    objectOutputStream.flush();
                    byteArrayOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    if (!tc.isEventEnabled()) break block2;
                    Tr.event(tc, "unexpected", exception);
                }
            }
            return byArray;
        }

        public void run() {
            block15: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run", this.connection);
                }
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() {
                        ConnectionThread.this.reconnect = true;
                        long l = Long.parseLong(System.getProperty("com.ibm.websphere.cluster.connection.heartbeat", "60000"));
                        String string = "corbaloc::" + ConnectionThread.this.connection.getHost() + ":" + ConnectionThread.this.connection.getPort() + "/" + "ClusterRegistrarService";
                        String string2 = "corbaloc::" + ConnectionThread.this.connection.getHost() + ":" + ConnectionThread.this.connection.getPort() + "/" + "ClusterListenerService";
                        ORB oRB = GlobalORBFactory.globalORB();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempting to contact remote registrar at the following location", string);
                        }
                        if (tc.isInfoEnabled()) {
                            Tr.info(tc, "WLMKEY_ATTEMPTING_TO_CONTACT_BACKUP_CLUSTER", new Object[]{ConnectionThread.this.name, ConnectionThread.this.connection.getHost(), new Integer(ConnectionThread.this.connection.getPort())});
                        }
                        while (ConnectionThread.this.reconnect) {
                            try {
                                ConnectionThread.this.iiopRegistrar = RegistrarHelper.narrow(oRB.string_to_object(string));
                                ConnectionThread.this.iiopDistributedListener = StateTransferHelper.narrow(oRB.string_to_object(string2));
                                return Boolean.TRUE;
                            }
                            catch (Exception exception) {
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Registration with remote cell failed, waiting to try again.", new Object[]{exception.getClass().getName(), exception.getMessage()});
                                }
                                try {
                                    Thread.sleep(l);
                                }
                                catch (InterruptedException interruptedException) {
                                    if (!tc.isEventEnabled()) continue;
                                    Tr.event(tc, "Thread interrupted!");
                                }
                            }
                        }
                        return Boolean.FALSE;
                    }
                };
                try {
                    Object object;
                    DescriptionKey descriptionKey;
                    String[] stringArray;
                    AdminService adminService;
                    block16: {
                        if (!((Boolean)ContextManagerFactory.getInstance().runAsSystem(privilegedExceptionAction)).booleanValue()) break block15;
                        String[] stringArray2 = this.iiopRegistrar.pullDescriptionKey("");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Retrived cell name: " + stringArray2[0] + " from remote dmgr");
                        }
                        if (tc.isInfoEnabled()) {
                            Tr.info(tc, "WLMKEY_SUCCESSFULLY_CONTACTED_BACKUP_CLUSTER", new Object[]{this.name, this.connection.getHost(), new Integer(this.connection.getPort())});
                        }
                        adminService = AdminServiceFactory.getAdminService();
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("ClusterListenerService");
                        stringBuffer.append("[");
                        stringBuffer.append(adminService.getNodeName());
                        stringBuffer.append(":");
                        stringBuffer.append(adminService.getProcessName());
                        stringBuffer.append("]");
                        stringBuffer.append(adminService.getCellName());
                        byte[] byArray = stringBuffer.toString().getBytes();
                        IIOPDistributedListener iIOPDistributedListener = (IIOPDistributedListener)IIOPRegistrar.getInstance().servantmanager.keyToObject(byArray);
                        iIOPDistributedListener.checkForPeerAccessPoint(stringArray2[0]);
                        stringArray = new String[]{stringArray2[0], this.name};
                        try {
                            this.iiopRegistrar.registerCurrentVersionBackupClusterListener(stringArray, iIOPDistributedListener, this.toByteArray(this.contract));
                        }
                        catch (Exception exception) {
                            this.iiopRegistrar.registerClusterListener(stringArray, iIOPDistributedListener, this.toByteArray(this.contract));
                        }
                        byte[] byArray2 = null;
                        try {
                            byArray2 = this.iiopRegistrar.pullCurrentVersion(stringArray, this.toByteArray(this.ivStructuralFormat));
                            descriptionKey = KeyConverter.convertKey(stringArray2[0], this.name);
                            iIOPDistributedListener.update(descriptionKey, byArray2);
                        }
                        catch (Exception exception) {
                            byArray2 = this.iiopRegistrar.pull(stringArray, this.toByteArray(this.ivStructuralFormat));
                            try {
                                object = KeyConverter.convertKey(stringArray2[0], this.name);
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Compressor.decompress(byArray2, 4));
                                WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
                                this.ivStreamHandler.parseVersion2(wsObjectInputStream, true, (DescriptionKey)object);
                                wsObjectInputStream.close();
                                byteArrayInputStream.close();
                                try {
                                    HashSet<Object> hashSet = new HashSet<Object>();
                                    hashSet.add(object);
                                    HashMap<Format, HashSet<Object>> hashMap = new HashMap<Format, HashSet<Object>>();
                                    hashMap.put(this.format, hashSet);
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                                    this.ivDescriptionManager.stream(hashMap, objectOutputStream);
                                    objectOutputStream.flush();
                                    byte[] byArray3 = Compressor.compress(byteArrayOutputStream.toByteArray(), 4);
                                    objectOutputStream.close();
                                    byteArrayOutputStream.close();
                                    iIOPDistributedListener.update((DescriptionKey)object, byArray3);
                                }
                                catch (Exception exception2) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event(tc, "unexpected", exception2);
                                    }
                                }
                            }
                            catch (Exception exception3) {
                                if (!tc.isEventEnabled()) break block16;
                                Tr.event(tc, "unexpected", exception3);
                            }
                        }
                    }
                    this.iiopDistributedListener.invokeRegistration(new String[]{adminService.getCellName(), this.name}, IIOPRegistrar.getInstance());
                    descriptionKey = KeyConverter.convertKey(stringArray);
                    object = (ClusterDescription)this.ivDescriptionManager.getDescription(descriptionKey, (class$com$ibm$websphere$cluster$topography$ClusterDescription == null ? (class$com$ibm$websphere$cluster$topography$ClusterDescription = CrossCellConnector.class$("com.ibm.websphere.cluster.topography.ClusterDescription")) : class$com$ibm$websphere$cluster$topography$ClusterDescription).getName());
                    this.callback.receiveClusterDescription((ClusterDescription)object, this.handback);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, (class$com$ibm$ws$cluster$runtime$CrossCellConnector == null ? (class$com$ibm$ws$cluster$runtime$CrossCellConnector = CrossCellConnector.class$("com.ibm.ws.cluster.runtime.CrossCellConnector")) : class$com$ibm$ws$cluster$runtime$CrossCellConnector).getName() + ".monitorConnection", "237", this, new Object[]{this.callback});
                    if (!tc.isEventEnabled()) break block15;
                    Tr.event(tc, "unexpected", new Object[]{exception});
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }
    }
}

