/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.ejs.oa.LocationService;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.DescriptionFactory;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.management.IIOPRegistrar;
import com.ibm.ws.cluster.propagation.IIOPDistributedListener;
import com.ibm.ws.cluster.propagation.ServerClusterContextListenerImpl;
import com.ibm.ws.cluster.propagation.WLMTemplateImpl;
import com.ibm.ws.cluster.propagation.bulletinboard.BBDescriptionManager;
import com.ibm.ws.cluster.runtime.ProcessRuntime;
import com.ibm.ws.cluster.runtime.WLMDiagnosticModule;
import com.ibm.ws.cluster.service.BuildLSDCluster;
import com.ibm.ws.cluster.topography.ClusterDescriptionImpl;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescription;
import com.ibm.ws.cluster.topography.IIOPClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.wlm.WLMAppServer;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.WLM;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.ws.webcontainer.util.EncodeCloneID;
import com.ibm.ws.wlm.TypeConversion;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.configuration.MemberAddress;
import com.ibm.ws.wlm.dopriv.FileInputStreamPrivileged;
import com.ibm.ws.wlm.server.ProfileService;
import com.ibm.ws.wlm.server.ServerAffinityManager;
import com.ibm.ws.wlm.server.WLMServerRequestInterceptor;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScopes;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.resource.Resource;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public class ProcessRuntimeImpl
extends WsComponentImpl
implements ProcessRuntime,
WLM {
    private static final TraceComponent tc = Tr.register(ProcessRuntimeImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static Integer HANDBACK_SERVER;
    private static Integer HANDBACK_NODEAGENT;
    private static Integer HANDBACK_DMGR;
    private DescriptionKey containingClusterKey = null;
    private String ivContainingClusterName = null;
    private DescriptionKey[] prefetchedClusters = new DescriptionKey[0];
    private DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private String ivProcessName = null;
    private String ivNodeName = null;
    private String ivUID = null;
    private int ivConfigWeight = 2;
    private boolean ivRegisterWithLSD = true;
    private List ivMembers = null;
    private Contract contract = null;
    private boolean useBB = true;
    static /* synthetic */ Class class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription;

    public ProcessRuntimeImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>", this);
        }
    }

    public void initialize(java.lang.Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        java.lang.Object object2;
        java.lang.Object object3;
        AdminService adminService;
        block34: {
            java.lang.Object object4;
            java.lang.Object object5;
            java.lang.Object object6;
            java.lang.Object object7;
            java.lang.Object object8;
            java.lang.Object object9;
            java.lang.Object object10;
            java.lang.Object object11;
            Repository repository2;
            String string;
            ProcessProperties processProperties;
            block33: {
                block32: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "initialize", new java.lang.Object[]{object});
                    }
                    WLMDiagnosticModule wLMDiagnosticModule = WLMDiagnosticModule.instance();
                    wLMDiagnosticModule.initialize(this);
                    wLMDiagnosticModule.registerWithFFDCService();
                    adminService = AdminServiceFactory.getAdminService();
                    Server server2 = null;
                    try {
                        server2 = (Server)WsServiceRegistry.getService((java.lang.Object)this, (Class)Server.class);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".initialize", "253");
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "initialize getService Failed");
                        }
                        throw new ComponentDisabledException();
                    }
                    this.ivContainingClusterName = server2.getClusterName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ivContainingClusterName = " + this.ivContainingClusterName);
                    }
                    processProperties = ProcessProperties.getInstance();
                    string = adminService.getCellName();
                    this.ivProcessName = adminService.getProcessName();
                    this.ivNodeName = adminService.getNodeName();
                    processProperties.put("key.containing.cellname", string);
                    WLMProperties.setAdminDomainName(string);
                    EndPointMgr endPointMgr = null;
                    try {
                        endPointMgr = (EndPointMgr)WsServiceRegistry.getService((java.lang.Object)this, (Class)EndPointMgr.class);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".initialize", "272");
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "initialize getService Failed");
                        }
                        throw new ComponentDisabledException();
                    }
                    if (!adminService.getProcessType().equals("ManagedProcess")) {
                        BuildLSDCluster.createLSDAddressList(endPointMgr);
                    }
                    repository2 = null;
                    try {
                        repository2 = (Repository)WsServiceRegistry.getService((java.lang.Object)this, (Class)Repository.class);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".loadClusterData", "666");
                        if (!tc.isEventEnabled()) break block32;
                        Tr.event(tc, "loadClusterData getService Failed");
                    }
                }
                try {
                    object3 = repository2.getConfigRoot();
                    object2 = object3.getResource(0, "cell.xml");
                    object11 = (Cell)object2.getContents().get(0);
                    object10 = object11.getProperties();
                    this.loadCustomProperties((List)object10);
                    object9 = null;
                    object8 = object3.getResource(4, "server.xml");
                    object7 = (com.ibm.websphere.models.config.process.Server)object8.getContents().get(0);
                    object6 = object7.getComponents();
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        object4 = (Component)object5.next();
                        if (!(object4 instanceof ApplicationServer)) continue;
                        ApplicationServer applicationServer = (ApplicationServer)object4;
                        object9 = applicationServer.getProperties();
                    }
                    if (object9 != null) {
                        this.loadCustomProperties((List)object9);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".initialize", "268");
                    if (!tc.isEventEnabled()) break block33;
                    Tr.event(tc, "ProcessRuntimeImpl.initialize getService Failed, cell level custom properties may not be loaded.");
                }
            }
            if (this.ivContainingClusterName != null) {
                object3 = new TreeMap();
                object3.put("CELLNAME", string);
                object3.put("CLUSTERNAME", this.ivContainingClusterName);
                this.containingClusterKey = this.keyRepository.getDescriptionKey((Map)object3);
                processProperties.put("key.containing.cluster", this.containingClusterKey);
                object2 = ClusterDescriptionImpl.getWeightTableKey(this.containingClusterKey);
                processProperties.put("key.containing.cluster.weight.table", object2);
                this.loadClusterData(string);
                repository2 = null;
                try {
                    repository2 = (Repository)WsServiceRegistry.getService((java.lang.Object)this, (Class)Repository.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".initialize", "304");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "initialize getService Failed");
                    }
                    throw new ComponentDisabledException();
                }
                object11 = repository2.getConfigRoot();
                object10 = object11.getAbsolutePath(2, this.ivContainingClusterName + ".wsrttbl");
                object9 = new FileInputStreamPrivileged((String)object10, false);
                try {
                    object8 = (FileInputStream)AccessController.doPrivileged(object9);
                    if (object8 != null) {
                        object7 = new WsObjectInputStream((InputStream)object8);
                        object6 = new ConcernImpl(Integer.MAX_VALUE);
                        object5 = new FormatImpl((Concern)object6, 3);
                        object4 = (ClusterDescription)this.descMgr.getDescription(this.containingClusterKey, ClusterDescription.class.getName());
                        object4.setMemento(object4.importFromStream((DataInput)object7, (Format)object5, null));
                        this.useBB = false;
                        BBDescriptionManager.processPosts = false;
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "loaded configuration route information", object4);
                        }
                        Tr.info(tc, "Loaded static configuration route information.\n" + (String)object10);
                    } else if (tc.isEventEnabled()) {
                        Tr.event(tc, "No configuration route information to load.");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, ProcessRuntimeImpl.class.getName() + "initialize", "254", this);
                    if (!tc.isEventEnabled()) break block34;
                    Tr.event(tc, "unexpected exception", exception);
                }
            }
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            new ProfileService();
        }
        object3 = ProcessProperties.getInstance();
        object2 = (String)((HashMap)object3).get("IBM_CLUSTER_ENABLE_PRELOAD");
        boolean bl = false;
        if (object2 != null && ((String)object2).compareToIgnoreCase("true") == 0) {
            bl = true;
        }
        if (adminService.getProcessType() == "NodeAgent" && bl) {
            this.preloadClustersForLSD();
        }
        this.contract = new ContractImpl();
        this.contract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.contract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        this.contract.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        try {
            WsServiceRegistry.addService((java.lang.Object)this, (Class)WLM.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".initialize", "358");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this);
        }
    }

    private void preloadClustersForLSD() {
        Repository repository2;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "preloadClustersForLSD");
            }
            repository2 = null;
            try {
                repository2 = (Repository)WsServiceRegistry.getService((java.lang.Object)this, (Class)Repository.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".loadClusterData", "666");
                if (!tc.isEventEnabled()) break block11;
                Tr.event(tc, "loadClusterData getService Failed");
            }
        }
        String string = repository2.getCellName();
        ConfigRoot configRoot = repository2.getConfigRoot();
        File file = new File(configRoot.getAbsolutePath(0, "clusters"));
        if (file != null) {
            File[] fileArray = file.listFiles();
            this.prefetchedClusters = new DescriptionKey[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    this.prefetchedClusters[i] = (DescriptionKey)IdentityMapping.getApplicationServerCluster(string, fileArray[i].getName());
                    this.descMgr.getDescription(this.prefetchedClusters[i], (class$com$ibm$websphere$cluster$topography$ClusterDescription == null ? ProcessRuntimeImpl.class$("com.ibm.websphere.cluster.topography.ClusterDescription") : class$com$ibm$websphere$cluster$topography$ClusterDescription).getName());
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl == null ? ProcessRuntimeImpl.class$("com.ibm.ws.cluster.runtime.ProcessRuntimeImpl") : class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl).getName() + ".preloadClustersForLSD", "353", this);
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unexpected", exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "preloadClustersForLSD", this.prefetchedClusters);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Bypassing preloadCluster logic - error getting clusters (expected on a base install)");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "preloadClustersForLSD - aborted");
            }
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        java.lang.Object object;
        java.lang.Object object2;
        PlatformHelper platformHelper;
        block49: {
            BulletinBoardScopes bulletinBoardScopes;
            GroupManager groupManager;
            BulletinBoardFactory bulletinBoardFactory;
            java.lang.Object object3;
            com.ibm.CORBA.iiop.ORB oRB;
            AdminService adminService;
            block48: {
                block47: {
                    block45: {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "start", this.containingClusterKey);
                        }
                        platformHelper = AdminHelper.getPlatformHelper();
                        adminService = AdminServiceFactory.getAdminService();
                        oRB = null;
                        if (!adminService.getProcessType().equals("UnManagedProcess")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "managed server");
                            }
                            object3 = null;
                            try {
                                object3 = (ORB)WsServiceRegistry.getService((java.lang.Object)this, (Class)ORB.class);
                                if (object3 != null) {
                                    oRB = object3.getORB();
                                }
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".start", "402");
                                if (!tc.isEventEnabled()) break block45;
                                Tr.event(tc, "start getService Failed");
                            }
                        }
                    }
                    if (adminService.getProcessType().equals("ManagedProcess") && this.ivContainingClusterName != null) {
                        block46: {
                            boolean bl = this.ivRegisterWithLSD = LocationService.getLocationService() != null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "In a managed process with RegisterWithLSD = " + this.ivRegisterWithLSD);
                            }
                            BuildLSDCluster.setRegisterWithLSD(this.ivRegisterWithLSD);
                            object3 = null;
                            try {
                                object3 = (EndPointMgr)WsServiceRegistry.getService((java.lang.Object)this, (Class)EndPointMgr.class);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".start", "420");
                                if (!tc.isEventEnabled()) break block46;
                                Tr.event(tc, "start getService Failed");
                            }
                        }
                        if (!this.ivRegisterWithLSD) {
                            this.buildClusterMemberAddresses(this.ivMembers, (EndPointMgr)object3);
                        } else {
                            WLMProperties.setMemberAddresses(new MemberAddress[0]);
                        }
                        BuildLSDCluster.createLSDAddressList((EndPointMgr)object3);
                    }
                    if (platformHelper.isBaseServantJvm() || platformHelper.isCRAJvm()) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "start");
                        }
                        return;
                    }
                    object3 = null;
                    try {
                        object3 = (CoreStack)WsServiceRegistry.getService((java.lang.Object)this, (Class)CoreStack.class);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".start", "454");
                        if (!tc.isEventEnabled()) break block47;
                        Tr.event(tc, "start getService Failed");
                    }
                }
                bulletinBoardFactory = null;
                groupManager = null;
                if (object3 != null) {
                    bulletinBoardFactory = object3.getBulletinboardFactory();
                    groupManager = object3.getGroupManager();
                }
                bulletinBoardScopes = null;
                try {
                    bulletinBoardScopes = (BulletinBoardScopes)WsServiceRegistry.getService((java.lang.Object)this, (Class)BulletinBoardScopes.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".start", "473");
                    if (!tc.isEventEnabled()) break block48;
                    Tr.event(tc, "start getService Failed");
                }
            }
            BulletinBoardScope bulletinBoardScope = null;
            if (bulletinBoardScopes != null) {
                bulletinBoardScope = bulletinBoardScopes.getPublicScope();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to load the Public BB scope, reverting to default scope.");
                }
                bulletinBoardScope = BulletinBoardScope.getDefault();
            }
            if (object3 == null || bulletinBoardFactory == null || groupManager == null) {
                Tr.warning(tc, "NLSKEY_HAMAMAGERFUNCTION_UNAVAILABLE", new java.lang.Object[]{adminService.getNodeName(), adminService.getProcessName(), adminService.getCellName()});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to load the HA services.", new java.lang.Object[]{object3, bulletinBoardFactory, groupManager});
                }
            }
            ProcessProperties processProperties = ProcessProperties.getInstance();
            processProperties.put("key.public.bbscope", bulletinBoardScope);
            processProperties.put("key.bbscopes", bulletinBoardScopes);
            processProperties.put("key.ha.groupmanager", groupManager);
            if (this.useBB) {
                processProperties.put("key.bulletinboard.factory", bulletinBoardFactory);
            }
            if (adminService.getProcessType().equals("ManagedProcess")) {
                new EventHandler(HANDBACK_SERVER);
            } else if (adminService.getProcessType().equals("NodeAgent")) {
                new EventHandler(HANDBACK_NODEAGENT);
            } else if (adminService.getProcessType().equals("DeploymentManager")) {
                new EventHandler(HANDBACK_DMGR);
            }
            if (!platformHelper.isZOS() && oRB != null) {
                new WLMTemplateImpl(oRB);
                object2 = new TreeMap<String, String>();
                object2.put("CELLNAME", adminService.getCellName());
                object = null;
                try {
                    object = this.keyRepository.getDescriptionKey((Map)object2);
                    if (adminService.getProcessType().equals("DeploymentManager")) {
                        IIOPRegistrar.createInstance(oRB);
                        oRB.register_initial_reference("ClusterListenerService", (Object)new IIOPDistributedListener((DescriptionKey)object));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, ProcessRuntimeImpl.class.getName() + "start", "365", this);
                    if (!tc.isEventEnabled()) break block49;
                    Tr.event(tc, "unexpected exception", exception);
                }
            }
        }
        new WLMAppServer().initialize(null);
        if (this.containingClusterKey != null) {
            block51: {
                block50: {
                    try {
                        object2 = (ClusterDescription)this.descMgr.getDescription(this.containingClusterKey, ClusterDescription.class.getName());
                        object2.setSelectionDescription(ClusterDescriptionImpl.WEIGHTED_NOT_INITIALIZED);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, ProcessRuntimeImpl.class.getName() + ".start", "400", this);
                        if (!tc.isEventEnabled()) break block50;
                        Tr.event(tc, "unexpected", exception);
                    }
                }
                object = null;
                try {
                    object = (ClusterMemberService)WsServiceRegistry.getService((java.lang.Object)this, (Class)ClusterMemberService.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".start", "565");
                    if (!tc.isEventEnabled()) break block51;
                    Tr.event(tc, "start getService Failed");
                }
            }
            String string = this.getMemberUID();
            if (string != null) {
                byte[] byArray;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("uid", string);
                Identity identity = ClusterServiceFactory.getClusterService().getIdentity(hashMap);
                if (platformHelper.isZOS()) {
                    byArray = string.getBytes();
                } else {
                    byArray = new byte[8];
                    TypeConversion.longToBytes(Long.parseLong(string), byArray, 0);
                }
                object.defineMemberScopedData(identity, byArray);
                object.defineAttribute(EncodeCloneID.encodeString((String)string));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UID null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start", ProcessProperties.getInstance().get("key.local.member"));
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        ProcessProperties.getInstance().put("key.ignore.bb.updates", new Boolean(true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public DescriptionKey getContainingCluster() {
        return this.containingClusterKey;
    }

    public String toString() {
        return ProcessRuntimeImpl.class.getName() + ":" + this.containingClusterKey;
    }

    public String getClusterName() {
        return this.ivContainingClusterName;
    }

    public ServerAffinityManager getServerAffinityManager() {
        return null;
    }

    public String getMemberName() {
        return this.ivProcessName;
    }

    public String getMemberUID() {
        return this.ivUID;
    }

    private void loadClusterData(String string) {
        block9: {
            Repository repository2;
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "loadClusterData");
                }
                repository2 = null;
                try {
                    repository2 = (Repository)WsServiceRegistry.getService((java.lang.Object)this, (Class)Repository.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".loadClusterData", "666");
                    if (!tc.isEventEnabled()) break block8;
                    Tr.event(tc, "loadClusterData getService Failed");
                }
            }
            Resource resource = null;
            ProcessProperties processProperties = ProcessProperties.getInstance();
            try {
                resource = repository2.getConfigRoot().getResource(2, "cluster.xml");
                ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
                this.ivContainingClusterName = serverCluster.getName();
                boolean bl = serverCluster.isPreferLocal();
                if (this.containingClusterKey != null) {
                    processProperties.put(this.containingClusterKey, new Boolean(bl));
                }
                this.ivMembers = serverCluster.getMembers();
                Iterator iterator = this.ivMembers.iterator();
                while (iterator.hasNext()) {
                    ClusterMember clusterMember = (ClusterMember)iterator.next();
                    if (!(clusterMember.getMemberName().equals(this.ivProcessName) & clusterMember.getNodeName().equals(this.ivNodeName))) continue;
                    this.ivUID = clusterMember.getUniqueId();
                    this.ivConfigWeight = clusterMember.getWeight();
                    processProperties.put("key.configured.weight", new Integer(this.ivConfigWeight));
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    treeMap.put("CELLNAME", string);
                    treeMap.put("NODENAME", this.ivNodeName);
                    treeMap.put("MEMBERNAME", this.ivProcessName);
                    DescriptionKey descriptionKey = this.keyRepository.getDescriptionKey(treeMap);
                    processProperties.put("key.local.member", descriptionKey);
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "got data for cluster " + this.ivContainingClusterName);
                        Tr.exit(tc, "loadClusterData:", new java.lang.Object[]{this.ivUID, new Integer(this.ivConfigWeight), new Boolean(bl)});
                    }
                    return;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ProcessRuntimeImpl.class.getName() + ".loadClusterData", "480");
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
    }

    private void loadCustomProperties(List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCustomProperties");
        }
        int n = list.size();
        ProcessProperties processProperties = ProcessProperties.getInstance();
        for (int i = 0; i < n; ++i) {
            Property property = (Property)list.get(i);
            String string = property.getName();
            if (!string.startsWith("IBM_CLUSTER")) continue;
            String string2 = property.getValue();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Loaded custom property", new java.lang.Object[]{string, string2});
            }
            processProperties.put(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCustomProperties");
        }
    }

    private void buildClusterMemberAddresses(List list, EndPointMgr endPointMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildClusterMemberAddresses");
        }
        MemberAddress[] memberAddressArray = null;
        ArrayList<MemberAddress> arrayList = new ArrayList<MemberAddress>(list.size());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initial creation size of memberlist", new Integer(list.size()));
        }
        Map map = endPointMgr.getNodeEndPoints();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            EndPointMgr.NodeEndPoints nodeEndPoints = (EndPointMgr.NodeEndPoints)entry.getValue();
            Map map2 = nodeEndPoints.getServerEndPoints();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string;
                String string2 = ((ClusterMember)iterator2.next()).getMemberName();
                EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(string2);
                if (serverEndPoints == null || (string = serverEndPoints.getType()) == null || !string.equals("APPLICATION_SERVER")) continue;
                EndPoint endPoint = serverEndPoints.getEndPoint("ORB_LISTENER_ADDRESS");
                EndPoint endPoint2 = serverEndPoints.getEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
                EndPoint endPoint3 = serverEndPoints.getEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
                if (endPoint == null || endPoint.getPort() == 0) continue;
                arrayList.add(new MemberAddress(endPoint.getHost(), endPoint.getPort(), endPoint2 == null ? 0 : endPoint2.getPort(), endPoint3 == null ? 0 : endPoint3.getPort()));
            }
        }
        memberAddressArray = new MemberAddress[arrayList.size()];
        arrayList.toArray(memberAddressArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dump Member Address List: ");
            for (int i = 0; i < memberAddressArray.length; ++i) {
                Tr.debug(tc, memberAddressArray[i].toString());
            }
        }
        WLMProperties.setMemberAddresses(memberAddressArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildClusterMemberAddresses");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.30.4.1 ");
        }
        HANDBACK_SERVER = new Integer(0);
        HANDBACK_NODEAGENT = new Integer(1);
        HANDBACK_DMGR = new Integer(2);
    }

    public class EventHandler
    implements NotificationListener,
    DescriptionModificationListener {
        AdminService adminService = null;
        ClusterDescription cd = null;
        DescriptionKey iiopMemberKey = null;
        PlatformHelper ph;

        public EventHandler(Integer n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ProcessRuntime.EventHandler <init>");
            }
            this.ph = AdminHelper.getPlatformHelper();
            this.adminService = AdminServiceFactory.getAdminService();
            this.registerNotificationListener(n);
        }

        public void handleNotification(DescriptionKey descriptionKey, String string, java.lang.Object object, java.lang.Object object2) {
            ClusterDescription clusterDescription;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "handleNotification", new java.lang.Object[]{descriptionKey, string, object});
            }
            if (string.equals("type.memento.updated") && this.iiopMemberKey != null && descriptionKey.equals(this.iiopMemberKey) && (clusterDescription = (ClusterDescription)ProcessRuntimeImpl.this.descMgr.getDescription(ProcessRuntimeImpl.this.containingClusterKey)) != null) {
                clusterDescription.setStructuralEpoch(System.currentTimeMillis());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found containing IIOP Cluster " + clusterDescription.getKey() + " setting structural epoch");
                }
            }
        }

        public void handleNotification(Notification notification, java.lang.Object object) {
            block29: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "handleNotification", new java.lang.Object[]{"handBack = " + object, "type = " + notification.getType(), "source = " + notification.getSource(), "userData = " + notification.getUserData()});
                }
                try {
                    java.lang.Object object2;
                    java.lang.Object object3;
                    java.lang.Object object4;
                    java.lang.Object object5;
                    EndPointMgr endPointMgr;
                    block27: {
                        block26: {
                            ProcessProperties processProperties = ProcessProperties.getInstance();
                            if (object.equals(HANDBACK_DMGR)) {
                                block25: {
                                    endPointMgr = null;
                                    try {
                                        endPointMgr = (EndPointMgr)WsServiceRegistry.getService((java.lang.Object)this, (Class)(class$com$ibm$ws$runtime$service$EndPointMgr == null ? (class$com$ibm$ws$runtime$service$EndPointMgr = ProcessRuntimeImpl.class$("com.ibm.ws.runtime.service.EndPointMgr")) : class$com$ibm$ws$runtime$service$EndPointMgr));
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException(exception, (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl == null ? (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.runtime.ProcessRuntimeImpl")) : class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl).getName() + ".handleNotification", "848");
                                        if (!tc.isEventEnabled()) break block25;
                                        Tr.event(tc, "handleNotification getService Failed");
                                    }
                                }
                                processProperties.put("key.endpointmgr", endPointMgr);
                            }
                            endPointMgr = null;
                            try {
                                object5 = null;
                                object5 = (ORB)WsServiceRegistry.getService((java.lang.Object)this, (Class)(class$com$ibm$ws$runtime$service$ORB == null ? (class$com$ibm$ws$runtime$service$ORB = ProcessRuntimeImpl.class$("com.ibm.ws.runtime.service.ORB")) : class$com$ibm$ws$runtime$service$ORB));
                                if (object5 != null && (endPointMgr = object5.getORB()) != null) {
                                    processProperties.put("key.orb", endPointMgr);
                                }
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException(exception, (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl == null ? (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.runtime.ProcessRuntimeImpl")) : class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl).getName() + ".handleNotification", "859");
                                if (!tc.isEventEnabled()) break block26;
                                Tr.event(tc, "handleNotification getService Failed");
                            }
                        }
                        object5 = null;
                        try {
                            object5 = (ClusterMemberService)WsServiceRegistry.getService((java.lang.Object)this, (Class)(class$com$ibm$wsspi$cluster$ClusterMemberService == null ? (class$com$ibm$wsspi$cluster$ClusterMemberService = ProcessRuntimeImpl.class$("com.ibm.wsspi.cluster.ClusterMemberService")) : class$com$ibm$wsspi$cluster$ClusterMemberService));
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException(exception, (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl == null ? (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.runtime.ProcessRuntimeImpl")) : class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl).getName() + ".handleNotification", "876");
                            if (!tc.isEventEnabled()) break block27;
                            Tr.event(tc, "handleNotification getService Failed");
                        }
                    }
                    if (object.equals(HANDBACK_NODEAGENT) && !this.ph.isZOS()) {
                        block28: {
                            object4 = null;
                            try {
                                object4 = (EndPointMgr)WsServiceRegistry.getService((java.lang.Object)this, (Class)(class$com$ibm$ws$runtime$service$EndPointMgr == null ? (class$com$ibm$ws$runtime$service$EndPointMgr = ProcessRuntimeImpl.class$("com.ibm.ws.runtime.service.EndPointMgr")) : class$com$ibm$ws$runtime$service$EndPointMgr));
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException(exception, (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl == null ? (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.runtime.ProcessRuntimeImpl")) : class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl).getName() + ".handleNotification", "886");
                                if (!tc.isEventEnabled()) break block28;
                                Tr.event(tc, "handleNotification getService Failed");
                            }
                        }
                        if (endPointMgr != null) {
                            object3 = new BuildLSDCluster((EndPointMgr)object4);
                            ((BuildLSDCluster)object3).joinLSDCluster();
                            if (!AdminHelper.getPlatformHelper().isZOS()) {
                                try {
                                    object2 = (WLMServerRequestInterceptor)endPointMgr.resolve_initial_references("WLMServerRequestInterceptor");
                                    ((WLMServerRequestInterceptor)((java.lang.Object)object2)).registerServiceContextListener((com.ibm.CORBA.iiop.ORB)endPointMgr, new ServerClusterContextListenerImpl((com.ibm.CORBA.iiop.ORB)endPointMgr, object5.getServerClusterContextListener()));
                                }
                                catch (InvalidName invalidName) {
                                    FFDCFilter.processException((Throwable)invalidName, (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl == null ? (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.runtime.ProcessRuntimeImpl")) : class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl).getName() + ".initialize", "548", this);
                                }
                            }
                        }
                    }
                    if (!object.equals(HANDBACK_SERVER)) break block29;
                    object4 = ClusterServiceFactory.getClusterService();
                    object3 = new HashMap<String, String>();
                    object3.put("type", "MBean");
                    object3.put("component", "JMX");
                    object2 = new HashMap<String, String>((Map<String, String>)object3);
                    String[] stringArray = new String[2];
                    object2.put("nodeName", this.adminService.getNodeName());
                    object2.put("processName", this.adminService.getProcessName());
                    stringArray[0] = this.adminService.getNodeName();
                    stringArray[1] = this.adminService.getProcessName();
                    byte[] byArray = TypeConversion.stringsToBytes(stringArray);
                    Identity identity = object4.getIdentity((Map)object2);
                    object5.defineMemberScopedData(identity, byArray);
                    if (ProcessRuntimeImpl.this.containingClusterKey == null) break block29;
                    if (endPointMgr != null) {
                        DescriptionKey descriptionKey = (DescriptionKey)ProcessProperties.getInstance().get("key.local.member");
                        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)ProcessRuntimeImpl.this.descMgr.getDescription(descriptionKey);
                        IIOPClusterMemberDescriptionImpl iIOPClusterMemberDescriptionImpl = null;
                        if (!AdminHelper.getPlatformHelper().isZOS()) {
                            TreeMap<String, String> treeMap = new TreeMap<String, String>();
                            treeMap.put(IIOPClusterMemberDescription.distinction[0], IIOPClusterMemberDescription.distinction[1]);
                            this.iiopMemberKey = ProcessRuntimeImpl.this.keyRepository.getDescriptionKey(clusterMemberDescription.getKey(), treeMap);
                            iIOPClusterMemberDescriptionImpl = (IIOPClusterMemberDescriptionImpl)ProcessRuntimeImpl.this.descMgr.getDescription(this.iiopMemberKey, (class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription == null ? (class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.topography.IIOPClusterMemberDescription")) : class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription).getName());
                            iIOPClusterMemberDescriptionImpl.setORB((com.ibm.CORBA.iiop.ORB)endPointMgr);
                            String string = (String)ProcessProperties.getInstance().get("key.localtemplate.ior");
                            iIOPClusterMemberDescriptionImpl.setIOR(com.ibm.CORBA.iiop.ORB.createIOR((com.ibm.CORBA.iiop.ORB)endPointMgr, (String)string));
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "retrived local template IOR", string);
                            }
                            iIOPClusterMemberDescriptionImpl.setClusterMemberAssociation(clusterMemberDescription.getKey());
                            clusterMemberDescription.setExtrinsicData(iIOPClusterMemberDescriptionImpl);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "handleNotification", new java.lang.Object[]{this.iiopMemberKey, ((IIOPClusterMemberDescription.Memento)iIOPClusterMemberDescriptionImpl.getMemento()).getIOR()});
                            }
                            try {
                                WLMServerRequestInterceptor wLMServerRequestInterceptor = (WLMServerRequestInterceptor)endPointMgr.resolve_initial_references("WLMServerRequestInterceptor");
                                wLMServerRequestInterceptor.registerServiceContextListener((com.ibm.CORBA.iiop.ORB)endPointMgr, new ServerClusterContextListenerImpl((com.ibm.CORBA.iiop.ORB)endPointMgr, object5.getServerClusterContextListener()));
                            }
                            catch (InvalidName invalidName) {
                                FFDCFilter.processException((Throwable)invalidName, (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl == null ? (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.runtime.ProcessRuntimeImpl")) : class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl).getName() + ".initialize", "632", this);
                            }
                        }
                    }
                    object5.joinCluster(ProcessRuntimeImpl.this.containingClusterKey);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl == null ? (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.runtime.ProcessRuntimeImpl")) : class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl).getName() + ".handleNotification", "642", this, new java.lang.Object[]{ProcessRuntimeImpl.this.descMgr, ProcessProperties.getInstance().get("key.local.member")});
                    if (!tc.isDebugEnabled()) break block29;
                    Tr.debug(tc, "unexpected", exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }

        private void registerNotificationListener(Integer n) {
            block2: {
                try {
                    String string = this.adminService.getDomainName() + ":*,type=" + "Server";
                    ObjectName objectName = new ObjectName(string);
                    NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                    notificationFilterSupport.enableType("j2ee.state.running");
                    this.adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, n);
                    DescriptionFactory.getInstance().registerNotificationListener(this, (class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription == null ? (class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.topography.IIOPClusterMemberDescription")) : class$com$ibm$ws$cluster$topography$IIOPClusterMemberDescription).getName(), "type.memento.updated");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl == null ? (class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl = ProcessRuntimeImpl.class$("com.ibm.ws.cluster.runtime.ProcessRuntimeImpl")) : class$com$ibm$ws$cluster$runtime$ProcessRuntimeImpl).getName() + ".registerNotificationListener", "663", this);
                    if (!tc.isEventEnabled()) break block2;
                    Tr.event(tc, "unexpected", exception);
                }
            }
        }
    }
}

