/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.runtime.ProcessRuntimeImpl;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.monitor.AdvisorFactory;
import com.ibm.wsspi.cluster.monitor.AdvisorMediator;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;

public class WLMDiagnosticModule
extends DiagnosticModule {
    private static final TraceComponent tc = Tr.register(WLMDiagnosticModule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String[] _packageList;
    private static final int DEFAULT_DEPTH = 3;
    private static WLMDiagnosticModule _instance;
    private ProcessRuntimeImpl _service;

    private WLMDiagnosticModule() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "WLMDiagnositicModule constructed.");
        }
    }

    static synchronized WLMDiagnosticModule instance() {
        if (_instance == null) {
            _instance = new WLMDiagnosticModule();
        }
        return _instance;
    }

    synchronized void initialize(ProcessRuntimeImpl processRuntimeImpl) {
        this._service = processRuntimeImpl;
    }

    boolean registerWithFFDCService() {
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        block6: for (int i = 0; !bl2 && i < _packageList.length; ++i) {
            n = FFDC.registerDiagnosticModule(this, _packageList[i]);
            switch (n) {
                case 0: {
                    Tr.event(tc, "WLMDiagnosticModule successfully registered for package " + _packageList[i]);
                    continue block6;
                }
                case 1: {
                    Tr.event(tc, "Unable to register WLMDiagnosticModule as another diagnostic module has already been registered with the package name " + _packageList[i] + ".");
                    bl = false;
                    continue block6;
                }
                case 2: {
                    Tr.event(tc, "Unable to register WLMDiagnosticModule as it does not support the minimum diagnostic module interface.");
                    bl = false;
                    bl2 = true;
                    continue block6;
                }
                case 3: {
                    Tr.event(tc, "Unable to register WLMDiagnosticModule due to an unknown failure.");
                    bl = false;
                    bl2 = true;
                    continue block6;
                }
                default: {
                    Tr.event(tc, "WLMDiagnosticModule registration resulted in an unexpected return code.");
                    bl = false;
                    bl2 = true;
                }
            }
        }
        return bl;
    }

    public void ffdcDumpDefault(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        try {
            if (objectArray == null) {
                incidentStream.writeLine(">WLM DM: null object array.", objectArray);
            } else {
                incidentStream.introspectAndWrite(">WLM DM dump of object array", objectArray, 3);
            }
            if (object != this._service) {
                incidentStream.introspectAndWriteLine(">WLM DM dump of WLM service", this._service, 3);
            } else {
                incidentStream.writeLine(">WLM DM dump of WLM service", this._service);
            }
        }
        catch (Exception exception) {
            incidentStream.writeLine(">WLM DM: An unexpected error occured during FFDC data capture", exception);
        }
    }

    public void ffdcDumpDefaultAdvisorMediator(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        try {
            AdvisorMediator advisorMediator = null;
            advisorMediator = object instanceof AdvisorMediator ? (AdvisorMediator)object : AdvisorFactory.getAdvisorMediator();
            if (advisorMediator != null) {
                incidentStream.introspectAndWrite(">WLM DM dump of AdvisorMediator", advisorMediator, 3);
            } else {
                incidentStream.writeLine(">WLM DM dump of AdvisorMediator", "*NULL");
            }
        }
        catch (Exception exception) {
            incidentStream.writeLine(">WLM DM: An unexpected error occured during FFDC data capture", exception);
        }
    }

    public void ffdcDumpDefaultClusterManagement(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        try {
            ClusterManagement clusterManagement = null;
            clusterManagement = object instanceof ClusterManagement ? (ClusterManagement)object : ClusterManagementFactory.getClusterManagement();
            if (clusterManagement != null) {
                incidentStream.introspectAndWrite(">WLM DM dump of ClusterManagement", clusterManagement, 3);
            } else {
                incidentStream.writeLine(">WLM DM dump of ClusterManagement", "*NULL");
            }
        }
        catch (Exception exception) {
            incidentStream.writeLine(">WLM DM: An unexpected error occured during FFDC data capture", exception);
        }
    }

    public void ffdcDumpDefaultClusterService(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        try {
            ClusterService clusterService = null;
            clusterService = object instanceof ClusterService ? (ClusterService)object : ClusterServiceFactory.getClusterService();
            if (clusterService != null) {
                incidentStream.introspectAndWrite(">WLM DM dump of ClusterService", clusterService, 3);
            } else {
                incidentStream.writeLine(">WLM DM dump of ClusterService", "*NULL");
            }
        }
        catch (Exception exception) {
            incidentStream.writeLine(">WLM DM: An unexpected error occured during FFDC data capture", exception);
        }
    }

    public void ffdcDumpDefaultSelectionService(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        try {
            SelectionService selectionService = null;
            selectionService = object instanceof SelectionService ? (SelectionService)object : SelectionServiceFactory.getSelectionService();
            if (selectionService != null) {
                incidentStream.introspectAndWrite(">WLM DM dump of SelectionService", selectionService, 3);
            } else {
                incidentStream.writeLine(">WLM DM dump of SelectionService", "*NULL");
            }
        }
        catch (Exception exception) {
            incidentStream.writeLine(">WLM DM: An unexpected error occured during FFDC data capture", exception);
        }
    }

    public void ffdcDumpDefaultProcessProperties(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        try {
            ProcessProperties processProperties = null;
            processProperties = object instanceof ProcessProperties ? (ProcessProperties)object : ProcessProperties.getInstance();
            if (processProperties != null) {
                incidentStream.introspectAndWrite(">WLM DM dump of ProcessProperties", processProperties);
            } else {
                incidentStream.writeLine(">WLM DM dump of ProcessProperties", "*NULL");
            }
        }
        catch (Exception exception) {
            incidentStream.writeLine(">WLM DM: An unexpected error occured during FFDC data capture", exception);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.3 ");
        }
        _packageList = new String[]{"com.ibm.ws.cluster", "com.ibm.ws.management.wlm", "com.ibm.ws.wlm", "com.ibm.websphere.cluster", "com.ibm.websphere.management.wlm", "com.ibm.websphere.wlm", "com.ibm.wsspi.cluster"};
    }
}

