/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.models.config.appcfg.ApplicationConfig;
import com.ibm.websphere.models.config.appcfg.WebModuleConfig;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.Cookie;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoMemberAvailableException;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class WLMNonDefaultCookieUtility {
    private static final TraceComponent tc = Tr.register(WLMNonDefaultCookieUtility.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String SERVER_DOCUMENT = "server.xml";
    private static final String DEPLOYMENT_DOCUMENT = "deployment.xml";
    private static ClusterMemberService clusterMemberService;
    private boolean serverCookieHasBeenSet;
    private static final String NON_DEFAULT_APPLICATION_COOKIE = "NON_DEFAULT_APPLICATION_COOKIE";
    private DescriptionManager descMgr;
    private static final ClusterService clusterService;
    private Repository repository;

    public WLMNonDefaultCookieUtility() {
        block7: {
            block6: {
                this.serverCookieHasBeenSet = false;
                this.descMgr = DescriptionManagerFactory.getDescriptionManager();
                this.repository = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "<init>");
                }
                try {
                    clusterMemberService = (ClusterMemberService)WsServiceRegistry.getService((Object)this, (Class)ClusterMemberService.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, WLMNonDefaultCookieUtility.class.getName() + ".<init>", "72");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                    Tr.event(tc, "<init> getService ClusterMemberService Failed");
                }
            }
            try {
                this.repository = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, WLMNonDefaultCookieUtility.class.getName() + ".<init>", "85");
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "<init> getService Repository Failed");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void parseAndSetCookie(Identity identity, String string) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "parseAndSetCookie", new Object[]{identity, string});
            }
            try {
                Object object;
                String string2 = IdentityMapping.getNodeNameFromClusterMemberIdentity(identity);
                String string3 = IdentityMapping.getServerNameFromClusterMemberIdentity(identity);
                String string4 = IdentityMapping.getCellNameFromIdentity(identity);
                if (!this.serverCookieHasBeenSet) {
                    object = this.parseServerLevelCookieFromXML(string2, string3);
                    this.setCookie(identity, (String)object);
                    if (object != null) {
                        this.serverCookieHasBeenSet = true;
                    }
                }
                object = this.parseAppModuleCookieFromXML(string, string4, string2);
                String string5 = (String)((HashMap)object).get(NON_DEFAULT_APPLICATION_COOKIE);
                this.setCookie(identity, string, string5);
                Iterator iterator = ((HashMap)object).keySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    if (string6 == NON_DEFAULT_APPLICATION_COOKIE) continue;
                    String string7 = (String)((HashMap)object).get(string6);
                    this.setCookie(identity, string, string6, string7);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, WLMNonDefaultCookieUtility.class.getName() + ".parseAndSetCookie", "135");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event(tc, "parseAndSetCookie - Unexpected exception", exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseAndSetCookie");
        }
    }

    public String parseServerLevelCookieFromXML(String string, String string2) {
        String string3;
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "parseServerLevelCookieFromXML", new Object[]{string, string2});
            }
            string3 = null;
            try {
                ConfigRoot configRoot = this.repository.getConfigRoot();
                Resource resource = configRoot.getResource(4, SERVER_DOCUMENT);
                Server server2 = (Server)resource.getContents().get(0);
                EList eList = server2.getComponents();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    Component component2 = (Component)iterator.next();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "parseServerLevelCookieFromXML component", component2.toString());
                    }
                    if (!(component2 instanceof ApplicationServer)) continue;
                    ApplicationServer applicationServer = (ApplicationServer)component2;
                    EList eList2 = applicationServer.getComponents();
                    Iterator iterator2 = eList2.iterator();
                    while (iterator2.hasNext()) {
                        Component component3 = (Component)iterator2.next();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "parseServerLevelCookieFromXML service", component3.toString());
                        }
                        if (!(component3 instanceof WebContainer)) continue;
                        WebContainer webContainer = (WebContainer)component3;
                        EList eList3 = webContainer.getServices();
                        Iterator iterator3 = eList3.iterator();
                        while (iterator3.hasNext()) {
                            Service service = (Service)iterator3.next();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseServerLevelCookieFromXML wcservice", service.toString());
                            }
                            if (!(service instanceof SessionManager)) continue;
                            SessionManager sessionManager = (SessionManager)service;
                            Cookie cookie = sessionManager.getDefaultCookieSettings();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseServerLevelCookieFromXML defaultCookieSettings", cookie.toString());
                            }
                            string3 = cookie.getName();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseServerLevelCookieFromXML cookie", string3);
                            }
                            if (string3 == null || !string3.equalsIgnoreCase("JSESSIONID")) continue;
                            string3 = null;
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, WLMNonDefaultCookieUtility.class.getName() + ".parseServerLevelCookieFromXML", "210", this, new Object[]{string2, string});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block12;
                Tr.event(tc, "Unexpected exception reading config for ", new Object[]{string2, string, exception});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseServerLevelCookieFromXML", string3);
        }
        return string3;
    }

    public HashMap parseAppModuleCookieFromXML(String string, String string2, String string3) {
        HashMap<Object, Object> hashMap;
        block32: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "parseAppModuleCookieFromXML", new Object[]{string, string2, string3});
            }
            hashMap = new HashMap<Object, Object>();
            try {
                String[] stringArray;
                ConfigRoot configRoot = this.repository.getConfigRoot();
                String[] stringArray2 = configRoot.list(1, null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "parseAppModuleCookieFromXML applicationDirectories", stringArray2);
                }
                Resource resource = null;
                if (stringArray2 != null) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray = configRoot.list(1, stringArray2[i] + File.separator + "deployments");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "parseAppModuleCookieFromXML applicationNames", stringArray);
                        }
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (!stringArray[j].equals(string)) continue;
                            resource = configRoot.getResource(1, stringArray2[i] + File.separator + "deployments" + File.separator + string + File.separator + DEPLOYMENT_DOCUMENT);
                        }
                    }
                }
                if (resource != null) {
                    Deployment deployment = (Deployment)resource.getContents().get(0);
                    stringArray = deployment.getDeployedObject();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "parseAppModuleCookieFromXML deployedObj", stringArray.toString());
                    }
                    if (stringArray instanceof ApplicationDeployment) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        ApplicationDeployment applicationDeployment = (ApplicationDeployment)stringArray;
                        EList eList = applicationDeployment.getConfigs();
                        EList eList2 = eList.iterator();
                        while (eList2.hasNext()) {
                            object4 = (ApplicationConfig)eList2.next();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseAppModuleCookieFromXML applicationConfig", object4.toString());
                            }
                            object3 = object4.getSessionManagement();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseAppModuleCookieFromXML appSessionManager", object3.toString());
                            }
                            object2 = null;
                            if (object3.isEnable()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "parseAppModuleCookieFromXML Application Override is set");
                                }
                                object = object3.getDefaultCookieSettings();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "parseAppModuleCookieFromXML defaultCookieSettings", object.toString());
                                }
                                object2 = object.getName();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "parseAppModuleCookieFromXML applicationCookie", object2);
                                }
                                if (object2 != null && ((String)object2).equalsIgnoreCase("JSESSIONID")) {
                                    object2 = null;
                                }
                            }
                            hashMap.put(NON_DEFAULT_APPLICATION_COOKIE, object2);
                        }
                        eList2 = applicationDeployment.getModules();
                        object4 = eList2.iterator();
                        while (object4.hasNext()) {
                            object3 = object4.next();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseAppModuleCookieFromXML webModuleDeployment", object3.toString());
                            }
                            if (!(object3 instanceof WebModuleDeployment)) continue;
                            object2 = (WebModuleDeployment)object3;
                            object = object2.getUri();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "parseAppModuleCookieFromXML moduleName", ((String)object).toString());
                            }
                            EList eList3 = object2.getConfigs();
                            Iterator iterator = eList3.iterator();
                            while (iterator.hasNext()) {
                                Object e2 = iterator.next();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "parseAppModuleCookieFromXML appConfig", e2.toString());
                                }
                                if (!(e2 instanceof WebModuleConfig)) continue;
                                WebModuleConfig webModuleConfig = (WebModuleConfig)e2;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "parseAppModuleCookieFromXML WebModuleConfig", webModuleConfig.toString());
                                }
                                SessionManager sessionManager = webModuleConfig.getSessionManagement();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "parseAppModuleCookieFromXML SessionManager", sessionManager.toString());
                                }
                                String string4 = null;
                                if (sessionManager.isEnable()) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "parseAppModuleCookieFromXML Module Override is set");
                                    }
                                    Cookie cookie = sessionManager.getDefaultCookieSettings();
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "parseAppModuleCookieFromXML defaultCookieSettings", cookie.toString());
                                    }
                                    string4 = cookie.getName();
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "parseAppModuleCookieFromXML moduleCookie", string4);
                                    }
                                    if (string4 != null && string4.equalsIgnoreCase("JSESSIONID")) {
                                        string4 = null;
                                    }
                                }
                                hashMap.put(object, string4);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, WLMNonDefaultCookieUtility.class.getName() + ".parseAppModuleCookieFromXML", "346", this, new Object[]{string2, string3, string});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block32;
                Tr.event(tc, "Unexpected exception reading config for ", new Object[]{string2, string3, string, exception});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseAppModuleCookieFromXML", hashMap);
        }
        return hashMap;
    }

    public void setCookie(Identity identity, String string) {
        this.setCookie(identity, null, null, string);
    }

    public void setCookie(Identity identity, String string, String string2) {
        this.setCookie(identity, string, null, string2);
    }

    public void setCookie(Identity identity, String string, String string2, String string3) {
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "setCookie", new Object[]{identity, string, string2, string3});
            }
            String string4 = IdentityMapping.getCellNameFromIdentity(identity);
            String string5 = IdentityMapping.getServerNameFromClusterMemberIdentity(identity);
            String string6 = IdentityMapping.getNodeNameFromClusterMemberIdentity(identity);
            byte[] byArray = null;
            if (string3 != null) {
                byArray = string3.getBytes();
            }
            Identity identity2 = IdentityMapping.getNonDefaultCookieIdentity(string4, string6, string5, string, string2);
            if (string3 != null) {
                clusterMemberService.defineMemberScopedData(identity2, byArray);
            } else {
                try {
                    byte[] byArray2 = clusterService.getMemberScopedData(identity, identity2);
                    if (byArray2 == null) break block11;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "setCookie - Clearing cookie");
                    }
                    EndPointImpl endPointImpl = null;
                    try {
                        endPointImpl = (EndPointImpl)this.descMgr.getDescription((DescriptionKey)identity2, EndPoint.class.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (endPointImpl != null) {
                        clusterMemberService.undefineLocalScopedData(endPointImpl);
                    }
                }
                catch (NoMemberAvailableException noMemberAvailableException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setCookie");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.1");
        }
        clusterMemberService = null;
        clusterService = ClusterServiceFactory.getClusterService();
    }
}

