/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.selection.AdvisorMediatorA;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.monitor.MembershipAdvisor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class RouterMediator
extends AdvisorMediatorA {
    private static final TraceComponent tc = Tr.register(RouterMediator.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr;
    private static Map outstandingCount;
    private static Map errorCount;
    private static Map feedbackMap;

    public RouterMediator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CTOR");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CTOR", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservedWeight(Identity identity, Identity identity2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setObservedWeight", new Object[]{identity, identity2, String.valueOf(n)});
        }
        WeightBasedFeedback[] weightBasedFeedbackArray = outstandingCount;
        synchronized (outstandingCount) {
            Integer n2 = (Integer)outstandingCount.get(identity2);
            n2 = n2 == null ? new Integer(n) : new Integer(n + n2);
            outstandingCount.put(identity2, n2);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ObservedWeight: " + n2);
            }
            weightBasedFeedbackArray = null;
            if (n2 > 1) {
                weightBasedFeedbackArray = (WeightBasedFeedback[])feedbackMap.get(identity);
                for (int i = 0; i < weightBasedFeedbackArray.length; ++i) {
                    weightBasedFeedbackArray[i].applyWorkloadUpdate(identity2, n2);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setObservedWeight", weightBasedFeedbackArray);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObservedWeight(Identity identity, Identity identity2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObservedWeight", new Object[]{identity, identity2});
        }
        int n = 0;
        Map map = outstandingCount;
        synchronized (map) {
            Integer n2 = (Integer)outstandingCount.get(identity2);
            if (n2 != null) {
                n = n2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObservedWeight - weight=" + n);
        }
        return n;
    }

    public void setErrorWeight(Identity identity, Identity identity2, int n) {
        Integer n2;
        HashMap<Identity, Integer> hashMap = (HashMap<Identity, Integer>)errorCount.get(identity);
        if (hashMap == null) {
            hashMap = new HashMap<Identity, Integer>();
        }
        n2 = (n2 = (Integer)hashMap.get(identity2)) == null ? new Integer(n) : new Integer(n2 + n);
        hashMap.put(identity2, n2);
        WeightBasedFeedback[] weightBasedFeedbackArray = (WeightBasedFeedback[])feedbackMap.get(identity);
        for (int i = 0; i < weightBasedFeedbackArray.length; ++i) {
            weightBasedFeedbackArray[i].applyExceptionUpdate(identity2, n2);
        }
    }

    public int getErrorWeight(Identity identity, Identity identity2) {
        Integer n;
        Map map = (Map)errorCount.get(identity);
        if (map != null && (n = (Integer)map.get(identity2)) != null) {
            return n;
        }
        return 0;
    }

    public void tareErrorWeights(Identity identity) {
        errorCount.remove(identity);
    }

    public void setAvailable(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAvailable", identity);
        }
        if (identity == null) {
            throw new IllegalArgumentException("The member identity must not be null.");
        }
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)identity);
        if (clusterMemberDescription == null) {
            throw new IllegalArgumentException("The member defined by " + identity + " is not yet active in this process.");
        }
        clusterMemberDescription.setReachability((byte)0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAvailable");
        }
    }

    public void setUnavailable(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUnavailable", identity);
        }
        if (identity == null) {
            throw new IllegalArgumentException("The member identity must not be null.");
        }
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)identity);
        if (clusterMemberDescription == null) {
            throw new IllegalArgumentException("The member defined by " + identity + " is not yet active in this process.");
        }
        clusterMemberDescription.setReachability((byte)4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUnavailable");
        }
    }

    public boolean isAvailable(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAvailable", identity);
        }
        if (identity == null) {
            throw new IllegalArgumentException("The member identity must not be null.");
        }
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)identity);
        if (clusterMemberDescription == null) {
            throw new IllegalArgumentException("The member defined by " + identity + " is not yet active in this process.");
        }
        byte by = ((ClusterMemberDescription.Memento)clusterMemberDescription.getMemento()).getState();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAvailable", String.valueOf(by));
        }
        return by == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tareObservedWeights(Identity identity) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "tareObservedWeights", identity);
        }
        ClusterService clusterService = ClusterServiceFactory.getClusterService();
        Identity[] identityArray = clusterService.getMemberIdentities(identity);
        Map map = outstandingCount;
        synchronized (map) {
            for (int i = 0; i < identityArray.length; ++i) {
                outstandingCount.remove(identityArray[i]);
            }
        }
    }

    public void registerMembershipAdvisor(MembershipAdvisor membershipAdvisor) {
    }

    public void deregisterMembershipAdvisor(MembershipAdvisor membershipAdvisor) {
    }

    public void registerFeedback(WeightBasedFeedback weightBasedFeedback, Identity identity) {
        feedbackMap.put(identity, new WeightBasedFeedback[]{weightBasedFeedback});
    }

    static {
        DescriptionManagerFactory.getInstance();
        descMgr = DescriptionManagerFactory.getDescriptionManager();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.13.1.1 : none");
        }
        outstandingCount = new HashMap();
        errorCount = new HashMap();
        feedbackMap = Collections.synchronizedMap(new HashMap());
    }
}

