/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.IdentityListKey;
import com.ibm.ws.cluster.selection.NoAvailableTargetExceptionImpl;
import com.ibm.ws.cluster.selection.SelectionAdvisor;
import com.ibm.ws.cluster.selection.TargetImpl;
import com.ibm.ws.cluster.topography.IdentityListKeyImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SelectionCriteriaImpl
implements SelectionCriteria,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(SelectionCriteriaImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private final Map strategyCache = Collections.synchronizedMap(new HashMap());
    private final Map targetCache = Collections.synchronizedMap(new HashMap());
    private final Integer targetCacheMutex = new Integer(42);
    private final ClusterDescription cluster;
    private final Identity identity;
    private final Map context;
    private final Set registered = new HashSet();
    private boolean affinityMapping;

    public SelectionCriteriaImpl(Identity identity, Map map) {
        try {
            if (identity == null) {
                throw new IllegalArgumentException("passed in identity can't be null");
            }
            this.identity = identity;
            this.cluster = (ClusterDescription)descMgr.getDescription((DescriptionKey)identity, ClusterDescription.class.getName());
            if (map == null) {
                throw new IllegalArgumentException("passed in map can't be null");
            }
            this.context = new HashMap(map);
            this.affinityMapping = this.context.containsKey("affinity.key");
            if (!this.affinityMapping) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "affinityMapping is " + this.affinityMapping);
                }
                this.cluster.registerNotificationListener(this, "member.added", null);
                this.cluster.registerNotificationListener(this, "member.removed", null);
                this.registered.add(identity);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The criteria may have been incorrect.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Map getAttributes() {
        return this.context;
    }

    public void match(List list) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target select() throws NoAvailableTargetException {
        Object object;
        DescriptionKey descriptionKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", this);
        }
        ArrayList<DescriptionKey> arrayList = new ArrayList<DescriptionKey>(3);
        ClusterMemberDescription clusterMemberDescription = this.cluster;
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
        while (!memento.isLeaf()) {
            descriptionKey = clusterMemberDescription.getKey();
            arrayList.add(descriptionKey);
            if (!this.affinityMapping && !this.registered.contains(descriptionKey)) {
                clusterMemberDescription.registerNotificationListener(this, "member.added", null);
                clusterMemberDescription.registerNotificationListener(this, "member.removed", null);
                this.registered.add(descriptionKey);
            }
            if ((object = (SelectionAdvisor)this.strategyCache.get(descriptionKey)) == null) {
                object = new SelectionAdvisor(descriptionKey, this.context);
                if (!this.affinityMapping) {
                    this.strategyCache.put(descriptionKey, object);
                }
            }
            if ((clusterMemberDescription = ((SelectionAdvisor)object).select()) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "select - null member from select.");
                }
                throw new NoAvailableTargetExceptionImpl(this, ((SelectionAdvisor)object).getReason());
            }
            memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
        }
        descriptionKey = clusterMemberDescription.getKey();
        object = new IdentityListKeyImpl();
        object.addAll(arrayList);
        object.add(descriptionKey);
        TargetImpl targetImpl = null;
        Serializable serializable = this.targetCacheMutex;
        synchronized (serializable) {
            targetImpl = (TargetImpl)this.targetCache.get(object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "targetCacheKey is: " + object);
        }
        if (targetImpl == null) {
            serializable = new ArrayList(memento.getExtrinsicData().values());
            if (tc.isDebugEnabled()) {
                if (serializable != null) {
                    Tr.debug(tc, "Number of Endpoints in Memento: " + String.valueOf(serializable.size()));
                }
                Tr.debug(tc, "Endpoint List", serializable);
            }
            EndPoint[] endPointArray = serializable.iterator();
            while (endPointArray.hasNext()) {
                if (endPointArray.next() instanceof EndPoint) continue;
                endPointArray.remove();
            }
            endPointArray = new EndPoint[serializable.size()];
            serializable.toArray(endPointArray);
            Identity[] identityArray = new Identity[arrayList.size()];
            arrayList.toArray(identityArray);
            if (tc.isDebugEnabled()) {
                if (endPointArray != null) {
                    Tr.debug(tc, "Number of Endpoints in array: " + String.valueOf(endPointArray.length));
                }
                Tr.debug(tc, "Endpoint array", endPointArray);
            }
            targetImpl = new TargetImpl(identityArray, descriptionKey, endPointArray);
            Integer n = this.targetCacheMutex;
            synchronized (n) {
                this.targetCache.put(object, targetImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", targetImpl);
        }
        return targetImpl;
    }

    public boolean isAffinityKeyPresent() {
        return this.affinityMapping;
    }

    public String toString() {
        return super.toString() + "[" + this.identity + ":" + this.context + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2});
        }
        DescriptionKey descriptionKey2 = null;
        try {
            descriptionKey2 = ((Description)object).getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterMember is: " + descriptionKey2);
            }
        }
        catch (ClassCastException classCastException) {
            Tr.debug(tc, "ClassCastException in handleNotification:", classCastException);
            FFDCFilter.processException(classCastException, SelectionCriteriaImpl.class.getName() + "handleNotification()", "237");
        }
        HashSet hashSet = new HashSet();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object4 = this.targetCacheMutex;
        synchronized (object4) {
            Object object5;
            object3 = this.targetCache.keySet();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object5 = (IdentityListKey)iterator.next();
                if (!object5.contains(descriptionKey2)) continue;
                hashSet.add(this.targetCache.get(object5));
                arrayList.add(object5);
            }
            object5 = arrayList.iterator();
            while (object5.hasNext()) {
                this.targetCache.remove(object5.next());
            }
        }
        if (string.equals("member.removed") && (object4 = (SelectionAdvisor)this.strategyCache.remove(this.cluster.getKey())) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set beingRemoved in SelectionAdvisor ", this.cluster.getKey());
            }
            ((SelectionAdvisor)object4).beingRemoved();
        }
        if (tc.isEntryEnabled()) {
            if (hashSet.size() > 0) {
                object4 = new StringBuffer(128);
                object3 = hashSet.iterator();
                while (object3.hasNext()) {
                    ((StringBuffer)object4).append(((Target)object3.next()).getMemberIdentity());
                }
                Tr.exit(tc, "handleNotification", ((StringBuffer)object4).toString());
            } else {
                Tr.exit(tc, "handleNotification");
            }
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.context == null ? 0 : ((Object)this.context).hashCode());
        n = 31 * n + (this.identity == null ? 0 : this.identity.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        SelectionCriteriaImpl selectionCriteriaImpl = (SelectionCriteriaImpl)object;
        if (this.context == null ? selectionCriteriaImpl.context != null : !((Object)this.context).equals(selectionCriteriaImpl.context)) {
            return false;
        }
        return !(this.identity == null ? selectionCriteriaImpl.identity != null : this.identity != selectionCriteriaImpl.identity);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.28 ");
        }
    }
}

