/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.selection.SelectContext;
import java.util.Map;

public class SelectionModifier {
    private static final TraceComponent tc = Tr.register(SelectionModifier.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private boolean clientFirst = false;
    private boolean inHostOnly = false;
    private boolean inProcessOnly = false;
    private int preferLocal = 8;
    private int preferProcess = 0;
    private Map endpointProp = null;
    private String algorithm = "com.ibm.websphere.cluster.selection.algorithm.predefinded.weightproportional";
    private int advisorMediator = 4;
    private int mediatorControl = 0;

    public SelectionModifier() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CTOR");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CTOR", new Object[]{this});
        }
    }

    public int getAdvisorMediator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdvisorMediator");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdvisorMediator", "advisorMediator=" + this.advisorMediator);
        }
        return this.advisorMediator;
    }

    public String getAlgorithm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlgorithm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlgorithm", "algorithm=" + this.algorithm);
        }
        return this.algorithm;
    }

    public Map getEndpointProp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpointProp");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointProp", this.endpointProp);
        }
        return this.endpointProp;
    }

    public boolean isInHostOnly() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInHostOnly");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInHostOnly", "inHostOnly=" + this.inHostOnly);
        }
        return this.inHostOnly;
    }

    public boolean isInProcessOnly() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInProcessOnly");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInProcessOnly", "inProcessOnly=" + this.inProcessOnly);
        }
        return this.inProcessOnly;
    }

    public int getMediatorControl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMediatorControl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMediatorControl", "mediatorControl=" + this.mediatorControl);
        }
        return this.mediatorControl;
    }

    public int getPreferLocal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferLocal");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreferLocal", "preferLocal=" + this.preferLocal);
        }
        return this.preferLocal;
    }

    public int getPreferProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferProcess");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreferProcess", "preferProcess=" + this.preferProcess);
        }
        return this.preferProcess;
    }

    public void setAdvisorMediator(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdvisorMediator");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAdvisorMediator", "advisorMediator=" + n);
        }
        this.advisorMediator = n;
    }

    public void setAlgorithm(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAlgorithm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAlgorithm", "algorithm=" + string);
        }
        this.algorithm = string;
    }

    public void setEndpointProp(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEndpointProp");
        }
        this.endpointProp = map;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEndpointProp", "endpointProp=" + map);
        }
    }

    public void setInHostOnly(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInHostOnly");
        }
        this.inHostOnly = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInHostOnly", "inHostOnly=" + bl);
        }
    }

    public void setInProcessOnly(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInProcessOnly");
        }
        this.inProcessOnly = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInProcessOnly", "inProcessOnly=" + bl);
        }
    }

    public void setMediatorControl(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMediatorControl");
        }
        this.mediatorControl = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMediatorControl", "mediatorControl=" + n);
        }
    }

    public void setPreferLocal(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPreferLocal");
        }
        this.preferLocal = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPreferLocal", "preferLocal=" + n);
        }
    }

    public void setPreferProcess(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPreferProcess");
        }
        this.preferProcess = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPreferProcess", "preferProcess=" + n);
        }
    }

    public boolean isPreferLocalEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPreferLocalEnabled");
        }
        boolean bl = false;
        if (this.preferLocal == 4 || this.preferLocal == 8) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPreferLocalEnabled", "result=" + bl);
        }
        return bl;
    }

    public boolean isPreferLocalCountTowardWeight() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPreferLocalCountTowardWeight");
        }
        boolean bl = false;
        if (this.preferLocal == 8) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPreferLocalCountTowardWeight", "result=" + bl);
        }
        return bl;
    }

    public boolean isPreferProcessEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPreferProcessEnabled");
        }
        boolean bl = false;
        if (this.preferProcess == 0 || this.preferProcess == 2) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPreferProcessEnabled", "result=" + bl);
        }
        return bl;
    }

    public boolean isPreferProcessCountTowardWeight() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPreferProcessCountTowardWeight");
        }
        boolean bl = false;
        if (this.preferProcess == 2) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPreferProcessCountTowardWeight", "result=" + bl);
        }
        return bl;
    }

    public boolean isMediatorControlDisabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMediatorControlDisabled");
        }
        boolean bl = true;
        if (this.mediatorControl == 0 || this.mediatorControl == 2) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMediatorControlDisabled", "result=" + bl);
        }
        return bl;
    }

    public boolean isSelectContextCacheStillValidWithSelectionModifier(SelectContext selectContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSelectContextCacheStillValidWithSelectionModifier");
        }
        boolean bl = true;
        Map map = null;
        SelectionModifier selectionModifier = selectContext.getModifier();
        if (this == selectionModifier) {
            return bl;
        }
        if (selectionModifier != null) {
            map = selectionModifier.getEndpointProp();
            if (map == null && this.endpointProp != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isSelectContextCacheStillValidWithSelectionModifier, result=false");
                }
                return false;
            }
        } else if (this.endpointProp != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSelectContextCacheStillValidWithSelectionModifier, result=false");
            }
            return false;
        }
        if (this.endpointProp == map) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSelectContextCacheStillValidWithSelectionModifier, result=" + bl);
            }
            return bl;
        }
        if (this.epMatches(this.endpointProp, map)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSelectContextCacheStillValidWithSelectionModifier, result=" + bl);
            }
            return bl;
        }
        bl = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSelectContextCacheStillValidWithSelectionModifier, result=" + bl);
        }
        return bl;
    }

    private boolean epMatches(Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "epMatches");
        }
        boolean bl = false;
        if (((Object)map).equals(map2)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "epMatches, result=" + bl);
        }
        return bl;
    }

    public boolean isClientFirst() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isClientFirst");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isClientFirst", "isClientFirst=" + this.clientFirst);
        }
        return this.clientFirst;
    }

    public void setClientFirst(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientFirst");
        }
        this.clientFirst = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClientFirst", "isClientFirst=" + bl);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(" {[clientFirst," + this.clientFirst + "]");
        stringBuffer.append(" [algorithm," + this.algorithm + "]");
        stringBuffer.append(" [advisorMediator," + this.advisorMediator + "]");
        stringBuffer.append(" [mediatorControl," + this.mediatorControl + "]");
        stringBuffer.append(" [preferLocal," + this.preferLocal + "]");
        stringBuffer.append(" [preferProcess," + this.preferProcess + "]");
        stringBuffer.append(" [inHostOnly," + this.inHostOnly + "]");
        stringBuffer.append(" [inProcessOnly," + this.inProcessOnly + "]}");
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.3 : none");
        }
    }
}

