/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.ClusterDescriptionImpl;
import com.ibm.ws.cluster.topography.LSDClusterMemberDescription;
import com.ibm.ws.cluster.topography.LSDClusterMemberDescriptionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.configuration.LSDAddress;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class BuildLSDCluster {
    private static final TraceComponent tc = Tr.register(BuildLSDCluster.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static boolean registerWithLSD;
    private String cellName;
    private String nodeName;
    private String processName;
    private String host = null;
    private int port = 0;
    private int sslPort = 0;
    private int sslCCPort = 0;

    public BuildLSDCluster(EndPointMgr endPointMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BuildLSDCluster.<CTOR>");
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        this.cellName = adminService.getCellName();
        this.nodeName = adminService.getNodeName();
        this.processName = adminService.getProcessName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LSDCluster data ", new Object[]{this.cellName, this.nodeName, this.processName});
        }
        this.constructsLSDEP(endPointMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BuildLSDCluster.<CTOR>");
        }
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        return "[cellName: " + this.cellName + "] [host: " + this.host + "][port: " + this.port + "][sslPort: " + this.sslPort + "][sslCCPort: " + this.sslCCPort + "]";
    }

    public void joinLSDCluster() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "joinLSDCluster");
        }
        KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
        DescriptionManager descriptionManager = DescriptionManagerFactory.getDescriptionManager();
        ProcessProperties processProperties = ProcessProperties.getInstance();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("CELLNAME", this.cellName);
        treeMap.put("CLUSTERNAME", "LSDCluster");
        DescriptionKey descriptionKey = keyRepository.getDescriptionKey(treeMap);
        DescriptionKey descriptionKey2 = null;
        descriptionKey2 = ClusterDescriptionImpl.getWeightTableKey(descriptionKey);
        processProperties.put("key.containing.cluster.weight.table", descriptionKey2);
        ClusterMemberService clusterMemberService = (ClusterMemberService)processProperties.get("key.clustermember.service");
        try {
            clusterMemberService.joinCluster(descriptionKey);
        }
        catch (NoClusterDefinedException noClusterDefinedException) {
            FFDCFilter.processException(noClusterDefinedException, "com.ibm.ws.cluster.control.service.BuildLSDCluster.constructsLSDEPs", "154");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unexpected exception, no cluster defined exception - exiting without joining LSD Cluster", noClusterDefinedException);
            }
            return;
        }
        DescriptionKey descriptionKey3 = (DescriptionKey)processProperties.get("key.local.member");
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descriptionManager.getDescription(descriptionKey3);
        if (descriptionKey3 == null || clusterMemberDescription == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "null process member key, or null member description - exiting without joining LSD cluster", new Object[]{descriptionKey3, clusterMemberDescription});
            }
            return;
        }
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        treeMap2.put(LSDClusterMemberDescription.distinction[0], LSDClusterMemberDescription.distinction[1]);
        DescriptionKey descriptionKey4 = keyRepository.getDescriptionKey(descriptionKey3, treeMap2);
        LSDClusterMemberDescriptionImpl lSDClusterMemberDescriptionImpl = null;
        try {
            lSDClusterMemberDescriptionImpl = (LSDClusterMemberDescriptionImpl)descriptionManager.getDescription(descriptionKey4, LSDClusterMemberDescription.class.getName());
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException(instantiationException, "com.ibm.ws.cluster.control.service.BuildLSDCluster.constructsLSDEPs", "185");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unexpected exception, unable to create lsd member - exiting without joining LSD Cluster", instantiationException);
            }
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException(illegalAccessException, "com.ibm.ws.cluster.control.service.BuildLSDCluster.constructsLSDEPs", "193");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unexpected exception, unable to create lsd member - exiting without joining LSD Cluster", illegalAccessException);
            }
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException(invocationTargetException, "com.ibm.ws.cluster.control.service.BuildLSDCluster.constructsLSDEPs", "201");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unexpected exception, unable to create lsd member - exiting without joining LSD Cluster", invocationTargetException);
            }
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException(noSuchMethodException, "com.ibm.ws.cluster.control.service.BuildLSDCluster.constructsLSDEPs", "209");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unexpected exception, unable to create lsd member - exiting without joining LSD Cluster", noSuchMethodException);
            }
            return;
        }
        lSDClusterMemberDescriptionImpl.setHost(this.host);
        if (this.port <= 0 || this.sslPort <= 0 || this.sslCCPort <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "port <= 0 || sslPort <= 0 || sslCCPort <= 0 - exiting without joining LSD cluster", new Object[]{new Integer(this.port), new Integer(this.sslPort), new Integer(this.sslCCPort)});
            }
            return;
        }
        lSDClusterMemberDescriptionImpl.setPort(this.port);
        lSDClusterMemberDescriptionImpl.setSSLPort(this.sslPort);
        lSDClusterMemberDescriptionImpl.setSSLClientCertificatePort(this.sslCCPort);
        lSDClusterMemberDescriptionImpl.setClusterMemberAssociation(descriptionKey3);
        clusterMemberDescription.setExtrinsicData(lSDClusterMemberDescriptionImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "joinLSDCluster", this);
        }
    }

    public void constructsLSDEP(EndPointMgr endPointMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructsLSDEPs");
        }
        LSDAddress[] lSDAddressArray = WLMProperties.getLSDAddresses();
        if (!registerWithLSD) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Process not registering with the LSD");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "constructsLSDEPs");
            }
            return;
        }
        if (lSDAddressArray == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected: LSDList is null");
            }
            FFDCFilter.processException((Throwable)new Exception("LSDCluster member for this process has not been set properly"), BuildLSDCluster.class.getName() + ".constructsLSDEP", "270", this);
            return;
        }
        Map map = endPointMgr.getNodeEndPoints();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            EndPointMgr.NodeEndPoints nodeEndPoints = (EndPointMgr.NodeEndPoints)entry.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Name of endpoint group", nodeEndPoints.getName());
            }
            if (!nodeEndPoints.getName().equals(this.nodeName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found my nodeName");
            }
            EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(this.processName);
            EndPoint endPoint = serverEndPoints.getEndPoint("ORB_LISTENER_ADDRESS");
            EndPoint endPoint2 = serverEndPoints.getEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
            EndPoint endPoint3 = serverEndPoints.getEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
            this.host = endPoint.getHost();
            this.port = endPoint.getPort();
            this.sslPort = endPoint2.getPort();
            this.sslCCPort = endPoint3.getPort();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructsLSDEPs", this);
        }
    }

    public static void setRegisterWithLSD(boolean bl) {
        registerWithLSD = bl;
    }

    public static void createLSDAddressList(EndPointMgr endPointMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLSDAddressList");
        }
        LSDAddress[] lSDAddressArray = null;
        ArrayList<LSDAddress> arrayList = null;
        if (!registerWithLSD) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "registerWithLSD = false, creating empty LSDAddress list");
            }
            lSDAddressArray = new LSDAddress[]{};
        } else {
            Object var3_3 = null;
            Map map = endPointMgr.getNodeEndPoints();
            arrayList = new ArrayList<LSDAddress>(map.size());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initial creation size of lsdlist", new Integer(map.size()));
            }
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                EndPointMgr.NodeEndPoints nodeEndPoints = (EndPointMgr.NodeEndPoints)entry.getValue();
                Map map2 = nodeEndPoints.getServerEndPoints();
                Iterator iterator2 = map2.values().iterator();
                while (iterator2.hasNext()) {
                    EndPointMgr.EndPoints endPoints = (EndPointMgr.EndPoints)iterator2.next();
                    String string = endPoints.getName();
                    EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(string);
                    String string2 = serverEndPoints.getType();
                    if (string2 == null || !string2.equals("NODE_AGENT")) continue;
                    EndPoint endPoint = serverEndPoints.getEndPoint("ORB_LISTENER_ADDRESS");
                    EndPoint endPoint2 = serverEndPoints.getEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
                    EndPoint endPoint3 = serverEndPoints.getEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
                    if (endPoint == null || endPoint.getPort() == 0) continue;
                    arrayList.add(new LSDAddress(endPoint.getHost(), endPoint.getPort(), endPoint2 == null ? 0 : endPoint2.getPort(), endPoint3 == null ? 0 : endPoint3.getPort()));
                }
            }
            lSDAddressArray = new LSDAddress[arrayList.size()];
            arrayList.toArray(lSDAddressArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createLSDAddressList:  dump LSDAddresses");
                for (int i = 0; i < lSDAddressArray.length; ++i) {
                    Tr.debug(tc, lSDAddressArray[i].toString());
                }
            }
        }
        WLMProperties.setLSDAddresses(lSDAddressArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLSDAddressList");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.12.1.1 : none");
        }
        registerWithLSD = true;
    }
}

