/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.IntrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescriptionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.NoMemberAvailableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ClusterManagementImpl
implements ClusterManagement {
    private static final TraceComponent tc = Tr.register(ClusterManagementImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final KeyRepository ivKeyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final Map scmdDistinction = new HashMap(1);
    private final DescriptionManager localOrGlobalDescMgr;

    public ClusterManagementImpl(boolean bl) {
        this.localOrGlobalDescMgr = bl ? DescriptionManagerFactory.getDescriptionManager() : DescriptionManagerFactory.getLocalDescriptionManager();
    }

    public Identity createClusterMember(String string, String string2, String string3, String string4) {
        ProcessDescription processDescription;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createClusterMember", string + ":" + string2 + ":" + string3 + ":" + string4);
            }
            processDescription = null;
            SelectionClusterMemberDescriptionImpl selectionClusterMemberDescriptionImpl = null;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("CELLNAME", string);
            treeMap.put("NODENAME", string2);
            treeMap.put("MEMBERNAME", string4);
            try {
                DescriptionKey descriptionKey = ivKeyRepository.getDescriptionKey(treeMap);
                processDescription = (ProcessDescription)this.localOrGlobalDescMgr.getDescription(descriptionKey, ProcessDescription.class.getName());
                processDescription.setNodeName(string2);
                processDescription.setProcessName(string4);
                TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
                treeMap2.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                DescriptionKey descriptionKey2 = ivKeyRepository.getDescriptionKey(descriptionKey, treeMap2);
                selectionClusterMemberDescriptionImpl = (SelectionClusterMemberDescriptionImpl)this.localOrGlobalDescMgr.getDescription(descriptionKey2, SelectionClusterMemberDescription.class.getName());
                if (string3 == null) {
                    string3 = "localhost";
                    try {
                        string3 = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                selectionClusterMemberDescriptionImpl.setHost(string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "localHost: " + ((SelectionClusterMemberDescription.Memento)selectionClusterMemberDescriptionImpl.getMemento()).getHost());
                }
                selectionClusterMemberDescriptionImpl.setClusterMemberAssociation(descriptionKey);
                processDescription.setExtrinsicData(selectionClusterMemberDescriptionImpl);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterManagementImpl.class.getName() + ".createClusterMember", "143");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClusterMember", processDescription.getKey());
        }
        return processDescription.getKey();
    }

    public void joinCluster(Identity identity, Identity[] identityArray) {
        ClusterDescription clusterDescription;
        block16: {
            Identity[] identityArray2;
            if (identity == null || identityArray == null) {
                throw new IllegalArgumentException("null arguments not allowed");
            }
            if (tc.isEntryEnabled()) {
                identityArray2 = new Identity[identityArray.length + 1];
                identityArray2[0] = identity;
                System.arraycopy(identityArray, 0, identityArray2, 1, identityArray.length);
                Tr.entry(tc, "joinCluster", identityArray2);
            }
            identityArray2 = (Identity[])identity;
            clusterDescription = null;
            try {
                clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identityArray2, ClusterDescription.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterManagementImpl.class.getName() + ".joinCluster", "175");
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        for (int i = 0; i < identityArray.length; ++i) {
            ClusterMemberDescription clusterMemberDescription;
            block17: {
                DescriptionKey descriptionKey = (DescriptionKey)identityArray[i];
                clusterMemberDescription = null;
                Description description = this.localOrGlobalDescMgr.getDescription(descriptionKey);
                if (description == null) {
                    try {
                        clusterMemberDescription = (ClusterMemberDescription)this.localOrGlobalDescMgr.getDescription(descriptionKey, (class$com$ibm$websphere$cluster$topography$ClusterMemberDescription == null ? ClusterManagementImpl.class$("com.ibm.websphere.cluster.topography.ClusterMemberDescription") : class$com$ibm$websphere$cluster$topography$ClusterMemberDescription).getName());
                        clusterMemberDescription.setAvailability((byte)0);
                        SelectionClusterMemberDescriptionImpl selectionClusterMemberDescriptionImpl = null;
                        TreeMap<String, String> treeMap = new TreeMap<String, String>();
                        treeMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                        DescriptionKey descriptionKey2 = ivKeyRepository.getDescriptionKey(descriptionKey, treeMap);
                        selectionClusterMemberDescriptionImpl = (SelectionClusterMemberDescriptionImpl)this.localOrGlobalDescMgr.getDescription(descriptionKey2, (class$com$ibm$ws$cluster$topography$SelectionClusterMemberDescription == null ? ClusterManagementImpl.class$("com.ibm.ws.cluster.topography.SelectionClusterMemberDescription") : class$com$ibm$ws$cluster$topography$SelectionClusterMemberDescription).getName());
                        String string = "localhost";
                        try {
                            string = InetAddress.getLocalHost().getHostName();
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                        selectionClusterMemberDescriptionImpl.setHost(string);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "localHost: " + ((SelectionClusterMemberDescription.Memento)selectionClusterMemberDescriptionImpl.getMemento()).getHost());
                        }
                        selectionClusterMemberDescriptionImpl.setClusterMemberAssociation(descriptionKey);
                        clusterMemberDescription.setExtrinsicData(selectionClusterMemberDescriptionImpl);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, (class$com$ibm$ws$cluster$service$ClusterManagementImpl == null ? ClusterManagementImpl.class$("com.ibm.ws.cluster.service.ClusterManagementImpl") : class$com$ibm$ws$cluster$service$ClusterManagementImpl).getName() + ".joinCluster", "194");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unexpected exception ", exception);
                        }
                        break block17;
                    }
                }
                if (description instanceof ClusterMemberDescription) {
                    clusterMemberDescription = (ClusterMemberDescription)description;
                } else {
                    throw new IllegalArgumentException("member is not of correct type");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add member[" + i + "] = ", identityArray[i]);
            }
            clusterDescription.addMember(clusterMemberDescription);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "joinCluster", clusterDescription);
        }
    }

    public void joinCluster(Identity[] identityArray, Identity[] identityArray2) {
        this.joinCluster(identityArray[identityArray.length - 1], identityArray2);
        if (identityArray.length > 1) {
            int n = identityArray.length;
            Identity identity = identityArray[n - 2];
            for (int i = identityArray.length - 1; i > 0; --i) {
                Identity[] identityArray3 = new Identity[]{identityArray[i]};
                this.joinCluster(identity, identityArray3);
                identity = identityArray3[0];
            }
        }
    }

    public synchronized void disjoinCluster(Identity identity, Identity[] identityArray) {
        ClusterDescription clusterDescription;
        Identity[] identityArray2;
        if (identity == null || identityArray == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        if (tc.isEntryEnabled()) {
            identityArray2 = new Identity[identityArray.length + 1];
            identityArray2[0] = identity;
            System.arraycopy(identityArray, 0, identityArray2, 1, identityArray.length);
            Tr.entry(tc, "disjoinCluster", identityArray2);
        }
        if ((clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)(identityArray2 = (Identity[])identity))) != null) {
            for (int i = 0; i < identityArray.length; ++i) {
                DescriptionKey descriptionKey = (DescriptionKey)identityArray[i];
                ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.localOrGlobalDescMgr.getDescription(descriptionKey);
                if (clusterMemberDescription == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remove member[" + i + "] = ", identityArray[i]);
                }
                clusterDescription.removeMember(clusterMemberDescription);
            }
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "Null Cluster!");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disjoinCluster", clusterDescription);
        }
    }

    public void disjoinCluster(Identity[] identityArray, Identity[] identityArray2) {
        if (identityArray == null || identityArray2 == null) {
            throw new IllegalArgumentException("Identity[] arguments must not be null.");
        }
        if (identityArray.length == 0) {
            throw new IllegalArgumentException("Identity[], clusterIdentities, must contain at least one entry.");
        }
        for (int i = 0; i < identityArray.length - 1; ++i) {
            this.disjoinCluster(identityArray[i], new Identity[]{identityArray[i + 1]});
        }
        this.disjoinCluster(identityArray[identityArray.length - 1], identityArray2);
    }

    public EndPoint defineClusterScopedData(Identity identity, Identity identity2, byte[] byArray) throws NoClusterDefinedException {
        EndPoint endPoint;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defineClusterScopedData", new Object[]{identity, identity2});
        }
        if (identity == null || identity2 == null || byArray == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        try {
            DescriptionKey descriptionKey = (DescriptionKey)identity;
            ClusterDescription clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription(descriptionKey, ClusterDescription.class.getName());
            clusterDescription.setClusterScopedData((DescriptionKey)identity2, byArray);
            endPoint = (EndPoint)((Object)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identity2, EndPoint.class.getName()));
            endPoint.setData(byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterManagementImpl.class.getName() + ".defineClusterScopedData", "312", this, new Object[]{identity, identity2, byArray});
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not resolve clusterIdentity.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defineClusterScopedData", endPoint);
        }
        return endPoint;
    }

    public EndPoint defineMemberScopedData(Identity identity, Identity identity2, byte[] byArray) throws NoMemberAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defineMemberScopedData", new Object[]{identity, identity2});
        }
        if (identity == null || identity2 == null || byArray == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        DescriptionKey descriptionKey = (DescriptionKey)identity;
        EndPointImpl endPointImpl = null;
        try {
            ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.localOrGlobalDescMgr.getDescription(descriptionKey, ClusterMemberDescription.class.getName());
            endPointImpl = (EndPointImpl)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identity2, EndPoint.class.getName());
            endPointImpl.setData(byArray);
            clusterMemberDescription.setExtrinsicData(endPointImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterManagementImpl.class.getName() + ".defineMemberScopedData", "346");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", exception);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("An internal error occurred while trying to process the member data.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defineMemberScopedData", endPointImpl);
        }
        return endPointImpl;
    }

    public synchronized void undefineClusterScopedData(Identity identity, EndPoint endPoint) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "undefineClusterScopedData", new Object[]{identity, endPoint});
        }
        if (identity == null || endPoint == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        DescriptionKey descriptionKey = (DescriptionKey)identity;
        DescriptionKey descriptionKey2 = (DescriptionKey)endPoint.getIdentity();
        ClusterDescription clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription(descriptionKey);
        if (clusterDescription == null) {
            throw new NoClusterDefinedException(identity);
        }
        clusterDescription.removeClusterScopedData(descriptionKey2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "undefineClusterScopedData");
        }
    }

    public synchronized void undefineMemberScopedData(Identity identity, EndPoint endPoint) throws NoMemberAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "undefineMemberScopedData", new Object[]{identity, endPoint});
        }
        if (identity == null || endPoint == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        DescriptionKey descriptionKey = (DescriptionKey)identity;
        DescriptionKey descriptionKey2 = (DescriptionKey)endPoint.getIdentity();
        ProcessDescription processDescription = (ProcessDescription)this.localOrGlobalDescMgr.getDescription(descriptionKey);
        if (processDescription == null) {
            throw new NoMemberAvailableException(identity);
        }
        processDescription.removeExtrinsicData(descriptionKey2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "undefineMemberScopedData");
        }
    }

    public int getDesiredWeight(Identity identity, Identity identity2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDesiredWeight", new Object[]{identity, identity2});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The cluster's Identity can not be null.");
        }
        if (identity2 == null) {
            throw new IllegalArgumentException("The member's Identity can not be null.");
        }
        try {
            ClusterDescription clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identity, ClusterDescription.class.getName());
            ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
            int n = memento.getWeightTableEntry((DescriptionKey)identity2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDesiredWeight", String.valueOf(n));
            }
            return n;
        }
        catch (Exception exception) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", exception);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not process parameters.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDesiredWeight(Identity identity, Identity identity2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDesiredWeight", new Object[]{identity, identity2, String.valueOf(n)});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The cluster's Identity can not be null.");
        }
        if (identity2 == null) {
            throw new IllegalArgumentException("The member's Identity can not be null.");
        }
        Identity identity3 = identity;
        synchronized (identity3) {
            block9: {
                try {
                    ClusterDescription clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identity, ClusterDescription.class.getName());
                    clusterDescription.setClusterWeightTableEntry((DescriptionKey)identity2, new Integer(n));
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ClusterManagementImpl.class.getName() + ".setDesiredWeight", "475", this, new Object[]{identity, identity2, String.valueOf(n)});
                    if (!tc.isEventEnabled()) break block9;
                    Tr.event(tc, "unexpected", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDesiredWeight", new Integer(n));
        }
    }

    public void defineAttribute(Identity identity, String string) {
        if (identity == null) {
            throw new IllegalArgumentException("The identity argument must not be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The attribute argument must not be null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defineAttribute", new Object[]{identity, string});
        }
        try {
            IntrinsicDescription intrinsicDescription = (IntrinsicDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identity);
            DescriptionKey descriptionKey = ivKeyRepository.getDescriptionKey((DescriptionKey)identity, scmdDistinction);
            SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)((IntrinsicDescription.Memento)intrinsicDescription.getMemento()).getExtrinsicData(descriptionKey);
            if (selectionClusterMemberDescription == null) {
                selectionClusterMemberDescription = (SelectionClusterMemberDescription)this.localOrGlobalDescMgr.getDescription(descriptionKey, SelectionClusterMemberDescription.class.getName());
                intrinsicDescription.setExtrinsicData(selectionClusterMemberDescription);
            }
            selectionClusterMemberDescription.addAttribute(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "defineAttribute", selectionClusterMemberDescription);
            }
        }
        catch (ClassCastException classCastException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Likely user error", classCastException);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The identity argument must be a cluster or member identity.");
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception", exception);
            }
            IllegalStateException illegalStateException = new IllegalStateException("Unable to load attribute.");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public void undefineAttribute(Identity identity, String string) {
        DescriptionKey descriptionKey;
        SelectionClusterMemberDescription selectionClusterMemberDescription;
        if (identity == null) {
            throw new IllegalArgumentException("The identity argument must not be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The attribute argument must not be null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "undefineAttribute", new Object[]{identity, string});
        }
        if ((selectionClusterMemberDescription = (SelectionClusterMemberDescription)this.localOrGlobalDescMgr.getDescription(descriptionKey = ivKeyRepository.getDescriptionKey((DescriptionKey)identity, scmdDistinction))) != null) {
            selectionClusterMemberDescription.removeAttribute(string);
            if (((SelectionClusterMemberDescriptionImpl)selectionClusterMemberDescription).isAttributeEmpty()) {
                IntrinsicDescription intrinsicDescription = (IntrinsicDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identity);
                intrinsicDescription.removeExtrinsicData(descriptionKey);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "undefineAttribute", selectionClusterMemberDescription);
        }
    }

    public Set getAttributes(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", identity);
        }
        Set set = null;
        try {
            IntrinsicDescription intrinsicDescription = (IntrinsicDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identity);
            DescriptionKey descriptionKey = ivKeyRepository.getDescriptionKey((DescriptionKey)identity, scmdDistinction);
            SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)((IntrinsicDescription.Memento)intrinsicDescription.getMemento()).getExtrinsicData(descriptionKey);
            if (selectionClusterMemberDescription != null) {
                set = ((SelectionClusterMemberDescription.Memento)selectionClusterMemberDescription.getMemento()).getAttributes();
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "SelctionClusterMember Description is null");
            }
        }
        catch (ClassCastException classCastException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception trying to getAttributes", classCastException);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The identity argument must be a cluster member identity.");
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception", exception);
            }
            FFDCFilter.processException(exception, ClusterManagementImpl.class.getName() + ".getAttributes", "694");
            IllegalStateException illegalStateException = new IllegalStateException("Unexpected exception trying to getAttributes");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", set);
        }
        return set;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.27.1.4 ");
        }
        scmdDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
    }
}

