/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionFactory;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.DescriptionKeyImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.wlm.TypeConversion;
import com.ibm.wsspi.cluster.ClusterService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class DescriptionManagerA
implements DescriptionManager {
    private static final TraceComponent tc = Tr.register(DescriptionManagerA.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected static final KeyRepository keyRepository;
    protected static final Format format;
    protected static final byte VERSION2 = 2;
    protected static final byte COMPRESSED = 1;
    protected static final byte UNCOMPRESSED = 0;
    private ObjectPool streamPool = new ObjectPool("WLMDescriptionManagerStreamPool", 5);

    public synchronized Description getDescription(DescriptionKey descriptionKey) {
        if (descriptionKey == null) {
            throw new IllegalArgumentException("The key must not be null.");
        }
        Description description = ((DescriptionKeyImpl)descriptionKey).getDescription();
        return description;
    }

    public synchronized Description getDescription(DescriptionKey descriptionKey, String string) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (descriptionKey == null) {
            throw new IllegalArgumentException("The key must not be null.");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("The implKey passed in was [" + string + "] which is not valid.");
        }
        Description description = ((DescriptionKeyImpl)descriptionKey).getDescription();
        if (description != null) {
            return description;
        }
        description = DescriptionFactory.getInstance().createDescription(descriptionKey, string);
        ((DescriptionKeyImpl)descriptionKey).setDescription(description);
        return description;
    }

    synchronized Description getLocalDescription(DescriptionKey descriptionKey, String string) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (descriptionKey == null) {
            throw new IllegalArgumentException("The key must not be null.");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("The implKey passed in was [" + string + "] which is not valid.");
        }
        Description description = ((DescriptionKeyImpl)descriptionKey).getDescription();
        if (description != null) {
            return description;
        }
        description = DescriptionFactory.getInstance().createLocalDescription(descriptionKey, string);
        ((DescriptionKeyImpl)descriptionKey).setDescription(description);
        return description;
    }

    public void stream(Map map, ObjectOutput objectOutput) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stream", map);
        }
        int n = map.size();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        objectOutput.writeInt(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote count " + n);
        }
        while (iterator.hasNext()) {
            Format format = (Format)iterator.next();
            objectOutput.writeObject(format);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote format ", format);
            }
            Set set2 = (Set)map.get(format);
            objectOutput.writeInt(set2.size());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote size " + set2.size());
            }
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                DescriptionKey descriptionKey = (DescriptionKey)iterator2.next();
                keyRepository.exportToStream(objectOutput, descriptionKey);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote key", descriptionKey);
                }
                Description description = this.getDescription(descriptionKey);
                objectOutput.writeObject(description.getDefinitionKey());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote definiton key", description.getDefinitionKey());
                }
                description.exportToStream(objectOutput, format);
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Description streamed", description);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stream");
        }
    }

    public void update(ObjectInput objectInput) throws IOException {
        Format format = null;
        DescriptionKey descriptionKey = null;
        try {
            int n = objectInput.readInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read count " + n);
            }
            while (n > 0) {
                format = (Format)objectInput.readObject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read format ", format);
                }
                int n2 = objectInput.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read size " + n2);
                }
                while (n2 > 0) {
                    descriptionKey = keyRepository.importFromStream(objectInput);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read key", descriptionKey);
                    }
                    String string = (String)objectInput.readObject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read definition key", string);
                    }
                    Description description = this.getDescription(descriptionKey, string);
                    Description.Memento memento = description.importFromStream(objectInput, format, null);
                    --n2;
                    description.setMemento(memento);
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "Description updated", memento);
                }
                --n;
            }
        }
        catch (InstantiationException instantiationException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", instantiationException);
            }
            IOException iOException = new IOException(instantiationException.getMessage());
            iOException.initCause(instantiationException);
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", illegalAccessException);
            }
            IOException iOException = new IOException(illegalAccessException.getMessage());
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", invocationTargetException);
            }
            IOException iOException = new IOException(invocationTargetException.getMessage());
            iOException.initCause(invocationTargetException);
            throw iOException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", noSuchMethodException);
            }
            IOException iOException = new IOException(noSuchMethodException.getMessage());
            iOException.initCause(noSuchMethodException);
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", classNotFoundException);
            }
            IOException iOException = new IOException(classNotFoundException.getMessage());
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
    }

    public boolean publish(Description description) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", description);
        }
        boolean bl = true;
        byte[] byArray = this.getDatatFromDescription(description);
        byte[] byArray2 = null;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(byArray);
        Iterator iterator = arrayList.iterator();
        byArray2 = this.aggregateMultipleInputs(iterator, new Integer(42));
        if (tc.isEventEnabled()) {
            Tr.event(tc, "publishing (version " + byArray2[0] + ") " + description.getKey(), new Object[]{String.valueOf(byArray.length), String.valueOf(byArray2.length)});
        }
        if (!(bl = description.isLocal() ? false : this.publish(this.keyToString(description.getKey()), byArray2))) {
            this.handleLocal(description, byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publish", String.valueOf(bl));
        }
        return bl;
    }

    public void update(String string, byte[][] byArray) {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "update", new Object[]{string, byArray == null ? null : String.valueOf(byArray.length)});
            }
            try {
                Description description;
                DescriptionKey descriptionKey = this.stringToKey(string);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "processing update for subject " + descriptionKey);
                }
                if ((description = this.getDescription(descriptionKey)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updated - description removed");
                    }
                    return;
                }
                Description.Memento memento = null;
                if (byArray == null) {
                    description.setMemento(description.createMemento());
                } else {
                    for (int i = 0; i < byArray.length; ++i) {
                        Object object;
                        byte[] byArray2 = byArray[i];
                        if (byArray2 == null || byArray2.length <= 2) continue;
                        byte by = byArray2[0];
                        if (by <= 1) {
                            if (byArray2[1] == 1) {
                                byArray2 = Compressor.decompress(byArray2, 2);
                            }
                            object = new ByteArrayInputStream(byArray2);
                            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                            do {
                                dataInputStream.skipBytes(2);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Available bytes (version " + by + ") " + String.valueOf(((ByteArrayInputStream)object).available()));
                                }
                                memento = description.importFromStream(dataInputStream, format, memento);
                            } while (by >= 1 && ((ByteArrayInputStream)object).available() > 2);
                            continue;
                        }
                        if (by < 2) continue;
                        object = this.divideMultipleInputs(byArray2);
                        for (int j = 0; j < ((byte[][])object).length; ++j) {
                            byte[] byArray3 = object[j];
                            if (byArray3[1] == 1) {
                                byArray3 = Compressor.decompress(byArray3, 2);
                            }
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
                            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                            dataInputStream.skipBytes(2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Available bytes (version " + by + ") " + String.valueOf(byteArrayInputStream.available()));
                            }
                            memento = description.importFromStream(dataInputStream, format, memento);
                        }
                    }
                    if (memento == null) {
                        description.setMemento(description.createMemento());
                    } else {
                        description.setMemento(memento);
                    }
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, DescriptionManagerA.class.getName() + ".update", "362", this, new Object[]{string, byArray});
                if (!tc.isEventEnabled()) break block19;
                Tr.event(tc, "Unexpected: Unable to perform update", iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    public String keyToString(DescriptionKey descriptionKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyToString", descriptionKey);
        }
        if (descriptionKey == null) {
            throw new IllegalArgumentException("Identity parameter is a null reference.");
        }
        String string = null;
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            TreeMap treeMap = new TreeMap(descriptionKey.getProperties());
            dataOutputStream.writeByte(0);
            int n = treeMap.size();
            dataOutputStream.writeInt(n);
            Iterator iterator = treeMap.entrySet().iterator();
            for (int i = 0; i < n; ++i) {
                Map.Entry entry = iterator.next();
                dataOutputStream.writeUTF((String)entry.getKey());
                dataOutputStream.writeUTF((String)entry.getValue());
            }
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            dataOutputStream.close();
            string = Util.toHexString(byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterService.class.getName() + ".keyToString", "613", this, new Object[]{descriptionKey});
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(exception);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", exception);
            }
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyToString", string);
        }
        return string;
    }

    public DescriptionKey stringToKey(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToKey", string);
        }
        DescriptionKey descriptionKey = null;
        try {
            byte[] byArray = Util.fromHexString(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            dataInputStream.readByte();
            int n = dataInputStream.readInt();
            if (n < 0) {
                throw new Exception("Invalid count from stream, possible interop with v4 stream");
            }
            for (int i = 0; i < n; ++i) {
                String string2 = dataInputStream.readUTF();
                String string3 = dataInputStream.readUTF();
                hashMap.put(string2, string3);
            }
            dataInputStream.close();
            byteArrayInputStream.close();
            descriptionKey = keyRepository.getDescriptionKey(hashMap);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterService.class.getName() + ".stringToKey", "648", this, new Object[]{string});
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(exception);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", exception);
            }
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToKey", descriptionKey);
        }
        return descriptionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] aggregateMultipleInputs(Iterator iterator, Object object) {
        byte[] byArray = new byte[4];
        Object object2 = object;
        synchronized (object2) {
            short s = 0;
            byArray[0] = 2;
            while (iterator.hasNext()) {
                byte[] byArray2 = (byte[])iterator.next();
                s = (short)(s + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "count: " + s);
                    Tr.debug(tc, "data to aggregate: ", byArray2);
                }
                if (byArray2[1] == 1) {
                    byArray2 = Compressor.decompress(byArray2, 2);
                    byArray2[1] = 0;
                }
                byte[] byArray3 = new byte[byArray.length + byArray2.length + 4];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                byArray3[byArray.length] = byArray2[0];
                byArray3[byArray.length + 1] = byArray2[1];
                TypeConversion.intToBytes(byArray2.length - 2, byArray3, byArray.length + 2);
                System.arraycopy(byArray2, 2, byArray3, byArray.length + 6, byArray2.length - 2);
                byArray = byArray3;
            }
            TypeConversion.shortToBytes(s, byArray, 1);
        }
        if (byArray.length > 128) {
            byArray = Compressor.compress(byArray, 4);
            byArray[3] = 1;
        } else {
            byArray[3] = 0;
        }
        return byArray;
    }

    protected byte[][] divideMultipleInputs(byte[] byArray) {
        byte by = byArray[0];
        int n = TypeConversion.bytesToShort(byArray, 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "data Length" + byArray.length);
            Tr.debug(tc, "data is ", byArray);
        }
        byte by2 = byArray[3];
        byte[][] byArrayArray = new byte[n][];
        if (by2 == 1) {
            byArray = Compressor.decompress(byArray, 4);
        }
        int n2 = 4;
        for (int i = 0; i < n; ++i) {
            int n3 = TypeConversion.bytesToInt(byArray, n2 + 2);
            byte[] byArray2 = new byte[n3 + 2];
            byArray2[0] = byArray[n2];
            byArray2[1] = byArray[n2 + 1];
            System.arraycopy(byArray, n2 + 6, byArray2, 2, n3);
            byArrayArray[i] = byArray2;
            n2 = n2 + n3 + 6;
        }
        return byArrayArray;
    }

    protected byte[] getDatatFromDescription(Description description) {
        byte[] byArray;
        block4: {
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            byArray = null;
            OutputStream[] outputStreamArray = (OutputStream[])this.streamPool.remove();
            if (outputStreamArray == null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                outputStreamArray = new OutputStream[]{byteArrayOutputStream, dataOutputStream};
            } else {
                byteArrayOutputStream = (ByteArrayOutputStream)outputStreamArray[0];
                dataOutputStream = (DataOutputStream)outputStreamArray[1];
            }
            try {
                dataOutputStream.writeByte(1);
                dataOutputStream.writeByte(0);
                description.exportToStream(dataOutputStream, format);
                dataOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
                this.streamPool.add(outputStreamArray);
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, DescriptionManagerA.class.getName() + ".publish", "730", this, new Object[]{description});
                Tr.warning(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{DescriptionManagerA.class.getName() + ".publish", iOException});
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", iOException);
            }
        }
        return byArray;
    }

    protected void handleLocal(Description description, byte[] byArray) {
        block2: {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                dataInputStream.readByte();
                dataInputStream.readByte();
                description.setMemento(description.importFromStream(dataInputStream, format, null));
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, DescriptionManagerA.class.getName() + ".publish", "763", this, new Object[]{description});
                Tr.warning(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{DescriptionManagerA.class.getName() + ".publish", iOException});
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "unexpected", iOException);
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.16.1.1");
        }
        keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
        format = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 4);
    }
}

