/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.LSDClusterMemberDescription;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LSDClusterMemberDescriptionImpl
extends DescriptionA
implements LSDClusterMemberDescription {
    private static final TraceComponent tc = Tr.register(LSDClusterMemberDescriptionImpl.class, "ClusterConfigurationIIOP", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private String host = "";
    private int port = 0;
    private int sslPort = 0;
    private int sslccPort = 0;
    private DescriptionKey clusterMemberAssociation = null;
    private KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();

    public LSDClusterMemberDescriptionImpl(DescriptionKey descriptionKey) {
        super(descriptionKey);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", descriptionKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public String getDefinitionKey() {
        return LSDClusterMemberDescription.class.getName();
    }

    public void setHost(String string) {
        this.host = string;
        this.updateMemento();
    }

    public void setPort(int n) {
        this.port = n;
        this.updateMemento();
    }

    public void setSSLPort(int n) {
        this.sslPort = n;
        this.updateMemento();
    }

    public void setSSLClientCertificatePort(int n) {
        this.sslccPort = n;
        this.updateMemento();
    }

    public void setClusterMemberAssociation(DescriptionKey descriptionKey) {
        this.clusterMemberAssociation = descriptionKey;
        this.updateMemento();
    }

    public void exportToStream(DataOutput dataOutput, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        LSDClusterMemberDescription.Memento memento = null;
        if (format.getType() == 3) {
            memento = (LSDClusterMemberDescription.Memento)this.getMemento();
        }
        String string = this.host;
        DescriptionKey descriptionKey = this.clusterMemberAssociation;
        int n = this.port;
        int n2 = this.sslccPort;
        int n3 = this.sslPort;
        if (memento != null) {
            string = memento.getHost();
            descriptionKey = memento.getClusterMemberAssociation();
            n = memento.getPort();
            n2 = memento.getSSLClientCertificatePort();
            n3 = memento.getSSLPort();
        }
        dataOutput.writeByte(0);
        if (descriptionKey != null) {
            dataOutput.writeInt(1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote association length = 1");
            }
            this.keyRepository.exportToStream(dataOutput, descriptionKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote clusterMemberAssociation " + descriptionKey);
            }
        } else {
            dataOutput.writeInt(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote association length = 0");
            }
        }
        dataOutput.writeUTF(string);
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "wrote host: " + string);
        }
        dataOutput.writeInt(n);
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "wrote port: " + n);
        }
        dataOutput.writeInt(n3);
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "wrote ssl port: " + n3);
        }
        dataOutput.writeInt(n2);
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "wrote ssl cc port: " + n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public Description.Memento importFromStream(DataInput dataInput, Format format, Description.Memento memento) throws IOException {
        MementoImpl mementoImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((mementoImpl = (MementoImpl)memento) == null) {
            mementoImpl = (MementoImpl)this.createMemento();
        }
        dataInput.readByte();
        int n = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read association size " + n);
        }
        if (n > 0) {
            mementoImpl.m_clusterMemberAssociation = this.keyRepository.importFromStream(dataInput);
        }
        mementoImpl.m_host = dataInput.readUTF();
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "read host: " + mementoImpl.m_host);
        }
        mementoImpl.m_port = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "read port: " + mementoImpl.m_port);
        }
        mementoImpl.m_sslPort = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "read ssl port: " + mementoImpl.m_sslPort);
        }
        mementoImpl.m_sslccPort = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "read ssl cc port: " + mementoImpl.m_sslccPort);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return mementoImpl;
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public String toString() {
        LSDClusterMemberDescription.Memento memento = (LSDClusterMemberDescription.Memento)this.getMemento();
        if (memento != null) {
            return super.toString() + "[" + memento.getHost() + ":" + memento.getPort() + ":" + memento.getSSLPort() + ":" + memento.getSSLClientCertificatePort() + "]";
        }
        return super.toString() + "\n[null memento]\n";
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.8 ");
        }
    }

    public class MementoImpl
    extends DescriptionA.MementoA
    implements LSDClusterMemberDescription.Memento {
        private Concern concern = new ConcernImpl(2);
        private String m_host = "";
        private int m_port = 0;
        private int m_sslPort = 0;
        private int m_sslccPort = 0;
        private DescriptionKey m_clusterMemberAssociation = null;

        public Concern getConcern() {
            return this.concern;
        }

        public DescriptionKey getClusterMemberAssociation() {
            return this.m_clusterMemberAssociation;
        }

        public int getPort() {
            return this.m_port;
        }

        public int getSSLPort() {
            return this.m_sslPort;
        }

        public String getHost() {
            return this.m_host;
        }

        public int getSSLClientCertificatePort() {
            return this.m_sslccPort;
        }

        public String toString() {
            return super.toString() + "[" + this.m_host + ":" + this.m_port + ":" + this.m_sslPort + ":" + this.m_sslccPort + "]";
        }
    }
}

