/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.connmgmt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.connmgmt.ConnectionType;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.nio.ByteBuffer;
import java.util.Map;

public class ConnectionHandle {
    private static final TraceComponent tc = Tr.register(ConnectionHandle.class, "CFWEXT", null);
    public static final int CONNECTION_ID_LENGTH = 16;
    private static final byte LOCAL_COMM_FLAG = -128;
    private static final byte SSL_FLAG = 64;
    private static final byte SYSPLEX_FLAG = 32;
    protected static Object globalIDLock = new Object();
    protected static final String CONNECTION_HANDLE_VC_KEY = "CFW_CONNECTION_HANDLE";
    private static long nextConnectionId = 1L;
    private static int sharedSequenceNum = 0;
    private final long connID;
    private final int seqNum;
    private final boolean usedInternalIDs;
    private boolean isLocalComm;
    private boolean isSSL;
    private boolean isTCPWithinSysplex;
    private byte myType;

    public static ConnectionHandle getConnectionHandle(VirtualConnection virtualConnection) {
        Map map = virtualConnection.getStateMap();
        ConnectionHandle connectionHandle = (ConnectionHandle)map.get(CONNECTION_HANDLE_VC_KEY);
        if (connectionHandle != null) {
            return connectionHandle;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnectionHandle - creating new connection handle");
        }
        connectionHandle = new ConnectionHandle();
        ConnectionHandle.setConnectionHandle(connectionHandle, virtualConnection);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnectionHandle - handle created", connectionHandle);
        }
        return connectionHandle;
    }

    public static ConnectionHandle setConnectionHandle(VirtualConnection virtualConnection, ConnectionType connectionType, long l, int n, boolean bl) {
        ConnectionType.setVCConnectionType(virtualConnection, connectionType);
        return ConnectionHandle.setConnectionHandle(virtualConnection, l, n, bl);
    }

    public static ConnectionHandle setConnectionHandle(VirtualConnection virtualConnection, long l, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionHandle", "ptr=" + l + ", seq=" + n + ", isLocalComm=" + bl);
        }
        ConnectionHandle connectionHandle = new ConnectionHandle(l, n, bl);
        ConnectionHandle.setConnectionHandle(connectionHandle, virtualConnection);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionHandle", connectionHandle.toString());
        }
        return connectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setConnectionHandle(ConnectionHandle connectionHandle, VirtualConnection virtualConnection) {
        Object object;
        Map map = virtualConnection.getStateMap();
        Object object2 = object = virtualConnection.getLockObject();
        synchronized (object2) {
            Object v = map.get(CONNECTION_HANDLE_VC_KEY);
            if (v != null) {
                String string = "Connection " + v + " has already been created";
                throw new IllegalStateException(string);
            }
            if (v == null) {
                map.put(CONNECTION_HANDLE_VC_KEY, connectionHandle);
            }
        }
        if (connectionHandle != null) {
            connectionHandle.setConnectionType(virtualConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionHandle() {
        Object object = globalIDLock;
        synchronized (object) {
            if (nextConnectionId == Long.MAX_VALUE) {
                nextConnectionId = 1L;
                sharedSequenceNum = sharedSequenceNum == Integer.MAX_VALUE ? 0 : ++sharedSequenceNum;
            }
            this.connID = nextConnectionId++;
            this.seqNum = sharedSequenceNum;
            this.usedInternalIDs = true;
        }
        this.isLocalComm = false;
        this.myType = 0;
    }

    protected ConnectionHandle(long l, int n, boolean bl) {
        this.connID = l;
        this.seqNum = n;
        this.usedInternalIDs = false;
        this.isLocalComm = bl;
        this.myType = 0;
    }

    protected ConnectionHandle(long l, int n, ConnectionType connectionType) {
        this.connID = l;
        this.seqNum = n;
        this.usedInternalIDs = false;
        this.isLocalComm = false;
        this.myType = connectionType.export();
    }

    public ConnectionHandle(byte[] byArray) {
        if (byArray == null || byArray.length < 16) {
            throw new IllegalArgumentException("Cannot create a valid connection handle");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.connID = byteBuffer.getLong();
        this.seqNum = byteBuffer.getInt();
        this.usedInternalIDs = byteBuffer.get() == 1;
        byte by = byteBuffer.get();
        this.myType = byteBuffer.get();
        byte by2 = byteBuffer.get();
        this.isLocalComm = (by & 0xFFFFFF80) == -128;
        this.isSSL = (by & 0x40) == 64;
        this.isTCPWithinSysplex = (by & 0x20) == 32;
    }

    protected void setConnectionType(VirtualConnection virtualConnection) {
        if (this.myType == 0 || virtualConnection == null) {
            ConnectionType connectionType = ConnectionType.getVCConnectionType(virtualConnection);
            this.myType = connectionType == null ? (byte)0 : connectionType.export();
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[16];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.putBytes(byteBuffer);
        return byArray;
    }

    public void putBytes(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < 16) {
            throw new IllegalArgumentException("Could not add ConnectionHandle to byte buffer: not enough space.");
        }
        byte by = 0;
        if (this.isLocalComm) {
            by = (byte)(by | 0xFFFFFF80);
        }
        if (this.isSSL) {
            by = (byte)(by | 0x40);
        }
        if (this.isTCPWithinSysplex) {
            by = (byte)(by | 0x20);
        }
        byteBuffer.putLong(this.connID);
        byteBuffer.putInt(this.seqNum);
        byteBuffer.put((byte)(this.usedInternalIDs ? 1 : 0));
        byteBuffer.put(by);
        byteBuffer.put(this.myType);
        byteBuffer.put((byte)-1);
    }

    public void setIsLocalComm(boolean bl) {
        this.isLocalComm = bl;
    }

    public boolean getIsLocalComm() {
        return this.isLocalComm;
    }

    public void setIsSSL(boolean bl) {
        this.isSSL = bl;
    }

    public boolean getIsSSL() {
        return this.isSSL;
    }

    public void setIsTCPWithinSysplex(boolean bl) {
        this.isTCPWithinSysplex = bl;
    }

    public boolean getIsTCPWithinSysplex() {
        return this.isTCPWithinSysplex;
    }

    public boolean isOutbound() {
        if (this.myType == 0) {
            return false;
        }
        return ConnectionType.isOutbound(this.myType);
    }

    public boolean isInbound() {
        if (this.myType == 0) {
            return true;
        }
        return ConnectionType.isInbound(this.myType);
    }

    public boolean isInternal() {
        if (this.myType == 0) {
            return false;
        }
        return ConnectionType.isInternal(this.myType);
    }

    public boolean isSyncReadRequired() {
        if (this.myType == 0) {
            return false;
        }
        return ConnectionType.isSyncReadRequired(this.myType);
    }

    public ConnectionType getConnectionType() {
        return ConnectionType.getConnectionType(this.myType);
    }

    public boolean equals(Object object) {
        if (object.getClass() == ConnectionHandle.class) {
            ConnectionHandle connectionHandle = (ConnectionHandle)object;
            return connectionHandle.usedInternalIDs == this.usedInternalIDs && connectionHandle.connID == this.connID && connectionHandle.seqNum == this.seqNum;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.connID;
    }

    public String toString() {
        String string;
        if (this.isLocalComm) {
            string = "localcomm";
        } else if (this.isInternal()) {
            string = "server";
        } else {
            string = "remote";
            if (this.isSSL) {
                string = string + " SSL";
            }
            if (this.isTCPWithinSysplex) {
                string = string + " within sysplex";
            }
        }
        String string2 = this.myType == 0 ? "<type>" : ConnectionType.getConnectionType(this.myType).toString();
        return this.getClass().getSimpleName() + "[0x" + Long.toHexString(this.connID) + "/0x" + Integer.toHexString(this.seqNum) + "/" + string2 + "/" + string + "]";
    }
}

