/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.connmgmt;

import com.ibm.wsspi.channel.framework.VirtualConnection;

public final class ConnectionType {
    protected static final String CONNECTION_TYPE_VC_KEY = "CFW_CONNECTION_TYPE";
    private static final byte TYPE_OUTBOUND_MIN = 0;
    private static final byte TYPE_OUTBOUND_CLIENT = 1;
    private static final byte TYPE_OUTBOUND_SERVER = 2;
    private static final byte TYPE_OUTBOUND_CR_TO_REMOTE = 3;
    private static final byte TYPE_OUTBOUND_SR_TO_CR_REMOTE = 4;
    private static final byte TYPE_OUTBOUND_MAX = 10;
    private static final byte TYPE_INTERNAL_CR_SR = -1;
    private static final byte TYPE_INBOUND_MIN = 20;
    private static final byte TYPE_INBOUND_CLIENT = 21;
    private static final byte TYPE_INBOUND_SERVER = 22;
    private static final byte TYPE_INBOUND_CR = 23;
    private static final byte TYPE_INBOUND_MAX = 30;
    public static final ConnectionType OUTBOUND_CLIENT = new ConnectionType(1, "OUT:CLIENT");
    public static final ConnectionType OUTBOUND_CR_TO_REMOTE = new ConnectionType(3, "OUT:CR");
    public static final ConnectionType OUTBOUND_SR_TO_CR_REMOTE = new ConnectionType(4, "OUT:SR-CR");
    public static final ConnectionType INTERNAL_CR_SR = new ConnectionType(-1, "CR-SR");
    public static final ConnectionType INBOUND_CLIENT = new ConnectionType(21, "IN:CLIENT");
    public static final ConnectionType INBOUND_CR = new ConnectionType(23, "IN:CR");
    private final byte type;
    private final String typeString;

    public static ConnectionType getVCConnectionType(VirtualConnection virtualConnection) {
        if (virtualConnection == null) {
            return null;
        }
        return (ConnectionType)virtualConnection.getStateMap().get(CONNECTION_TYPE_VC_KEY);
    }

    public static void setVCConnectionType(VirtualConnection virtualConnection, ConnectionType connectionType) {
        if (virtualConnection == null || connectionType == null) {
            return;
        }
        virtualConnection.getStateMap().put(CONNECTION_TYPE_VC_KEY, connectionType);
    }

    public static ConnectionType getConnectionType(byte by) {
        switch (by) {
            case 1: {
                return OUTBOUND_CLIENT;
            }
            case 3: {
                return OUTBOUND_CR_TO_REMOTE;
            }
            case 4: {
                return OUTBOUND_SR_TO_CR_REMOTE;
            }
            case 21: {
                return INBOUND_CLIENT;
            }
            case 23: {
                return INBOUND_CR;
            }
            case -1: {
                return INTERNAL_CR_SR;
            }
        }
        return null;
    }

    static final boolean isOutbound(byte by) {
        return by > 0 && by < 10;
    }

    static final boolean isInbound(byte by) {
        return by > 20 && by < 30;
    }

    static final boolean isInternal(byte by) {
        return by < 0;
    }

    public static final boolean isSyncReadRequired(byte by) {
        switch (by) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private ConnectionType(byte by, String string) {
        this.type = by;
        this.typeString = string;
    }

    public byte export() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return ((ConnectionType)object).type == this.type;
    }

    public String toString() {
        return this.typeString;
    }
}

