/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.security.PrivilegedAction;

public class KeyReference {
    private static final TraceComponent tc = Tr.register(KeyReference.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private String keySetName = null;
    private String keyAlias = null;
    private int version = 1;
    private String password = null;
    private WSKeyStore kstore = null;
    private WSKeySet wsKeySet = null;

    public KeyReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference keyReference, WSKeySet wSKeySet, WSKeyStore wSKeyStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyReference");
        }
        this.kstore = wSKeyStore;
        this.keySetName = wSKeySet.getName();
        this.wsKeySet = wSKeySet;
        this.keyAlias = keyReference.getKeyAlias();
        this.version = keyReference.getVersion();
        this.password = keyReference.getPassword();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyReference", new Object[]{this.toString()});
        }
    }

    public String getKeyAlias() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyAlias");
        }
        String string2 = this.wsKeySet.getAliasPrefix();
        String string3 = string = this.keyAlias != null ? this.keyAlias : string2 + "_" + this.version;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyAlias -> " + string);
        }
        return string;
    }

    public int getVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersion");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVersion -> " + this.version);
        }
        return this.version;
    }

    public String getPassword() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPassword");
        }
        final WSKeySet wSKeySet = this.wsKeySet;
        String string2 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return wSKeySet.getPassword();
            }
        });
        String string3 = string = this.password != null ? this.password : string2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPassword -> " + SSLConfigManager.mask(string));
        }
        return string;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("KeyReference.toString() {\n");
        stringBuffer.append("keySetName = ");
        stringBuffer.append(this.getKeySetName());
        stringBuffer.append("\n");
        stringBuffer.append("keyAlias = ");
        stringBuffer.append(this.getKeyAlias());
        stringBuffer.append("\n");
        stringBuffer.append("version = ");
        stringBuffer.append(this.version);
        if (this.password != null && !this.password.equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append("password = ");
            stringBuffer.append(SSLConfigManager.mask(this.password));
        }
        stringBuffer.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return stringBuffer.toString();
    }

    public WSKeySet getWSKeySet() {
        return this.wsKeySet;
    }

    public String getKeySetName() {
        return this.wsKeySet.getName();
    }

    public WSKeyStore getWSKeyStore() {
        return this.kstore;
    }
}

