/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyGenerator;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;

public class WSKeyReference
extends KeyReference {
    private static final TraceComponent tc = Tr.register(WSKeyReference.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private Key key = null;
    private KeyGenerator keyGenerationClassImpl = null;
    private String keyGenerationClass = null;

    public WSKeyReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference keyReference, WSKeySet wSKeySet, WSKeyStore wSKeyStore) {
        super(keyReference, wSKeySet, wSKeyStore);
        this.keyGenerationClass = wSKeySet.getKeyGenerationClass();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyReference");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyReference", new Object[]{this.toString()});
        }
    }

    public WSKeyReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference keyReference, Key key, WSKeySet wSKeySet, WSKeyStore wSKeyStore) throws KeyException {
        super(keyReference, wSKeySet, wSKeyStore);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyReference (import key)");
        }
        try {
            this.keyGenerationClass = wSKeySet.getKeyGenerationClass();
            KeyStore keyStore = wSKeyStore.getKeyStore(false, false);
            this.importKey(key, keyStore);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSKeyPairReference import key initialization failed.", new Object[]{exception});
            }
            if (exception instanceof KeyException) {
                throw (KeyException)exception;
            }
            throw new KeyException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyReference (import key)", new Object[]{this.toString()});
        }
    }

    public Key getKey() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey");
        }
        if (this.key == null) {
            try {
                KeyStore keyStore = null;
                String string = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreName");
                String string2 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreType");
                String string3 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreProvider");
                String string4 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
                String string5 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
                String string6 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreScope");
                keyStore = KeyStoreManager.getInstance().getKeyStore(string, string2, string3, string4, string5, string6, true, null);
                if (keyStore != null) {
                    String string7 = this.getKeyAlias();
                    String string8 = this.getPassword();
                    this.key = keyStore.getKey(string7, string8.toCharArray());
                    if (this.key == null && this.isValidKeyStoreType()) {
                        this.key = this.initializeReferenceIfNotInKeyStore(keyStore);
                    }
                }
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception getting Key from KeyStore.", new Object[]{exception});
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSKeyReference.getKey", "129", this);
                Tr.error(tc, "crypto.key.getkey.error.CWPKI0201E", new Object[]{this.getKeySetName(), this.getKeyAlias(), exception.getMessage()});
                if (exception instanceof KeyException) {
                    throw (KeyException)exception;
                }
                throw new KeyException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey");
        }
        return this.key;
    }

    public Key initializeReferenceIfNotInKeyStore(KeyStore keyStore) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeReferenceIfNotInKeyStore", new Object[]{keyStore.getType(), keyStore.getProvider()});
        }
        FileOutputStream fileOutputStream = null;
        try {
            if (keyStore == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot generate keys because Java KeyStore cannot be obtained.");
                }
                throw new KeyException("Java KeyStore is NULL.");
            }
            if (this.keyGenerationClass == null || this.keyGenerationClass.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot generate keys as auto-generation class is not specified.");
                }
                throw new KeyException("Key is not present and keyGenerationClass is null.");
            }
            KeyGenerator keyGenerator = (KeyGenerator)this.getKeyGeneratorImpl();
            Key key = keyGenerator.generateKey();
            if (key != null) {
                String string = this.getKeyAlias();
                String string2 = this.getPassword();
                keyStore.setKeyEntry(string, key, string2.toCharArray(), null);
                String string3 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
                String string4 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
                fileOutputStream = new FileOutputStream(string3);
                keyStore.store(fileOutputStream, string4.toCharArray());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initializeReferenceIfNotInKeyStore (generated)");
                }
                Key key2 = key;
                return key2;
            }
            try {
                throw new KeyException("KeyGenerator " + this.keyGenerationClass + " did not return a Key.");
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception generating Key.", new Object[]{exception});
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSKeySet.generate", "196", this);
                Tr.error(tc, "crypto.key.generate.configuration.error.CWPKI0200E", new Object[]{this.getKeySetName(), exception.getMessage()});
                if (exception instanceof KeyException) {
                    throw (KeyException)exception;
                }
                throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.generate.configuration.error.CWPKI0200E", new Object[]{this.getKeySetName(), exception.getMessage()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys.  The detailed message is: " + exception.getMessage()));
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void importKey(Key key, KeyStore keyStore) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importKey");
        }
        FileOutputStream fileOutputStream = null;
        try {
            if (keyStore == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot update keys because Java KeyStore cannot be obtained.");
                }
                throw new KeyException("Java KeyStore is NULL.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore type is \"" + keyStore.getType() + "\" and the provider is \"" + keyStore.getProvider() + "\".");
            }
            if (key == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot updates keys as the Key is not specified.");
                }
                throw new KeyException("Key was not passed in.");
            }
            String string = this.getKeyAlias();
            String string2 = this.getPassword();
            keyStore.setKeyEntry(string, key, string2.toCharArray(), null);
            String string3 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
            String string4 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
            fileOutputStream = new FileOutputStream(string3);
            keyStore.store(fileOutputStream, string4.toCharArray());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importKey (imported)");
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception updating KeyStore with keys.", new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSKeyPairReference.importKey", "263", this);
            Tr.error(tc, "crypto.key.import.error.CWPKI0203E", new Object[]{this.getKeySetName(), exception.getMessage()});
            if (exception instanceof KeyException) {
                throw (KeyException)exception;
            }
            throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.import.error.CWPKI0203E", new Object[]{this.getKeySetName(), exception.getMessage()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys.  The detailed message is: " + exception.getMessage()));
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Object getKeyGeneratorImpl() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyGeneratorImpl");
        }
        if (this.keyGenerationClassImpl == null) {
            if (this.keyGenerationClass != null && !this.keyGenerationClass.equals("")) {
                Object object;
                Object var1_1;
                block11: {
                    var1_1 = null;
                    try {
                        object = Class.forName(this.keyGenerationClass);
                        var1_1 = ((Class)object).newInstance();
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "Could not load using class using current class loader.");
                    }
                }
                if (var1_1 == null) {
                    object = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(this.keyGenerationClass, true, (ClassLoader)object);
                    var1_1 = clazz.newInstance();
                }
                if (var1_1 != null && var1_1 instanceof KeyGenerator) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Instantiating new KeyGenerator: " + this.keyGenerationClass);
                    }
                    this.keyGenerationClassImpl = var1_1;
                    if (this.getWSKeySet().getCustomProperties() != null) {
                        this.keyGenerationClassImpl.init(this.getWSKeySet().getCustomProperties());
                    }
                    return this.keyGenerationClassImpl;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getKeyGeneratorImpl is not an implementation of KeyGenerator.");
                }
                throw new KeyException("The custom key generator class " + this.keyGenerationClass + " is not an implementation of com.ibm.websphere.crypto.KeyGenerator.");
            }
            Tr.error(tc, "crypto.key.generate.configuration.error.CWPKI0202E", new Object[]{this.getKeySetName()});
            throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.generate.configuration.error.CWPKI0202E", new Object[]{this.getKeySetName()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyGeneratorImpl");
        }
        return this.keyGenerationClassImpl;
    }

    private boolean isValidKeyStoreType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidKeyStoreType");
        }
        if (this.getWSKeyStore() != null) {
            String string = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreReadOnly");
            if (string == null || string.equals("")) {
                string = this.getWSKeyStore().getProperty("com.ibm.ssl.trustStoreReadOnly");
            }
            if (string != null && string.equals("true")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidKeyStoreType (readonly) -> false");
                }
                return false;
            }
            String string2 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreType");
            if (string2 == null || string2.equals("")) {
                string2 = this.getWSKeyStore().getProperty("com.ibm.ssl.trustStoreType");
            }
            if (string2 != null && (string2.equals("JCEKS") || string2.equals("JCECCAKS"))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidKeyStoreType -> true");
                }
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidKeyStoreType -> false keyStoreType is " + string2);
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidKeyStoreType (null keystore) -> false");
        }
        return false;
    }
}

