/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.models.config.ipc.ssl.WSSchedule;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class WSScheduler
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(WSScheduler.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String name = null;
    int frequency = 90;
    int dayOfWeek = 7;
    int hour = 23;
    int minute = 0;
    long timeout = -1L;
    long nextStartLong = 0L;
    AlarmListener alarmListener = null;
    private static ConcurrentHashMap alarmMap = new ConcurrentHashMap();
    private static Object _lockObj = new Object();
    private static String _debug_interval = System.getProperty("com.ibm.ws.crypto.config.debugInterval");
    private static boolean isSecurityReady = false;
    private static boolean isSecurityEnabled = false;
    private static boolean isSecurityEnabledChecked = false;
    private static boolean isSecurityFailure = false;
    private static long lastAlarm = 0L;

    public WSScheduler(WSSchedule wSSchedule, AlarmListener alarmListener) {
        this.WSSchedulerInit(wSSchedule, alarmListener, "<nullstring>");
    }

    public WSScheduler(WSSchedule wSSchedule, AlarmListener alarmListener, String string) {
        this.WSSchedulerInit(wSSchedule, alarmListener, string);
    }

    private void WSSchedulerInit(WSSchedule wSSchedule, AlarmListener alarmListener, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSScheduler");
        }
        this.nextStartLong = wSSchedule.getNextStartDate();
        long l = System.currentTimeMillis();
        if (string != null) {
            AlarmObject alarmObject = (AlarmObject)alarmMap.get(string);
            if (tc.isDebugEnabled() && alarmObject != null) {
                Tr.debug(tc, "Time difference between current time and nextStart time: " + (this.nextStartLong - l));
                Tr.debug(tc, "Time difference between nextStart in alarm and security.xml: " + (alarmObject.getNextStartLong() - this.nextStartLong));
                Tr.debug(tc, "nextStart in Alarm:" + alarmObject.getNextStartLong() + " nextStart in security.xml:" + this.nextStartLong + " CurrentTime:" + l);
            }
            if (alarmObject != null && (this.nextStartLong < l || this.nextStartLong == alarmObject.getNextStartLong())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "WSScheduler; skip processing due to a duplicate call.");
                }
                return;
            }
        }
        this.name = wSSchedule.getName();
        this.frequency = wSSchedule.getFrequency();
        this.dayOfWeek = wSSchedule.getDayOfWeek();
        this.hour = wSSchedule.getHour();
        this.minute = wSSchedule.getMinute();
        this.alarmListener = alarmListener;
        try {
            Object object;
            long l2 = 0L;
            if (this.nextStartLong > 0L) {
                l = System.currentTimeMillis();
                if (this.nextStartLong > l) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Next alarm scheduled for: " + new Date(this.nextStartLong));
                    }
                    l2 = this.nextStartLong - l;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Alarm is past, Next alarm scheduled for: " + new Date(l + 60000L));
                    }
                    l2 = 60000L;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Time could not be read from the configuration.");
                }
                object = this.getNextEventDateFromNow();
                this.nextStartLong = ((Date)object).getTime();
                this.updateNextStartDate(this.name, new Long(this.nextStartLong));
                l2 = this.nextStartLong - l;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next alarm generated from today's date, scheduled for: " + object);
                }
            }
            object = AlarmManager.createDeferrable(l2, this, string);
            this.setAlarm(string, this.nextStartLong, (Alarm)object);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.crypto.config.WSScheduler.WSSchedulerInit", "145", this, new Object[]{exception});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception generating schedule.", new Object[]{exception});
            }
            Tr.error(tc, "ssl.schedule.init.error.CWPKI0034E", new Object[]{exception.getMessage()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSScheduler", new Object[]{this.toString()});
        }
    }

    public WSScheduler(int n, int n2, int n3, int n4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSScheduler");
        }
        this.frequency = n;
        this.dayOfWeek = n2;
        this.hour = n3;
        this.minute = n4;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSScheduler", new Object[]{this.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        Object object2 = _lockObj;
        synchronized (object2) {
            String string = null;
            long l = 0L;
            if (object != null && object instanceof String) {
                string = (String)object;
                AlarmObject alarmObject = (AlarmObject)alarmMap.get(string);
                if (alarmObject != null) {
                    l = alarmObject.getNextStartLong();
                }
                alarmMap.remove(string);
            }
            boolean bl = this.isSecurityReady();
            if ((this.isAlarmFired(120) || !bl) && l != 0L) {
                long l2 = 120L;
                if (!bl) {
                    l2 = 30L;
                }
                Alarm alarm = AlarmManager.createDeferrable(l2 * 1000L, this, string);
                this.setAlarm(string, l, alarm);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "An Alarm was fired within one minute, or Security Service is not ready, Retry is scheduled in " + l2 + " seconds");
                }
            } else if (this.isSecurityFailure() || l == 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security Service Failure, an alarm won't be fired.");
                }
            } else {
                Date date = this.getNextEventDateFromNow();
                this.nextStartLong = date.getTime();
                Alarm alarm = AlarmManager.createDeferrable(this.nextStartLong - System.currentTimeMillis(), this, string);
                this.setAlarm(string, this.nextStartLong, alarm);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next alarm generated by an alarm, scheduled for: " + date);
                }
                try {
                    this.setAlarmFired();
                    this.alarmListener.alarm(object);
                    this.updateNextStartDate(this.name, new Long(date.getTime()));
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.crypto.config.WSScheduler.alarm", "221", this, new Object[]{exception});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception generating schedule.", new Object[]{exception});
                    }
                    Tr.error(tc, "ssl.schedule.init.error.CWPKI0034E", new Object[]{exception.getMessage()});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    public Date getNextEventDateFromNow() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextEventDateFromNow");
        }
        Calendar calendar = Calendar.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextEventDateFromNow", new Object[]{calendar.getTime()});
        }
        return this.computeDate(calendar);
    }

    public Date getNextEventDateFromDate(Date date) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextEventDateFromDate");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextEventDateFromDate", new Object[]{calendar.getTime()});
        }
        return this.computeDate(calendar);
    }

    public Date computeDate(Calendar calendar) {
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "computeDate");
        }
        if (this.hour < 24) {
            calendar.set(11, this.hour);
        }
        if (this.minute < 60) {
            calendar.set(12, this.minute);
        }
        int n3 = calendar.get(6);
        int n4 = calendar.get(1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "currentDay = " + n3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "currentYear = " + n4);
        }
        if ((n2 = n3 + this.frequency) > 365) {
            calendar.set(6, n2 -= 365);
            calendar.set(1, ++n4);
        } else {
            calendar.set(6, n2);
        }
        if (this.dayOfWeek > 0 && this.dayOfWeek < 8) {
            int n5 = 0;
            n = calendar.get(7);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dayOfWeek (preferred) = " + this.dayOfWeek);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentDayOfWeek = " + n);
            }
            if (n != this.dayOfWeek) {
                n5 = n - this.dayOfWeek;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "delta (dayOfWeek) = " + n5);
                }
                if (n2 - n5 <= 0) {
                    n2 = n2 - n5 + 365;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nextDay (w/delta) = " + n2);
                    }
                    calendar.set(6, n2);
                    --n4;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentYear = " + n4);
                    }
                    calendar.set(1, n4);
                } else if (n2 - n5 > 365) {
                    n2 = n2 - n5 - 365;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nextDay (w/delta) = " + n2);
                    }
                    calendar.set(6, n2);
                    ++n4;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentYear = " + n4);
                    }
                    calendar.set(1, n4);
                } else {
                    n2 -= n5;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nextDay (w/delta) = " + n2);
                    }
                    calendar.set(6, n2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentYear = " + n4);
                    }
                }
            }
        }
        Date date = calendar.getTime();
        if (_debug_interval != null && _debug_interval.length() > 0) {
            n = Integer.parseInt(_debug_interval);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.set(14, 0);
            calendar2.set(13, 0);
            date = new Date(calendar2.getTime().getTime() + (long)(n * 60000));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "computeDate-Debug code", new Object[]{new Integer(n), date});
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "computeDate", new Object[]{date});
        }
        return date;
    }

    public void updateNextStartDate(String string, Long l) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateNextStartDate");
            }
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.ssl.utils.SchedulerCommandHelper");
                Method method2 = clazz.getMethod("updateNextStartDate", String.class, Long.class);
                method2.invoke(clazz.newInstance(), string, l);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSScheduler.updateNextStartDate", "361", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception updating next start date.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNextStartDate");
        }
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WSScheduler.toString() {\n");
        stringBuffer.append("name = ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        stringBuffer.append("frequency = ");
        stringBuffer.append(this.frequency);
        stringBuffer.append("\n");
        stringBuffer.append("dayOfWeek = ");
        stringBuffer.append(this.dayOfWeek);
        stringBuffer.append("\n");
        stringBuffer.append("hour = ");
        stringBuffer.append(this.hour);
        stringBuffer.append("\n");
        stringBuffer.append("minute = ");
        stringBuffer.append(this.minute);
        stringBuffer.append("\n");
        stringBuffer.append("nextStartLong = ");
        stringBuffer.append(this.nextStartLong);
        stringBuffer.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return stringBuffer.toString();
    }

    private void cancelAlarm(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelAlarm  key:" + string);
        }
        if (string != null) {
            Alarm alarm = null;
            AlarmObject alarmObject = (AlarmObject)alarmMap.get(string);
            if (alarmObject != null) {
                alarm = alarmObject.getAlarm();
            }
            if (alarm != null) {
                boolean bl = AlarmManager.disableAlarm(alarm);
                alarmMap.remove(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "disableAlarm:" + bl + "  size:" + alarmMap.size());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelAlarm");
        }
    }

    private void setAlarm(String string, long l, Alarm alarm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAlarm  key:" + string + "  Alarm:" + alarm + "Next Start:" + l);
        }
        if (string != null && alarm != null) {
            this.cancelAlarm(string);
            alarmMap.put(string, new AlarmObject(l, alarm));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "store Alarm.. size:" + alarmMap.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAlarm");
        }
    }

    private void setAlarmFired() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAlarmFired");
        }
        lastAlarm = System.currentTimeMillis();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAlarmFired " + lastAlarm);
        }
    }

    private boolean isAlarmFired(int n) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlarmFired range:" + n);
        }
        if (System.currentTimeMillis() - lastAlarm < (long)(n * 1000)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlarmFired " + bl);
        }
        return bl;
    }

    private boolean isSecurityFailure() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityFailure" + isSecurityFailure);
        }
        return isSecurityFailure;
    }

    private boolean isSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityEnabled");
        }
        if (!isSecurityEnabledChecked) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                Method method2 = clazz.getMethod("getInstance", null);
                Object object = method2.invoke(null, null);
                Class<?> clazz2 = Class.forName("com.ibm.ws.security.core.ContextManager");
                Method method3 = clazz2.getMethod("isCellSecurityEnabled", null);
                Boolean bl = (Boolean)method3.invoke(object, null);
                isSecurityEnabled = bl;
                isSecurityEnabledChecked = true;
                isSecurityFailure = false;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSScheduler.isSecurityEnabled", "513", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isSecurityEnabled() call failed.", new Object[]{exception});
                }
                isSecurityFailure = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityEnabled" + isSecurityEnabled);
        }
        return isSecurityEnabled;
    }

    public boolean isSecurityReady() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityReady");
        }
        if (!isSecurityReady) {
            if (!this.isSecurityEnabled() && !this.isSecurityFailure()) {
                isSecurityReady = true;
            } else {
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                    Method method2 = clazz.getMethod("getInstance", null);
                    Object object = method2.invoke(null, null);
                    Class<?> clazz2 = Class.forName("com.ibm.ws.security.core.ContextManager");
                    Method method3 = clazz2.getMethod("isSecurityServiceStarted", null);
                    Boolean bl = (Boolean)method3.invoke(object, null);
                    isSecurityReady = bl;
                    isSecurityFailure = false;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSScheduler.isSecurityReady", "549", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isSecurityReady() call failed.", new Object[]{exception});
                    }
                    isSecurityFailure = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityReady" + isSecurityReady);
        }
        return isSecurityReady;
    }

    class AlarmObject {
        Alarm _alarmObj = null;
        long _nextStartLong = 0L;

        AlarmObject() {
        }

        AlarmObject(long l, Alarm alarm) {
            this._alarmObj = alarm;
            this._nextStartLong = l;
        }

        Alarm getAlarm() {
            return this._alarmObj;
        }

        long getNextStartLong() {
            return this._nextStartLong;
        }
    }
}

