/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.AfterActivationCollaborator;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.compensationservice.CompensationService;
import com.ibm.websphere.models.config.pmeserver.PME51ServerExtension;
import com.ibm.websphere.models.config.serverindex.RecoveryLog;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.activity.WebSphereUserActivity;
import com.ibm.ws.cscope.CScopeAfterActivationCollaborator;
import com.ibm.ws.cscope.CScopeLogConfiguration;
import com.ibm.ws.cscope.CScopeMetaDataListener;
import com.ibm.ws.cscope.CScopeRecoveryAgent;
import com.ibm.ws.cscope.CScopeService;
import com.ibm.ws.cscope.CScopeServiceManager;
import com.ibm.ws.cscope.CScopeSystemException;
import com.ibm.ws.cscope.CScopeXAResourceInfo;
import com.ibm.ws.cscope.CompensatorWrapper;
import com.ibm.ws.cscope.RecoveryManager;
import com.ibm.ws.cscope.UserCompensationScopeImpl;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityManager;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.MethodMetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.wccm.services.pme.metadata.MetaDataHelperService;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CScopeComponentImpl
extends WsComponentImpl
implements PropertyChangeListener {
    private static boolean _started;
    private static final TraceComponent tc;
    private static ActivityManager _actMgr;
    private static WebSphereUserActivity _webSphereUserActivity;
    private static RecoveryLogManager _recoveryLogManager;
    private static com.ibm.ws.recoverylog.spi.RecoveryLog _recoveryLog;
    private static RecoveryDirector _recoveryDirector;
    private static int _recoveryId;
    private static boolean _serverStarted;
    private static boolean _serverStopping;
    private static boolean _enabled;
    private static CScopeComponentImpl _instance;
    private static boolean _peerRecoveryRestartMode;
    private static HashMap _logConfigurations;

    public CScopeComponentImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CScopeComponentImpl");
        }
        _instance = this;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CScopeComponentImpl", this);
        }
    }

    public void initializeAndStartForPRR(FailureScope failureScope) throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeAndStartForPRR", new Object[]{failureScope, this});
        }
        try {
            CompensationService compensationService = this.lookupCompensationService();
            this.processConfiguration(compensationService, false);
            Tr.info(tc, "INF_STARTED");
            _started = true;
        }
        catch (ConfigurationError configurationError) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "config could not be loaded manually: assume disabled");
            }
            Tr.info(tc, "INF_NOT_ENABLED");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeAndStartForPRR", configurationError);
            }
            throw configurationError;
        }
        catch (CScopeSystemException cScopeSystemException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeAndStartForPRR", cScopeSystemException);
            }
            throw cScopeSystemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeAndStartForPRR");
        }
    }

    private void registerWithRLS() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerWithRLS", this);
        }
        try {
            _recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
            CScopeRecoveryAgent cScopeRecoveryAgent = new CScopeRecoveryAgent(_recoveryDirector);
            _recoveryLogManager = _recoveryDirector.registerService(cScopeRecoveryAgent, 3);
            RecoveryManager.setRecoveryLogManager(_recoveryLogManager);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeComponentImpl.registerWithRLS", "171", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception when registering with recovery log", exception);
            }
            Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"registerWithRLS", "CScopeComponentImpl", exception});
            Tr.error(tc, "ERR_NO_SERVICE", "Recovery Log");
            _enabled = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerWithRLS", "RuntimeWarning");
            }
            throw new RuntimeWarning(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerWithRLS");
        }
    }

    public void initialize(Object object) throws ConfigurationError {
        Server server2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object, this});
        }
        if (object != null && object instanceof CompensationService) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "config is not null - try to extract values");
            }
            server2 = (CompensationService)object;
            this.processConfiguration((CompensationService)server2, true);
        }
        try {
            server2 = (Server)WsServiceRegistry.getService((Object)this, (Class)Server.class);
            if (server2.getServerMode() == 1) {
                _peerRecoveryRestartMode = true;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeComponentImpl.initialize", "217", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", "ConfigurationError");
            }
            throw new ConfigurationError(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void processConfiguration(CompensationService compensationService, boolean bl) throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processConfiguration", new Object[]{compensationService, new Boolean(bl), this});
        }
        _enabled = compensationService.isEnable();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enable is: " + _enabled);
        }
        if (_enabled) {
            int n = compensationService.getCompensationHandlerRetryLimit();
            int n2 = 1000 * compensationService.getCompensationHandlerRetryInterval();
            UserCompensationScopeImpl.setCompensatorRetryInterval(n2);
            UserCompensationScopeImpl.setCompensatorRetryLimit(n);
            if (bl) {
                try {
                    Server server2 = (Server)WsServiceRegistry.getService((Object)this, (Class)Server.class);
                    server2.addPropertyChangeListener("state", this);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeComponentImpl.processConfiguration", "254", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "processConfiguration", "ConfigurationError");
                    }
                    throw new ConfigurationError(exception);
                }
            }
            CScopeService.setEnabled();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "config is disabled");
            }
            Tr.info(tc, "INF_NOT_ENABLED");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processConfiguration");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", this);
        }
        if (!_enabled) {
            if (_peerRecoveryRestartMode) {
                this.registerWithRLS();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start");
            }
            return;
        }
        this.registerWithRLS();
        MetaDataService metaDataService = null;
        MetaDataHelperService metaDataHelperService = null;
        MetaDataSlot metaDataSlot = null;
        CScopeMetaDataListener cScopeMetaDataListener = null;
        try {
            metaDataService = (MetaDataService)WsServiceRegistry.getService((Object)this, (Class)MetaDataService.class);
            metaDataSlot = metaDataService.reserveSlot(MethodMetaData.class);
            metaDataHelperService = (MetaDataHelperService)WsServiceRegistry.getService((Object)this, (Class)MetaDataHelperService.class);
            object2 = (MetaDataFactoryMgr)WsServiceRegistry.getService((Object)this, (Class)MetaDataFactoryMgr.class);
            cScopeMetaDataListener = new CScopeMetaDataListener(object2.getJ2EENameFactory(), metaDataHelperService, metaDataSlot);
            metaDataService.addMetaDataListener(cScopeMetaDataListener);
            object = (ApplicationMgr)WsServiceRegistry.getService((Object)this, (Class)ApplicationMgr.class);
            object.addDeployedObjectListener(cScopeMetaDataListener);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeComponentImpl.start", "195", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught registering with meta data service", exception);
            }
            Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"start", "CScopeComponentImpl", exception});
            if (metaDataService == null) {
                Tr.error(tc, "ERR_NO_SERVICE", "Meta Data");
            } else if (metaDataHelperService == null) {
                Tr.error(tc, "ERR_NO_SERVICE", "Meta Data Helper");
            }
            _enabled = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start", "RuntimeWarning");
            }
            throw new RuntimeWarning(exception);
        }
        object2 = null;
        try {
            object2 = (EJBContainer)WsServiceRegistry.getService((Object)this, (Class)EJBContainer.class);
            object = new CScopeAfterActivationCollaborator(metaDataSlot);
            object2.addCollaborator((AfterActivationCollaborator)object);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeComponentImpl.start", "241", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexception exception caught add collaborator to EJB container", exception);
            }
            Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"start", "ComponentImpl", exception});
            if (object2 == null) {
                Tr.error(tc, "ERR_NO_SERVICE", EJBContainer.class);
            }
            _enabled = false;
            metaDataService.removeMetaDataListener(cScopeMetaDataListener);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start", "RuntimeWarning");
            }
            throw new RuntimeWarning(exception);
        }
        try {
            object = new InitialContext();
            _actMgr = (ActivityManager)((InitialContext)object).lookup("services:websphere/ActivityManager");
            _webSphereUserActivity = (WebSphereUserActivity)((Object)_actMgr);
            FailureScope failureScope = _recoveryDirector.currentFailureScope();
            _actMgr.registerService(new CScopeServiceManager(failureScope, this.getLogConfiguration(failureScope).getLogDirectory()));
            _actMgr.setTimeout(-1);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.cscope.CScopeComponentImpl.start", "311", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Lookup of ActivityManager failed", namingException);
            }
            Tr.error(tc, "ERR_NO_SERVICE", "Activity");
            _enabled = false;
            metaDataService.removeMetaDataListener(cScopeMetaDataListener);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start", "RuntimeWarning");
            }
            throw new RuntimeWarning(namingException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeComponentImpl.start", "327", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception from the Activity service", exception);
            }
            Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"start", "CScopeComponentImpl", exception});
            _enabled = false;
            metaDataService.removeMetaDataListener(cScopeMetaDataListener);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start", "RuntimeWarning");
            }
            throw new RuntimeWarning(exception);
        }
        Tr.info(tc, "INF_STARTED");
        _started = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        _serverStopping = true;
    }

    public void destroy() {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "destroy", this);
            }
            if (!_enabled) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "destroy - not enabled");
                }
                return;
            }
            String string = "WebSphere:type=TransactionService,*";
            String string2 = "listOfTransactions";
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName objectName = new ObjectName(string);
                Set set = adminService.queryNames(objectName, null);
                if (!set.isEmpty()) {
                    ObjectName objectName2 = (ObjectName)set.iterator().next();
                    String[] stringArray = (String[])adminService.invoke(objectName2, string2, null, null);
                    if (stringArray == null || stringArray.length == 0) {
                        if (_recoveryLog != null) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Closing cscope recovery log");
                            }
                            _recoveryLog.closeLog();
                        }
                    } else if (tc.isEventEnabled()) {
                        Tr.event(tc, "Active transactions exist - cscope recovery log not closed");
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event(tc, "Transaction Service MBean was not found - cscope recovery log not closed");
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException(malformedObjectNameException, "com.ibm.ws.cscope.CScopeComponentImpl.destroy", "351");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught retrieving Transaction Service MBean", malformedObjectNameException);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.cscope.CScopeComponentImpl.destroy", "355");
                if (!tc.isEventEnabled()) break block16;
                Tr.event(tc, "Exception caught while querying admin service", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public static ActivityManager getActivityManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivityManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivityManager", _actMgr);
        }
        return _actMgr;
    }

    protected static int getRecoveryId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryId");
        }
        if (_recoveryId == -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering resource info with transaction service");
            }
            CScopeXAResourceInfo cScopeXAResourceInfo = new CScopeXAResourceInfo(_recoveryDirector.currentFailureScope());
            _recoveryId = TransactionManagerFactory.getTransactionManager().registerResourceInfo("com.ibm.ws.cscope.CScopeXAResourceFactory", (XAResourceInfo)cScopeXAResourceInfo, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryId", new Integer(_recoveryId));
        }
        return _recoveryId;
    }

    protected static com.ibm.ws.recoverylog.spi.RecoveryLog getRecoveryLog() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryLog");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryLog", _recoveryLog);
        }
        return _recoveryLog;
    }

    protected static void setRecoveryLog(com.ibm.ws.recoverylog.spi.RecoveryLog recoveryLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRecoveryLog", recoveryLog);
        }
        _recoveryLog = recoveryLog;
        try {
            _recoveryLog.openLog();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.cscope.CScopeComponentImpl.setRecoveryLog", "562");
            _recoveryLog = null;
            Tr.error(tc, "ERR_PERSIST_FAILURE", exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setRecoveryLog", "CScopeSystemException");
            }
            throw new CScopeSystemException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRecoveryLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertyChange", new Object[]{propertyChangeEvent, this});
        }
        _serverStarted = (string = (String)propertyChangeEvent.getNewValue()).equals("STARTED");
        Object object = CompensatorWrapper.RETRY_LOCK;
        synchronized (object) {
            CompensatorWrapper.RETRY_LOCK.notifyAll();
        }
        object = CScopeRecoveryAgent.getInstance();
        if (object != null) {
            ((CScopeRecoveryAgent)object).setServerStatus(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertyChange");
        }
    }

    protected static boolean isServerStarted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerStarted");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerStarted", Boolean.toString(_serverStarted));
        }
        return _serverStarted;
    }

    protected static boolean isEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEnabled");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEnabled", Boolean.toString(_enabled));
        }
        return _enabled;
    }

    protected static WebSphereUserActivity getWebSphereUserActivity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWebSphereUserActivity");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebSphereUserActivity", _webSphereUserActivity);
        }
        return _webSphereUserActivity;
    }

    private CompensationService lookupCompensationService() throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupCompensationService", this);
        }
        CompensationService compensationService = null;
        Repository repository2 = null;
        try {
            repository2 = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
            PME51ServerExtension pME51ServerExtension = (PME51ServerExtension)repository2.getConfigRoot().getResource(4, "server-pme51.xml").getContents().get(0);
            compensationService = pME51ServerExtension.getCompensationService();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeComponentImpl.lookupCompensationService", "756", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Could not lookup compensation service in config", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "lookupCompensationService", "ConfigurationError");
            }
            throw new ConfigurationError(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupCompensationService", compensationService);
        }
        return compensationService;
    }

    public static CScopeComponentImpl getInstance() {
        return _instance;
    }

    public boolean isStarted() {
        return _started;
    }

    protected static boolean isPeerRecoveryRestartMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPeerRecoveryRestartMode");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPeerRecoveryRestartMode", Boolean.toString(_peerRecoveryRestartMode));
        }
        return _peerRecoveryRestartMode;
    }

    protected CScopeLogConfiguration getLogConfiguration(FailureScope failureScope) {
        CScopeLogConfiguration cScopeLogConfiguration;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLogConfiguration", new Object[]{failureScope, this});
        }
        if ((cScopeLogConfiguration = (CScopeLogConfiguration)_logConfigurations.get(failureScope)) == null) {
            RecoveryLog recoveryLog = _recoveryDirector.getRecoveryLogConfiguration(failureScope);
            if (recoveryLog != null) {
                String string = this.expandVariable(recoveryLog.getCompensationLogDirectory());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Log directory from configuration", string);
                }
                if (string != null && string.length() == 0) {
                    string = null;
                }
                int n = recoveryLog.getCompensationLogFileSize();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Maximum log size from configuration", new Integer(n));
                }
                if ((n *= 1024) < RecoveryManager.INITIAL_LOG_SIZE) {
                    n = RecoveryManager.INITIAL_LOG_SIZE;
                }
                cScopeLogConfiguration = new CScopeLogConfiguration(n, string);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No log configuration data found. Using default values.");
                }
                cScopeLogConfiguration = new CScopeLogConfiguration();
            }
            _logConfigurations.put(failureScope, cScopeLogConfiguration);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLogConfiguration", cScopeLogConfiguration);
        }
        return cScopeLogConfiguration;
    }

    public static boolean isServerStopping() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerStopping");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerStopping", _serverStopping);
        }
        return _serverStopping;
    }

    static {
        tc = Tr.register(CScopeComponentImpl.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
        _actMgr = null;
        _webSphereUserActivity = null;
        _recoveryLogManager = null;
        _recoveryLog = null;
        _recoveryDirector = null;
        _recoveryId = -1;
        _serverStarted = false;
        _serverStopping = false;
        _enabled = false;
        _instance = null;
        _peerRecoveryRestartMode = false;
        _logConfigurations = new HashMap();
    }
}

