/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.WebSphereActivityCoordinator;
import com.ibm.ws.cscope.CScope;
import com.ibm.ws.cscope.CScopeComponentImpl;
import com.ibm.ws.cscope.CScopeSubordImpl;
import com.ibm.ws.cscope.CScopeSystemException;
import com.ibm.ws.cscope.CompensationFailedException;
import com.ibm.ws.cscope.Compensator;
import com.ibm.ws.cscope.CompensatorRecord;
import com.ibm.ws.cscope.CompensatorWrapper;
import com.ibm.ws.cscope.CompletedParentCScope;
import com.ibm.ws.cscope.RecoveredData;
import com.ibm.ws.cscope.RetryAlarmContext;
import com.ibm.ws.cscope.RetryCompensatorException;
import com.ibm.ws.cscope.util.TraceUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.javax.activity.ServiceNotRegisteredException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroup;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class CScopeImpl
implements CScope,
PropertyGroup {
    private static final TraceComponent tc = Tr.register(CScopeImpl.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    protected static final int GLOBALID_RUS_ID = 0;
    protected static final int CSCOPE_TYPE_RUS_ID = 1;
    protected static final int COMPENSATOR_RUS_ID = 2;
    protected static final int PARENT_GLOBALID_RUS_ID = 3;
    protected static final int TX_XID_RUS_ID = 4;
    protected static final int TX_OUTCOME_RUS_ID = 5;
    protected static final int ONE_PHASE_UOW_IDENTIFIER_RUS_ID = 6;
    protected static final int PROPAGATE_ON_WEB_SERVICE_REQUESTS_RUS_ID = 7;
    public static final byte CSCOPE_TYPE_ROOT = 0;
    public static final byte CSCOPE_TYPE_SUBORDINATE = 1;
    public static final byte TX_OUTCOME_UNKNOWN = -1;
    public static final byte TX_OUTCOME_COMMIT = 0;
    public static final byte TX_OUTCOME_ROLLBACK = 1;
    public static final byte TX_OUTCOME_INDOUBT = 2;
    public static final byte ONE_PHASE_UOW = 0;
    protected RecoverableUnit _csRecUnit;
    private RecoverableUnitSection _globalIdRecUnitSection;
    private RecoverableUnitSection _cScopeTypeRecUnitSection;
    private RecoverableUnitSection _propagateOnWebServiceRequestRecUnitSection;
    protected RecoverableUnitSection _compensatorRecUnitSection;
    private RecoverableUnitSection _parentGlobalIdRecUnitSection;
    protected RecoverableUnitSection _txOutcomeRecUnitSection;
    protected boolean _transactionalCompensatorsRequireCompletion;
    private int _compensatorId = 0;
    protected WebSphereActivityCoordinator _coord;
    protected GlobalId _gid = null;
    protected String _id = null;
    protected CScope _parent = null;
    protected boolean _onePhaseUOW = false;
    protected HashMap _activeCompensators = new HashMap();
    protected HashMap _inactiveCompensators = new HashMap();
    protected boolean _completed = false;
    private RecoveryLog _recoveryLog;
    private CScopeSubordImpl[] _loopbackSubordinates = null;
    private HashMap _customData = new HashMap();
    protected boolean _propagateOnWebServiceRequests = true;
    private RetryAlarmContext _retryContext = null;
    protected CScopeImpl _child;

    public CScopeImpl(GlobalId globalId, CScopeImpl cScopeImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CScopeImpl", new Object[]{globalId, cScopeImpl});
        }
        this._gid = globalId;
        this._parent = cScopeImpl;
        this._id = this._gid.print();
        if (cScopeImpl != null) {
            cScopeImpl.setChild(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CScopeImpl");
        }
    }

    public CScopeImpl(RecoveredData recoveredData, CScopeImpl cScopeImpl, RecoveryLog recoveryLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CScopeImpl", new Object[]{recoveredData, cScopeImpl, recoveryLog});
        }
        this._gid = recoveredData.getGlobalId();
        this._id = this._gid.print();
        this._recoveryLog = recoveryLog;
        this._propagateOnWebServiceRequests = recoveredData.propagateOnWebServiceRequests();
        if (cScopeImpl == null && recoveredData.getParentGlobalId() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parent expected but none given");
            }
            this._parent = new CompletedParentCScope(recoveredData.getParentGlobalId().print());
        } else {
            this._parent = cScopeImpl;
        }
        this._csRecUnit = recoveredData.getRecoverableUnit();
        this._txOutcomeRecUnitSection = this._csRecUnit.lookupSection(5);
        this._compensatorRecUnitSection = this._csRecUnit.lookupSection(2);
        CompensatorWrapper[] compensatorWrapperArray = recoveredData.getCompensators();
        if (compensatorWrapperArray != null) {
            for (int i = 0; i < compensatorWrapperArray.length; ++i) {
                CompensatorWrapper compensatorWrapper = compensatorWrapperArray[i];
                int n = compensatorWrapper.getId();
                if (this._compensatorId < n) {
                    this._compensatorId = n;
                }
                Compensator compensator = compensatorWrapper.getCompensator();
                if (compensatorWrapper.isTransactional()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding compensator " + compensator.getName() + " to inactive map");
                    }
                    this._inactiveCompensators.put(compensator, compensatorWrapper);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding compensator " + compensator.getName() + " to active map");
                }
                this._activeCompensators.put(compensator, compensatorWrapper);
            }
            ++this._compensatorId;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CompensatorId: " + this._compensatorId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CScopeImpl", this);
        }
    }

    protected void setActivityCoordinator(WebSphereActivityCoordinator webSphereActivityCoordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setActivityCoordinator", new Object[]{webSphereActivityCoordinator, this});
        }
        this._coord = webSphereActivityCoordinator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setActivityCoordinator");
        }
    }

    protected void addCompensatorPreInvoke(Compensator compensator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCompensatorPreInvoke", new Object[]{compensator, this});
        }
        if (compensator == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addCompensatorPreInvoke", "IllegalArgumentException");
            }
            throw new IllegalArgumentException();
        }
        if (this._completed) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addCompensatorPreInvoke", "IllegalStateException");
            }
            throw new IllegalStateException();
        }
    }

    public void addCompensator(Compensator compensator, boolean bl, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCompensator", new Object[]{compensator, bl, string, this});
        }
        this.addCompensator(compensator, bl, string, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCompensator");
        }
    }

    public void addCompensator(Compensator compensator, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCompensator", new Object[]{compensator, bl, this});
        }
        this.addCompensator(compensator, bl, null, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCompensator");
        }
    }

    public void addCompensatorPromotedFromChild(Compensator compensator, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCompensatorPromotedFromChild", new Object[]{compensator, string, this});
        }
        this.addCompensator(compensator, false, string, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCompensatorPromotedFromChild");
        }
    }

    public void addCompensator(Compensator compensator, boolean bl, String string, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCompensator", new Object[]{compensator, bl, string, bl2, this});
        }
        if (!this._activeCompensators.containsKey(compensator) && !this._inactiveCompensators.containsKey(compensator)) {
            CompensatorWrapper compensatorWrapper = null;
            try {
                compensatorWrapper = new CompensatorWrapper(compensator, bl, this._compensatorId++, string);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cscope.CScopeImpl.addCompensator", "317", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "IOException caught serializing the compensator", iOException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addCompensator", "CScopeSystemException");
                }
                throw new CScopeSystemException(iOException);
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compensator is non-transactional - adding compensator to active list");
                }
                this._activeCompensators.put(compensator, compensatorWrapper);
                try {
                    if (string == null) {
                        this.persistCompensator(compensatorWrapper, (byte)0, bl2);
                    }
                    this.persistCompensator(compensatorWrapper, (byte)5, bl2);
                }
                catch (CScopeSystemException cScopeSystemException) {
                    FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.addCompensator", "224", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "CScopeSystemException caught from persistCompensator", cScopeSystemException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "addCompensator", cScopeSystemException);
                    }
                    throw cScopeSystemException;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compensator is transactional - adding compensator to inactive list");
                }
                this._inactiveCompensators.put(compensator, compensatorWrapper);
                if (this._propagateOnWebServiceRequests) {
                    try {
                        this.persistCompensator(compensatorWrapper, (byte)0, bl2);
                    }
                    catch (CScopeSystemException cScopeSystemException) {
                        FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.addCompensator", "224", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "CScopeSystemException caught from persistCompensator", cScopeSystemException);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "addCompensator", cScopeSystemException);
                        }
                        throw cScopeSystemException;
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The compensator " + compensator.getName() + "is already associated with this CScope");
        }
        if (this._parent instanceof CScopeImpl) {
            ((CScopeImpl)this._parent).propagateCompensator(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCompensator");
        }
    }

    public boolean removeCompensator(Compensator compensator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCompensator", new Object[]{compensator, this});
        }
        boolean bl = this.removeCompensator(compensator, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCompensator", bl);
        }
        return bl;
    }

    public boolean removeCompensator(Compensator compensator, boolean bl) {
        boolean bl2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCompensator", new Object[]{compensator, bl, this});
        }
        if (compensator == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeCompensator", "IllegalArgumentException");
            }
            throw new IllegalArgumentException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Compensator name", compensator.getName());
        }
        boolean bl3 = false;
        CompensatorWrapper compensatorWrapper = (CompensatorWrapper)this._inactiveCompensators.remove(compensator);
        if (compensatorWrapper == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Compensator not found in inactive list.");
            }
            if ((compensatorWrapper = (CompensatorWrapper)this._activeCompensators.remove(compensator)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compensator found in active list");
                }
                bl3 = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Compensator not found in active list");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Compensator found in inactive list");
            }
            bl3 = compensatorWrapper.isLogged();
        }
        if (bl3) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Persisting compensator's removal. Removal will be forced: " + bl);
            }
            try {
                this.persistCompensator(compensatorWrapper, (byte)2, bl);
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.removeCompensator", "304", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CScopeSystemException caught from persistCompensator", cScopeSystemException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeCompensator", cScopeSystemException);
                }
                throw cScopeSystemException;
            }
        }
        boolean bl4 = bl2 = compensatorWrapper != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCompensator", bl2);
        }
        return bl2;
    }

    private void removePromotedCompensator(Compensator compensator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePromotedCompensator", new Object[]{compensator, this});
        }
        this.removeCompensator(compensator, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePromotedCompensator");
        }
    }

    public boolean updateCompensator(Compensator compensator) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCompensator", new Object[]{compensator, this});
        }
        if (compensator == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateCompensator", "IllegalArgumentException");
            }
            throw new IllegalArgumentException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Compensator name", compensator.getName());
        }
        boolean bl2 = false;
        CompensatorWrapper compensatorWrapper = (CompensatorWrapper)this._activeCompensators.get(compensator);
        if (compensatorWrapper != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Compensator is active, updating and persisting.");
            }
            try {
                compensatorWrapper.setCompensator(compensator);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cscope.CScopeImpl.updateCompensator", "459", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "IOException caught serializing the compensator", iOException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updateCompensator", "CScopeSystemException");
                }
                throw new CScopeSystemException(iOException);
            }
            bl2 = true;
        } else {
            compensatorWrapper = (CompensatorWrapper)this._inactiveCompensators.get(compensator);
            if (compensatorWrapper != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compensator is inactive, updating.");
                }
                try {
                    compensatorWrapper.setCompensator(compensator);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cscope.CScopeImpl.updateCompensator", "481", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "IOException caught serializing the compensator", iOException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateCompensator", "CScopeSystemException");
                    }
                    throw new CScopeSystemException(iOException);
                }
                if (compensatorWrapper.isLogged()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Inactive compensator already logged - updating");
                    }
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            try {
                if (compensatorWrapper.getJ2EEName() == null) {
                    this.persistCompensator(compensatorWrapper, (byte)1, true);
                } else {
                    this.persistCompensator(compensatorWrapper, (byte)6, true);
                }
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.updateCompensator", "375", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CScopeSystemException caught persisting compensator updated", cScopeSystemException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updateCompensator", cScopeSystemException);
                }
                throw cScopeSystemException;
            }
        }
        boolean bl3 = bl = compensatorWrapper != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCompensator", bl);
        }
        return bl;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getId", this._id);
        }
        return this._id;
    }

    public String toString() {
        String string = "CScopeImpl " + this._id;
        return string;
    }

    protected boolean closeCompensators(CompensatorWrapper[] compensatorWrapperArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeCompensators", new Object[]{compensatorWrapperArray, this});
        }
        try {
            Arrays.sort(compensatorWrapperArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.closeCompensators", "556", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected failure occured ordering compensators", exception);
            }
            Tr.error(tc, "ERR_COMPENSATOR_SORT_FAILURE", new Object[]{this._gid, exception});
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = this._parent != null;
        CompensatorWrapper compensatorWrapper = null;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; i < compensatorWrapperArray.length && bl; ++i) {
            compensatorWrapper = compensatorWrapperArray[i];
            if (bl3 && compensatorWrapper.getPromoteResponse()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Promoting compensator");
                }
                try {
                    if (!(this._parent instanceof CScopeImpl)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Parent does not exist, throwing IllegalStateException");
                        }
                        throw new IllegalStateException();
                    }
                    ((CScopeImpl)this._parent).addCompensatorPromotedFromChild(compensatorWrapper.getCompensator(), compensatorWrapper.getJ2EEName());
                    this.removePromotedCompensator(compensatorWrapper.getCompensator());
                    bl5 = true;
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.cscope.CScopeImpl.closeCompensators", "617", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "IllegalStateException caught from addCompensator - the parent has timed out", illegalStateException);
                    }
                    try {
                        bl = compensatorWrapper.compensate(bl2, this);
                    }
                    catch (RetryCompensatorException retryCompensatorException) {
                        this.handleRetry(compensatorWrapperArray, i, 1, false);
                        bl4 = true;
                        break;
                    }
                    catch (CompensationFailedException compensationFailedException) {
                        FFDCFilter.processException((Throwable)compensationFailedException, "com.ibm.ws.cscope.CScopeImpl.closeCompensators", "636", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "CompensationFailedException caught from close call", compensationFailedException);
                        }
                        bl2 = true;
                    }
                    catch (CScopeSystemException cScopeSystemException) {
                        FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.closeCompensators", "645", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "CScopeSystemException caught from close call", cScopeSystemException);
                        }
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.closeCompensators", "654", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unexcepted exception caught from close call", exception);
                        }
                        Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"closeCompensators", "CScopeImpl", this});
                        bl2 = true;
                    }
                }
                continue;
            }
            if (compensatorWrapper.isTransactional() && !this._transactionalCompensatorsRequireCompletion) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Closing compensator");
            }
            try {
                bl = compensatorWrapper.close(this);
                continue;
            }
            catch (RetryCompensatorException retryCompensatorException) {
                this.handleRetry(compensatorWrapperArray, i, 0, false);
                bl4 = true;
                break;
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.closeCompensators", "694", this);
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "CScopeSystemException caught from compensate call", cScopeSystemException);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.closeCompensators", "702", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception caught from close call ", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"closeCompensators", "CScopeImpl", exception});
            }
        }
        if (bl5) {
            try {
                ((CScopeImpl)this._parent)._csRecUnit.writeSections();
                this._csRecUnit.forceSections();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.cscope.CScopeImpl.closeCompensators", "854", this);
                CScopeSystemException cScopeSystemException = new CScopeSystemException(internalLogException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeCompensators", cScopeSystemException);
                }
                throw cScopeSystemException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeCompensators", bl4);
        }
        return bl4;
    }

    private void handleRetry(CompensatorWrapper[] compensatorWrapperArray, int n, int n2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRetry", new Object[]{compensatorWrapperArray, new Integer(n), TraceUtils.printDirection(n2), bl, this});
        }
        if (CScopeComponentImpl.isServerStarted()) {
            CompensatorWrapper[] compensatorWrapperArray2 = new CompensatorWrapper[compensatorWrapperArray.length - n];
            System.arraycopy(compensatorWrapperArray, n, compensatorWrapperArray2, 0, compensatorWrapperArray2.length);
            if (this._retryContext == null) {
                this._retryContext = new RetryAlarmContext(compensatorWrapperArray2, this, n2, bl, this._propagateOnWebServiceRequests);
            } else {
                this._retryContext.setRemainingCompensators(compensatorWrapperArray2);
            }
            boolean bl2 = this._retryContext.createRetryAlarm();
            if (bl2) {
                this.removeRecoverableUnit();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRetry");
        }
    }

    protected void persistCompensator(CompensatorWrapper compensatorWrapper, byte by, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistCompensator", new Object[]{compensatorWrapper, TraceUtils.printCompensatorRecordType(by), bl, this});
        }
        try {
            CompensatorRecord compensatorRecord = new CompensatorRecord(by, compensatorWrapper);
            byte[] byArray = compensatorRecord.write();
            if (this._compensatorRecUnitSection == null) {
                this._compensatorRecUnitSection = this.createRecoverableUnitSection(2, false);
            }
            this.logData(this._compensatorRecUnitSection, byArray, bl);
            compensatorWrapper.setLogged(true);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cscope.CScopeImpl.persistCompensator", "460", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "IOException caught creating compensator log record", iOException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistCompensator", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (CScopeSystemException cScopeSystemException) {
            FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.persistCompensator", "552", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "CScopeSystemException caught persisting compensator", cScopeSystemException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistCompensator", cScopeSystemException);
            }
            throw cScopeSystemException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistCompensator");
        }
    }

    protected RecoverableUnitSection createRecoverableUnitSection(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRecoverableUnitSection", new Object[]{new Integer(n), bl, this});
        }
        RecoverableUnitSection recoverableUnitSection = null;
        try {
            if (this._csRecUnit == null) {
                this.persistCScope();
            }
            recoverableUnitSection = this._csRecUnit.createSection(n, bl);
        }
        catch (RecoverableUnitSectionExistsException recoverableUnitSectionExistsException) {
            FFDCFilter.processException((Throwable)recoverableUnitSectionExistsException, "com.ibm.ws.cscope.CScopeImpl.createRecoverableUnitSection", "552", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "A RUS with ID " + n + " already exists", recoverableUnitSectionExistsException);
            }
            Tr.error(tc, "ERR_PERSIST_FAILURE", recoverableUnitSectionExistsException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRecoverableUnitSection", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.cscope.CScopeImpl.createRecoverableUnitSection", "559", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Internal log failure", internalLogException);
            }
            Tr.error(tc, "ERR_PERSIST_FAILURE", internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRecoverableUnitSection", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (CScopeSystemException cScopeSystemException) {
            FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.createRecoverableUnitSection", "567", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "CScopeSystemException caught persisting CScope", cScopeSystemException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRecoverableUnitSection", cScopeSystemException);
            }
            throw cScopeSystemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.createRecoverableUnitSection", "571", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught", exception);
            }
            Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"createRecoverableUnitSection", "CScopeImpl", exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRecoverableUnitSection", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRecoverableUnitSection", recoverableUnitSection);
        }
        return recoverableUnitSection;
    }

    protected GlobalId getGlobalId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalId", this._gid);
        }
        return this._gid;
    }

    public String getPropertyGroupName() {
        return "CScope";
    }

    protected void removeRecoverableUnit() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRecoverableUnit", this);
        }
        if (this._csRecUnit != null) {
            try {
                RecoveryLog recoveryLog = this._recoveryLog != null ? this._recoveryLog : CScopeComponentImpl.getRecoveryLog();
                recoveryLog.removeRecoverableUnit(this._csRecUnit.identity());
                this._csRecUnit = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CScope " + this + " has removed its recoverable unit from the log.");
                }
            }
            catch (LogClosedException logClosedException) {
                FFDCFilter.processException((Throwable)logClosedException, "com.ibm.ws.cscope.CScopeImpl.removeRecoverableUnit", "907", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Log closed", logClosedException);
                }
                Tr.error(tc, "ERR_PERSIST_FAILURE", logClosedException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeRecoverableUnit", "CScopeSystemException");
                }
                throw new CScopeSystemException(logClosedException);
            }
            catch (InvalidRecoverableUnitException invalidRecoverableUnitException) {
                FFDCFilter.processException((Throwable)invalidRecoverableUnitException, "com.ibm.ws.cscope.CScopeImpl.removeRecoverableUnit", "915", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Invalid recoverable unit", invalidRecoverableUnitException);
                }
                Tr.error(tc, "ERR_PERSIST_FAILURE", invalidRecoverableUnitException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeRecoverableUnit", "CScopeSystemException");
                }
                throw new CScopeSystemException(invalidRecoverableUnitException);
            }
            catch (LogFullException logFullException) {
                FFDCFilter.processException((Throwable)logFullException, "com.ibm.ws.cscope.CScopeImpl.removeRecoverableUnit", "923", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Log full", logFullException);
                }
                Tr.error(tc, "ERR_LOG_FULL");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeRecoverableUnit", "CScopeSystemException");
                }
                throw new CScopeSystemException(logFullException);
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.cscope.CScopeImpl.removeRecoverableUnit", "931", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Log closed", internalLogException);
                }
                Tr.error(tc, "ERR_PERSIST_FAILURE", internalLogException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeRecoverableUnit", "CScopeSystemException");
                }
                throw new CScopeSystemException(internalLogException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.removeRecoverableUnit", "939", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception caught removing CScope from log", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"completed", "CScopeImpl", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeRecoverableUnit", "CScopeSystemException");
                }
                throw new CScopeSystemException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRecoverableUnit");
        }
    }

    public void completed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completed", this);
        }
        if (this._retryContext == null && this._completed) {
            this.removeRecoverableUnit();
        }
        if (this._loopbackSubordinates != null) {
            for (int i = 0; i < this._loopbackSubordinates.length; ++i) {
                this._loopbackSubordinates[i].completed();
            }
            this._loopbackSubordinates = null;
        }
        if (this._parent instanceof CScopeSubordImpl) {
            CScopeSubordImpl cScopeSubordImpl = (CScopeSubordImpl)this._parent;
            if (cScopeSubordImpl._parent == null) {
                ((CScopeSubordImpl)this._parent).childCompleted();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completed");
        }
    }

    public void suspended() {
    }

    public void resumed() {
    }

    protected abstract byte getType();

    public abstract boolean isOnePhase();

    protected void persistCScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistCScope", this);
        }
        try {
            this._csRecUnit = CScopeComponentImpl.getRecoveryLog().createRecoverableUnit();
            this._globalIdRecUnitSection = this.createRecoverableUnitSection(0, true);
            this._cScopeTypeRecUnitSection = this.createRecoverableUnitSection(1, true);
            this._propagateOnWebServiceRequestRecUnitSection = this.createRecoverableUnitSection(7, true);
            if (this._parent != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Child CScope - logging parent's GlobalId");
                }
                this._parentGlobalIdRecUnitSection = this.createRecoverableUnitSection(3, true);
                this.logData(this._parentGlobalIdRecUnitSection, ((CScopeImpl)this._parent).getGlobalId().toBytes(), false);
            }
            this.logData(this._globalIdRecUnitSection, this._gid.toBytes(), false);
            this.logData(this._cScopeTypeRecUnitSection, new byte[]{this.getType()}, false);
            this.logData(this._propagateOnWebServiceRequestRecUnitSection, new byte[]{(byte)(this._propagateOnWebServiceRequests ? 1 : 0)}, false);
        }
        catch (LogFullException logFullException) {
            FFDCFilter.processException((Throwable)logFullException, "com.ibm.ws.cscope.CScopeImpl.persistCScope", "766", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Log full exception caught when persisting CScope", logFullException);
            }
            Tr.error(tc, "ERR_LOG_FULL");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistCScope", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.cscope.CScopeImpl.persistCScope", "635", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Internal log exception caught when creating recoverable unit", internalLogException);
            }
            Tr.error(tc, "ERR_PERSIST_FAILURE", internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistCScope", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (LogClosedException logClosedException) {
            FFDCFilter.processException((Throwable)logClosedException, "com.ibm.ws.cscope.CScopeImpl.persistCScope", "644", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Log closed - cannot create recoverable unit", logClosedException);
            }
            Tr.error(tc, "ERR_PERSIST_FAILURE", logClosedException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistCScope", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (CScopeSystemException cScopeSystemException) {
            FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.persistCScope", "658", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistCScope", cScopeSystemException);
            }
            throw cScopeSystemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.persistCScope", "804", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught persisting CScope", exception);
            }
            Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"persistCScope", "CScopeImpl", exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistCScope", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistCScope");
        }
    }

    protected void beforeCompletion(boolean bl) {
        CompensatorWrapper compensatorWrapper;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion", new Object[]{bl, this});
        }
        CompensatorWrapper[] compensatorWrapperArray = this._activeCompensators.values().toArray(new CompensatorWrapper[0]);
        CompensatorWrapper[] compensatorWrapperArray2 = this._inactiveCompensators.values().toArray(new CompensatorWrapper[0]);
        CompensatorWrapper[] compensatorWrapperArray3 = new CompensatorWrapper[compensatorWrapperArray.length + compensatorWrapperArray2.length];
        System.arraycopy(compensatorWrapperArray, 0, compensatorWrapperArray3, 0, compensatorWrapperArray.length);
        System.arraycopy(compensatorWrapperArray2, 0, compensatorWrapperArray3, compensatorWrapperArray.length, compensatorWrapperArray2.length);
        String string = this._parent != null ? this._parent.getId() : null;
        boolean bl2 = false;
        if (compensatorWrapperArray2.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Persisting inactive compensators");
            }
            try {
                for (n = 0; n < compensatorWrapperArray2.length; ++n) {
                    compensatorWrapper = compensatorWrapperArray2[n];
                    if (compensatorWrapper.getJ2EEName() == null) {
                        this.persistCompensator(compensatorWrapper, (byte)0, false);
                        continue;
                    }
                    this.persistCompensator(compensatorWrapper, (byte)5, false);
                }
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.beforeCompletion", "929", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CScopeSystemException caught persisting compensator", cScopeSystemException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeCompletion", cScopeSystemException);
                }
                throw cScopeSystemException;
            }
            bl2 = true;
        }
        for (n = 0; n < compensatorWrapperArray3.length; ++n) {
            compensatorWrapper = compensatorWrapperArray3[n];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing wrapper " + compensatorWrapper);
            }
            try {
                boolean bl3 = compensatorWrapper.promote(string, this);
                if (bl || bl3 || compensatorWrapper.getType() != 1) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "2-Phase UOW, logging promote response.");
                }
                this.persistCompensator(compensatorWrapper, (byte)3, false);
                bl2 = true;
                continue;
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.beforeCompletion", "977", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CScopeSystemException caught persisting promote response", cScopeSystemException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeCompletion", cScopeSystemException);
                }
                throw cScopeSystemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.beforeCompletion", "972", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught calling promote on compensator wrapper", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"beforeCompletion", "CScopeImpl", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeCompletion", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
        }
        if (bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Log updated - forcing updates.");
            }
            try {
                this._csRecUnit.forceSections();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.beforeCompletion", "289", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught forcing compensator promote responses", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"beforeCompletion", "CScopeImpl", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeCompletion", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeCompletion");
        }
    }

    protected void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", this);
        }
        try {
            this.persistTransactionOutcome((byte)0);
        }
        catch (CScopeSystemException cScopeSystemException) {
            FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.close", "1097", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Persisting tx outcome failed - rethrowing CScopeSystemException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close", cScopeSystemException);
            }
            throw cScopeSystemException;
        }
        this._completed = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Closing/promoting non-transactional compensators");
        }
        CompensatorWrapper[] compensatorWrapperArray = this._activeCompensators.values().toArray(new CompensatorWrapper[0]);
        CompensatorWrapper[] compensatorWrapperArray2 = null;
        if (this._parent != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Child CScope - promoting transactional compensators");
            }
            CompensatorWrapper[] compensatorWrapperArray3 = this._inactiveCompensators.values().toArray(new CompensatorWrapper[0]);
            compensatorWrapperArray2 = new CompensatorWrapper[compensatorWrapperArray.length + compensatorWrapperArray3.length];
            System.arraycopy(compensatorWrapperArray, 0, compensatorWrapperArray2, 0, compensatorWrapperArray.length);
            System.arraycopy(compensatorWrapperArray3, 0, compensatorWrapperArray2, compensatorWrapperArray.length, compensatorWrapperArray3.length);
        } else {
            compensatorWrapperArray2 = compensatorWrapperArray;
        }
        try {
            this.closeCompensators(compensatorWrapperArray2);
        }
        catch (CScopeSystemException cScopeSystemException) {
            FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.close", "979", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "CScopeSystemException caught from closeCompensators", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close", cScopeSystemException);
            }
            throw cScopeSystemException;
        }
        if (this._loopbackSubordinates != null) {
            for (int i = 0; i < this._loopbackSubordinates.length; ++i) {
                this._loopbackSubordinates[i].close();
            }
        }
        this.closePostInvoke();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    protected void compensate() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compensate", this);
        }
        try {
            this.persistTransactionOutcome((byte)1);
        }
        catch (CScopeSystemException cScopeSystemException) {
            FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.compensate", "1442", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Persisting tx outcome failed - rethrowing CScopeSystemException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compensate", cScopeSystemException);
            }
            throw cScopeSystemException;
        }
        this._completed = true;
        CompensatorWrapper[] compensatorWrapperArray = this._activeCompensators.values().toArray(new CompensatorWrapper[0]);
        CompensatorWrapper[] compensatorWrapperArray2 = this._inactiveCompensators.values().toArray(new CompensatorWrapper[0]);
        String string2 = string = this._parent == null ? null : this._parent.getId();
        if (this.isOnePhase()) {
            this.demoteCompensators(compensatorWrapperArray, string);
            this.demoteCompensators(compensatorWrapperArray2, string);
        }
        this.compensateCompensators(compensatorWrapperArray, false);
        if (this._loopbackSubordinates != null) {
            for (int i = 0; i < this._loopbackSubordinates.length; ++i) {
                this._loopbackSubordinates[i].compensate();
            }
        }
        this.compensatePostInvoke();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compensate");
        }
    }

    protected boolean compensateCompensators(CompensatorWrapper[] compensatorWrapperArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compensateCompensators", new Object[]{compensatorWrapperArray, bl, this});
        }
        try {
            Arrays.sort(compensatorWrapperArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.compensateCompensators", "1294", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected failure occured ordering compensators", exception);
            }
            Tr.error(tc, "ERR_COMPENSATOR_SORT_FAILURE", new Object[]{this._gid, exception});
        }
        boolean bl2 = false;
        for (int i = 0; i < compensatorWrapperArray.length; ++i) {
            try {
                compensatorWrapperArray[i].compensate(bl, this);
                continue;
            }
            catch (RetryCompensatorException retryCompensatorException) {
                this.handleRetry(compensatorWrapperArray, i, 1, bl);
                bl2 = true;
                break;
            }
            catch (CompensationFailedException compensationFailedException) {
                FFDCFilter.processException((Throwable)compensationFailedException, "com.ibm.ws.cscope.CScopeImpl.compensateCompensators", "1313", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CompensationFailedException caught from compensate call", compensationFailedException);
                }
                bl = true;
                continue;
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.compensateCompensators", "1322", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CScopeSystemException caught from compensate call", cScopeSystemException);
                }
                bl = true;
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.compensateCompensators", "1331", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception caught from compensate call", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"compensatorCompensators", "CScopeImpl", exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compensateCompensators", bl2);
        }
        return bl2;
    }

    private void demoteCompensators(CompensatorWrapper[] compensatorWrapperArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "demoteCompensators", new Object[]{compensatorWrapperArray, string, this});
        }
        for (int i = 0; i < compensatorWrapperArray.length; ++i) {
            try {
                compensatorWrapperArray[i].demote(string, this);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.demoteCompensators", "1046", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception caught from demote call", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"demoteCompensators", "CScopeImpl", exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "demoteCompensators");
        }
    }

    protected void logData(RecoverableUnitSection recoverableUnitSection, byte[] byArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logData", new Object[]{recoverableUnitSection, "byte[" + byArray.length + "]", new Boolean(bl), this});
        }
        try {
            recoverableUnitSection.addData(byArray);
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Forcing log updates");
                }
                this._csRecUnit.forceSections();
            }
        }
        catch (LogFullException logFullException) {
            FFDCFilter.processException((Throwable)logFullException, "com.ibm.ws.cscope.CScopeImpl.logData", "957", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Log full exception caught", logFullException);
            }
            Tr.error(tc, "ERR_LOG_FULL");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "logData", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.cscope.CScopeImpl.logData", "965", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught internal log exception", internalLogException);
            }
            Tr.error(tc, "ERR_PERSIST_FAILURE", internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "logData", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.logData", "973", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught unexpected exception when adding data to RUS", exception);
            }
            Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"logData", "CScopeImpl", exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "logData", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistTransactionOutcome(byte by) {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "persistTransactionOutcome", new Object[]{TraceUtils.printTxOutcome(by), this});
            }
            try {
                if (this._csRecUnit == null) {
                    this._txOutcomeRecUnitSection = this.createRecoverableUnitSection(5, true);
                    this.logData(this._txOutcomeRecUnitSection, new byte[]{by}, true);
                    break block11;
                }
                RecoverableUnit recoverableUnit = this._csRecUnit;
                synchronized (recoverableUnit) {
                    if (this._txOutcomeRecUnitSection == null) {
                        this._txOutcomeRecUnitSection = this.createRecoverableUnitSection(5, true);
                        this.logData(this._txOutcomeRecUnitSection, new byte[]{by}, true);
                    }
                }
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeImpl.persistTransactionOutcome", "981", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CScopeSystemException caught persisting tx outcome", cScopeSystemException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "persistTransactionOutcome", cScopeSystemException);
                }
                throw cScopeSystemException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistTransactionOutcome");
        }
    }

    public WebSphereActivityCoordinator getActivityCoordinator(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivityCoordinator", new Object[]{new Boolean(bl), this});
        }
        if (this._coord == null && bl) {
            try {
                this._coord = (WebSphereActivityCoordinator)CScopeComponentImpl.getWebSphereUserActivity().getActivityCoordinator(this._gid);
            }
            catch (ServiceNotRegisteredException serviceNotRegisteredException) {
                FFDCFilter.processException((Throwable)serviceNotRegisteredException, "com.ibm.ws.cscope.CScopeImpl.getActivityCoordinator", "143", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Service not registered when getting coordinator", serviceNotRegisteredException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getActivityCoordinator", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.cscope.CScopeImpl.getActivityCoordinator", "150", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "SystemException caught from getCoordinator", systemException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getActivityCoordinator", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CScopeImpl.getActivityCoordinator", "157", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to get ActivityCoordinator", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"initializeActivityCoordinator", "CScopeImpl", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getActivityCoordinator", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivityCoordinator", this._coord);
        }
        return this._coord;
    }

    protected void propagateCompensator(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateCompensator", new Object[]{new Boolean(bl), this});
        }
        if (this._parent != null && this._parent instanceof CScopeImpl) {
            ((CScopeImpl)this._parent).propagateCompensator(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateCompensator");
        }
    }

    protected void recreateLoopbackSubordinates(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recreateLoopbackSubordinates", new Object[]{list, this});
        }
        this._loopbackSubordinates = new CScopeSubordImpl[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this._loopbackSubordinates[n++] = new CScopeSubordImpl((RecoveredData)iterator.next(), this._parent instanceof CScopeImpl ? (CScopeImpl)this._parent : null, this._recoveryLog);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recreateLoopbackSubordinates");
        }
    }

    public Object getCustomData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomData", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomData", this._customData);
        }
        return this._customData;
    }

    public void setPropagateOnWebServiceRequest(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPropagateOnWebServiceRequest", new Object[]{new Boolean(bl), this});
        }
        this._propagateOnWebServiceRequests = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropagateOnWebServiceRequest");
        }
    }

    public boolean propagateOnWebServiceRequest() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateOnWebServiceRequest", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateOnWebServiceRequest", new Boolean(this._propagateOnWebServiceRequests));
        }
        return this._propagateOnWebServiceRequests;
    }

    protected void setTxOutcomeRecoverableUnitSection(RecoverableUnitSection recoverableUnitSection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTxOutcomeRecoverableUnitSection", new Object[]{recoverableUnitSection, this});
        }
        this._txOutcomeRecUnitSection = recoverableUnitSection;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTxOutcomeRecoverableUnitSection");
        }
    }

    protected void setChild(CScopeImpl cScopeImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setChild", new Object[]{cScopeImpl, this});
        }
        this._child = cScopeImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setChild");
        }
    }

    protected abstract void closePostInvoke();

    protected abstract void compensatePostInvoke();

    public abstract void faultReceivedWhileActive();
}

