/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cscope.CScopeComponentImpl;
import com.ibm.ws.cscope.CScopeSystemException;
import com.ibm.ws.cscope.RecoveryManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InvalidFailureScopeException;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogCallBack;
import com.ibm.ws.recoverylog.spi.TerminationFailedException;
import java.util.HashMap;
import java.util.Iterator;

public class CScopeRecoveryAgent
implements RecoveryAgent,
RecoveryLogCallBack {
    private static TraceComponent tc = Tr.register(CScopeRecoveryAgent.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    private static final int CSCOPE_RECOVERYLOG_FORMAT_VERSION = 1;
    private static RecoveryDirector _recoveryDirector = null;
    private static CScopeRecoveryAgent _instance;
    private HashMap _recoveryManagers;

    public CScopeRecoveryAgent(RecoveryDirector recoveryDirector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CScopeRecoveryAgent", recoveryDirector);
        }
        _recoveryDirector = recoveryDirector;
        _recoveryDirector.addCallBack(this);
        _instance = this;
        this._recoveryManagers = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CScopeRecoveryAgent");
        }
    }

    public void prepareForRecovery(FailureScope failureScope) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateRecovery(FailureScope failureScope) throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initiateRecovery", new Object[]{failureScope, this});
        }
        try {
            RecoveryManager recoveryManager;
            HashMap hashMap = this._recoveryManagers;
            synchronized (hashMap) {
                recoveryManager = new RecoveryManager(failureScope, _recoveryDirector, this);
                this._recoveryManagers.put(failureScope, recoveryManager);
            }
            if (CScopeComponentImpl.isServerStarted()) {
                recoveryManager.start();
            }
        }
        catch (CScopeSystemException cScopeSystemException) {
            FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CScopeRecoveryAgent.initiateRecovery", "74", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Failure occured getting the recovery manager for failure scope " + failureScope, cScopeSystemException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initiateRecovery", "RecoveryFailedException");
            }
            throw new RecoveryFailedException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initiateRecovery");
        }
    }

    public void terminateRecovery(FailureScope failureScope) throws TerminationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminateRecovery", new Object[]{failureScope, this});
        }
        try {
            RecoveryManager recoveryManager = this.getRecoveryManager(failureScope);
            if (recoveryManager != null) {
                recoveryManager.terminateRecovery();
            } else {
                _recoveryDirector.terminationComplete(this, failureScope);
            }
        }
        catch (InvalidFailureScopeException invalidFailureScopeException) {
            FFDCFilter.processException((Throwable)invalidFailureScopeException, "com.ibm.ws.cscope.CScopeRecoveryAgent.terminateRecovery", "122", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Failure occured informing recovery director of recovery termination", invalidFailureScopeException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "terminateRecovery", "TerminationFailedException");
            }
            throw new TerminationFailedException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateRecovery");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RecoveryManager getRecoveryManager(FailureScope failureScope) {
        RecoveryManager recoveryManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryManager", new Object[]{failureScope, this});
        }
        HashMap hashMap = this._recoveryManagers;
        synchronized (hashMap) {
            recoveryManager = (RecoveryManager)this._recoveryManagers.get(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryManager", recoveryManager);
        }
        return recoveryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RecoveryManager getContainingRecoveryManager(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContainingRecoveryManager", new Object[]{failureScope, this});
        }
        RecoveryManager recoveryManager = null;
        HashMap hashMap = this._recoveryManagers;
        synchronized (hashMap) {
            Iterator iterator = this._recoveryManagers.keySet().iterator();
            while (iterator.hasNext()) {
                FailureScope failureScope2 = (FailureScope)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RecoveryManager FailureScope", failureScope2);
                }
                if (!failureScope.isContainedBy(failureScope2)) continue;
                recoveryManager = (RecoveryManager)this._recoveryManagers.get(failureScope2);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContainingRecoveryManager", recoveryManager);
        }
        return recoveryManager;
    }

    public int clientIdentifier() {
        return 3;
    }

    public String clientName() {
        return "compensation";
    }

    public int clientVersion() {
        return 1;
    }

    public static CScopeRecoveryAgent getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", _instance);
        }
        return _instance;
    }

    protected void setServerStatus(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerStatus", new Object[]{string, this});
        }
        RecoveryManager[] recoveryManagerArray = this._recoveryManagers.values().toArray(new RecoveryManager[0]);
        for (int i = 0; i < recoveryManagerArray.length; ++i) {
            recoveryManagerArray[i].setServerStatus(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerStatus");
        }
    }

    protected void removeRecoveryManager(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRecoveryManager", new Object[]{failureScope, this});
        }
        Object v = this._recoveryManagers.remove(failureScope);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RecoveryManager removed from map", v);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRecoveryManager");
        }
    }

    public void recoveryStarted(FailureScope failureScope) {
    }

    public void terminateStarted(FailureScope failureScope) {
    }

    public void recoveryCompleted(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryCompleted", new Object[]{failureScope, this});
        }
        this.removeRecoveryManager(failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryCompleted");
        }
    }

    public void terminateCompleted(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminateCompleted", new Object[]{failureScope, this});
        }
        this.removeRecoveryManager(failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateCompleted");
        }
    }

    public String[] logDirectories(FailureScope failureScope) {
        return null;
    }

    public void agentReportedFailure(int n, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "agentReportedFailure", new Object[]{new Integer(n), failureScope, this});
        }
        if (n == 1) {
            RecoveryManager recoveryManager;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Recovery failure reported by the transaction service.");
            }
            if ((recoveryManager = (RecoveryManager)this._recoveryManagers.get(failureScope)) != null && recoveryManager.transactionRecoveryRequired()) {
                try {
                    _recoveryDirector.initialRecoveryFailed(this, failureScope);
                }
                catch (InvalidFailureScopeException invalidFailureScopeException) {
                    FFDCFilter.processException((Throwable)invalidFailureScopeException, "com.ibm.ws.cscope.CScopeRecoveryAgent.agentReportedFailure", "308", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "agentReportedFailure", "CScopeSystemException");
                    }
                    throw new CScopeSystemException(invalidFailureScopeException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "agentReportedFailure");
        }
    }

    public boolean disableFileLocking() {
        return false;
    }

    public boolean isSnapshotSafe() {
        return false;
    }

    public void logFileWarning(String string, int n, int n2) {
        Tr.info(tc, "INF_LOG_WARNING", new Object[]{string, n, n2});
    }
}

