/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ContextExtractor;
import com.ibm.ws.activity.CustomContextServiceManager;
import com.ibm.ws.activity.HighlyAvailableServiceManager;
import com.ibm.ws.activity.coordination.ActivityHandlerCollaborator;
import com.ibm.ws.cscope.BeforeCompSigSet;
import com.ibm.ws.cscope.CScopeComponentImpl;
import com.ibm.ws.cscope.CScopePGMgr;
import com.ibm.ws.cscope.CompletionSignalSet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.javax.activity.PropertyGroupUnknownException;
import com.ibm.ws.javax.activity.ServiceInformation;
import com.ibm.ws.javax.activity.SignalSetUnknownException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.coordination.RecoverableAction;
import com.ibm.ws.javax.activity.coordination.SignalSet;
import com.ibm.ws.javax.activity.coordination.SubordinateSignalSet;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroupManager;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.wsba.CoordinatorCompletionProtocolHandler;
import com.ibm.ws.wsba.ParticipantCompletionProtocolHandler;
import com.ibm.ws.wsba.WSBAActivityHandlerCollaborator;
import com.ibm.ws.wsba.WSBAContextExtractor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CScopeServiceManager
implements HighlyAvailableServiceManager,
CustomContextServiceManager {
    private static final TraceComponent tc = Tr.register(CScopeServiceManager.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    public static final String SERVICE_NAME = "com.ibm.ws.cscope";
    public static final String PROPERTY_GROUP_NAME = "CScope";
    private static final long DEFAULT_ASYNC_RESPONSE_TIMEOUT = 30000L;
    public static long ASYNC_RESPONSE_TIMEOUT = 30000L;
    public static final long GET_STATUS_ASYNC_RESPONSE_TIMEOUT = 5000L;
    private ServiceInformation _serviceInfo;
    private Properties _props;
    private FailureScope _failureScope;
    private PropertyGroupManager _propertyGroupManager;
    private String _logDirectory;
    private static final ContextExtractor _contextExtractor = new WSBAContextExtractor();
    private static final List _coordinationProtocolHandlers = new ArrayList();
    private static final ActivityHandlerCollaborator _activityHandlerCollaborator = new WSBAActivityHandlerCollaborator();

    public CScopeServiceManager(FailureScope failureScope, String string) {
        block4: {
            this._propertyGroupManager = null;
            this._logDirectory = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CScopeServiceManager", new Object[]{failureScope, string});
            }
            this._serviceInfo = new ServiceInformation(SERVICE_NAME, SERVICE_NAME, (Serializable)((Object)""));
            this._failureScope = failureScope;
            this._propertyGroupManager = new CScopePGMgr(this._failureScope);
            this._logDirectory = string;
            _coordinationProtocolHandlers.add(new ParticipantCompletionProtocolHandler());
            _coordinationProtocolHandlers.add(new CoordinatorCompletionProtocolHandler());
            String string2 = System.getProperty("wsba.asyncTimeout", Long.toString(30000L));
            try {
                ASYNC_RESPONSE_TIMEOUT = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException(numberFormatException, "com.ibm.ws.cscope.CScopeServiceManager.CScopeServiceManager", "108");
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Property wsba.asyncTimeout is malformed. Its value is " + string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CScopeServiceManager");
        }
    }

    public ServiceInformation getServiceInformation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceInformation", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceInformation", this._serviceInfo);
        }
        return this._serviceInfo;
    }

    public void activityImported(ServiceInformation serviceInformation) {
    }

    public String getCompletionSignalSetName() {
        return "com.ibm.ws.cscope.Completion";
    }

    public SignalSet getSignalSet(String string) throws SignalSetUnknownException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignalSet", new Object[]{string, this});
        }
        SubordinateSignalSet subordinateSignalSet = null;
        if (string.equals("com.ibm.ws.cscope.BeforeCompletion")) {
            subordinateSignalSet = new BeforeCompSigSet();
        } else if (string.equals("com.ibm.ws.cscope.Completion")) {
            subordinateSignalSet = new CompletionSignalSet();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " is unknown.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSignalSet", "SignalSetUnknownException");
            }
            throw new SignalSetUnknownException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignalSet", subordinateSignalSet);
        }
        return subordinateSignalSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubordinateSignalSet getSubordinateSignalSet(String string) throws SignalSetUnknownException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubordinateSignalSet", new Object[]{string, this});
        }
        SignalSet signalSet = null;
        try {
            signalSet = this.getSignalSet(string);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubordinateSignalSet", signalSet);
            }
        }
        return (SubordinateSignalSet)signalSet;
    }

    public PropertyGroupManager getPropertyGroupManager(String string) throws PropertyGroupUnknownException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroupManager", new Object[]{string, this});
        }
        if (!string.equals(PROPERTY_GROUP_NAME)) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, string + " is an unknown property group");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertyGroupManager", "PropertyGroupUnknownException");
            }
            throw new PropertyGroupUnknownException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroupManager", this._propertyGroupManager);
        }
        return this._propertyGroupManager;
    }

    public String[] getPropertyGroupNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroupNames", this);
        }
        String[] stringArray = new String[]{PROPERTY_GROUP_NAME};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroupNames", stringArray);
        }
        return stringArray;
    }

    public int getActivityType() {
        return 1244808517;
    }

    public Properties getProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", this);
        }
        if (this._props == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null properties - initializing");
            }
            this._props = new Properties();
            this._props.put("SignalTxnBegin", "false");
            this._props.put("SignalChildBegin", "false");
            this._props.put("NotifyImported", "false");
            this._props.put("markChildrenFailed", "false");
            this._props.put("logIdentifier", "3");
            this._props.put("logName", "compensation");
            this._props.put("noForceCoordinator", "true");
            if (this._logDirectory != null) {
                this._props.put("logDirectory", this._logDirectory);
            }
            this._props.put("EnableWebServicePropagation", "custom");
            this._props.put("asyncTimeout", Long.toString(ASYNC_RESPONSE_TIMEOUT));
            int n = CScopeComponentImpl.getInstance().getLogConfiguration(this._failureScope).getMaximumLogSize();
            this._props.put("logSize", "" + n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", this._props);
        }
        return this._props;
    }

    public SignalSet[] recoverSignalSets(GlobalId globalId) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoverSignalSets", new Object[]{globalId, this});
        }
        SignalSet[] signalSetArray = new SignalSet[]{new BeforeCompSigSet()};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoverSignalSets", signalSetArray);
        }
        return signalSetArray;
    }

    public RecoverableAction[] recoverActions(GlobalId globalId, String string) throws SignalSetUnknownException, SystemException {
        return null;
    }

    public String getHeuristicCompletionSignalSetName() {
        return null;
    }

    public FailureScope getFailureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFailureScope", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFailureScope", this._failureScope);
        }
        return this._failureScope;
    }

    public ContextExtractor getSOAPContextExtractor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSOAPContextExtractor", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSOAPContextExtractor", _contextExtractor);
        }
        return _contextExtractor;
    }

    public List getCoordinationProtocolHandlers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoordinationProtocolHandlers", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoordinationProtocolHandlers", _coordinationProtocolHandlers);
        }
        return _coordinationProtocolHandlers;
    }

    public ActivityHandlerCollaborator getActivityHandlerCollaborator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivityHandlerCollaborator", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivityHandlerCollaborator", _activityHandlerCollaborator);
        }
        return _activityHandlerCollaborator;
    }
}

