/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cscope.CScopeMetaDataListener;
import com.ibm.ws.cscope.Compensator;
import com.ibm.ws.cscope.CompensatorWrapper;
import com.ibm.ws.cscope.util.TraceUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CompensatorRecord {
    private static final TraceComponent tc = Tr.register(CompensatorRecord.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    private byte _recordType;
    private CompensatorWrapper _compensator;
    private byte[] _serializedCompensator;
    private String _j2eeName;
    private boolean _promoteResponse;
    private int _compensatorId;
    private boolean _transactional;
    public static final byte TYPE_COMPENSATOR_ADDED = 0;
    public static final byte TYPE_COMPENSATOR_UPDATED = 1;
    public static final byte TYPE_COMPENSATOR_REMOVED = 2;
    public static final byte TYPE_COMPENSATOR_PROMOTE_RESPONSE = 3;
    public static final byte TYPE_COMPENSATORS_DELETED = 4;
    public static final byte TYPE_COMPENSATOR_ADDED_WITH_J2EENAME = 5;
    public static final byte TYPE_COMPENSATOR_UPDATED_WITH_J2EENAME = 6;

    protected CompensatorRecord(byte by, CompensatorWrapper compensatorWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CompensatorRecord", new Object[]{TraceUtils.printCompensatorRecordType(by), compensatorWrapper});
        }
        this._recordType = by;
        this._compensator = compensatorWrapper;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CompensatorRecord", this);
        }
    }

    protected CompensatorRecord(byte[] byArray) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CompensatorRecord", byArray);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this._compensatorId = dataInputStream.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Recovering record for compensator " + this._compensatorId);
        }
        this._recordType = dataInputStream.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Record type " + TraceUtils.printCompensatorRecordType(this._recordType));
        }
        if (this._recordType != 4) {
            this._transactional = dataInputStream.readBoolean();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Transactional = " + this._transactional);
            }
            if (this._recordType == 0 || this._recordType == 1 || this._recordType == 5 || this._recordType == 6) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compensator added or updated - recovering compensator");
                }
                if (this._recordType == 5 || this._recordType == 6) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Compensator added or updated with J2EEName");
                    }
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    try {
                        this._j2eeName = (String)objectInputStream.readObject();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.cscope.CompensatorRecord.CompensatorRecord", "145", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Caught a ClassNotFoundException reading the classpath from the record");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "CompensatorRecord", "IOException");
                        }
                        throw new IOException();
                    }
                }
                this._serializedCompensator = new byte[byteArrayInputStream.available()];
                byteArrayInputStream.read(this._serializedCompensator);
            } else if (this._recordType == 3) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compensator promote response");
                }
                this._promoteResponse = dataInputStream.readBoolean();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "promoteResponse", new Boolean(this._promoteResponse));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CompensatorRecord", this);
        }
    }

    protected byte[] write() throws IOException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "write", this);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (this._recordType != 4) {
            dataOutputStream.writeInt(this._compensator.getId());
        } else {
            dataOutputStream.writeInt(-1);
        }
        dataOutputStream.write(this._recordType);
        if (this._recordType != 4) {
            dataOutputStream.writeBoolean(this._compensator.isTransactional());
            if (this._recordType == 3) {
                dataOutputStream.writeBoolean(this._compensator.getPromoteResponse());
            } else if (this._recordType == 0 || this._recordType == 1) {
                byteArrayOutputStream.write(this._compensator.getSerializedCompensator());
            } else if (this._recordType == 5 || this._recordType == 6) {
                object = new ObjectOutputStream(byteArrayOutputStream);
                ((ObjectOutputStream)object).writeObject(this._compensator.getJ2EEName());
                ((ObjectOutputStream)object).close();
                byteArrayOutputStream.write(this._compensator.getSerializedCompensator());
            }
        }
        dataOutputStream.close();
        byteArrayOutputStream.close();
        object = byteArrayOutputStream.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "write", object);
        }
        return object;
    }

    public byte getType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType");
        }
        return this._recordType;
    }

    public int getCompensatorId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompensatorId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompensatorId");
        }
        return this._compensatorId;
    }

    public Compensator getCompensator() throws IOException, ClassNotFoundException {
        WsObjectInputStream wsObjectInputStream;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompensator", this);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._serializedCompensator);
        if (this._j2eeName != null) {
            object = CScopeMetaDataListener.getClassLoader(this._j2eeName);
            wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream, (ClassLoader)object);
        } else {
            wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
        }
        object = (Compensator)wsObjectInputStream.readObject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompensator", object);
        }
        return object;
    }

    public boolean isTransactional() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTransactional", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTransactional", new Boolean(this._transactional));
        }
        return this._transactional;
    }

    public boolean getPromoteResponse() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPromoteResponse", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPromoteResponse", new Boolean(this._promoteResponse));
        }
        return this._promoteResponse;
    }

    public String getJ2EEName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2EEName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEName", this._j2eeName);
        }
        return this._j2eeName;
    }
}

