/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cscope.CScope;
import com.ibm.ws.cscope.CScopeComponentImpl;
import com.ibm.ws.cscope.CScopeImpl;
import com.ibm.ws.cscope.CScopeSystemException;
import com.ibm.ws.cscope.CombinedCompensator;
import com.ibm.ws.cscope.CompensationFailedException;
import com.ibm.ws.cscope.Compensator;
import com.ibm.ws.cscope.OrderedCompensator;
import com.ibm.ws.cscope.RetryCompensatorException;
import com.ibm.ws.cscope.UserCompensationScopeImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class CompensatorWrapper
implements Comparable {
    private static TraceComponent tc = Tr.register(CompensatorWrapper.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    protected static final int TYPE_COMPENSATOR = 0;
    protected static final int TYPE_COMBINED_COMPENSATOR = 1;
    private Compensator _compensator = null;
    private int _id;
    private int _type;
    private boolean _promoteResponse = true;
    private boolean _logged = false;
    private boolean _transactional = true;
    private String _j2eeName = null;
    protected static final Object RETRY_LOCK = new Object();
    private byte[] _serializedCompensator;

    public CompensatorWrapper(Compensator compensator, boolean bl, int n, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CompensatorWrapper", new Object[]{compensator, bl, new Integer(n), string});
        }
        this._j2eeName = string;
        this.setCompensator(compensator);
        this._id = n;
        this._transactional = bl;
        if (this._compensator instanceof CombinedCompensator) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Wrapping CombinedCompensator");
            }
            this._type = 1;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Wrapping Compensator");
            }
            this._type = 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CompensatorWrapper", this);
        }
    }

    public byte[] getSerializedCompensator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSerializedCompensator", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSerializedCompensator", this._serializedCompensator);
        }
        return this._serializedCompensator;
    }

    protected int getId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getId", new Integer(this._id));
        }
        return this._id;
    }

    protected Compensator getCompensator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompensator", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompensator", this._compensator);
        }
        return this._compensator;
    }

    protected void setCompensator(Compensator compensator) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCompensator", new Object[]{compensator, this});
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(compensator);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        this._serializedCompensator = byteArrayOutputStream.toByteArray();
        this._compensator = compensator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCompensator");
        }
    }

    public boolean equals(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{object, this});
        }
        boolean bl = false;
        if (object != null && object.getClass() == CompensatorWrapper.class) {
            bl = this._compensator.equals(((CompensatorWrapper)object).getCompensator());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals", bl);
        }
        return bl;
    }

    protected int getType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType", new Integer(this._type));
        }
        return this._type;
    }

    protected void setPromoteResponse(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPromoteResponse", new Object[]{bl, this});
        }
        this._promoteResponse = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPromoteResponse");
        }
    }

    protected boolean getPromoteResponse() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPromoteResponse", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPromoteResponse", this._promoteResponse);
        }
        return this._promoteResponse;
    }

    protected boolean close(CScope cScope) throws RetryCompensatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", new Object[]{cScope, this});
        }
        boolean bl = false;
        if (CScopeComponentImpl.isServerStarted()) {
            try {
                this._compensator.close(cScope);
                bl = true;
            }
            catch (RetryCompensatorException retryCompensatorException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Compensator has requested close call be retried");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "close", retryCompensatorException);
                }
                throw retryCompensatorException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CompensatorWrapper.close", "451", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception caught from close call the compensator " + this._compensator, exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"close", "CompensatorWrapper", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "close", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close", bl);
        }
        return bl;
    }

    public boolean compensate(boolean bl, CScope cScope) throws CompensationFailedException, RetryCompensatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compensate", new Object[]{bl, cScope, this});
        }
        boolean bl2 = false;
        if (CScopeComponentImpl.isServerStarted()) {
            try {
                if (bl && this._compensator instanceof OrderedCompensator) {
                    ((OrderedCompensator)((Object)this._compensator)).postFailureCompensate(cScope);
                } else {
                    this._compensator.compensate(cScope);
                }
                bl2 = true;
            }
            catch (RetryCompensatorException retryCompensatorException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Compensator has requested compensate call be retried");
                }
                ((CScopeImpl)cScope).persistTransactionOutcome((byte)1);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "compensate", retryCompensatorException);
                }
                throw retryCompensatorException;
            }
            catch (CompensationFailedException compensationFailedException) {
                FFDCFilter.processException((Throwable)compensationFailedException, "com.ibm.ws.cscope.CompensatorWrapper.compensate", "534", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CompensationFailedException received from compensator " + this._compensator, compensationFailedException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "compensate", compensationFailedException);
                }
                throw compensationFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CompensatorWrapper.compensate", "544", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexcepted exception caught from compensator " + this._compensator, exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"compensate", "CompensatorWrapper", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "compensate", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compensate", bl2);
        }
        return bl2;
    }

    public boolean promote(String string, CScope cScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promote", new Object[]{string, cScope, this});
        }
        if (this._type == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Wrapped combined compensator - calling promote");
            }
            try {
                this._promoteResponse = ((CombinedCompensator)this._compensator).promote(string, cScope);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CompensatorWrapper.promote", "581", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught calling promote on combined compensator", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"promote", "CompensatorWrapper", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promote", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Wrapped compensator - no promote call to make, response is true");
            }
            this._promoteResponse = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promote", this._promoteResponse);
        }
        return this._promoteResponse;
    }

    public void demote(String string, CScope cScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "demote", new Object[]{string, cScope, this});
        }
        if (this._type == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Wrapped combined compensator - calling demote");
            }
            try {
                ((CombinedCompensator)this._compensator).demote(string, cScope);
            }
            catch (RetryCompensatorException retryCompensatorException) {
                FFDCFilter.processException((Throwable)retryCompensatorException, "com.ibm.ws.cscope.CompensatorWrapper.demote", "344", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "The compensator " + this._compensator + " has requested that the demote call be retried");
                }
                try {
                    this.retryDemote(string, cScope);
                }
                catch (CScopeSystemException cScopeSystemException) {
                    FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.CompensatorWrapper.demote", "393", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "demote", cScopeSystemException);
                    }
                    throw cScopeSystemException;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CompensatorWrapper.demote", "601", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught calling demote on combined compensator", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"demote", "CompensatorWrapper", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "demote", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Wrapped compensator - no demote call to make");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "demote");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retryDemote(String string, CScope cScope) throws CScopeSystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retryDemote", new Object[]{string, cScope, this});
        }
        boolean bl = false;
        int n = UserCompensationScopeImpl.getCompensatorRetryLimit();
        long l = UserCompensationScopeImpl.getCompensatorRetryInterval();
        boolean bl2 = n == -1;
        for (int i = 0; (bl2 || i < n) && CScopeComponentImpl.isServerStarted(); ++i) {
            try {
                Object object = RETRY_LOCK;
                synchronized (object) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for " + l + " milliseconds before retrying");
                    }
                    if (l != 0L) {
                        RETRY_LOCK.wait(l);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.cscope.CompensatorWrapper.retryDemote", "508", this);
            }
            finally {
                l *= 2L;
            }
            if (!CScopeComponentImpl.isServerStarted()) continue;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling demote on compensator " + this._compensator);
                }
                ((CombinedCompensator)this._compensator).demote(string, cScope);
                bl = true;
                break;
            }
            catch (RetryCompensatorException retryCompensatorException) {
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.CompensatorWrapper.retryDemote", "537", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception caught from compensator during demote retry", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"retryDemote", "CompensatorWrapper", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "retryDemote", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retryDemote", bl);
        }
        return bl;
    }

    public int compareTo(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareTo", new Object[]{object, this});
        }
        int n = 1;
        if (this._compensator instanceof OrderedCompensator) {
            Compensator compensator = ((CompensatorWrapper)object).getCompensator();
            n = compensator instanceof OrderedCompensator ? ((OrderedCompensator)((Object)this._compensator)).compareTo(compensator) : -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareTo", new Integer(n));
        }
        return n;
    }

    public boolean isLogged() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isLogged", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isLogged", this._logged);
        }
        return this._logged;
    }

    public void setLogged(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLogged", new Object[]{bl, this});
        }
        this._logged = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLogged");
        }
    }

    public boolean isTransactional() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTransactional", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTransactional", this._transactional);
        }
        return this._transactional;
    }

    public String getJ2EEName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2EEName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEName", this._j2eeName);
        }
        return this._j2eeName;
    }
}

