/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.javax.activity.ActivityCoordinator;
import com.ibm.ws.javax.activity.CoordinationInformation;
import com.ibm.ws.javax.activity.Outcome;
import com.ibm.ws.javax.activity.Signal;
import com.ibm.ws.javax.activity.SignalSetActiveException;
import com.ibm.ws.javax.activity.SignalSetInactiveException;
import com.ibm.ws.javax.activity.coordination.SubordinateSignalSet;
import java.io.Serializable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;

public class CompletionSignalSet
implements SubordinateSignalSet {
    private static final TraceComponent tc = Tr.register(CompletionSignalSet.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    public static final String COMPLETION_SUCCESS = "CompletionSuccess";
    public static final String COMPLETION_ERROR = "CompletionError";
    public static final String SIGNAL_SET_NAME = "com.ibm.ws.cscope.Completion";
    public static final String CLOSE_SIGNAL_NAME = "close";
    public static final String COMPENSATE_SIGNAL_NAME = "compensate";
    public static final String CANCEL_SIGNAL_NAME = "cancel";
    private boolean _signalSent = false;
    private int _compStatus;
    private Outcome _outcome = new Outcome("CompletionSuccess", (Serializable)null);

    public String getSignalSetName() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignalSetName", SIGNAL_SET_NAME);
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "getSignalSetName returning:com.ibm.ws.cscope.Completion");
        }
        return SIGNAL_SET_NAME;
    }

    public Signal getSignal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignal");
        }
        String string = null;
        Signal signal = null;
        if (!this._signalSent) {
            string = this._compStatus == 0 ? CLOSE_SIGNAL_NAME : COMPENSATE_SIGNAL_NAME;
            signal = new Signal(string, SIGNAL_SET_NAME, (Serializable)null);
            this._signalSent = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignal", signal);
        }
        return signal;
    }

    public void setSignal(Signal signal) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignal", signal);
        }
        this._signalSent = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignal");
        }
    }

    public CoordinationInformation setResponse(Outcome outcome) throws SignalSetInactiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setResponse", outcome);
        }
        CoordinationInformation coordinationInformation = null;
        if (!this._signalSent) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setResponse called prior to signal being sent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setResponse", "SignalSetInactiveException");
            }
            throw new SignalSetInactiveException();
        }
        String string = outcome.getName();
        if (string.equals(COMPLETION_SUCCESS)) {
            coordinationInformation = new CoordinationInformation(true, false);
        } else if (string.equals("org.omg.CosActivity.ActionSystemException")) {
            Serializable serializable = outcome.getExtendedValue();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "ActionSystemException recieved; contained exception is: " + serializable);
            }
            if (serializable instanceof COMM_FAILURE || serializable instanceof NO_RESPONSE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot contact subord - spin off a thread for this action and continue");
                }
                coordinationInformation = new CoordinationInformation(true, false);
            } else if (serializable instanceof OBJECT_NOT_EXIST) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received OBJECT_NOT_EXIST from subordinate");
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"setResponse", "BeforeCompSigSet", serializable});
                coordinationInformation = new CoordinationInformation(true, false);
            }
        } else if (string.equals("org.omg.CosActivity.ActionError")) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "ActionError received - log message and continue signaling");
            }
            Tr.error(tc, "ERR_SUBORD_ERROR", string);
            coordinationInformation = new CoordinationInformation(true, false);
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected outcome: " + outcome.getName() + " received - log message and continue signaling");
            }
            Tr.error(tc, "ERR_SUBORD_ERROR", string);
            coordinationInformation = new CoordinationInformation(true, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setResponse", coordinationInformation);
        }
        return coordinationInformation;
    }

    public Outcome getOutcome() throws SignalSetActiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutcome");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutcome", this._outcome);
        }
        return this._outcome;
    }

    public Outcome getCurrentOutcome() throws SignalSetInactiveException {
        return new Outcome(COMPLETION_SUCCESS, (Serializable)null);
    }

    public void setCompletionStatus(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCompletionStatus", new Object[]{new Integer(n), new Integer(n2)});
        }
        this._compStatus = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCompletionStatus");
        }
    }

    public int getCompletionStatus() throws SignalSetActiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompletionStatus");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompletionStatus", new Integer(this._compStatus));
        }
        return this._compStatus;
    }

    public void destroy() {
    }

    public void setActivityCoordinator(ActivityCoordinator activityCoordinator) throws SignalSetActiveException {
    }
}

