/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.cscope.CScopeImpl;
import com.ibm.ws.cscope.CScopeSystemException;
import com.ibm.ws.cscope.Compensator;
import com.ibm.ws.cscope.CompensatorRecord;
import com.ibm.ws.cscope.CompensatorWrapper;
import com.ibm.ws.cscope.XidImpl;
import com.ibm.ws.cscope.util.TraceUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCoordinator;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import com.ibm.ws.util.LongObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class RecoveredData
implements Comparable {
    private static final TraceComponent tc = Tr.register(RecoveredData.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    private byte _cScopeType = (byte)-1;
    private GlobalId _parentGlobalId = null;
    private GlobalId _globalId = null;
    private XidImpl _xid = null;
    private ArrayList _compensatorRecords = null;
    private byte _txOutcome = (byte)-1;
    private RecoverableUnit _recoverableUnit;
    private boolean _isOnePhase = false;
    private ActivityCoordinator _activityCoordinator = null;
    private RecoveredData _child = null;
    private RecoveredData _parent = null;
    private CScopeImpl _cScope = null;
    private List _loopbackRecoveredData;
    private boolean _propagateOnWebServiceRequests;
    private Boolean _promoteCompensators;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RecoveredData(RecoverableUnit recoverableUnit) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoveredData", recoverableUnit);
        }
        this._recoverableUnit = recoverableUnit;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RecoverableUnit ID: " + this._recoverableUnit.identity());
        }
        try {
            Object object;
            Object object2;
            block44: {
                RecoverableUnitSection recoverableUnitSection;
                block53: {
                    block55: {
                        block54: {
                            RecoverableUnitSection recoverableUnitSection2;
                            byte[] byArray;
                            RecoverableUnitSection recoverableUnitSection3;
                            block51: {
                                block52: {
                                    block49: {
                                        block50: {
                                            RecoverableUnitSection recoverableUnitSection4;
                                            block47: {
                                                block48: {
                                                    block45: {
                                                        block46: {
                                                            RecoverableUnitSection recoverableUnitSection5 = recoverableUnit.lookupSection(0);
                                                            if (recoverableUnitSection5 == null) break block45;
                                                            byte[] byArray2 = recoverableUnitSection5.lastData();
                                                            if (byArray2 == null) break block46;
                                                            this._globalId = new GlobalIdImpl(byArray2);
                                                            if (!tc.isDebugEnabled()) break block47;
                                                            break block48;
                                                        }
                                                        if (tc.isDebugEnabled()) {
                                                            Tr.debug(tc, "Null data returned from global ID RUS");
                                                        }
                                                        throw new CScopeSystemException();
                                                    }
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "No CScope global ID found in log.");
                                                    }
                                                    throw new CScopeSystemException();
                                                }
                                                Tr.debug(tc, "GlobalID", this._globalId);
                                            }
                                            if ((recoverableUnitSection4 = recoverableUnit.lookupSection(1)) == null) break block49;
                                            byte[] byArray3 = recoverableUnitSection4.lastData();
                                            if (byArray3 == null) break block50;
                                            byte by = recoverableUnitSection4.lastData()[0];
                                            if (by != 0 && by != 1) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Unexpected CScope type found in log.", new Byte(by));
                                                }
                                                throw new CScopeSystemException();
                                            }
                                            this._cScopeType = by;
                                            if (!tc.isDebugEnabled()) break block51;
                                            break block52;
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Null data returned from CScope type RUS");
                                        }
                                        throw new CScopeSystemException();
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "No record of the CScope's type found in log.");
                                    }
                                    throw new CScopeSystemException();
                                }
                                Tr.debug(tc, "CScope type", TraceUtils.printCScopeType(this._cScopeType));
                            }
                            if ((recoverableUnitSection3 = recoverableUnit.lookupSection(3)) != null) {
                                byte[] byArray4 = recoverableUnitSection3.lastData();
                                if (byArray4 != null) {
                                    this._parentGlobalId = new GlobalIdImpl(byArray4);
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Null data returned from parent global ID RUS");
                                    }
                                    throw new CScopeSystemException();
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Parent GlobalId", this._parentGlobalId);
                            }
                            if ((byArray = (recoverableUnitSection2 = recoverableUnit.lookupSection(7)).lastData()) != null) {
                                boolean bl = this._propagateOnWebServiceRequests = byArray[0] == 1;
                            }
                            if (this._cScopeType != 0) break block53;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Root CScope - recovering UOW information");
                            }
                            if ((recoverableUnitSection = recoverableUnit.lookupSection(4)) == null) break block53;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found xid RUS");
                            }
                            if ((object2 = recoverableUnitSection.lastData()) == null) break block54;
                            object = new ObjectInputStream(new ByteArrayInputStream((byte[])object2));
                            this._xid = (XidImpl)((ObjectInputStream)object).readObject();
                            if (!tc.isDebugEnabled()) break block53;
                            break block55;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Null data returned from Xid RUS");
                        }
                        throw new CScopeSystemException();
                    }
                    Tr.debug(tc, "Transaction Xid", this._xid);
                }
                if ((recoverableUnitSection = recoverableUnit.lookupSection(5)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found tx outcome RUS");
                    }
                    if ((object2 = recoverableUnitSection.lastData()) != null) {
                        this._txOutcome = object2[0];
                        break block44;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Null data returned from OUW outcome type RUS");
                        }
                        throw new CScopeSystemException();
                    }
                }
                if (this._cScopeType == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No tx outcome RUS");
                    }
                    this._txOutcome = 1;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UOW outcome", TraceUtils.printTxOutcome(this._txOutcome));
            }
            if (this._cScopeType == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subordinate CScope - recovering One Phase UOW identifier");
                }
                if ((object2 = (Object)recoverableUnit.lookupSection(6)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found One Phase UOW identifier RUS");
                    }
                    if ((object = (Object)object2.lastData()) != null) {
                        Object object3 = object[0];
                        if (object3 == false) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "UOW is one phase");
                            }
                            this._isOnePhase = true;
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unexcepted one phase UOW identifier found in the log");
                            }
                            throw new CScopeSystemException();
                        }
                    }
                }
            }
            if ((object2 = (Object)recoverableUnit.lookupSection(2)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found compensator RUS");
                }
                object = object2.data();
                this._compensatorRecords = new ArrayList();
                while (object.hasNext()) {
                    byte[] byArray = (byte[])object.next();
                    this._compensatorRecords.add(new CompensatorRecord(byArray));
                }
            }
        }
        catch (CScopeSystemException cScopeSystemException) {
            FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.RecoveredData.<init>", "300", this);
            Tr.error(tc, "ERR_LOG_CORRUPT", this._globalId);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RecoveredData", cScopeSystemException);
            }
            throw cScopeSystemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveredData.<init>", "126", this);
            Tr.error(tc, "ERR_RECOVERY_FAILURE", exception);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Recovery log failure - unable to recover CScope", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RecoveredData", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoveredData", this);
        }
    }

    protected GlobalId getGlobalId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalId", this._globalId);
        }
        return this._globalId;
    }

    protected XidImpl getXid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXid", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXid", this._xid);
        }
        return this._xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RecoverableUnitSection setTxOutcome(byte by) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTxOutcome", new Object[]{TraceUtils.printTxOutcome(by), this});
        }
        try {
            this._txOutcome = by;
            RecoverableUnitSection recoverableUnitSection = null;
            RecoverableUnit recoverableUnit = this._recoverableUnit;
            synchronized (recoverableUnit) {
                recoverableUnitSection = this._recoverableUnit.lookupSection(5);
                if (recoverableUnitSection == null) {
                    recoverableUnitSection = this._recoverableUnit.createSection(5, true);
                }
                recoverableUnitSection.addData(new byte[]{by});
                this._recoverableUnit.forceSections();
                if (this._cScope != null) {
                    this._cScope.setTxOutcomeRecoverableUnitSection(recoverableUnitSection);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTxOutcome", recoverableUnitSection);
            }
            return recoverableUnitSection;
        }
        catch (RecoverableUnitSectionExistsException recoverableUnitSectionExistsException) {
            FFDCFilter.processException((Throwable)recoverableUnitSectionExistsException, "com.ibm.ws.cscope.RecoveredData.setTxOutcome", "357", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Tx outcome RUS already exists", recoverableUnitSectionExistsException);
            }
            Tr.error(tc, "ERR_PERSIST_FAILURE", recoverableUnitSectionExistsException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTxOutcome", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (LogFullException logFullException) {
            FFDCFilter.processException((Throwable)logFullException, "com.ibm.ws.cscope.RecoveredData.setTxOutcome", "365", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Log full trying to persist tx outcome", logFullException);
            }
            Tr.error(tc, "ERR_LOG_FULL");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTxOutcome", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.cscope.RecoveredData.setTxOutcome", "373", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Log failed persisting tx outcome", internalLogException);
            }
            Tr.error(tc, "ERR_PERSIST_FAILURE", internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTxOutcome", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveredData.setTxOutcome", "338", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected Exception caught persisting tx outcome", exception);
            }
            Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"setTxOutcome", "RecoveredData", exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTxOutcome", "CScopeSystemException");
            }
            throw new CScopeSystemException();
        }
    }

    protected GlobalId getParentGlobalId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentGlobalId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentGlobalId", this._parentGlobalId);
        }
        return this._parentGlobalId;
    }

    protected void setChild(RecoveredData recoveredData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setChild", new Object[]{recoveredData, this});
        }
        this._child = recoveredData;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setChild");
        }
    }

    protected RecoveredData getChild() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChild", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChild", this._child);
        }
        return this._child;
    }

    protected byte getTxOutcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTxOutcome", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTxOutcome", TraceUtils.printTxOutcome(this._txOutcome));
        }
        return this._txOutcome;
    }

    protected void setActivityCoordinator(ActivityCoordinator activityCoordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setActivityCoordinator", new Object[]{activityCoordinator, this});
        }
        this._activityCoordinator = activityCoordinator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setActivityCoordinator");
        }
    }

    protected ActivityCoordinator getActivityCoordinator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivityCoordinator", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivityCoordinator", this._activityCoordinator);
        }
        return this._activityCoordinator;
    }

    protected void setParent(RecoveredData recoveredData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParent", new Object[]{recoveredData, this});
        }
        this._parent = recoveredData;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParent");
        }
    }

    protected RecoveredData getParent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParent", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParent", this._parent);
        }
        return this._parent;
    }

    protected byte getCScopeType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCScopeType", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCScopeType", TraceUtils.printCScopeType(this._cScopeType));
        }
        return this._cScopeType;
    }

    protected RecoverableUnit getRecoverableUnit() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoverableUnit", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoverableUnit", this._recoverableUnit);
        }
        return this._recoverableUnit;
    }

    protected CompensatorWrapper[] getCompensators() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompensators", this);
        }
        CompensatorWrapper[] compensatorWrapperArray = null;
        if (this._compensatorRecords != null) {
            CompensatorRecord[] compensatorRecordArray = this._compensatorRecords.toArray(new CompensatorRecord[0]);
            LongObjectHashMap longObjectHashMap = new LongObjectHashMap();
            try {
                for (int i = 0; i < compensatorRecordArray.length; ++i) {
                    int n;
                    CompensatorWrapper compensatorWrapper;
                    CompensatorRecord compensatorRecord = compensatorRecordArray[i];
                    byte by = compensatorRecord.getType();
                    if (by == 4) {
                        longObjectHashMap = null;
                        break;
                    }
                    if (by == 2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Compensator removed");
                        }
                        Object object = longObjectHashMap.remove(compensatorRecord.getCompensatorId());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Wrapped removed from map", object);
                        continue;
                    }
                    if (by == 0 || by == 1 || by == 5 || by == 6) {
                        CompensatorWrapper compensatorWrapper2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Compensator added or updated - deserializing compensator");
                        }
                        Compensator compensator = compensatorRecord.getCompensator();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Compensator recovered", compensator.getName());
                        }
                        int n2 = compensatorRecord.getCompensatorId();
                        if (by == 0 || by == 5) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Compensator added");
                            }
                            compensatorWrapper2 = new CompensatorWrapper(compensator, compensatorRecord.isTransactional(), n2, compensatorRecord.getJ2EEName());
                            longObjectHashMap.put(n2, compensatorWrapper2);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Compensator updated");
                        }
                        if ((compensatorWrapper2 = (CompensatorWrapper)longObjectHashMap.get(n2)) != null) {
                            compensatorWrapper2.setCompensator(compensator);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Update record found before add record.");
                        }
                        throw new CScopeSystemException();
                    }
                    if (by != 3) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Compensator promote response");
                    }
                    if ((compensatorWrapper = (CompensatorWrapper)longObjectHashMap.get(n = compensatorRecord.getCompensatorId())) != null) {
                        compensatorWrapper.setPromoteResponse(compensatorRecord.getPromoteResponse());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Promote response record found before add record.");
                    }
                    throw new CScopeSystemException();
                }
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.RecoveredData.getCompensators", "636", this);
                Tr.error(tc, "ERR_LOG_CORRUPT", this._globalId);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCompensators", cScopeSystemException);
                }
                throw cScopeSystemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveredData.getCompensators", "649", this);
                Tr.error(tc, "ERR_RECOVERY_FAILURE", exception);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Malformed compensator data - unable to recover CScope", exception);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCompensators", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
            if (longObjectHashMap != null) {
                Object[] objectArray = longObjectHashMap.values();
                compensatorWrapperArray = new CompensatorWrapper[objectArray.length];
                System.arraycopy(objectArray, 0, compensatorWrapperArray, 0, compensatorWrapperArray.length);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompensators", compensatorWrapperArray);
        }
        return compensatorWrapperArray;
    }

    protected void setCScope(CScopeImpl cScopeImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCScope", new Object[]{cScopeImpl, this});
        }
        this._cScope = cScopeImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCScope");
        }
    }

    protected CScopeImpl getCScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCScope", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCScope", this._cScope);
        }
        return this._cScope;
    }

    protected boolean isOnePhase() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isOnePhase", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isOnePhase", this._isOnePhase);
        }
        return this._isOnePhase;
    }

    protected boolean isUOWOutcomeKnown() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUOWOutcomeKnown", this);
        }
        boolean bl = false;
        if (this._cScopeType == 1 || this._cScopeType == 0 && this._txOutcome != 2) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUOWOutcomeKnown", bl);
        }
        return bl;
    }

    public String toString() {
        return "RecoveredData: " + TraceUtils.printCScopeType(this._cScopeType) + " " + this._globalId;
    }

    protected void addLoopbackRecoveredData(RecoveredData recoveredData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addLoopbackRecoveredData", new Object[]{recoveredData, this});
        }
        if (this._loopbackRecoveredData == null) {
            this._loopbackRecoveredData = new ArrayList();
        }
        this._loopbackRecoveredData.add(recoveredData);
        List list = recoveredData.getLoopbackRecoveredData();
        if (list != null) {
            this._loopbackRecoveredData.addAll(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addLoopbackRecoveredData");
        }
    }

    protected List getLoopbackRecoveredData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoopbackRecoveredData", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoopbackRecoveredData", this._loopbackRecoveredData);
        }
        return this._loopbackRecoveredData;
    }

    public boolean propagateOnWebServiceRequests() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateOnWebServiceRequests", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateOnWebServiceRequests", this._propagateOnWebServiceRequests);
        }
        return this._propagateOnWebServiceRequests;
    }

    public int compareTo(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareTo", new Object[]{object, this});
        }
        RecoveredData recoveredData = (RecoveredData)object;
        if (this._cScopeType == recoveredData._cScopeType) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compareTo", "0");
            }
            return 0;
        }
        if (this._cScopeType == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compareTo", "-1");
            }
            return -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareTo", "1");
        }
        return 1;
    }

    public void setPromoteCompensators(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPromoteCompensators", new Object[]{bl, this});
        }
        this._promoteCompensators = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPromoteCompensators");
        }
    }

    public Boolean getPromoteCompensators() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPromoteCompensators", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPromoteCompensators", this._promoteCompensators);
        }
        return this._promoteCompensators;
    }
}

