/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.WebSphereActivityCoordinator;
import com.ibm.ws.cscope.CScopeComponentImpl;
import com.ibm.ws.cscope.CScopeImpl;
import com.ibm.ws.cscope.CScopeLogConfiguration;
import com.ibm.ws.cscope.CScopeRecoveryAgent;
import com.ibm.ws.cscope.CScopeServiceManager;
import com.ibm.ws.cscope.CScopeSystemException;
import com.ibm.ws.cscope.RecoveredData;
import com.ibm.ws.cscope.XidImpl;
import com.ibm.ws.cscope.util.TraceUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityManager;
import com.ibm.ws.javax.activity.GlobalId;
import com.ibm.ws.javax.activity.Signal;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.StreamLogProperties;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.wsba.systemapp.BusinessAgreementWithParticipantCompletionParticipantPortSoapBindingImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class RecoveryManager
extends Thread
implements XAResource {
    private static final TraceComponent tc = Tr.register(RecoveryManager.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    private static RecoveryLogManager _recoveryLogManager = null;
    private RecoveryLog _recoveryLog = null;
    protected static final String CSCOPE_LOG_NAME = "logs";
    protected static int INITIAL_LOG_SIZE = 1024;
    private HashMap _recoveredData = new HashMap();
    private FailureScope _failureScope;
    private ActivityManager _activityManager;
    private boolean _relationshipsEstablished = false;
    private boolean _terminate = false;
    private boolean _processingRecoveredData = false;
    private static final Object TERMINATION_LOCK = new Object();
    private RecoveryDirector _recoveryDirector = null;
    private boolean _recoveryPrevented = false;

    public RecoveryManager(FailureScope failureScope, RecoveryDirector recoveryDirector, CScopeRecoveryAgent cScopeRecoveryAgent) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoveryManager", new Object[]{failureScope, recoveryDirector, cScopeRecoveryAgent});
        }
        this._failureScope = failureScope;
        this._recoveryDirector = recoveryDirector;
        try {
            this._recoveryLog = _recoveryLogManager.getRecoveryLog(this._failureScope, RecoveryManager.getLogProperties(this._failureScope));
            object = this._recoveryDirector.currentFailureScope();
            if (object.isSameExecutionZone(this._failureScope)) {
                CScopeComponentImpl.setRecoveryLog(_recoveryLogManager.getRecoveryLog((FailureScope)object, RecoveryManager.getLogProperties(failureScope)));
            }
            this._recoveryLog.openLog();
        }
        catch (LogIncompatibleException logIncompatibleException) {
            FFDCFilter.processException((Throwable)logIncompatibleException, "com.ibm.ws.cscope.RecoveryManager.RecoveryManager", "157", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "LogIncompatibleException caught opening CScope recovery log", logIncompatibleException);
            }
            this._recoveryPrevented = true;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveryManager.RecoveryManager", "161", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught opening recovery log", exception);
            }
            Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"<init>", "com.ibm.ws.cscope.RecoveryManager", exception});
            CScopeSystemException cScopeSystemException = new CScopeSystemException(exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RecoveryManager", cScopeSystemException);
            }
            throw cScopeSystemException;
        }
        if (!this._recoveryPrevented) {
            if (!CScopeComponentImpl.isPeerRecoveryRestartMode()) {
                try {
                    object = new InitialContext();
                    this._activityManager = (ActivityManager)((InitialContext)object).lookup("services:websphere/ActivityManager");
                    this._activityManager.registerService(new CScopeServiceManager(this._failureScope, CScopeComponentImpl.getInstance().getLogConfiguration(this._failureScope).getLogDirectory()));
                    this._activityManager.setTimeout(-1);
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.cscope.RecoveryManager.<init>", "99", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "JNDI lookup of ActivityManager failed", namingException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "RecoveryManager", "CScopeSystemException");
                    }
                    throw new CScopeSystemException();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveryManager.<init>", "107", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected exception caught when registering with activity service", exception);
                    }
                    Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"RecoveryManager", "RecoveryManager", exception});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "RecoveryManager", "CScopeSystemException");
                    }
                    throw new CScopeSystemException();
                }
                try {
                    this._activityManager.recover();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveryManager.<init>", "115", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught when driving Activity service recovery", exception);
                    }
                    Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"RecoveryManager", "RecoveryManager", exception});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "RecoveryManager", "CScopeSystemException");
                    }
                    throw new CScopeSystemException();
                }
            }
            object = null;
            try {
                object = this._recoveryLog.recoverableUnits();
                int n = object.initialSize();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, n + " CScope(s) found in the log.");
                }
                if (n > 0) {
                    while (object.hasNext()) {
                        RecoverableUnit recoverableUnit = (RecoverableUnit)object.next();
                        try {
                            RecoveredData recoveredData = new RecoveredData(recoverableUnit);
                            GlobalId globalId = recoveredData.getGlobalId();
                            RecoveredData recoveredData2 = (RecoveredData)this._recoveredData.get(globalId);
                            if (recoveredData2 != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Loopback detected during recovery");
                                }
                                if (recoveredData2.getCScopeType() == 0 || recoveredData.getCScopeType() != 0) {
                                    recoveredData2.addLoopbackRecoveredData(recoveredData);
                                    continue;
                                }
                                recoveredData.addLoopbackRecoveredData(recoveredData2);
                                this._recoveredData.put(globalId, recoveredData);
                                continue;
                            }
                            this._recoveredData.put(recoveredData.getGlobalId(), recoveredData);
                            BusinessAgreementWithParticipantCompletionParticipantPortSoapBindingImpl.cScopeRecreationPending(globalId, this);
                        }
                        catch (CScopeSystemException cScopeSystemException) {
                            FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.RecoveryManager.<init>", "119", this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "CScopeSystemException caught when creating recovered data ... absorbing");
                            }
                            object.remove();
                        }
                    }
                    object.close();
                    this._recoveryDirector.serialRecoveryComplete(cScopeRecoveryAgent, failureScope);
                } else {
                    object.close();
                    this.closeLog();
                    this._recoveryDirector.serialRecoveryComplete(cScopeRecoveryAgent, failureScope);
                    this._recoveryDirector.initialRecoveryComplete(cScopeRecoveryAgent, failureScope);
                }
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.RecoveryManager.<init>", "139", this);
                if (object != null) {
                    object.close();
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CScopeSystemException caught - rethrowing");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "RecoveryManager", cScopeSystemException);
                }
                throw cScopeSystemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveryManager.<init>", "143", this);
                if (object != null) {
                    object.close();
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught when processing logged data", exception);
                }
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"RecoveryManager", "RecoveryManager", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "RecoveryManager", "CScopeSystemException");
                }
                throw new CScopeSystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoveryManager", this);
        }
    }

    protected static void setRecoveryLogManager(RecoveryLogManager recoveryLogManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRecoveryLogManager", recoveryLogManager);
        }
        _recoveryLogManager = recoveryLogManager;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRecoveryLogManager");
        }
    }

    protected static LogProperties getLogProperties(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLogProperties", failureScope);
        }
        LogProperties logProperties = null;
        CScopeLogConfiguration cScopeLogConfiguration = CScopeComponentImpl.getInstance().getLogConfiguration(failureScope);
        String string = cScopeLogConfiguration.getLogDirectory();
        int n = cScopeLogConfiguration.getMaximumLogSize();
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating LogFileProperties with values: logSize: " + n);
            }
            logProperties = new FileLogProperties(3, CSCOPE_LOG_NAME, INITIAL_LOG_SIZE, n);
        } else {
            String string2 = null;
            String string3 = null;
            if (string.toLowerCase().startsWith("logstream://") || string.toLowerCase().startsWith("stream://")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":/");
                string2 = stringTokenizer.nextToken();
                if (!string.toUpperCase().endsWith("://")) {
                    string3 = stringTokenizer.nextToken();
                }
                if (string3 == null || string3.length() < 1 || string3.length() > 8) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "UNEXPECTED_LOGSTREAMFILE_SPECIFICATION: Creating FileLogProperties with values: logSize: " + n);
                    }
                    logProperties = new FileLogProperties(3, CSCOPE_LOG_NAME, INITIAL_LOG_SIZE, n);
                } else {
                    logProperties = new StreamLogProperties(3, CSCOPE_LOG_NAME, string3);
                }
            } else {
                String string4 = System.getProperty("file.separator");
                string = string + string4 + "compensation" + string4 + CSCOPE_LOG_NAME;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating LogFileProperties with values: logSize: " + n + " logDir: " + string);
                }
                logProperties = new FileLogProperties(3, CSCOPE_LOG_NAME, string, INITIAL_LOG_SIZE, n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLogProperties", logProperties);
        }
        return logProperties;
    }

    protected void setServerStatus(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerStatus", new Object[]{string, this});
        }
        if (string.equals("STARTED") && !CScopeComponentImpl.isPeerRecoveryRestartMode()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server startup complete - processing recovered CScopes");
            }
            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a z/OS Server - about to process recovered CScopes");
                }
                try {
                    this.getThreadPool().executeOnDaemon(this);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception " + exception);
                    }
                    this.processRecoveredData();
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Is a z/OS Server - processing recovered CScopes");
                }
                this.processRecoveredData();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerStatus");
        }
    }

    public ThreadPool getThreadPool() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPool");
        }
        ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)WsServiceRegistry.getService((Object)this, (Class)ThreadPoolMgr.class);
        ThreadPool threadPool = threadPoolMgr.getThreadPool("Default");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool", threadPool);
        }
        return threadPool;
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run", this);
        }
        if (!CScopeComponentImpl.isPeerRecoveryRestartMode()) {
            this.processRecoveredData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void processRecoveredData() {
        if (RecoveryManager.tc.isEntryEnabled()) {
            Tr.entry(RecoveryManager.tc, "processRecoveredData", this);
        }
        if (this._recoveryPrevented) ** GOTO lbl129
        if (!this._relationshipsEstablished) {
            this.establishParentToChildRelationships();
            this._relationshipsEstablished = true;
        }
        if (this._recoveredData.size() <= 0) ** GOTO lbl129
        var1_1 = RecoveryManager.TERMINATION_LOCK;
        synchronized (RecoveryManager.TERMINATION_LOCK) {
            this._processingRecoveredData = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            var1_1 = this._recoveredData.values().toArray(new RecoveredData[0]);
            Arrays.sort(var1_1);
            var2_2 = new ArrayList<Object>();
            var3_3 = 0;
            while (true) {
                block55: {
                    block57: {
                        block56: {
                            if (var3_3 >= var1_1.length || this._terminate) break;
                            if (RecoveryManager.tc.isDebugEnabled()) {
                                Tr.debug(RecoveryManager.tc, "Processing recovered CScope " + (var3_3 + 1) + " of " + var1_1.length);
                            }
                            var4_5 = var1_1[var3_3];
                            if (RecoveryManager.tc.isDebugEnabled()) {
                                Tr.debug(RecoveryManager.tc, "Processing recovered data " + var4_5);
                            }
                            if (var4_5.getParent() == null) break block56;
                            if (RecoveryManager.tc.isDebugEnabled()) {
                                Tr.debug(RecoveryManager.tc, "Not top-level");
                            }
                            break block55;
                        }
                        if (var4_5.getCScopeType() == 0) break block57;
                        if (var4_5.isUOWOutcomeKnown()) ** GOTO lbl-1000
                        if (RecoveryManager.tc.isDebugEnabled()) {
                            Tr.debug(RecoveryManager.tc, "Outcome of UOW is not yet known.");
                        }
                        break block55;
                    }
                    while (!var4_5.isUOWOutcomeKnown() && !this._terminate) {
                        if (RecoveryManager.tc.isEventEnabled()) {
                            Tr.event(RecoveryManager.tc, "Waiting for UOW outcome", var4_5);
                        }
                        try {
                            Thread.sleep(1000L);
                            if (!CScopeComponentImpl.isServerStopping()) continue;
                            if (RecoveryManager.tc.isEntryEnabled()) {
                                Tr.exit(RecoveryManager.tc, "processRecoveredData");
                            }
                            return;
                        }
                        catch (InterruptedException var5_6) {
                        }
                    }
                    if (this._terminate) {
                        if (RecoveryManager.tc.isDebugEnabled()) {
                            Tr.debug(RecoveryManager.tc, "Terminate detected.");
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        var5_7 = true;
                        var7_17 = 1;
                        for (var6_13 = var4_5.getChild(); var6_13 != null && var5_7; var6_13 = var6_13.getChild(), ++var7_17) {
                            var5_7 = var6_13.isUOWOutcomeKnown();
                        }
                        if (var5_7) {
                            if (RecoveryManager.tc.isDebugEnabled()) {
                                Tr.debug(RecoveryManager.tc, "Recreating hierarchy of depth " + var7_17);
                            }
                            var9_23 = null;
                            var10_24 = null;
                            var11_25 = null;
                            try {
                                for (var8_22 = var4_5; var8_22 != null; var8_22 = var8_22.getChild()) {
                                    var10_24 = var8_22.getGlobalId();
                                    var12_26 = this._activityManager.recreate(var10_24, var9_23, false);
                                    var8_22.getCScope().setActivityCoordinator((WebSphereActivityCoordinator)var12_26);
                                    BusinessAgreementWithParticipantCompletionParticipantPortSoapBindingImpl.cScopeRecreated(var10_24);
                                    var9_23 = var10_24;
                                    var11_25 = var8_22;
                                }
                            }
                            catch (Exception var12_27) {
                                FFDCFilter.processException((Throwable)var12_27, "com.ibm.ws.cscope.RecoveryManager.processRecoveredData", "248", this);
                                if (RecoveryManager.tc.isEventEnabled()) {
                                    Tr.event(RecoveryManager.tc, "Exception caught during Activity recreation", var12_27);
                                }
                                Tr.error(RecoveryManager.tc, "ERR_ACTIVITY_RECREATE", var12_27);
                                for (var8_22 = var4_5; var8_22 != null; var8_22 = var8_22.getChild()) {
                                    this._recoveredData.remove(var8_22.getGlobalId());
                                }
                                var1_1 = this._recoveredData.values().toArray(new RecoveredData[0]);
                                var3_3 = -1;
                                break block55;
                            }
                            var2_2.add(var11_25);
                        }
                    }
                }
                ++var3_3;
            }
            var3_4 = var2_2.iterator();
            while (true) {
                if (var3_4.hasNext() && !this._terminate) {
                    var5_8 = var4_5 = (RecoveredData)var3_4.next();
                    var6_15 = false;
                } else {
                    var1_1 = this._recoveredData.values().toArray(new RecoveredData[0]);
                    var4_5 = RecoveryManager.TERMINATION_LOCK;
                    synchronized (var4_5) {
                        this._processingRecoveredData = false;
                        if (this._terminate) {
                            RecoveryManager.TERMINATION_LOCK.notifyAll();
                        } else if (this._recoveredData.size() == 0) {
                            try {
                                var5_9 = this._activityManager.recover();
                                for (var6_16 = 0; var6_16 < var5_9.length; ++var6_16) {
                                    try {
                                        this._activityManager.forget(var5_9[var6_16]);
                                        continue;
                                    }
                                    catch (Exception var7_21) {
                                        FFDCFilter.processException((Throwable)var7_21, "com.ibm.ws.cscope.RecoveryManager.processRecoveredData", "398", this);
                                        if (RecoveryManager.tc.isEventEnabled()) {
                                            Tr.event(RecoveryManager.tc, "Exception caught forgetting activity " + var5_9[var6_16], var7_21);
                                        }
                                        Tr.error(RecoveryManager.tc, "ERR_UNEXPECTED_ERROR", new Object[]{"processRecoveredData", "RecoveryManager", var7_21});
                                    }
                                }
                            }
                            catch (Exception var5_10) {
                                FFDCFilter.processException((Throwable)var5_10, "com.ibm.ws.cscope.RecoveryManager.processRecoveredData", "408", var5_10);
                                if (RecoveryManager.tc.isEventEnabled()) {
                                    Tr.event(RecoveryManager.tc, "Exception caught getting remaining activities' global ids");
                                }
                                Tr.error(RecoveryManager.tc, "ERR_UNEXPECTED_ERROR", new Object[]{"processRecoveredData", "RecoveryManager", var5_10});
                            }
                            this.closeLog();
                            try {
                                RecoveryDirectorFactory.recoveryDirector().initialRecoveryComplete(CScopeRecoveryAgent.getInstance(), this._failureScope);
                            }
                            catch (InternalLogException var5_11) {
                                FFDCFilter.processException((Throwable)var5_11, "com.ibm.ws.cscope.RecoveryManager.processRecoveredData", "580", this);
                                Tr.error(RecoveryManager.tc, "ERR_RECOVERY_FAILURE", var5_11);
                            }
                            catch (Exception var5_12) {
                                FFDCFilter.processException((Throwable)var5_12, "com.ibm.ws.cscope.RecoveryManager.processRecoveredData", "494", this);
                            }
                        }
                    }
lbl129:
                    // 8 sources

                    if (RecoveryManager.tc.isEntryEnabled()) {
                        Tr.exit(RecoveryManager.tc, "processRecoveredData");
                    }
                    return;
                }
                while (var5_8 != null && !this._terminate) {
                    if (var5_8.getTxOutcome() == -1) {
                        if (RecoveryManager.tc.isEventEnabled()) {
                            Tr.event(RecoveryManager.tc, "Waiting for TX outcome", var5_8);
                        }
                        try {
                            Thread.sleep(1000L);
                            var6_15 = true;
                            if (!CScopeComponentImpl.isServerStopping()) continue;
                            if (RecoveryManager.tc.isEntryEnabled()) {
                                Tr.exit(RecoveryManager.tc, "processRecoveredData");
                            }
                            return;
                        }
                        catch (InterruptedException var7_19) {
                            continue;
                        }
                    }
                    var5_8 = var5_8.getParent();
                }
                if (this._terminate) {
                    if (!RecoveryManager.tc.isDebugEnabled()) continue;
                    Tr.debug(RecoveryManager.tc, "Terminate detected.");
                    continue;
                }
                if (var6_15) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException var7_20) {
                        // empty catch block
                    }
                }
                var5_8 = var4_5;
                while (true) {
                    if (var5_8 == null) ** break;
                    this.completeRecoveredData((RecoveredData)var5_8);
                    var5_8 = var5_8.getParent();
                }
                break;
            }
        }
    }

    private void completeRecoveredData(RecoveredData recoveredData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeRecoveredData", new Object[]{recoveredData, this});
        }
        byte by = recoveredData.getTxOutcome();
        CScopeImpl cScopeImpl = recoveredData.getCScope();
        if (cScopeImpl != null) {
            WebSphereActivityCoordinator webSphereActivityCoordinator = cScopeImpl.getActivityCoordinator(false);
            if (by == 0) {
                if (cScopeImpl.getType() == 1 && webSphereActivityCoordinator.getSuperiorCoordinatorType() == 2) {
                    try {
                        webSphereActivityCoordinator.preCompletion(0);
                        webSphereActivityCoordinator.processSignal(new Signal("close", "com.ibm.ws.cscope.Completion", recoveredData.getPromoteCompensators()));
                        webSphereActivityCoordinator.postCompletion(0);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveryManager.completeRecoveredData", "686", this);
                        CScopeSystemException cScopeSystemException = new CScopeSystemException(exception);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "completeRecoveredData", cScopeSystemException);
                        }
                        throw cScopeSystemException;
                    }
                } else {
                    cScopeImpl.close();
                }
            } else if (by == 1) {
                if (cScopeImpl.getType() == 1 && webSphereActivityCoordinator.getSuperiorCoordinatorType() == 2) {
                    try {
                        webSphereActivityCoordinator.preCompletion(0);
                        webSphereActivityCoordinator.processSignal(new Signal("compensate", "com.ibm.ws.cscope.Completion", recoveredData.getPromoteCompensators()));
                        webSphereActivityCoordinator.postCompletion(0);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveryManager.completeRecoveredData", "686", this);
                        CScopeSystemException cScopeSystemException = new CScopeSystemException(exception);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "completeRecoveredData", cScopeSystemException);
                        }
                        throw cScopeSystemException;
                    }
                } else {
                    cScopeImpl.compensate();
                }
            }
            try {
                this._activityManager.suspendAll();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveryManager.completeRecoveredData", "731", this);
                CScopeSystemException cScopeSystemException = new CScopeSystemException(exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completeRecoveredData", cScopeSystemException);
                }
                throw cScopeSystemException;
            }
        }
        this._recoveredData.remove(recoveredData.getGlobalId());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeRecoveredData");
        }
    }

    private void establishParentToChildRelationships() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "establishParentToChildRelationships", this);
        }
        Iterator iterator = this._recoveredData.values().iterator();
        while (iterator.hasNext()) {
            RecoveredData recoveredData = (RecoveredData)iterator.next();
            GlobalId globalId = recoveredData.getParentGlobalId();
            if (globalId == null) continue;
            RecoveredData recoveredData2 = (RecoveredData)this._recoveredData.get(globalId);
            if (recoveredData2 != null) {
                recoveredData2.setChild(recoveredData);
            }
            recoveredData.setParent(recoveredData2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "establishParentToChildRelationships");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Object[]{xid, bl, this});
        }
        try {
            this.setTxOutcome(xid, (byte)0);
            if (CScopeComponentImpl.isServerStarted() && !CScopeComponentImpl.isPeerRecoveryRestartMode() && !this._processingRecoveredData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server is started - processing data");
                }
                this.processRecoveredData();
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
        }
    }

    public Xid[] recover(int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", new Object[]{new Integer(n), this});
        }
        RecoveredData[] recoveredDataArray = this._recoveredData.values().toArray(new RecoveredData[0]);
        ArrayList<XidImpl> arrayList = new ArrayList<XidImpl>();
        for (int i = 0; i < recoveredDataArray.length; ++i) {
            byte by;
            XidImpl xidImpl = recoveredDataArray[i].getXid();
            if (xidImpl == null || (by = recoveredDataArray[i].getTxOutcome()) != -1 && by != 2) continue;
            arrayList.add(xidImpl);
        }
        Xid[] xidArray = arrayList.toArray(new Xid[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover", xidArray);
        }
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback", new Object[]{xid, this});
        }
        try {
            this.setTxOutcome(xid, (byte)1);
            if (CScopeComponentImpl.isServerStarted() && !CScopeComponentImpl.isPeerRecoveryRestartMode() && !this._processingRecoveredData) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server is started - processing data");
                }
                this.processRecoveredData();
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
        }
    }

    public void setTxOutcome(GlobalId globalId, byte by, Boolean bl) {
        RecoveredData recoveredData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTxOutcome", new Object[]{globalId, new Byte(by), bl, this});
        }
        if ((recoveredData = (RecoveredData)this._recoveredData.get(globalId)) != null) {
            recoveredData.setTxOutcome(by);
            recoveredData.setPromoteCompensators(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTxOutcome");
        }
    }

    private void setTxOutcome(Xid xid, byte by) throws XAException {
        RecoveredData recoveredData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTxOutcome", new Object[]{xid, TraceUtils.printTxOutcome(by), this});
        }
        if ((recoveredData = this.findRecoveredDataByXid(xid)) != null) {
            try {
                recoveredData.setTxOutcome(by);
            }
            catch (CScopeSystemException cScopeSystemException) {
                FFDCFilter.processException((Throwable)cScopeSystemException, "com.ibm.ws.cscope.RecoveryManager.setTxOutcome", "563", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "CScopeSystemException caught setting tx outcome", cScopeSystemException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setTxOutcome", "XAException");
                }
                throw new XAException(-3);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RecoveredData entry not found for given Xid");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTxOutcome", "XAException");
            }
            throw new XAException(-4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTxOutcome");
        }
    }

    public void forget(Xid xid) throws XAException {
        throw new XAException(-6);
    }

    private RecoveredData findRecoveredDataByXid(Xid xid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findRecoveredDataByXid", new Object[]{xid, this});
        }
        RecoveredData[] recoveredDataArray = this._recoveredData.values().toArray(new RecoveredData[0]);
        RecoveredData recoveredData = null;
        XidImpl xidImpl = new XidImpl(xid);
        for (int i = 0; i < recoveredDataArray.length; ++i) {
            if (!xidImpl.equals(recoveredDataArray[i].getXid())) continue;
            recoveredData = recoveredDataArray[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findRecoveredDataByXid", recoveredData);
        }
        return recoveredData;
    }

    protected RecoveredData getRecoveredData(GlobalId globalId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveredData", new Object[]{globalId, this});
        }
        RecoveredData recoveredData = (RecoveredData)this._recoveredData.get(globalId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveredData", recoveredData);
        }
        return recoveredData;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSameRM", new Object[]{xAResource, this});
        }
        boolean bl2 = bl = xAResource == this;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSameRM", bl);
        }
        return bl;
    }

    public int prepare(Xid xid) throws XAException {
        throw new XAException(-6);
    }

    public boolean setTransactionTimeout(int n) {
        return false;
    }

    public void start(Xid xid, int n) throws XAException {
        throw new XAException(-6);
    }

    public void end(Xid xid, int n) throws XAException {
        throw new XAException(-6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateRecovery() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminateRecovery", this);
        }
        if (this._recoveryPrevented) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Log is incompatible - no termination processing required");
            }
            try {
                RecoveryDirectorFactory.recoveryDirector().terminationComplete(CScopeRecoveryAgent.getInstance(), this._failureScope);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveryManager.terminateRecovery", "975", this);
                Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"terminateRecovery", "com.ibm.ws.cscope.RecoveryManager", exception});
            }
        } else {
            Object object = TERMINATION_LOCK;
            synchronized (object) {
                this._terminate = true;
                try {
                    if (this._processingRecoveredData) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovered data processing in progress: waiting");
                        }
                        TERMINATION_LOCK.wait();
                    }
                    this.closeLog();
                    RecoveryDirectorFactory.recoveryDirector().terminationComplete(CScopeRecoveryAgent.getInstance(), this._failureScope);
                }
                catch (InternalLogException internalLogException) {
                    FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.cscope.RecoveryManager.terminateRecovery", "862", this);
                    Tr.error(tc, "ERR_RECOVERY_FAILURE", internalLogException);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cscope.RecoveryManager.terminateRecovery", "829", this);
                    Tr.error(tc, "ERR_UNEXPECTED_ERROR", new Object[]{"terminateRecovery", "com.ibm.ws.cscope.RecoveryManager", exception});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateRecovery");
        }
    }

    protected RecoveryLog getRecoveryLog() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryLog", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryLog", this._recoveryLog);
        }
        return this._recoveryLog;
    }

    private void closeLog() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeLog", this);
        }
        try {
            this._recoveryLog.closeLog();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.cscope.RecoveryManager.closeLog", "893", this);
            Tr.error(tc, "ERR_RECOVERY_FAILURE", internalLogException);
        }
    }

    protected boolean transactionRecoveryRequired() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transactionRecoveryRequired", this);
        }
        boolean bl = false;
        RecoveredData[] recoveredDataArray = this._recoveredData.values().toArray(new RecoveredData[0]);
        for (int i = 0; i < recoveredDataArray.length; ++i) {
            if (recoveredDataArray[i].getXid() == null) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transactionRecoveryRequired", bl);
        }
        return bl;
    }
}

