/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cscope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.cscope.CScopeImpl;
import com.ibm.ws.cscope.Compensator;
import com.ibm.ws.cscope.CompensatorWrapper;
import com.ibm.ws.cscope.UserCompensationScopeImpl;
import com.ibm.ws.cscope.util.TraceUtils;

public class RetryAlarmContext
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(RetryAlarmContext.class, "CScope", "com.ibm.ws.cscope.resources.CScopeMessages");
    private CompensatorWrapper[] _compensators;
    private int _direction;
    private CScopeImpl _cscope;
    private boolean _failureOccurred;
    public static final int CLOSE = 0;
    public static final int COMPENSATE = 1;
    private long _retryInterval;
    private int _retryLimit;
    private int _retryCount;
    private boolean _outputMessages;

    public RetryAlarmContext(CompensatorWrapper[] compensatorWrapperArray, CScopeImpl cScopeImpl, int n, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RetryAlarmContext", new Object[]{compensatorWrapperArray, cScopeImpl, TraceUtils.printDirection(n), bl, bl2});
        }
        this._compensators = compensatorWrapperArray;
        this._cscope = cScopeImpl;
        this._direction = n;
        this._failureOccurred = bl;
        this._retryInterval = UserCompensationScopeImpl.getCompensatorRetryInterval();
        this._retryLimit = UserCompensationScopeImpl.getCompensatorRetryLimit();
        this._retryCount = 0;
        this._outputMessages = bl2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RetryAlarmContext", this);
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", new Object[]{object, this});
        }
        if (this._direction == 0) {
            boolean bl = this._cscope.closeCompensators(this._compensators);
            if (!bl) {
                this._cscope.removeRecoverableUnit();
            }
        } else {
            boolean bl = this._cscope.compensateCompensators(this._compensators, this._failureOccurred);
            if (!bl) {
                this._cscope.removeRecoverableUnit();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    protected boolean createRetryAlarm() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRetryAlarm", this);
        }
        boolean bl2 = false;
        boolean bl3 = bl = this._retryLimit == -1;
        if (bl || this._retryLimit > this._retryCount) {
            this.outputRetryInfoMessage(this._compensators[0].getCompensator());
            AlarmManager.createNonDeferrable(this._retryInterval, this);
            ++this._retryCount;
            this._retryInterval *= 2L;
        } else {
            this.outputRetryLimitInfoMessage(this._compensators[0].getCompensator());
            if (this._compensators.length == 1) {
                bl2 = true;
            } else {
                CompensatorWrapper[] compensatorWrapperArray = new CompensatorWrapper[this._compensators.length - 1];
                System.arraycopy(this._compensators, 1, compensatorWrapperArray, 0, compensatorWrapperArray.length);
                this.setRemainingCompensators(compensatorWrapperArray);
                this.alarm(null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRetryAlarm", bl2);
        }
        return bl2;
    }

    protected void setRemainingCompensators(CompensatorWrapper[] compensatorWrapperArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRemainingCompensators", new Object[]{compensatorWrapperArray, this});
        }
        if (this._compensators.length > compensatorWrapperArray.length) {
            this._compensators = compensatorWrapperArray;
            this._retryCount = 0;
            this._retryInterval = UserCompensationScopeImpl.getCompensatorRetryInterval();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRemainingCompensators");
        }
    }

    private void outputRetryLimitInfoMessage(Compensator compensator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "outputRetryLimitInfoMessage", new Object[]{compensator, this});
        }
        if (this._outputMessages) {
            if (this._direction == 0) {
                Tr.info(tc, "INF_COMPENSATOR_RETRY_LIMIT", new Object[]{"close", compensator.getName(), new Integer(this._retryLimit)});
            } else if (this._direction == 1) {
                Tr.info(tc, "INF_COMPENSATOR_RETRY_LIMIT", new Object[]{"compensate", compensator.getName(), new Integer(this._retryLimit)});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "outputRetryLimitInfoMessage");
        }
    }

    private void outputRetryInfoMessage(Compensator compensator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "outputRetryInfoMessage", new Object[]{compensator, this});
        }
        if (this._outputMessages) {
            if (this._direction == 0) {
                Tr.info(tc, "INF_COMPENSATOR_RETRY", new Object[]{"close", compensator.getName(), new Long(this._retryInterval / 1000L)});
            } else if (this._direction == 1) {
                Tr.info(tc, "INF_COMPENSATOR_RETRY", new Object[]{"compensate", compensator.getName(), new Long(this._retryInterval / 1000L)});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "outputRetryInfoMessage");
        }
    }
}

